/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation;

import com.suncode.plugin.pwe.documentation.NumberedPoint;
import com.suncode.plugin.pwe.documentation.NumberedPoints;
import com.suncode.plugin.pwe.documentation.ParagraphContent;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.ParagraphIndents;
import com.suncode.plugin.pwe.documentation.ParagraphSpacing;
import com.suncode.plugin.pwe.documentation.TableCell;
import com.suncode.plugin.pwe.documentation.TableHeader;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecord;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.TextValue;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.documentation.util.TableUtils;
import com.suncode.plugin.pwe.documentation.util.TextValueUtils;
import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.util.PweContext;
import com.suncode.plugin.pwe.util.exception.DocumentationInitializationException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io3.Save;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTLanguage;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTSimpleField;
import org.docx4j.wml.CTVerticalJc;
import org.docx4j.wml.Color;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.FooterReference;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.HdrFtrRef;
import org.docx4j.wml.HeaderReference;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STBrType;
import org.docx4j.wml.STLineSpacingRule;
import org.docx4j.wml.STVerticalJc;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.docx4j.wml.U;
import org.docx4j.wml.UnderlineEnumeration;
import org.springframework.core.io.Resource;

public class Documentation {
    public static Logger log = Logger.getLogger(Documentation.class);
    private WordprocessingMLPackage wmlPack;
    private ObjectFactory objectFactory;
    private Counter imageId;
    private Counter bookmarkId;
    private NumberingDefinitionsPart numerator;
    private static final String DEFAULT_FONT = "Tahoma";
    private static final String TITLE_STYLE_ID = "Title";
    private static final String TITLE_FONT_COLOR = "B41D8D";
    private static final String SUBTITLE_STYLE_ID = "Subtitle";
    private static final String SUBTITLE_FONT_COLOR = "000000";
    private static final String CHAPTER_STYLE_ID = "Heading2";
    private static final String CHAPTER_FONT_COLOR = "B41D8D";
    private static final String SUBCHAPTER_STYLE_ID = "Heading3";
    private static final String SUBCHAPTER_FONT_COLOR = "B41D8D";
    private static final String HYPERLINK_STYLE_ID = "Hyperlink";
    private static final String HYPERLINK_FONT_COLOR = "B41D8D";
    private static final String HEADER_IMAGE_LOCATION = "/images/documentation/header.jpg";
    private static final String LOGO_IMAGE_LOCATION = "/images/documentation/intro.png";
    private static final String DEFAULT_IMAGE_FILE_NAME_HINT = "Suncode";
    private static final Integer LOGO_WIDTH = 580;
    private static final Integer LOGO_HEIGHT = 540;
    private static final long LOGO_SPACING_BEFORE = 100L;
    private static final long LOGO_SPACING_AFTER = 400L;
    private static final long CHAPTER_SPACING_AFTER = 400L;
    private static final int CHAPTER_LINE_SIZE = 12;
    private static final String CHAPTER_LINE_COLOR = "B41D8D";
    private static final int INDENT_SIZE = 500;
    private static final long TABLE_OUTSIDE_BORDER_SIZE = 12L;
    private static final long TABLE_INSIDE_BORDER_SIZE = 6L;
    private static final BigInteger TABLE_WIDTH = BigInteger.valueOf(9212L);
    private static final String TABLE_HEADER_COLOR = "B41D8D";
    private static final String TEXT_SPACE = "preserve";
    private static final BigInteger DEFAULT_SPACING_LINE = BigInteger.valueOf(100L);
    private static final String NEW_LINE = "\n";
    private static final String DEFAULT_LANGUAGE = "pl-PL";
    private static final Integer MAX_IMAGE_HEIGHT = 900;

    public Documentation(String title, String subtitle) {
        try {
            this.wmlPack = WordprocessingMLPackage.createPackage();
            this.objectFactory = Context.getWmlObjectFactory();
            this.imageId = new Counter(1);
            this.bookmarkId = new Counter(1);
            this.setDefaultFont();
            this.setTitlePageStyle();
            this.setChapterTitleStyle();
            this.setSubchapterTitleStyle();
            this.setHyperlinkStyle();
            this.initNumbering();
            this.addHeader();
            this.addFooter();
            this.addTitlePage(title, subtitle);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new DocumentationInitializationException(exception);
        }
    }

    private void setDefaultFont() throws Docx4JException {
        MainDocumentPart mainDocumentPart = this.wmlPack.getMainDocumentPart();
        Styles styles = (Styles)mainDocumentPart.getStyleDefinitionsPart().getContents();
        for (Style style : styles.getStyle()) {
            RFonts fonts;
            RPr properties = style.getRPr();
            if (properties == null) {
                properties = this.objectFactory.createRPr();
                style.setRPr(properties);
            }
            if ((fonts = properties.getRFonts()) == null) {
                fonts = this.objectFactory.createRFonts();
                properties.setRFonts(fonts);
            }
            fonts.setAscii(DEFAULT_FONT);
            fonts.setHAnsi(DEFAULT_FONT);
            fonts.setCs(DEFAULT_FONT);
        }
    }

    private void setTitlePageStyle() {
        this.setStyleFontColor(TITLE_STYLE_ID, "B41D8D");
        this.setStyleFontColor(SUBTITLE_STYLE_ID, SUBTITLE_FONT_COLOR);
    }

    private void setChapterTitleStyle() {
        this.setStyleFontColor(CHAPTER_STYLE_ID, "B41D8D");
    }

    private void setSubchapterTitleStyle() {
        this.setStyleFontColor(SUBCHAPTER_STYLE_ID, "B41D8D");
    }

    private void setHyperlinkStyle() {
        this.setStyleFontColor(HYPERLINK_STYLE_ID, "B41D8D");
    }

    private void setStyleFontColor(String styleId, String hexColor) {
        MainDocumentPart mainDocumentPart = this.wmlPack.getMainDocumentPart();
        Style style = mainDocumentPart.getStyleDefinitionsPart().getStyleById(styleId);
        if (style != null) {
            RPr properties = style.getRPr();
            if (properties == null) {
                properties = this.objectFactory.createRPr();
                style.setRPr(properties);
            }
            properties.setColor(this.buildColor(hexColor));
        }
    }

    private void initNumbering() throws InvalidFormatException, JAXBException {
        this.numerator = new NumberingDefinitionsPart();
        this.numerator.unmarshalDefaultNumbering();
        this.wmlPack.getMainDocumentPart().addTargetPart((Part)this.numerator);
    }

    private void addHeader() throws Exception {
        HeaderPart header = new HeaderPart();
        header.setPackage((OpcPackage)this.wmlPack);
        header.setJaxbElement((Object)this.buildHdr((Part)header));
        Relationship relationship = this.wmlPack.getMainDocumentPart().addTargetPart((Part)header);
        this.createHeaderReference(relationship);
    }

    private Hdr buildHdr(Part sourcePart) throws Exception {
        P image = this.buildImage(sourcePart, HEADER_IMAGE_LOCATION, DEFAULT_IMAGE_FILE_NAME_HINT);
        image.setPPr(this.buildRightParagraphProperties());
        Hdr hdr = this.objectFactory.createHdr();
        hdr.getContent().add(image);
        return hdr;
    }

    private void createHeaderReference(Relationship relationship) {
        SectPr sectPr = this.getSectPr();
        HeaderReference reference = this.objectFactory.createHeaderReference();
        reference.setId(relationship.getId());
        reference.setType(HdrFtrRef.DEFAULT);
        reference.setParent((Object)sectPr);
        sectPr.getEGHdrFtrReferences().add(reference);
        sectPr.setTitlePg(this.buildBooleanValue(true));
    }

    private SectPr getSectPr() {
        List sections = this.wmlPack.getDocumentModel().getSections();
        SectPr sectPr = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        if (sectPr == null) {
            sectPr = this.objectFactory.createSectPr();
            this.wmlPack.getMainDocumentPart().addObject((Object)sectPr);
            ((SectionWrapper)sections.get(sections.size() - 1)).setSectPr(sectPr);
        }
        return sectPr;
    }

    private void addFooter() throws Exception {
        FooterPart footer = new FooterPart();
        footer.setPackage((OpcPackage)this.wmlPack);
        footer.setJaxbElement((Object)this.buildFtr());
        Relationship relationship = this.wmlPack.getMainDocumentPart().addTargetPart((Part)footer);
        this.createFooterReference(relationship);
    }

    private void createFooterReference(Relationship relationship) {
        SectPr sectPr = this.getSectPr();
        FooterReference reference = this.objectFactory.createFooterReference();
        reference.setId(relationship.getId());
        reference.setType(HdrFtrRef.DEFAULT);
        reference.setParent((Object)sectPr);
        sectPr.getEGHdrFtrReferences().add(reference);
        sectPr.setTitlePg(this.buildBooleanValue(true));
    }

    private Ftr buildFtr() {
        RPr runProperties = this.initRunProperties();
        runProperties.setNoProof(this.buildBooleanValue(false));
        R run = this.objectFactory.createR();
        run.setRPr(runProperties);
        CTSimpleField ctSimple = this.objectFactory.createCTSimpleField();
        ctSimple.setInstr("PAGE \\* MERGEFORMAT");
        ctSimple.getContent().add(run);
        JAXBElement fldSimple = this.objectFactory.createPFldSimple(ctSimple);
        PPr paragraphProperties = this.buildLeftParagraphProperties();
        paragraphProperties.setSpacing(this.buildNoParagraphSpacing());
        P paragraph = this.objectFactory.createP();
        paragraph.setPPr(paragraphProperties);
        paragraph.getContent().add(fldSimple);
        Ftr ftr = this.objectFactory.createFtr();
        ftr.getContent().add(paragraph);
        return ftr;
    }

    private void addTitlePage(String title, String subtitle) throws Exception {
        this.addLogo();
        this.addTitle(title);
        this.addSubtitle(subtitle);
    }

    private void addLogo() throws Exception {
        PPrBase.Spacing spacing = this.objectFactory.createPPrBaseSpacing();
        spacing.setBefore(BigInteger.valueOf(LOGO_SPACING_BEFORE));
        spacing.setAfter(BigInteger.valueOf(LOGO_SPACING_AFTER));
        PPr properties = this.buildCenteredParagraphProperties();
        properties.setSpacing(spacing);
        P logo = this.buildImage((Part)this.wmlPack.getMainDocumentPart(), LOGO_IMAGE_LOCATION, DEFAULT_IMAGE_FILE_NAME_HINT, LOGO_WIDTH, LOGO_HEIGHT);
        logo.setPPr(properties);
        this.wmlPack.getMainDocumentPart().addObject((Object)logo);
    }

    public void addImage(String location, long spacingBefore, long spacingAfter, int width, int height) throws Exception {
        PPrBase.Spacing spacing = this.objectFactory.createPPrBaseSpacing();
        spacing.setBefore(BigInteger.valueOf(spacingBefore));
        spacing.setAfter(BigInteger.valueOf(spacingAfter));
        PPr properties = this.buildCenteredParagraphProperties();
        properties.setSpacing(spacing);
        P image = this.buildImage((Part)this.wmlPack.getMainDocumentPart(), location, "", (Integer)width, (Integer)height);
        image.setPPr(properties);
        this.wmlPack.getMainDocumentPart().addObject((Object)image);
    }

    private void addTitle(String title) {
        P paragraph = this.wmlPack.getMainDocumentPart().addStyledParagraphOfText(TITLE_STYLE_ID, title);
        paragraph.getPPr().setSpacing(this.buildNoParagraphSpacing());
        paragraph.getPPr().setJc(this.buildJc(JcEnumeration.CENTER));
        for (Object object : paragraph.getContent()) {
            if (!(object instanceof R)) continue;
            R run = (R)object;
            RPr properties = run.getRPr();
            if (properties == null) {
                properties = this.initRunProperties();
                run.setRPr(properties);
            } else {
                this.setRunLanguage(properties);
            }
            properties.setB(this.buildBooleanValue(true));
        }
    }

    private void addSubtitle(String subtitle) {
        P paragraph = this.wmlPack.getMainDocumentPart().addStyledParagraphOfText(SUBTITLE_STYLE_ID, subtitle);
        paragraph.getPPr().setSpacing(this.buildNoParagraphSpacing());
        paragraph.getPPr().setJc(this.buildJc(JcEnumeration.CENTER));
        for (Object object : paragraph.getContent()) {
            if (!(object instanceof R)) continue;
            R run = (R)object;
            RPr properties = run.getRPr();
            if (properties == null) {
                properties = this.initRunProperties();
                run.setRPr(properties);
            } else {
                this.setRunLanguage(properties);
            }
            properties.setI(this.buildBooleanValue(false));
        }
    }

    public void addChapter(String title) {
        this.addNewPage();
        PPrBase.Spacing spacing = this.objectFactory.createPPrBaseSpacing();
        spacing.setAfter(BigInteger.valueOf(CHAPTER_SPACING_AFTER));
        P paragraph = this.wmlPack.getMainDocumentPart().addStyledParagraphOfText(CHAPTER_STYLE_ID, title);
        paragraph.getPPr().setSpacing(spacing);
        this.addHorizontalLineToParagraph(paragraph, CHAPTER_LINE_SIZE, "B41D8D");
        this.setLanguageInContentAccessor((ContentAccessor)paragraph);
    }

    private P addSubchapter(String title, String styleId) {
        P paragraph = this.wmlPack.getMainDocumentPart().addStyledParagraphOfText(styleId, title);
        this.setLanguageInContentAccessor((ContentAccessor)paragraph);
        return paragraph;
    }

    private void setLanguageInContentAccessor(ContentAccessor contentAccessor) {
        for (Object object : contentAccessor.getContent()) {
            if (!(object instanceof R)) continue;
            R run = (R)object;
            RPr properties = run.getRPr();
            if (properties == null) {
                properties = this.initRunProperties();
                run.setRPr(properties);
                continue;
            }
            this.setRunLanguage(properties);
        }
    }

    public void addSubchapter(String title) {
        this.addSubchapter(title, SUBCHAPTER_STYLE_ID);
    }

    public void addBookmarkedSubchapter(String title, String bookmarkName) {
        P paragraph = this.addSubchapter(title, SUBCHAPTER_STYLE_ID);
        this.addBookmark(paragraph, bookmarkName);
    }

    public void addSubchapter(String title, ParagraphContents contents) {
        ArrayList<ParagraphContents> listOfcontents = new ArrayList<ParagraphContents>();
        listOfcontents.add(contents);
        this.addSubchapter(title, listOfcontents);
    }

    public void addSubchapter(String title, List<ParagraphContents> listOfcontents) {
        this.addSubchapter(title);
        for (ParagraphContents contents : listOfcontents) {
            this.addParagraph(contents);
        }
        this.addNewLine();
    }

    public void addSubchapter(String title, NumberedPoints points) {
        this.addSubchapter(title);
        this.addNumberedPoints(points);
    }

    public void addNumberedPoints(NumberedPoints points) {
        this.addNumberedPoints(points, 1);
    }

    public void addNumberedPoints(NumberedPoints points, int leftIndents) {
        for (NumberedPoint point : points) {
            StringBuilder text = new StringBuilder();
            text.append(point.getTitle());
            text.append(": ");
            ParagraphContent content = new ParagraphContent();
            content.setTextValue(TextValueUtils.build(text.toString()));
            ParagraphContents contents = new ParagraphContents();
            contents.setIndents(ParagraphIndentsUtils.buildLeft(leftIndents));
            contents.addContent(content);
            this.addParagraph(contents);
            if (CollectionUtils.isNotEmpty(point.getSubPoints())) {
                this.addNumberedList(point.getSubPoints(), leftIndents);
            }
            this.addNewLine();
        }
    }

    public void addSubchapter(String title, TableHeaders headers, TableRecords records) {
        this.addSubchapter(title);
        this.addTable(headers, records);
    }

    public void addParagraph(ParagraphContents contents) {
        PPr properties = this.buildParagraphProperties(contents);
        P paragraph = this.objectFactory.createP();
        paragraph.setPPr(properties);
        for (ParagraphContent content : contents) {
            this.addParagraphContent(paragraph, content);
        }
        this.wmlPack.getMainDocumentPart().addObject((Object)paragraph);
    }

    private void addParagraphContent(P paragraph, ParagraphContent content) {
        if (ArrayUtils.isNotEmpty((byte[])content.getBytes())) {
            try {
                R image = this.buildImageRun(content.getBytes(), "");
                paragraph.getContent().add(image);
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException(exception);
            }
        } else {
            TextValue textValue = content.getTextValue();
            if (textValue.isBookmarkHyperlink()) {
                P.Hyperlink hyperlink = this.buildHyperlink(textValue.getBookmarkName(), textValue.getText());
                paragraph.getContent().add(hyperlink);
            } else {
                RPr properties = this.initRunProperties();
                if (content.isBold()) {
                    properties.setB(this.buildBooleanValue(true));
                }
                if (content.isUnderline()) {
                    U underline = this.objectFactory.createU();
                    underline.setVal(UnderlineEnumeration.SINGLE);
                    properties.setU(underline);
                }
                R run = this.objectFactory.createR();
                run.setRPr(properties);
                this.addStringToRun(run, textValue.getText());
                paragraph.getContent().add(run);
            }
        }
    }

    private P.Hyperlink buildHyperlink(String bookmarkName, String text) {
        P.Hyperlink hyperlink = MainDocumentPart.hyperlinkToBookmark((String)bookmarkName, (String)StringEscapeUtils.escapeXml((String)text));
        this.setLanguageInContentAccessor((ContentAccessor)hyperlink);
        return hyperlink;
    }

    private void addStringToRun(R run, String string) {
        if (string != null) {
            String[] lines = string.split(NEW_LINE, -1);
            Counter counter = new Counter(1);
            for (String line : lines) {
                Text text = this.buildText(line);
                run.getContent().add(text);
                if (counter.getCountAndIncrement() == ArrayUtils.getLength((Object)lines)) continue;
                run.getContent().add(this.buildLineBreak());
            }
        }
    }

    private Br buildLineBreak() {
        Br lineBreak = this.objectFactory.createBr();
        lineBreak.setType(STBrType.TEXT_WRAPPING);
        return lineBreak;
    }

    public void addNumberedList(List<ParagraphContents> subPoints) {
        this.addNumberedList(subPoints, 1);
    }

    public void addNumberedList(List<ParagraphContents> subPoints, int leftIndents) {
        List<P> paragraphs = this.buildNumberedListParagraphs(subPoints, leftIndents);
        for (P paragraph : paragraphs) {
            this.wmlPack.getMainDocumentPart().addObject((Object)paragraph);
        }
    }

    private List<P> buildNumberedListParagraphs(List<ParagraphContents> subPoints) {
        return this.buildNumberedListParagraphs(subPoints, 1);
    }

    private List<P> buildNumberedListParagraphs(List<ParagraphContents> subPoints, int leftIndents) {
        ArrayList<P> paragraphs = new ArrayList<P>();
        long newNumId = this.numerator.restart(Long.valueOf(1L).longValue(), Long.valueOf(0L).longValue(), Long.valueOf(1L).longValue());
        for (ParagraphContents subPoint : subPoints) {
            PPrBase.NumPr.Ilvl ilvl = this.objectFactory.createPPrBaseNumPrIlvl();
            ilvl.setVal(BigInteger.valueOf(leftIndents - 1));
            PPrBase.NumPr.NumId numId = this.objectFactory.createPPrBaseNumPrNumId();
            numId.setVal(BigInteger.valueOf(newNumId));
            PPrBase.NumPr numPr = this.objectFactory.createPPrBaseNumPr();
            numPr.setIlvl(ilvl);
            numPr.setNumId(numId);
            PPr ppr = this.objectFactory.createPPr();
            ppr.setNumPr(numPr);
            ppr.setSpacing(this.buildNoParagraphSpacing());
            P paragraph = this.objectFactory.createP();
            paragraph.setPPr(ppr);
            for (ParagraphContent subPointContent : subPoint) {
                this.addParagraphContent(paragraph, subPointContent);
            }
            paragraphs.add(paragraph);
        }
        return paragraphs;
    }

    public void addTable(TableHeaders headers, TableRecords records) {
        Tbl table = this.objectFactory.createTbl();
        table.setTblPr(this.buildTableProperties());
        table.setTblGrid(this.buildTableGrid(headers));
        this.addTableHeaders(table, headers);
        this.addTableRecords(table, headers, records);
        this.wmlPack.getMainDocumentPart().addObject((Object)table);
    }

    private TblPr buildTableProperties() {
        TblPr tableProperties = new TblPr();
        tableProperties.setTblBorders(this.buildTableBorders());
        tableProperties.setTblW(this.buildTableWidth());
        return tableProperties;
    }

    private TblGrid buildTableGrid(TableHeaders headers) {
        TblGrid tableGrid = this.objectFactory.createTblGrid();
        BigInteger basicWidth = this.calculateBasicTableHeaderWidth(headers);
        for (TableHeader header : headers) {
            TblGridCol tableGridCol = null;
            tableGridCol = header.getWidth() != null ? this.buildTableGridCol(header.getWidth()) : this.buildTableGridCol(basicWidth);
            tableGrid.getGridCol().add(tableGridCol);
        }
        return tableGrid;
    }

    private BigInteger calculateBasicTableHeaderWidth(TableHeaders headers) {
        BigInteger remainedWidth = BigInteger.valueOf(TABLE_WIDTH.longValue());
        Counter headersWithoutWidthCounter = new Counter(headers.size());
        for (TableHeader header : headers) {
            if (header.getWidth() == null) continue;
            remainedWidth = remainedWidth.subtract(header.getWidth());
            headersWithoutWidthCounter.decrement();
        }
        if (headersWithoutWidthCounter.getCount() > 0) {
            return remainedWidth.divide(BigInteger.valueOf(headersWithoutWidthCounter.getCount()));
        }
        return BigInteger.ZERO;
    }

    private TblGridCol buildTableGridCol(BigInteger width) {
        TblGridCol tableGridCol = this.objectFactory.createTblGridCol();
        tableGridCol.setW(width);
        return tableGridCol;
    }

    private TblBorders buildTableBorders() {
        CTBorder outsideBorder = this.buildTableBorder(TABLE_OUTSIDE_BORDER_SIZE);
        CTBorder insideBorder = this.buildTableBorder(TABLE_INSIDE_BORDER_SIZE);
        TblBorders borders = new TblBorders();
        borders.setBottom(outsideBorder);
        borders.setLeft(outsideBorder);
        borders.setRight(outsideBorder);
        borders.setTop(outsideBorder);
        borders.setInsideH(insideBorder);
        borders.setInsideV(insideBorder);
        return borders;
    }

    private CTBorder buildTableBorder(long size) {
        CTBorder border = this.objectFactory.createCTBorder();
        border.setVal(STBorder.SINGLE);
        border.setSz(BigInteger.valueOf(size));
        border.setSpace(BigInteger.ZERO);
        border.setColor("auto");
        return border;
    }

    private TblWidth buildTableWidth() {
        TblWidth width = this.objectFactory.createTblWidth();
        width.setType("dxa");
        width.setW(TABLE_WIDTH);
        return width;
    }

    private void addTableHeaders(Tbl table, TableHeaders headers) {
        Tr row = this.objectFactory.createTr();
        for (TableHeader header : headers) {
            this.addTableHeader(row, header);
        }
        table.getContent().add(row);
    }

    private void addTableHeader(Tr row, TableHeader header) {
        RPr runProperties = this.initRunProperties();
        runProperties.setB(this.buildBooleanValue(true));
        runProperties.setColor(this.buildColor("FFFFFF"));
        R run = this.objectFactory.createR();
        run.setRPr(runProperties);
        this.addStringToRun(run, header.getText());
        PPr paragraphProperties = this.buildCenteredParagraphProperties();
        paragraphProperties.setSpacing(this.buildNoParagraphSpacing());
        P paragraph = this.objectFactory.createP();
        paragraph.setPPr(paragraphProperties);
        paragraph.getContent().add(run);
        TcPr cellProperties = this.initTableCellProperties();
        cellProperties.setShd(this.buildTableHeaderFill());
        if (header.getWidth() != null) {
            TblWidth cellWidth = this.buildCellWidth(header.getWidth());
            cellProperties.setTcW(cellWidth);
        }
        Tc cell = this.objectFactory.createTc();
        cell.getContent().add(paragraph);
        cell.setTcPr(cellProperties);
        row.getContent().add(cell);
        row.setTrPr(this.buildTableHeaderRowProperties());
    }

    private TcPr initTableCellProperties() {
        CTVerticalJc vAlign = this.objectFactory.createCTVerticalJc();
        vAlign.setVal(STVerticalJc.CENTER);
        TcPr properties = this.objectFactory.createTcPr();
        properties.setVAlign(vAlign);
        return properties;
    }

    private CTShd buildTableHeaderFill() {
        CTShd fill = this.objectFactory.createCTShd();
        fill.setFill("B41D8D");
        return fill;
    }

    private TblWidth buildCellWidth(BigInteger width) {
        TblWidth cellWidth = new TblWidth();
        cellWidth.setType("dxa");
        cellWidth.setW(width);
        return cellWidth;
    }

    private TrPr buildTableHeaderRowProperties() {
        TrPr properties = this.objectFactory.createTrPr();
        List elements = properties.getCnfStyleOrDivIdOrGridBefore();
        if (elements != null) {
            JAXBElement header = this.objectFactory.createCTTrPrBaseTblHeader(this.buildBooleanValue(true));
            elements.add(header);
        }
        return properties;
    }

    private void addTableRecords(Tbl table, TableHeaders headers, TableRecords records) {
        for (TableRecord record : records) {
            this.addTableRecord(table, headers, record);
        }
    }

    private void addTableRecord(Tbl table, TableHeaders headers, TableRecord record) {
        Tr row = this.objectFactory.createTr();
        if (record.isMerged()) {
            this.addMergedTableRecord(row, record, BigInteger.valueOf(headers.size()));
        } else {
            for (TableHeader header : headers) {
                this.addTableCell(row, this.getTableCell(header, record));
            }
        }
        table.getContent().add(row);
    }

    private TableCell getTableCell(TableHeader header, TableRecord record) {
        TableCell tableCell = record.getCell(header.getColumnId());
        if (tableCell != null) {
            return tableCell;
        }
        return TableUtils.buildTableCell("");
    }

    private void addMergedTableRecord(Tr row, TableRecord record, BigInteger span) {
        TableCell tableCell = record.getFirstCell();
        PPr paragraphProperties = this.buildCenteredParagraphProperties();
        paragraphProperties.setSpacing(this.buildNoParagraphSpacing());
        P paragraph = this.objectFactory.createP();
        paragraph.setPPr(paragraphProperties);
        for (ParagraphContent content : tableCell.getContents()) {
            this.addParagraphContent(paragraph, content);
        }
        TcPrInner.GridSpan gridSpan = this.objectFactory.createTcPrInnerGridSpan();
        gridSpan.setVal(span);
        TcPr tableCellProperties = this.initTableCellProperties();
        tableCellProperties.setGridSpan(gridSpan);
        Tc cell = this.objectFactory.createTc();
        cell.getContent().add(paragraph);
        cell.setTcPr(tableCellProperties);
        row.getContent().add(cell);
    }

    private void addTableCell(Tr row, TableCell tableCell) {
        TcPr cellProperties = this.initTableCellProperties();
        if (tableCell.getWidth() != null) {
            TblWidth cellWidth = this.buildCellWidth(tableCell.getWidth());
            cellProperties.setTcW(cellWidth);
        }
        Tc cell = this.objectFactory.createTc();
        if (CollectionUtils.isNotEmpty((Collection)tableCell.getContents())) {
            PPr paragraphProperties = this.objectFactory.createPPr();
            paragraphProperties.setSpacing(this.buildNoParagraphSpacing());
            P paragraph = this.objectFactory.createP();
            paragraph.setPPr(paragraphProperties);
            for (ParagraphContent content : tableCell.getContents()) {
                this.addParagraphContent(paragraph, content);
            }
            cell.getContent().add(paragraph);
        }
        if (CollectionUtils.isNotEmpty(tableCell.getNumberedList())) {
            List<P> paragraphs = this.buildNumberedListParagraphs(tableCell.getNumberedList());
            for (P paragraph : paragraphs) {
                cell.getContent().add(paragraph);
            }
        }
        if (CollectionUtils.isEmpty((Collection)cell.getContent())) {
            cell.getContent().add(this.buildEmptyParagraph());
        }
        cell.setTcPr(cellProperties);
        row.getContent().add(cell);
    }

    public void addNewLine() {
        this.wmlPack.getMainDocumentPart().addObject((Object)this.buildEmptyParagraph());
    }

    public void removeLastObject() {
        List objects = this.wmlPack.getMainDocumentPart().getContent();
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            objects.remove(objects.size() - 1);
        }
    }

    public void addNewPage() {
        Br pageBreak = new Br();
        pageBreak.setType(STBrType.PAGE);
        R run = new R();
        run.getContent().add(pageBreak);
        P paragraph = new P();
        paragraph.getContent().add(run);
        this.wmlPack.getMainDocumentPart().addObject((Object)paragraph);
    }

    public void addImage(byte[] bytes, String fileNameHint) throws Exception {
        P image = this.buildImage((Part)this.wmlPack.getMainDocumentPart(), bytes, fileNameHint, null, null);
        this.wmlPack.getMainDocumentPart().addObject((Object)image);
    }

    private R buildImageRun(byte[] bytes, String fileNameHint) throws Exception {
        return this.buildImageRun((Part)this.wmlPack.getMainDocumentPart(), bytes, fileNameHint, null, null);
    }

    private P buildImage(Part sourcePart, String imageLocation, String fileNameHint) throws Exception {
        InputStream inputStream = this.getFile(imageLocation);
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        return this.buildImage(sourcePart, bytes, fileNameHint, null, null);
    }

    private P buildImage(Part sourcePart, String imageClasspath, String fileNameHint, Integer width, Integer height) throws Exception {
        InputStream inputStream = this.getFile(imageClasspath);
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        return this.buildImage(sourcePart, bytes, fileNameHint, width, height);
    }

    private P buildImage(Part sourcePart, byte[] bytes, String fileNameHint, Integer width, Integer height) throws Exception {
        R run = this.buildImageRun(sourcePart, bytes, fileNameHint, width, height);
        PPr paragraphProperties = this.objectFactory.createPPr();
        paragraphProperties.setSpacing(this.buildNoParagraphSpacing());
        P paragraph = this.objectFactory.createP();
        paragraph.setPPr(paragraphProperties);
        paragraph.getContent().add(run);
        return paragraph;
    }

    private R buildImageRun(Part sourcePart, byte[] bytes, String fileNameHint, Integer width, Integer height) throws Exception {
        CTPositiveSize2D extent;
        long currentHeight;
        int id1 = this.imageId.getCountAndIncrement();
        int id2 = this.imageId.getCountAndIncrement();
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)this.wmlPack, (Part)sourcePart, (byte[])bytes);
        Inline inline = null;
        inline = width != null && height != null ? imagePart.createImageInline(fileNameHint, "", id1, id2, (long)(9525 * width), (long)(9525 * height), false) : (width != null ? imagePart.createImageInline(fileNameHint, "", id1, id2, (long)(9525 * width), false) : imagePart.createImageInline(fileNameHint, "", id1, id2, false));
        if (inline.getExtent() != null && (currentHeight = (extent = inline.getExtent()).getCy()) > (long)(9525 * MAX_IMAGE_HEIGHT)) {
            extent.setCy((long)(9525 * MAX_IMAGE_HEIGHT));
        }
        Drawing drawing = this.objectFactory.createDrawing();
        drawing.getAnchorOrInline().add(inline);
        RPr properties = this.initRunProperties();
        R run = this.objectFactory.createR();
        run.setRPr(properties);
        run.getContent().add(drawing);
        return run;
    }

    private InputStream getFile(String location) throws IOException {
        InputStream inputStream = this.getInputStreamFromClasspath(location);
        if (inputStream != null) {
            return inputStream;
        }
        return new FileInputStream(location);
    }

    private InputStream getInputStreamFromClasspath(String location) throws IOException {
        PluginService pluginService = PweContext.getBean(PluginService.class);
        Resource resource = pluginService.getResource(location);
        if (resource.exists()) {
            return resource.getInputStream();
        }
        return null;
    }

    private void addHorizontalLineToParagraph(P paragraph, int size, String color) {
        CTBorder bottomBorder = this.objectFactory.createCTBorder();
        bottomBorder.setVal(STBorder.SINGLE);
        bottomBorder.setSz(BigInteger.valueOf(size));
        bottomBorder.setSpace(BigInteger.valueOf(1L));
        bottomBorder.setColor(color);
        PPrBase.PBdr borders = this.objectFactory.createPPrBasePBdr();
        borders.setBottom(bottomBorder);
        PPr properties = paragraph.getPPr();
        if (properties == null) {
            properties = this.objectFactory.createPPr();
            paragraph.setPPr(properties);
        }
        properties.setPBdr(borders);
    }

    private BooleanDefaultTrue buildBooleanValue(boolean bool) {
        BooleanDefaultTrue value = new BooleanDefaultTrue();
        value.setVal(Boolean.valueOf(bool));
        return value;
    }

    private PPr buildCenteredParagraphProperties() {
        return this.initParagraphProperties(JcEnumeration.CENTER);
    }

    private PPr buildRightParagraphProperties() {
        return this.initParagraphProperties(JcEnumeration.RIGHT);
    }

    private PPr buildLeftParagraphProperties() {
        return this.initParagraphProperties(JcEnumeration.LEFT);
    }

    private PPr initParagraphProperties(JcEnumeration jcEnumeration) {
        PPr properties = this.objectFactory.createPPr();
        properties.setJc(this.buildJc(jcEnumeration));
        return properties;
    }

    private PPr buildParagraphProperties(ParagraphContents contents) {
        PPr properties = this.initParagraphProperties(JcEnumeration.BOTH);
        if (contents.getSpacing() != null) {
            properties.setSpacing(this.buildParagraphSpacing(contents.getSpacing()));
        } else {
            properties.setSpacing(this.buildNoParagraphSpacing());
        }
        if (contents.getIndents() != null) {
            properties.setInd(this.buildInd(contents.getIndents()));
        }
        return properties;
    }

    private PPrBase.Spacing buildParagraphSpacing(ParagraphSpacing paragraphSpacing) {
        BigInteger before = BigInteger.valueOf(20L * paragraphSpacing.getBefore());
        BigInteger after = BigInteger.valueOf(20L * paragraphSpacing.getAfter());
        return this.buildParagraphSpacing(before, after);
    }

    private PPrBase.Spacing buildNoParagraphSpacing() {
        return this.buildParagraphSpacing(BigInteger.ZERO, BigInteger.ZERO);
    }

    private PPrBase.Spacing buildParagraphSpacing(BigInteger before, BigInteger after) {
        PPrBase.Spacing spacing = this.objectFactory.createPPrBaseSpacing();
        spacing.setBefore(before);
        spacing.setAfter(after);
        spacing.setLineRule(STLineSpacingRule.AT_LEAST);
        spacing.setLine(DEFAULT_SPACING_LINE);
        return spacing;
    }

    private PPrBase.Ind buildInd(ParagraphIndents paragraphIndents) {
        PPrBase.Ind ind = this.objectFactory.createPPrBaseInd();
        ind.setLeft(this.buildIndentsValue(paragraphIndents.getLeft()));
        ind.setRight(this.buildIndentsValue(paragraphIndents.getRight()));
        return ind;
    }

    private BigInteger buildIndentsValue(int indents) {
        return BigInteger.valueOf(INDENT_SIZE * indents);
    }

    private RPr initRunProperties() {
        RPr properties = this.objectFactory.createRPr();
        this.setRunLanguage(properties);
        return properties;
    }

    private void setRunLanguage(RPr properties) {
        CTLanguage language = properties.getLang();
        if (language == null) {
            language = this.objectFactory.createCTLanguage();
            properties.setLang(language);
        }
        language.setVal(DEFAULT_LANGUAGE);
    }

    private Jc buildJc(JcEnumeration jcEnumeration) {
        Jc jc = this.objectFactory.createJc();
        jc.setVal(jcEnumeration);
        return jc;
    }

    private void addBookmark(P paragraph, String name) {
        BigInteger id = BigInteger.valueOf(this.bookmarkId.getCountAndIncrement());
        CTMarkupRange markupRange = this.objectFactory.createCTMarkupRange();
        markupRange.setId(id);
        JAXBElement bookmarkEnd = this.objectFactory.createBodyBookmarkEnd(markupRange);
        paragraph.getContent().add(paragraph.getContent().size() - 1, bookmarkEnd);
        CTBookmark bookmark = this.objectFactory.createCTBookmark();
        bookmark.setId(id);
        bookmark.setName(name);
        JAXBElement bookmarkStart = this.objectFactory.createBodyBookmarkStart(bookmark);
        paragraph.getContent().add(0, bookmarkStart);
    }

    private Color buildColor(String hexColor) {
        Color color = this.objectFactory.createColor();
        color.setVal(hexColor);
        return color;
    }

    private Text buildText(String value) {
        Text text = this.objectFactory.createText();
        text.setValue(value);
        text.setSpace(TEXT_SPACE);
        return text;
    }

    private P buildEmptyParagraph() {
        PPr properties = this.objectFactory.createPPr();
        properties.setSpacing(this.buildNoParagraphSpacing());
        P paragraph = new P();
        paragraph.setPPr(properties);
        return paragraph;
    }

    public void save(OutputStream stream) throws Docx4JException {
        Save saver = new Save((OpcPackage)this.wmlPack);
        saver.save(stream);
    }

    public void save(String filePath) throws Docx4JException {
        File file = new File(filePath);
        this.wmlPack.save(file);
    }

    public byte[] getBytes() throws IOException, Docx4JException {
        try (ByteArrayOutputStream stream = null;){
            stream = new ByteArrayOutputStream();
            this.save(stream);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }
}

