Ext.ux.suncode.VariablesCollationWindow = function( config ) {
    config = Ext.apply( {
        modal: true,
        title: getTranslation( 'Zestawienie zmiennych' ),
        closable: true,
        items: [ new Ext.ux.suncode.VariablesCollationPanel( config ) ],
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.VariablesCollationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariablesCollationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.VariablesCollationWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.variablesCollationPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.VariablesCollationPanel = function( config ) {
    var viewSize = Ext.getBody().getViewSize();
    var processNode = config.processNode;
    var fields = new Array();
    var columns = new Array();
    var data = new Array();
    var changes = new HashMap();

    fields.push( {
        name: 'activityName',
        type: 'string'
    } );
    fields.push( {
        name: 'activityDefId',
        type: 'string'
    } );
    fields.push( {
        name: 'activityType',
        type: 'string'
    } );
    fields.push( {
        name: 'formVariableDefinitions'
    } );

    columns.push( {
        id: 'activityName',
        header: getTranslation( 'Nazwa zadania' ),
        dataIndex: 'activityName',
        align: 'left',
        width: 250,
        hideable: false,
        locked: true,
        sortable: true
    } );

    if ( !Ext.isEmpty( processNode.attributes.variables ) ) {
    	var me = this;
    	
        Ext.each( processNode.attributes.variables, function( variable, index, variables ) {
            fields.push( {
                name: 'variable_' + variable.id,
                type: 'boolean'
            } );

            columns.push( {
                id: 'variable_' + variable.id,
                header: variable.name,
                dataIndex: 'variable_' + variable.id,
                align: 'center',
                width: 100,
                renderer: {
                	fn: function( value, metaData, record, rowIndex, colIndex, store ) {
                		var id = me.getId();
                		
                		if ( value ) {
                			var rendered = '';
                			var formVariableDefinitions = record.get( 'formVariableDefinitions' );
                			var fieldName = me.getColumnModel().getDataIndex( colIndex );
                			var formVariableDefinition = formVariableDefinitions.get( fieldName );
                			var hiddenIcon = formVariableDefinition.hidden ? getPluginImgPath( 'hidden' ) : getPluginImgPath( 'visible' );
                			var hiddenTooltip = ( formVariableDefinition.hidden
        						? getTranslation( 'Ukryta' ) : getTranslation( 'Widoczna' ) ) + '<br>'
        						+ getTranslation( 'Kliknij w celu zmiany stanu' );
                			var removeVariableTooltip = getTranslation( 'Usuń zmienną z formularza' );
                			
                			if ( !formVariableDefinition.hidden ) {
                				var editableIcon = formVariableDefinition.editable
                					? getPluginImgPath( 'editable' ) : getPluginImgPath( 'noneditable' );
                				var editableTooltip = ( formVariableDefinition.editable
                					? getTranslation( 'Edytowalna' ) : getTranslation( 'Nieedytowalna' ) ) + '<br>'
                					+ getTranslation( 'Kliknij w celu zmiany stanu' );
                				rendered = '<img onmouseover=\"new Function(showImageTooltip(this, \'' + editableTooltip + '\'))\" '
                					+ 'onclick="callGridFunctionForRow(\'' + id + '\', \'onToggleEditableClick\', \''
	                				+ rowIndex + '\', \'' + colIndex + '\')" ' + 'src=\"' + editableIcon
	                				+ '\" style="margin-right: 10px;">';
                			}
                			
                			return rendered
	                        	+ '<img onmouseover=\"new Function(showImageTooltip(this, \'' + hiddenTooltip + '\'))\" '
	                        	+ 'onclick="callGridFunctionForRow(\'' + id + '\', \'onToggleHiddenClick\', \''
	                        	+ rowIndex + '\', \'' + colIndex + '\')" ' + 'src=\"' + hiddenIcon
	                        	+ '\" style="margin-right: 10px;">'
	                        	+ '<img onmouseover=\"new Function(showImageTooltip(this, \'' + removeVariableTooltip + '\'))\" '
	                        	+ 'onclick="callGridFunctionForRow(\'' + id + '\', \'onRemoveVariableFromActivityClick\', \''
	                        	+ rowIndex + '\', \'' + colIndex + '\')" ' + 'src=\"' + getPluginImgPath( 'delete' ) + '\">';
                	    } else {
                	    	var addVariableTooltip = getTranslation( 'Zmienna niedostępna na formularzu' ) + '<br>'
                	    		+ getTranslation( 'Kliknij w celu dodania zmiennej do formularza' );
                	    	
                	    	return '<img onmouseover=\"new Function(showImageTooltip(this, \'' + addVariableTooltip + '\'))\" '
                	    		+ 'onclick="callGridFunctionForRow(\'' + id + '\', \'onAddVariableToActivityClick\', \''
                	    		+ rowIndex + '\', \'' + colIndex + '\')" '+ 'src=\"' + getPluginImgPath( 'close' ) + '\">';
                	    }
                    },
                    scope: this
                }
            } );
        }, this );
    }

    processNode.eachChild( function( activityNode ) {
      var activityType = activityNode.attributes.activityType;

      if ( activityType != Ext.ux.suncode.Constants.ROUTE ) {
        var datum = new Object();
        var formVariableDefinitions = new HashMap();
        var activityName = activityNode.attributes.activityName;
        var activityDefId = activityNode.attributes.activityDefId;
        var processNode = activityNode.parentNode;
        var processDefId = processNode.attributes.processDefId
        var packageNode = processNode.parentNode;
        var packageId = packageNode.attributes.packageId
        var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, activityName );

        if ( !Ext.isEmpty( activityNode.attributes.form.variables ) ) {
          Ext.each( activityNode.attributes.form.variables, function( variable, index, variables ) {
            if ( variable.genre == 'VARIABLE' ) {
              var id = 'variable_' + variable.varId;
              datum[id] = true;
              formVariableDefinitions.put( id, {
                editable: variable.editable,
                hidden: variable.hidden,
                inVariableSet: false
              } );
            } else if ( variable.genre == 'VARIABLE_SET' ) {
              Ext.each( variable.columns, function( variableSetColumn, index, variableSetColumns ) {
                var id = 'variable_' + variableSetColumn.varId;
                datum[id] = true;
                formVariableDefinitions.put( id, {
                  editable: variableSetColumn.readonly,
                  hidden: variableSetColumn.hidden,
                  inVariableSet: true
                } );
              } );
            }
          } );
        }

        datum = Ext.apply( datum, {
          activityName: activityNameTranslation,
          activityDefId: activityDefId,
          activityType: activityType,
          formVariableDefinitions: formVariableDefinitions
        } );

        data.push( datum );

        changes.put( activityDefId, {
          addition: new HashMap(),
          deletion: new HashMap(),
          editability: new HashMap(),
          visibility: new HashMap()
        } );
      }
    } );

    config = Ext.apply( {
    	ref: 'variablesCollationPanel',
        width: viewSize.width * 0.8,
        height: viewSize.height * 0.8,
        cls: 'x-Module-wrappedHeader',
        store: new Ext.data.Store( {
            data: data,
            reader: new Ext.data.JsonReader( {
                fields: Ext.data.Record.create( fields )
            } )
        } ),
        border: false,
        columnLines: true,
        autoScroll: true,
        enableColumnResize: true,
        enableColumnMove: false,
        enableColLock: false,
        colModel: new Ext.ux.grid.LockingColumnModel( columns ),
        sm: new Ext.grid.CellSelectionModel(),
        changes: changes,
        view: new Ext.ux.grid.LockingGridView( {
            lockText: getTranslation( 'Zablokuj' ),
            unlockText: getTranslation( 'Odblokuj' ),
            getRowClass: function( record, index ) {
                return 'x-Module-variablesCollationGridCell';
            }
        } ),
        tbar: new Ext.Toolbar( {
        	items: [ {
            	xtype: 'tbtext',
            	text: getTranslation( 'Typ zadania' ) + ':'
            }, {
                xtype: 'compositefield',
                width: 200,
                ref: 'activityTypeFilterItem',
                items: [ new Ext.ux.suncode.VariablesCollactionActivityTypesChooser( {
                	flex: 1,
                	style: {
                        textAlign: 'left'
                    },
                    value: this.ALL_ACTIVITY_TYPES_FILTER_VALUE,
                	listeners: {
                        scope: this,
                        select: this.onActivityTypeFilterSelect
                    }
                } ) ]
            } ]
        } ),
        listeners: {
            scope: this,
            afterrender: this.onAfterRender,
            cellcontextmenu: this.onCellContextMenu
        }
    }, config );

    Ext.ux.suncode.VariablesCollationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariablesCollationPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.VariablesCollationPanel.superclass.initComponent.call( this );
    },
    VARIABLE_PREFIX: 'variable_',
    ALL_ACTIVITY_TYPES_FILTER_VALUE: 'ALL',
    onAfterRender: function( grid ) {
    	var variableHeaderElement = this.getView().getHeaderCell( 2 );
    	
    	if ( !Ext.isEmpty( variableHeaderElement ) ) {
    		var variableHeader = Ext.get( variableHeaderElement );
    		var activityNameHeader = Ext.get( this.getView().getHeaderCell( 0 ) );
    		var variableHeaderHeight = variableHeader.getHeight();
    		var activityNameHeaderHeight = activityNameHeader.getHeight();
    		
    		if ( variableHeaderHeight != activityNameHeaderHeight ) {
    			activityNameHeader.setHeight( variableHeaderHeight );
    		}
    	}
    },
    onCellContextMenu: function( grid, rowIndex, columnIndex, e ) {
    	var fieldName = this.getColumnModel().getDataIndex( columnIndex );

        if ( fieldName == 'activityName' ) {
        	var record = this.getRecord( rowIndex );
            var activityNode = this.getActivityNode( record );
            
            var menu = new Ext.menu.Menu( {
                items: [ {
                    xtype: 'menuitem',
                    cls: 'x-btn-text-icon',
                    icon: getPluginImgPath( 'editable' ),
                    text: getTranslation( 'Ustaw zmienne jako edytowalne' ),
                    handler: function() {
                        activityNode.setFormVariablesEditability( true );
                        this.setAllVariablesEditability( record, true );
                    },
                    scope: this
                }, {
                    xtype: 'menuitem',
                    cls: 'x-btn-text-icon',
                    icon: getPluginImgPath( 'noneditable' ),
                    text: getTranslation( 'Ustaw zmienne jako nieedytowalne' ),
                    handler: function() {
                        activityNode.setFormVariablesEditability( false );
                        this.setAllVariablesEditability( record, false );
                    },
                    scope: this
                }, {
                    xtype: 'menuitem',
                    cls: 'x-btn-text-icon',
                    icon: getPluginImgPath( 'form' ),
                    text: getTranslation( 'Formularz' ),
                    scope: this,
                    handler: function() {
                        this.ownerCt.closeWindow();
                        designActivityForm( activityNode );
                    }
                } ]
            } );

            showMenu( menu, e );
        }
    },
    onAddVariableToActivityClick: function( rowIndex, colIndex ) {
    	var fieldName = this.getColumnModel().getDataIndex( colIndex );
        var varId = fieldName.substring( this.VARIABLE_PREFIX.length );
        var processNode = this.initialConfig.processNode;
        var variable = processNode.findVariable( varId );
        
        if ( variable.placement === 'table' ) {
        	showWarn( getTranslation( 'Zmienna może być umieszczona tylko w tabeli dynamicznej.' ) );
        } else {
        	var record = this.getRecord( rowIndex );
        	var activityNode = this.getActivityNode( record );
        	var formVariableDefinitions = record.get( 'formVariableDefinitions' );
    		formVariableDefinitions.put( fieldName, {
    			editable: true,
            	hidden: false,
            	inVariableSet: false
    		} );
    		
    		record.set( 'formVariableDefinitions', formVariableDefinitions );
	        record.set( fieldName, true );
	        record.commit();
	        
	        var addition = this.changes.get( activityNode.attributes.activityDefId ).addition;
        	addition.put( variable.id, {
        		variable: variable
        	} );
	        
	        this.storeParentWindowAsUnsaved();
        }
    },
    onRemoveVariableFromActivityClick: function( rowIndex, colIndex ) {
      var record = this.getRecord( rowIndex );
      var activityNode = this.getActivityNode( record );
      var fieldName = this.getColumnModel().getDataIndex( colIndex );
      var varId = fieldName.substring( this.VARIABLE_PREFIX.length );

      if ( !this.validateVariableRemoval( activityNode, varId ) ) {
        return;
      }

      var formVariableDefinitions = record.get( 'formVariableDefinitions' );
      formVariableDefinitions.remove( fieldName );

      record.set( 'formVariableDefinitions', formVariableDefinitions );
      record.set( fieldName, false );
      record.commit();

      var activityDefId = activityNode.attributes.activityDefId;
      var addition = this.changes.get( activityDefId ).addition;

      if ( addition.contains( varId ) ) {
        addition.remove( varId );
      } else {
        var deletion = this.changes.get( activityDefId ).deletion;
        deletion.put( varId, {} );
      }

      this.storeParentWindowAsUnsaved();
    },
    validateVariableRemoval: function( activityNode, varId ) {
      var processNode = this.initialConfig.processNode;
      var variable = processNode.findVariable( varId );
      var componentsUsingVariable = activityNode.getFormActionsUsingVariable( varId );
      componentsUsingVariable = componentsUsingVariable.concat( activityNode.getEventActionsUsingVariable( varId ) );

      if ( !Ext.isEmpty( componentsUsingVariable ) ) {
        var varName = variable.name;
        var warning = getTranslation( 'Zmienna' ) + ' <b>' + varName + '</b> '
            + getTranslation( 'jest wykorzystywana w komponentach' ) + '.';
        var title = getTranslation( 'Komponenty wykorzystujące zmienną' ) + ': ' + varName;
        Ext.ux.suncode.IntegrationComponentService.showComponentsUsingVariableWarning( warning, {
          windowTitle: title,
          utilization: componentsUsingVariable,
          showCustomDescription: true,
          showVariableUtilizationActions: true,
          enableRemoveAll: true,
          preventSave: true,
          processNode: processNode,
          variableId: varId
        } );
        return false;
      } else {
        return true;
      }
    },
    onToggleEditableClick: function( rowIndex, colIndex ) {
        var record = this.getRecord( rowIndex );
        var activityNode = this.getActivityNode( record );
        var fieldName = this.getColumnModel().getDataIndex( colIndex );
        var varId = fieldName.substring( this.VARIABLE_PREFIX.length );
        var formVariableDefinitions = record.get( 'formVariableDefinitions' );
        var formVariableDefinition = formVariableDefinitions.get( fieldName );
        formVariableDefinition.editable = !formVariableDefinition.editable;
		    formVariableDefinitions.put( fieldName, formVariableDefinition );
		
		    record.set( 'formVariableDefinitions', formVariableDefinitions );
        record.commit();
        
        var editability = this.changes.get( activityNode.attributes.activityDefId ).editability;
        editability.put( varId, {
        	inVariableSet: formVariableDefinition.inVariableSet,
        	editable: formVariableDefinition.editable
    	  } );
        
        this.storeParentWindowAsUnsaved();
    },
    onToggleHiddenClick: function( rowIndex, colIndex ) {
    	var fieldName = this.getColumnModel().getDataIndex( colIndex );
    	var varId = fieldName.substring( this.VARIABLE_PREFIX.length );
    	var record = this.getRecord( rowIndex );
        var activityNode = this.getActivityNode( record );
        var formVariableDefinitions = record.get( 'formVariableDefinitions' );
        var formVariableDefinition = formVariableDefinitions.get( fieldName );
        var valid = true;
        
        if ( formVariableDefinition.inVariableSet ) {
        	var variableSet = activityNode.getVariableSetByColumn( varId );

            if ( !Ext.isEmpty( variableSet ) ) {
                var visibleColumns = 0;
                Ext.each( variableSet.columns, function( variableSetColumn, index, variableSetColumns ) {
                    if ( !variableSetColumn.hidden ) {
                        visibleColumns++;
                    }
                } );

                if ( !formVariableDefinition.hidden && visibleColumns == 1 ) {
                	valid = false;
                	
                    var msg = 'Tabela dynamiczna, która zawiera zmienną, ';
                    msg += 'musi posiadać przynajmniej jedną widoczną kolumnę.';
                    showWarn( getTranslation( msg ) );
                }
            }
        }
        
        if ( valid ) {
        	formVariableDefinition.hidden = !formVariableDefinition.hidden;
            if ( formVariableDefinition.hidden ) {
            	formVariableDefinition.editable = true;
            	
            	var editability = this.changes.get( activityNode.attributes.activityDefId ).editability;
                editability.put( varId, {
                	inVariableSet: formVariableDefinition.inVariableSet,
                	editable: true
            	} );
            }
    		formVariableDefinitions.put( fieldName, formVariableDefinition );
    		
    		record.set( 'formVariableDefinitions', formVariableDefinitions );
            record.commit();
            
            var visibility = this.changes.get( activityNode.attributes.activityDefId ).visibility;
            visibility.put( varId, {
            	inVariableSet: formVariableDefinition.inVariableSet,
            	hidden: formVariableDefinition.hidden
        	} );
            
            this.storeParentWindowAsUnsaved();
        }
    },
    setAllVariablesEditability: function( record, editable ) {
    	var formVariableDefinitions = record.get( 'formVariableDefinitions' );
    	var activityNode = this.getActivityNode( record );
    	var editability = this.changes.get( activityNode.attributes.activityDefId ).editability;
    	
    	formVariableDefinitions.each( function( fieldName, formVariableDefinition ) {
    		Ext.apply( formVariableDefinition, {
    			editable: editable
    		} );
    		
    		var varId = fieldName.substring( this.VARIABLE_PREFIX.length );
    		
            editability.put( varId, {
            	inVariableSet: formVariableDefinition.inVariableSet,
            	editable: formVariableDefinition.editable
        	} );
    	}, this );
    	
    	record.set( 'formVariableDefinitions', formVariableDefinitions );
        record.commit();
    },
    getRecord: function( rowIndex ) {
    	var store = this.getStore();
    	
        return store.getAt( rowIndex );
    },
    getActivityNode: function( record ) {
        var activityDefId = record.get( 'activityDefId' );
        
        return this.getActivityNodeById( activityDefId );
    },
    getActivityNodeById: function( activityDefId ) {
    	var packagePanel = Ext.getCmp( 'package_panel' );
        var processNode = this.initialConfig.processNode;
        var processDefId = processNode.attributes.processDefId;
        
        return packagePanel.findActivity( processDefId, activityDefId );
    },
    onActivityTypeFilterSelect: function( combo, record, index ) {
    	var value = combo.getValue();
    	
    	if ( combo.isValid() && !Ext.isEmpty( value ) ) {
    		this.doFilter( {
            	activityType: value
            } );
    	}
    },
    doFilter: function( filter ) {
    	var store = this.getStore();
    	var filterByActivityType = !Ext.isEmpty( filter.activityType ) && filter.activityType != this.ALL_ACTIVITY_TYPES_FILTER_VALUE;
    	
    	store.filterBy( function( record, id ) {
        	var accept = true;
        	
        	if ( filterByActivityType && record.get( 'activityType' ) !== filter.activityType ) {
        		accept = false;
        	}
    		
    		return accept;
    	} );
    },
    saveForm: function() {
    	this.changes.each( function( activityDefId, change ) {
    		var activityNode = this.getActivityNodeById( activityDefId );
    		
    		change.addition.each( function( variableId, definition ) {
    			this.addVariableToActivity( activityNode, definition.variable );
        	}, this );
    		
    		change.deletion.each( function( variableId, definition ) {
    			activityNode.clearFormVariablesByVarId( variableId );
        	}, this );
    		
    		change.editability.each( function( variableId, definition ) {
    			if ( definition.inVariableSet ) {
                	activityNode.setVariableSetColumnReadOnly( variableId, !definition.editable );
                } else {
                	activityNode.setFormVariableEditability( variableId, definition.editable );
                }
        	}, this );
    		
    		change.visibility.each( function( variableId, definition ) {
    			if ( definition.inVariableSet ) {
                	activityNode.setVariableSetColumnVisibility( variableId, definition.hidden );
                } else {
                	activityNode.setFormVariableVisibility( variableId, definition.hidden );
                }
        	}, this );
    	}, this );
    	
    	this.ownerCt.closeWindow();
    },
    addVariableToActivity: function( activityNode, variable ) {
    	var processNode = this.initialConfig.processNode;
    	var globalSettings = processNode.attributes.globalSettings.formVariableLabel;
        var varDef = new Object();
        varDef = Ext.apply( {
            varId: variable.id,
            name: variable.name,
            type: variable.type,
            hidden: false,
            editable: true,
            autoUpdates: new Array(),
            formActions: new Array(),
            eventActions: new Array(),
            genre: 'VARIABLE'
        }, varDef );

        var item = new Object();
        item = Ext.apply( {
            id: variable.id,
            type: variable.type,
            labelAlign: globalSettings.labelAlign,
            labelWidth: globalSettings.labelWidth,
            labelSeparator: globalSettings.labelSeparator,
            labelFontSize: globalSettings.labelFontSize,
            labelColor: globalSettings.labelColor,
            textDecoration: globalSettings.textDecoration,
            width: null
        }, item );

        if ( variable.type == 'TEXTAREA' ) {
            item = Ext.apply( {
                height: 100
            }, item );
        }

        if ( variable.type == 'ROLEUSERS' || variable.type == 'ROLEUSERS_NO_FILTER' ) {
            varDef = Ext.apply( {
                roleusersFilters: [ {
                    type: 'role',
                    value: 'unknown'
                } ],
                roleusersConjunction: false
            }, varDef );
        }

        activityNode.addVariable( varDef, item );
    }
} );