Ext.ux.suncode.PackageExportWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var packageId = config.packageId;
    var packageName = config.packageName;
    var packageNameTranslation = getXpdlPackageNameTranslation( packageId, packageName );

    var mainPanel = Ext.getCmp( 'main_panel' );
    config = Ext.apply( {
        AV: mainPanel.getAdvancedView(),
        packageNameTranslation: packageNameTranslation,
        packageNewAuthor: config.skipExport ? config.packageAuthor : mainPanel.getUserName(),
        windowWidth: windowWidth
    }, config );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoHeight: true,
        title: getTranslation( 'Eksport pakietu o nazwie' ) + ' ' + packageNameTranslation,
        layout: 'fit',
        items: [ new Ext.ux.suncode.PackageExportPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'package_export' ),
                tooltip: getTranslation( 'Publikuj' ),
                handler: this.executeExport,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.PackageExportWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackageExportWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.PackageExportWindow.superclass.initComponent.call( this );

        if ( !this.initialConfig.skipExport ) {
            this.on( 'beforeshow', lockHotkeys );
            this.on( 'beforeclose', unlockHotkeys );
        }
    },
    executeExport: function() {
        this.packageExportPanel.executeExport();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.PackageExportPanel = function( config ) {
    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        frame: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: config.windowWidth * 0.4,
        autoHeight: true,
        autoScroll: true,
        border: false,
        ref: 'packageExportPanel',
        items: [ {
            xtype: 'displayfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Identyfikator pakietu' ),
            anchor: '100%',
            value: config.packageId,
            ref: 'packageIdItem',
            hidden: !config.AV
        }, {
            xtype: 'displayfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Nazwa pakietu' ),
            anchor: '100%',
            value: config.packageNameTranslation,
            ref: 'packageNameItem'
        }, {
            xtype: 'displayfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Nowy autor' ),
            anchor: '100%',
            value: config.packageNewAuthor,
            ref: 'packageNewAuthorItem'
        }, {
            xtype: 'displayfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Ilość procesów' ),
            anchor: '100%',
            value: config.packageNoOfProcesses,
            ref: 'packageNoOfProcessesItem'
        }, {
            xtype: 'fieldset',
            autoHeight: true,
            anchor: '100%',
            title: getTranslation( 'Informacje o pakiecie' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                inputType: 'text',
                height: 150,
                autoScroll: true,
                anchor: '100%',
                ref: '../packageInfoItem',
                value: config.packageInfoTemplate.content
            } ]
        } ]
    }, config );

    Ext.ux.suncode.PackageExportPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackageExportPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.PackageExportPanel.superclass.initComponent.call( this );
    },
    executeExport: function() {
    	var mainPanel = Ext.getCmp( 'main_panel' );
    	var packageInfo = this.packageInfoItem.getValue();
        
        if ( mainPanel.isProductionSystemType() ) {
          if ( Ext.isEmpty( packageInfo ) ) {
            showWarn( getTranslation( 'System produkcyjny wymaga uzupełnienia sekcji "Informacje o pakiecie".' ) );
            return;
          } else if ( this.shouldValidatePackageInfo() && !this.isValidPackageInfo( packageInfo ) ) {
            showWarn( getTranslation( 'Sekcja "Informacje o pakiecie" jest niezgodna z szablonem lub nieuzupełniona.' ) );
            return;
          }
        }
        
        var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
        var skipExport = this.initialConfig.skipExport;
        var packageId = this.initialConfig.packageId;
        var packageName = this.initialConfig.packageName;
        var packageVersion = this.initialConfig.packageVersion;
        var formTemplates = new Array();
        var nodeToReload = this.initialConfig.nodeToReload;
        this.ownerCt.closeWindow();

        if ( skipExport ) {
            executeRefreshXpdl( {
                packageId: packageId,
                packageName: packageName,
                packageVersion: packageVersion,
                packageInfo: packageInfo,
                formTemplates: Ext.util.JSON.encode( formTemplates ),
                processSpecifications: Ext.util.JSON.encode( packageNode.getProcessSpecifications() ),
                formPreviewProcessDataSets: Ext.util.JSON.encode( packageNode.getFormPreviewProcessDataSets() ),
                processGlobalSettings: Ext.util.JSON.encode( packageNode.getProcessGlobalSettings() ),
                xpdlTranslations: Ext.util.JSON.encode( Ext.ux.suncode.I18NService.getAllPackageTranslations() ),
                nodeToReload: nodeToReload
            } );
        } else {
            executeExportXpdl( {
                packageId: packageId,
                packageName: packageName,
                packageInfo: packageInfo
            } );
        }
    },
    shouldValidatePackageInfo: function() {
      return this.initialConfig.packageInfoTemplate.validate;
    },
    isValidPackageInfo: function( packageInfo ) {
        var valid = true;
        var templateContent = this.initialConfig.packageInfoTemplate.content;
        var templateContentLines = templateContent.split( '\n' );
        var packageInfoLines = packageInfo.split( '\n' );

        if ( !Ext.isEmpty( templateContentLines ) ) {
          for ( var i = 0; i < templateContentLines.length; i++ ) {
            var templateContentLine = templateContentLines[i];
            var found = false;

            for ( var j = 0; j < packageInfoLines.length; j++ ) {
              var packageInfoLine = packageInfoLines[j];

              if ( packageInfoLine.startsWith( templateContentLine )
                  && !Ext.isEmpty( packageInfoLine.substring( templateContentLine.length) ) ) {
                found = true;
                break;
              }
            }

            if ( !found ) {
              valid = false;
              break;
            }
          }
        }

        return valid;
    }
} );