Ext.ux.suncode.MainPanel = function( config ) {
    var height = 0;
    var pageContainerEl = document.getElementById('page-container');

    if ( !Ext.isEmpty( pageContainerEl ) ) {
      height = pageContainerEl.offsetHeight - 1;
    } else {
      height = Ext.getBody().getViewSize().height;
    }

    var editionMode = config.editionMode;
    var items = new Array();
    items.push( new Ext.ux.suncode.PackagePanel( config ) );
    items.push( new Ext.ux.suncode.PaperPanel( config ) );

    config = Ext.apply( {
        id: 'main_panel',
        renderTo: 'pwe-div',
        autoWidth: true,
        height: height,
        layout: 'border',
        border: false,
        bodyStyle: {
            border: '0'
        },
        defaults: {
            split: true
        },
        tools: editionMode ? null : [ {
          id: 'maximize',
          type: 'maximize',
          qtip: getTranslation( 'Maksymalizuj' ),
          handler: function( event, toolEl, panel ) {
            fullScreen();
          }
        } ],
        tbar: new Ext.ux.suncode.MainPanelTopToolbar( config ),
        items: items,
        menus: new Array(),
        standardDataChoosers: new Array(),
        standardAutoUpdates: new Array(),
        acceptValidators: new Array(),
        variablesSetters: new Array(),
        integrationComponents: {
            formActions: new Object(),
            validators: new Object(),
            variablesSetters: new Object(),
            applications: new Object(),
            dataChoosers: new Object(),
            eventTypes: new Array(),
            eventActions: new Object()
        },
        autoJS: {
            dtButtons: new Array()
        },
        customJS: new Array(),
        javaClasses: new Array(),
        systemFunctions: new Array(),
        systemColors: new Array(),
        hotkeysLocked: false,
        saved: true,
        modes: {
            editionMode: true,
            currentActivityMapMode: false,
            simulationMode: false,
            processPreviewMode: false
        },
        globalConfig: {
            userName: '',
            enableDataChooserAutoMapping: false
        },
        simulationInfo: null,
        screenMaskId: 'screen_mask_id',
        transitionIds: new Array(),
        globalIds: new Array(),
        autoSaveActive: editionMode,
        autoSaveStarted: false,
        autoSaveTask: {
    	    run: autoSave,
    	    interval: 2 * 60 * 1000
    	},
    	checkSavedOnUnload: true,
    	unsavedWindows: new HashMap(),
    	formDesignerConfig: {
    		gridActive: false,
        copyModeActive: false,
        integrationComponentsVisible: false
    	},
    	customFormConfig: {
    		typesVisible: false,
        functionPrettyFormat: true
      },
      currentXpdlVersion: null
    }, config );

    Ext.ux.suncode.MainPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.MainPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.MainPanel.superclass.initComponent.call( this );
    },
    PRODUCTION_SYSTEM_TYPE: 'Production',
    SNAPSHOT_VERSION_PART: 'SNAPSHOT',
    FORM_OBJECT_TYPE: 'FORM',
    VARIABLE_OBJECT_TYPE: 'VARIABLE',
    VARIABLE_SET_OBJECT_TYPE: 'GRID',
    DT_BUTTON_OBJECT_TYPE: 'DT_BUTTON',
    HTTP_LINK_OBJECT_TYPE: 'ACTION_BUTTON',
    ACCEPT_BUTTON_OBJECT_TYPE: 'ACCEPT_BUTTON',
    isProductionSystemType: function() {
      return this.systemType === this.PRODUCTION_SYSTEM_TYPE;
    },
    getVersion: function() {
      return this.version;
    },
    getCurrentXpdlVersion: function() {
      return this.currentXpdlVersion;
    },
    setCurrentXpdlVersion: function( currentXpdlVersion) {
      this.currentXpdlVersion = currentXpdlVersion;
    },
    isCurrentXpdlVersionOlder: function() {
      if ( !Ext.isEmpty( this.currentXpdlVersion ) ) {
        var splittedVersion = this.version.split( /[.-]/ );
        var splittedCurrentXpdlVersion = this.currentXpdlVersion.split( /[.-]/ );

        for ( var i = 0; i < splittedVersion.length; i++ ) {
          var versionPart = splittedVersion[i];

          if ( splittedCurrentXpdlVersion.length >= i ) {
            var currentXpdlVersionPart = splittedCurrentXpdlVersion[i];

            if ( ( versionPart === this.SNAPSHOT_VERSION_PART
                    && currentXpdlVersionPart !== this.SNAPSHOT_VERSION_PART )
                || ( versionPart !== this.SNAPSHOT_VERSION_PART
                    && currentXpdlVersionPart === this.SNAPSHOT_VERSION_PART )
                || parseInt( versionPart ) < parseInt( currentXpdlVersionPart ) ) {
              return true;
            }
          }
        }

        if ( splittedVersion.length > splittedCurrentXpdlVersion.length ) {
          return true;
        }
      }

      return false;
    },
    getUserConfig: function() {
        return this.userConfig;
    },
    getAdvancedView: function() {
        return this.userConfig.advancedView;
    },
    changeAdvancedView: function() {
        this.userConfig.advancedView = !this.userConfig.advancedView;
    },
    getExperimentalView: function() {
      return this.userConfig.experimentalView;
    },
    changeExperimentalView: function() {
      this.userConfig.experimentalView = !this.userConfig.experimentalView;
    },
    getStandardDataChoosers: function() {
        return this.standardDataChoosers;
    },
    setStandardDataChoosers: function( dcs ) {
        if ( dcs ) {
            this.standardDataChoosers = dcs;
        }
    },
    getStandardDataChooser: function( dcId ) {
        var allDcs = this.standardDataChoosers;
        for ( var i = 0; i < allDcs.length; i++ ) {
            if ( dcId == allDcs[i].id ) {
                return allDcs[i];
            }
        }
        return null;
    },
    getStandardDataChooserByClasspath: function( classpath ) {
        var allDcs = this.standardDataChoosers;
        for ( var i = 0; i < allDcs.length; i++ ) {
            if ( classpath == allDcs[i].definition.classpath ) {
                return allDcs[i];
            }
        }
        return null;
    },
    getStandardAutoUpdates: function() {
        return this.standardAutoUpdates;
    },
    setStandardAutoUpdates: function( autoUpdates ) {
        if ( autoUpdates ) {
            this.standardAutoUpdates = autoUpdates;
        }
    },
    getStandardAutoUpdate: function( autoUpdateId ) {
        var autoUpdates = this.standardAutoUpdates;
        for ( var i = 0; i < autoUpdates.length; i++ ) {
            if ( autoUpdateId == autoUpdates[i].id ) {
                return autoUpdates[i];
            }
        }
        return null;
    },
    getStandardAutoUpdateByTaskName: function( taskName ) {
        var autoUpdates = this.standardAutoUpdates;
        for ( var i = 0; i < autoUpdates.length; i++ ) {
            if ( taskName == autoUpdates[i].definition.taskName ) {
                return autoUpdates[i];
            }
        }
        return null;
    },
    getAcceptValidators: function() {
        return this.acceptValidators;
    },
    setAcceptValidators: function( validators ) {
        this.acceptValidators = validators;
    },
    getAcceptValidator: function( classpath ) {
        var classes = this.acceptValidators;

        return this.getClassByClasspath( classes, classpath );
    },
    getVariablesSetters: function() {
        return this.variablesSetters;
    },
    setVariablesSetters: function( setters ) {
        this.variablesSetters = setters;
    },
    getVariablesSetter: function( classpath ) {
        var classes = this.variablesSetters;

        return this.getClassByClasspath( classes, classpath );
    },
    getClassByClasspath: function( classes, classpath ) {
        for ( var i = 0; i < classes.length; i++ ) {
            var clazz = classes[i];
            if ( clazz.classpath == classpath ) {
                return clazz;
            }
        }
        return null;
    },
    loadIntegrationComponents: function( finalizeTask ) {
    	var loaders = [ {
    		url: '/api/workflow/form/actions/grouppedByCategories',
    		setter: this.setFormActionsIntegrationComponentCategories
    	}, {
    		url: '/api/workflow/validators/grouppedByCategories',
    		setter: this.setValidatorsIntegrationComponentCategories
    	}, {
    		url: '/api/workflow/variablessetters/grouppedByCategories',
    		setter: this.setVariablesSettersIntegrationComponentCategories
    	}, {
    		url: '/api/workflow/applications/grouppedByCategories',
    		setter: this.setApplicationsIntegrationComponentCategories
    	}, {
    		url: '/api/workflow/form/datachoosers/grouppedByCategories',
    		setter: this.setDataChoosersIntegrationComponentCategories
    	} ];

    	this.executeLoadIntegrationComponents( loaders, finalizeTask );
    },
    executeLoadIntegrationComponents: function( loaders, finalizeTask ) {
        var me = this
        var promises = loaders.map(function (loader) {
            return new Promise(function(resolve) {
                Ext.Ajax.request( {
                    url: Suncode.context( 'pwe' ).contextPath + loader.url,
                    method: 'GET',
                    scope: this,
                    success: function( response ) {
                        var categories = Ext.util.JSON.decode( response.responseText );
                        loader.setter.apply( me, [ categories ] );
                        resolve()
                    },
                    failure: function( ) {
                        resolve()
                    }
                } );
            })
        })

        Promise.all(promises)
            .then(function() {
                finalizeTask.run()
            })
    },
    supplyIntegrationComponents: function( categories, groupName ) {
    	if ( !Ext.isEmpty( categories ) ) {
            Ext.iterate( categories, function( category, components, allCategories ) {
                Ext.each( components, function( component, index, allComponents ) {
                	var componentReplacement = ( component.deprecated && !Ext.isEmpty( component.componentReplacement) ) ?
            				Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( categories,
            						component.componentReplacement ) : null;
            		  var replacement = Ext.ux.suncode.IntegrationComponentService.getReplacementLabel( component, componentReplacement );
            				
                    component = Ext.apply( component, {
                        category: category,
                        groupName: groupName,
                        replacement: replacement
                    } );

                    if ( !Ext.isEmpty( component.documentationLink ) ) {
                      component = Ext.apply( component, {
                        documentationLink: this.buildUrl( component.documentationLink )
                      } );
                    }

                  if ( !Ext.isEmpty( component.dtButtons ) ) {
                    Ext.each( component.dtButtons, function( dtButton, dtButtonIndex, dtButtons ) {
                      if ( !Ext.isEmpty( dtButton.icon ) ) {
                        dtButton.icon = 'style/img/fam/' +
                            dtButton.icon.replaceAll( 'silk-', '' ).replaceAll( '-', '_' ) + '.png';
                      }
                    } );
                  }

                  Ext.ux.suncode.IntegrationComponentService.storePluginInfo( component.source.id, {
                      name: component.source.name,
                      description: component.source.description
                  } );
                }, this );
            }, this );

            return categories;
        } else {
            return new Object();
        }
    },
    buildUrl: function( link ) {
      return link.match( /^https?:\/\//i ) ? link : 'http://' + link;
    },
    setFormActionsIntegrationComponentCategories: function( categories ) {
        this.integrationComponents = Ext.apply( this.integrationComponents, {
            formActions: this.supplyIntegrationComponents( categories, getTranslation( 'Akcje formularza' )  )
        } );
    },
    getFormActionsIntegrationComponentCategories: function() {
        if ( !Ext.isEmpty( this.integrationComponents ) ) {
            return this.integrationComponents.formActions;
        } else {
            return new Object();
        }
    },
    setValidatorsIntegrationComponentCategories: function( categories ) {
    	this.integrationComponents = Ext.apply( this.integrationComponents, {
            validators: this.supplyIntegrationComponents( categories, getTranslation( 'Mechanizmy sprawdzające formularz' ) )
        } );
    },
    getValidatorsIntegrationComponentCategories: function() {
        if ( !Ext.isEmpty( this.integrationComponents ) ) {
            return this.integrationComponents.validators;
        } else {
            return new Object();
        }
    },
    setVariablesSettersIntegrationComponentCategories: function( categories ) {
    	this.integrationComponents = Ext.apply( this.integrationComponents, {
            variablesSetters: this.supplyIntegrationComponents( categories, getTranslation( 'Mechanizmy uruchamiane po akceptacji' ) )
        } );
    },
    getVariablesSettersIntegrationComponentCategories: function() {
        if ( !Ext.isEmpty( this.integrationComponents ) ) {
            return this.integrationComponents.variablesSetters;
        } else {
            return new Object();
        }
    },
    setApplicationsIntegrationComponentCategories: function( categories ) {
    	this.integrationComponents = Ext.apply( this.integrationComponents, {
    		applications: this.supplyIntegrationComponents( categories, getTranslation( 'Aplikacje' ) )
        } );
    },
    getApplicationsIntegrationComponentCategories: function() {
        if ( !Ext.isEmpty( this.integrationComponents ) ) {
            return this.integrationComponents.applications;
        } else {
            return new Object();
        }
    },
    setDataChoosersIntegrationComponentCategories: function( categories ) {
    	this.integrationComponents = Ext.apply( this.integrationComponents, {
    		dataChoosers: this.supplyIntegrationComponents( categories, getTranslation( 'Dynamiczne listy' ) )
        } );
    },
    getDataChoosersIntegrationComponentCategories: function() {
        if ( !Ext.isEmpty( this.integrationComponents ) ) {
            return this.integrationComponents.dataChoosers;
        } else {
            return new Object();
        }
    },
    setEventTypes: function( types ) {
      this.integrationComponents = Ext.apply( this.integrationComponents, {
        eventTypes: types
      } );
    },
    getEventTypesForForm: function() {
      return this.getEventTypesForObject( this.FORM_OBJECT_TYPE );
    },
    getEventTypesForVariable: function() {
      return this.getEventTypesForObject( this.VARIABLE_OBJECT_TYPE );
    },
    getEventTypesForVariableSet: function() {
      return this.getEventTypesForObject( this.VARIABLE_SET_OBJECT_TYPE );
    },
    getEventTypesForDtButton: function() {
      return this.getEventTypesForObject( this.DT_BUTTON_OBJECT_TYPE );
    },
    getEventTypesForHttpLink: function() {
      return this.getEventTypesForObject( this.HTTP_LINK_OBJECT_TYPE );
    },
    getEventTypesForAcceptButton: function() {
      return this.getEventTypesForObject( this.ACCEPT_BUTTON_OBJECT_TYPE );
    },
    getEventTypesForObject: function( objectType ) {
      if ( !Ext.isEmpty( this.integrationComponents ) ) {
        var eventTypes = this.integrationComponents.eventTypes;

        if ( !Ext.isEmpty( eventTypes ) ) {
          for ( var i = 0; i < eventTypes.length; i++ ) {
            var objectEventTypes = eventTypes[i];

            if ( objectEventTypes.type == objectType ) {
              return objectEventTypes.events;
            }
          }
        }
      }

      return new Array();
    },
    setEventActionsCategories: function( categories ) {
      const eventActions = this.supplyIntegrationComponents( categories, getTranslation( 'Zdarzenia' )  );

      const index = new Map();
      Ext.iterate(categories, (category, components) => {
        Ext.each(components, (cmp) => {
            index.set(cmp.id, cmp);
        })
      });

      this.integrationComponents = Ext.apply( this.integrationComponents, {
        eventActions: eventActions,
        eventActionsById: index
      } );
    },
    getEventActionsCategories: function() {
      if ( !Ext.isEmpty( this.integrationComponents ) ) {
        return this.integrationComponents.eventActions;
      } else {
        return new Object();
      }
    },
    getEventAction: function(id) {
        return this.integrationComponents.eventActionsById.get(id);
    },
    storeDTButtonJS: function( dtbtn ) {
        var add = true;
        var container = null;
        var objToAdd = null;

        if ( Ext.isEmpty( dtbtn.buttonDefId ) ) {
            container = this.customJS;
            objToAdd = {
                sourceCodeType: 'JS_DT_BUTTON',
                functionName: dtbtn.handler,
                options: {
                    parameters: [ 'oButton' ]
                }
            };
            var handler = dtbtn.handler;

            for ( var i = 0; i < container.length; i++ ) {
                if ( handler == container[i].handler ) {
                    add = false;
                    break;
                }
            }
        } else {
            if ( dtbtn.parameterized && !Ext.isEmpty( dtbtn.params ) ) {
                if ( typeof CUF !== 'undefined' && typeof CUFDefs.DTButtons !== 'undefined' ) {
                    var button = CUFDefs.DTButtons[dtbtn.buttonDefId];

                    if ( !Ext.isEmpty( button ) ) {
                        dtbtn = Ext.apply( {
                            systemButtonHandler: button.handler
                        }, dtbtn );
                    }
                }

                container = this.autoJS.dtButtons;
                objToAdd = dtbtn;
                var buttonId = dtbtn.buttonId;

                for ( var i = 0; i < container.length; i++ ) {
                    if ( buttonId == container[i].buttonId ) {
                        add = false;
                        break;
                    }
                }
            } else {
                add = false;
            }
        }

        if ( add ) {
            container.push( objToAdd );
        }
    },
    storeAcceptButtonJS: function( btnDef ) {
        var add = true;
        var container = this.customJS;
        var jsAction = btnDef.jsAction;

        for ( var i = 0; i < container.length; i++ ) {
            if ( jsAction == container[i].handler ) {
                add = false;
                break;
            }
        }

        if ( add ) {
            container.push( {
                sourceCodeType: 'JS_ACTION_ACCEPT_BUTTON',
                functionName: btnDef.jsAction,
                options: {
                    parameters: []
                }
            } );
        }
    },
    storeDTActionJS: function( actionDef ) {
        var add = true;
        var container = this.customJS;
        var func = actionDef.func;

        for ( var i = 0; i < container.length; i++ ) {
            if ( func == container[i].handler ) {
                add = false;
                break;
            }
        }

        if ( add ) {
            container.push( {
                sourceCodeType: 'JS_DT_EVENT',
                functionName: actionDef.func,
                options: {
                    parameters: Ext.ux.suncode.DTActionsParams.getActionParamsAsTable( actionDef.source )
                }
            } );
        }
    },
    storeHttpLinkJS: function( hlDef ) {
        var add = true;
        var container = this.customJS;
        var url = hlDef.url;

        for ( var i = 0; i < container.length; i++ ) {
            if ( url == container[i].handler ) {
                add = false;
                break;
            }
        }

        if ( add ) {
            var hlParams = hlDef.params;
            var params = new Array();

            for ( var i = 0; i < hlParams.length; i++ ) {
                params.push( hlParams[i].varId );
            }

            container.push( {
                sourceCodeType: 'JS_HTTP_LINK',
                functionName: hlDef.url,
                options: {
                    parameters: params
                }
            } );
        }
    },
    clearCustomJS: function() {
        this.customJS = new Array();
    },
    addJavaClass: function( c ) {
        var add = true;
        var container = this.javaClasses;
        var qualifiedName = c.qualifiedName;

        for ( var i = 0; i < container.length; i++ ) {
            if ( qualifiedName == container[i].qualifiedName ) {
                add = false;
                break;
            }
        }

        if ( add ) {
            container.push( c );
        }
    },
    clearJavaClasses: function() {
        this.javaClasses = new Array();
    },
    setSystemFunctions: function( functions ) {
        this.systemFunctions = this.supplySystemFunctions( functions );
    },
    getSystemFunctions: function( returnType, inArray, accessibility, recommendations ) {
    	var systemFunctions = new Array();
    	var compatibilityMode = this.getCompatibilityMode();
    	
    	Ext.each( this.systemFunctions, function( func, funcIndex, funcs ) {
            if ( ( compatibilityMode.showDeprecatedSystemFunctions() || !func.deprecated )
            		&& ( returnType === Ext.ux.suncode.IntegrationComponentService.FUNCTION_TYPE
            				|| func.returnType === returnType || ( inArray && func.returnType === returnType + '[]' ) )
            		&& ( func.accessibility === Ext.ux.suncode.IntegrationComponentService.ALL_ACCESSIBILITY
            				|| Ext.isEmpty( func.accessibility ) || func.accessibility === accessibility ) ) {
            	systemFunctions.push( func );
            }
        } );
    	
    	if ( Ext.isArray( recommendations ) && !Ext.isEmpty( recommendations ) ) {
    		systemFunctions.sort( function( a, b ) {
    			var aIsRecommended = recommendations.indexOf( a.name ) != -1;
    			var bIsRecommended = recommendations.indexOf( b.name ) != -1;
    			
    			if ( aIsRecommended === bIsRecommended ) {
    				return ( a.name.toLowerCase() > b.name.toLowerCase() ) ? 1 : -1;
    			} else {
    				return aIsRecommended ? -1 : 1;
    			}
    		} );
    	}
    	
        return systemFunctions;
    },
    getSystemFunction: function( name, parameterTypes ) {
        var systemFunction = null;

        Ext.each( this.systemFunctions, function( func, funcIndex, funcs ) {
            if ( func.name === name && func.parameters.length == parameterTypes.length ) {
            	var match = true;
            	
            	Ext.each( func.parameters, function( parameter, parameterIndex, parameters ) {
        			var type = !Ext.isEmpty( parameter.type ) ? parameter.type : 'string';
        			var parameterType = parameterTypes[parameterIndex];
        			
        			if ( Ext.isEmpty( parameterType ) || parameterType.type != type ||
        					parameterType.array !== parameter.array ) {
        				match = false
        				return false;
        			}
                } );
            	
            	if ( match ) {
            		systemFunction = func;
            	}
            }
            
            if ( !Ext.isEmpty( systemFunction ) ) {
            	return false;
            }
        } );

        return systemFunction;
    },
    supplySystemFunctions: function( functions ) {
        if ( !Ext.isEmpty( functions ) ) {
        	var service = Ext.ux.suncode.IntegrationComponentService;
        	
        	Ext.each( functions, function( func, funcIndex, allFunctions ) {
        		var extendedName = func.name;
        		var parameterTypes = new Array();
        		var parameterExtendedNames = new Array();
        		
        		if ( !Ext.isEmpty( func.parameters ) ) {
	        		Ext.each( func.parameters, function( parameter, parameterIndex, allParameters ) {
	        			var parameterType = !Ext.isEmpty( parameter.type ) ? parameter.type : service.STRING_TYPE;
	        			var parameterId = !Ext.isEmpty( parameter.id ) ? parameter.id : 'param';
	        			var parameterExtendedName = service.getParameterTypeTranslation( new String( parameterType ) );
	        			if ( parameter.array ) {
	        				parameterExtendedName += '[]';
	        			}
	        			parameterExtendedName += ' ';
	        			parameterExtendedName += parameterId;
	        			
	        			parameterTypes.push( {
	        				type: parameterType,
	        				array: parameter.array
	        			} );
	        			parameterExtendedNames.push( parameterExtendedName );
	                } );
        		}
        		
        		extendedName += '(';
        		extendedName += parameterExtendedNames.join( ', ' );
        		extendedName += ')';
        		
        		func = Ext.apply( func, {
        			extendedName: extendedName,
                    parameterTypes: parameterTypes
                } );
            } );
        	
        	functions.sort( this.compareSystemFunctions );

            return functions;
        } else {
            return new Array();
        }
    },
    compareSystemFunctions: function( func1, func2 ) {
    	var parameterTypesOrder = [ 'string', 'integer', 'float', 'boolean', 'date', 'datetime', 'variable', 'function' ];
    	
    	if ( func1.name !== func2.name ) {
    		return func1.name > func2.name ? 1 : -1;
    	} else {
    		for( var i = 0; i< func1.parameterTypes.length; i++ ) {
    			var parameterType1 = func1.parameterTypes[i];
    			var parameterType2 = func2.parameterTypes[i];
    			
    			if ( Ext.isEmpty( parameterType2 ) ) {
    				return 1;
    			}
    			
    			if ( parameterType1.array !== parameterType2.array ) {
    				return parameterType1.array === true ? 1 : -1;
    			}
    			
    			if ( parameterType1.type !== parameterType2.type ) {
    	    		return parameterTypesOrder.indexOf( parameterType1.type ) - parameterTypesOrder.indexOf( parameterType2.type );
    	    	}
    		}
    		
    		if ( func1.parameterTypes.length < func2.parameterTypes.length ) {
    			return -1;
    		}
    		
    		return -1;
    	}
    },
    getSystemFunctionOverloadings: function( name, returnType, inArray, accessibility ) {
    	var systemFunctions = new Array();

        Ext.each( this.systemFunctions, function( func, funcIndex, funcs ) {
            if ( func.name === name && ( returnType === Ext.ux.suncode.IntegrationComponentService.FUNCTION_TYPE
            		|| func.returnType === returnType || ( inArray && func.returnType === returnType + '[]' ) )
            		&& ( func.accessibility === Ext.ux.suncode.IntegrationComponentService.ALL_ACCESSIBILITY
            				|| Ext.isEmpty( func.accessibility ) || func.accessibility === accessibility ) ) {
            	systemFunctions.push( func );
            }
        } );

        return systemFunctions;
    },
    getSystemFunctionEquivalents: function( returnType, inArray, accessibility, parameterTypes ) {
        var systemFunctions = new Array();

        Ext.each( this.systemFunctions, function( func, funcIndex, funcs ) {
            if ( !func.deprecated && ( returnType === Ext.ux.suncode.IntegrationComponentService.FUNCTION_TYPE
            		|| func.returnType === returnType || ( inArray && func.returnType === returnType + '[]' ) )
            		&& ( func.accessibility === Ext.ux.suncode.IntegrationComponentService.ALL_ACCESSIBILITY
            				|| Ext.isEmpty( func.accessibility ) || func.accessibility === accessibility )
            		&& func.parameters.length == parameterTypes.length ) {
            	var match = true;
            	
            	Ext.each( func.parameters, function( parameter, parameterIndex, parameters ) {
        			var type = !Ext.isEmpty( parameter.type ) ? parameter.type : 'string';
        			var parameterType = parameterTypes[parameterIndex];
        			
        			if ( Ext.isEmpty( parameterType ) || parameterType.type != type ||
        					parameterType.array !== parameter.array ) {
        				match = false
        				return false;
        			}
                } );
            	
            	if ( match ) {
            		systemFunctions.push( func );
            	}
            }
        } );

        return systemFunctions;
    },
    setSystemColors: function( systemColors ) {
      systemColors.sort( function( a, b ) {
        if ( a > b ) {
          return 1;
        } else {
          return -1;
        }
      } );

      this.systemColors = systemColors;
    },
    getSystemColors: function() {
      return this.systemColors;
    },
    getUserName: function() {
        return this.globalConfig.userName;
    },
    getEnableDataChooserAutoMapping: function() {
        return this.globalConfig.enableDataChooserAutoMapping;
    },
    getSystemDecimalSeparator: function() {
        return this.globalConfig.decimalSeparator;
    },
    setGlobalConfig: function( globalConfig ) {
        this.globalConfig = globalConfig;
    },
    lockHotkeys: function() {
        this.hotkeysLocked = true;
    },
    unlockHotkeys: function() {
        this.hotkeysLocked = false;
    },
    areHotkeysLocked: function() {
        return this.hotkeysLocked;
    },
    getShowTooltips: function() {
        return this.userConfig.showTooltips;
    },
    changeTooltipsVisibility: function() {
        this.userConfig.showTooltips = !this.userConfig.showTooltips;
    },
    getAnimationsOn: function() {
        return this.userConfig.animationsOn;
    },
    changeAnimationsAbility: function() {
        this.userConfig.animationsOn = !this.userConfig.animationsOn;
    },
    getExportJs: function() {
        return this.userConfig.exportJs;
    },
    changeExportJs: function() {
        this.userConfig.exportJs = !this.userConfig.exportJs;
    },
    getExportJavaCode: function() {
        return this.userConfig.exportJavaCode;
    },
    changeExportJavaCode: function() {
        this.userConfig.exportJavaCode = !this.userConfig.exportJavaCode;
    },
    getCompatibilityMode: function() {
        return Ext.ux.suncode.CompatibilityModeService.getMode( this.userConfig.compatibilityMode );
    },
    setCompatibilityMode: function( id ) {
        this.userConfig.compatibilityMode = id;
    },
    getHoverColor: function() {
        return this.userConfig.hoverColor;
    },
    setHoverColor: function( color ) {
        this.userConfig.hoverColor = color;
    },
    getDistinctionColor: function() {
        return this.userConfig.distinctionColor;
    },
    setDistinctionColor: function( color ) {
        this.userConfig.distinctionColor = color;
    },
    getIncomingTransitionColor: function() {
      return this.userConfig.incomingTransitionColor;
    },
    setIncomingTransitionColor: function( color ) {
      this.userConfig.incomingTransitionColor = color;
    },
    getOutgoingTransitionColor: function() {
      return this.userConfig.outgoingTransitionColor;
    },
    setOutgoingTransitionColor: function( color ) {
      this.userConfig.outgoingTransitionColor = color;
    },
    getDocumentationView: function() {
        return this.userConfig.documentationView;
    },
    changeDocumentationView: function() {
        this.userConfig.documentationView = !this.userConfig.documentationView;
    },
    getShowDeprecatedIntegrationComponents: function() {
    	return this.userConfig.showDeprecatedComponents;
    },
    changeShowDeprecatedIntegrationComponents: function() {
    	this.userConfig.showDeprecatedComponents = !this.userConfig.showDeprecatedComponents;
    },
    getSnapToGrid: function() {
    	return this.userConfig.snapToGrid;
    },
    changeSnapToGrid: function() {
    	this.userConfig.snapToGrid = !this.userConfig.snapToGrid;
    },
    getShowGrid: function() {
    	return this.userConfig.showGrid;
    },
    changeShowGrid: function() {
    	this.userConfig.showGrid = !this.userConfig.showGrid;
    },
    getGridSize: function() {
        return this.userConfig.gridSize;
    },
    setGridSize: function( gridSize ) {
        this.userConfig.gridSize = gridSize;
    },
    getXpdlTranslationLanguage: function() {
      return this.userConfig.xpdlTranslationLanguage;
    },
    setXpdlTranslationLanguage: function( language ) {
      this.userConfig.xpdlTranslationLanguage = language;
    },
    getUseExternalClipboard: function() {
      return this.userConfig.useExternalClipboard;
    },
    changeUseExternalClipboard: function() {
      this.userConfig.useExternalClipboard = !this.userConfig.useExternalClipboard;
    },
    getFormDesignerConfig: function() {
    	return this.formDesignerConfig;
    },
    setFormDesignerConfig: function( formDesignerConfig ) {
    	this.formDesignerConfig = formDesignerConfig;
    },
    getCustomFormConfig: function() {
    	return this.customFormConfig;
    },
    setCustomFormConfig: function( customFormConfig ) {
    	this.customFormConfig = customFormConfig;
    },
    setSaved: function( saved ) {
        if ( this.saved && !saved ) {
            clearMessageToolbarWithDelay( 0 );
        }
        
        if ( this.autoSaveActive ) {
        	if ( saved && this.autoSaveStarted ) {
            	Ext.TaskMgr.stop( this.autoSaveTask );
            	this.autoSaveStarted = false;
            } else if ( !saved && !this.autoSaveStarted ) {
            	Ext.TaskMgr.start( this.autoSaveTask );
            	this.autoSaveStarted = true;
            }
        }

        this.saved = saved;
    },
    isSaved: function() {
        return this.saved;
    },
    suspendAutoSave: function() {
    	this.autoSaveActive = false;
    },
    resumeAutoSave: function() {
    	this.autoSaveActive = true;
    },
    setCheckSavedOnUnload: function( checkSavedOnUnload ) {
    	this.checkSavedOnUnload = checkSavedOnUnload;
    },
    shouldCheckSavedOnUnload: function() {
    	return this.checkSavedOnUnload;
    },
    getSimulationInfo: function() {
        return this.simulationInfo;
    },
    setCurrentActivityMapMode: function( simulation ) {
        this.simulationInfo = simulation;
        this.modes.editionMode = false;
        this.modes.currentActivityMapMode = true;
    },
    setSimulationMode: function( simulation ) {
        this.simulationInfo = simulation;
        this.modes.editionMode = false;
        this.modes.simulationMode = true;
    },
    setProcessPreviewMode: function() {
        this.modes.editionMode = false;
        this.modes.processPreviewMode = true;
    },
    isEditionModeActive: function() {
        return this.modes.editionMode;
    },
    maskScreen: function( msg ) {
        showLoadingMask( this.screenMaskId, msg );
    },
    unmaskScreen: function() {
        removeLoadingMask( this.screenMaskId );
    },
    resetTransitionIds: function() {
        clearArray( this.transitionIds );
        this.transitionIds = new Array();
    },
    storeTransitionId: function( transitionId ) {
        this.transitionIds[transitionId] = true;
    },
    isTransitionIdUnique: function( transitionId ) {
        return !this.transitionIds[transitionId];
    },
    resetGlobalIds: function() {
      clearArray( this.globalIds );
      this.globalIds = new Array();
    },
    storeGlobalId: function( globalId ) {
      this.globalIds[globalId] = true;
    },
    isGlobalIdUnique: function( globalId ) {
      return !this.globalIds[globalId];
    },
    storeUnsavedWindow: function( windowId ) {
    	this.unsavedWindows.put( windowId, true );
    },
    removeUnsavedWindow: function( windowId ) {
    	this.unsavedWindows.remove( windowId );
    },
    isWindowUnsaved: function( windowId ) {
    	return this.unsavedWindows.get( windowId );
    },
    exit: function() {
        this.getEl().switchOff( {
            easing: 'easeOut',
            duration: 1,
            remove: true,
            useDisplay: false,
            callback: onExitProgram
        } );
    }
} );

Ext.ux.suncode.MainPanelTopToolbar = function( config ) {
    var items = new Array();
    var itemsConfig = new Array();
    var itemConfig = new Object();
    var subitemsConfig = new Array();

    itemConfig = Ext.apply( {
        id: 'new_xpdl_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'new' ),
        text: getTranslation( 'Nowy' ),
        functionName: 'newXpdl'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'open_xpdl_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'open' ),
        text: menuTextWithHotkey( getTranslation( 'Otwórz' ), 'Ctrl+O' ),
        functionName: 'openXpdl'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    var recentFilesRec = Ext.data.Record.create( [ {
        name: 'location',
        type: 'string'
    }, {
        name: 'fileName',
        type: 'string'
    }, {
        name: 'locationName',
        type: 'string'
    }, {
        name: 'size',
        type: 'string'
    }, {
        name: 'openTime',
        type: 'string'
    } ] );

    itemConfig = Ext.apply( {
        id: 'recent_files_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'recent_files' ),
        text: getTranslation( 'Poprzednie pliki' ),
        menu: new Ext.ux.suncode.Menu( [ {
        	cls: 'x-btn-text',
            text: getTranslation( 'Trwa ładowanie danych...' ),
            disabled: true
        } ] ),
        store: new Ext.data.JsonStore( {
            proxy: new Ext.data.HttpProxy( {
                method: 'GET',
                url: 'api/recentfile/get',
                timeout: 120000
            } ),
            reader: new Ext.data.JsonReader( {
                fields: recentFilesRec
            } ),
            fields: recentFilesRec,
            root: 'data'
        } )
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'separator'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'save_xpdl_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'save' ),
        text: menuTextWithHotkey( getTranslation( 'Zapisz' ), 'Ctrl+S' ),
        functionName: 'saveXpdl'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'preview_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'preview' ),
        text: menuTextWithHotkey( getTranslation( 'Podgląd' ), 'Ctrl+P' ),
        functionName: 'showXpdlPreview'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    subitemsConfig.push( {
        id: 'generate_process_map_image_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'map' ),
        text: getTranslation( 'Obraz mapy procesu' ),
        functionName: 'generateProcessMapImage'
    } );
    subitemsConfig.push( {
        id: 'generate_xpdl_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'xpdl' ),
        text: getTranslation( 'Mapa pakietu' ),
        functionName: 'generateXpdl'
    } );
    subitemsConfig.push( {
        id: 'generate_js_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'scripts' ),
        text: getTranslation( 'Skrypty' ),
        functionName: 'generateCustomJs'
    } );
    subitemsConfig.push( {
        id: 'generate_java_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'java_code' ),
        text: getTranslation( 'Kody źródłowe' ),
        functionName: 'generateJavaClasses'
    } );
    subitemsConfig.push( {
        id: 'generate_documentation_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'specification' ),
        text: getTranslation( 'Dokumentacja procesu' ),
        hidden: !config.userConfig.documentationView,
        functionName: 'generateProcessDocumentation'
    } );
    subitemsConfig.push( {
        id: 'separator'
    } );
    subitemsConfig.push( {
        id: 'generate_zip_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'zip' ),
        text: menuTextWithHotkey( getTranslation( 'Archiwum ZIP' ), 'Ctrl+G' ),
        functionName: 'generateZip'
    } );

    itemConfig = Ext.apply( {
        id: 'generate_file_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'create_file' ),
        text: getTranslation( 'Generuj' ),
        submenu: new Ext.ux.suncode.Menu( subitemsConfig )
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();
    subitemsConfig = new Array();

    subitemsConfig.push( {
        id: 'export_java_classes_main_menu_item',
        cls: 'x-btn-text-icon',
        hidden: !Ext.ux.suncode.CompatibilityModeService.getMode( config.userConfig.compatibilityMode ).showLoadJavaCodeToSystem(),
        icon: getPluginImgPath( 'java_code' ),
        text: addTooltipToField( getTranslation( 'Kody źródłowe' ), null, null, true ),
        functionName: 'exportJavaClasses'
    } );
    subitemsConfig.push( {
        id: 'export_package_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'translations' ),
        text: getTranslation( 'Tłumaczenia' ),
        functionName: 'executeValidateXpdl',
        functionArg: {
          doExportXpdl: false,
          doExportPackageTranslations: true
        }
    } );
    subitemsConfig.push( {
        id: 'export_xpdl_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'package_export' ),
        text: menuTextWithHotkey( getTranslation( 'Pakiet' ), 'Ctrl+E' ),
        functionName: 'executeValidateXpdl',
        functionArg: {
            doExportXpdl: true,
            doExportPackageTranslations: false
        }
    } );

    itemConfig = Ext.apply( {
        id: 'export_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'export' ),
        text: getTranslation( 'Publikuj' ),
        submenu: new Ext.ux.suncode.Menu( subitemsConfig )
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();
    subitemsConfig = new Array();

    itemConfig = Ext.apply( {
        id: 'separator'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'close_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'close' ),
        text: getTranslation( 'Zamknij' ),
        functionName: 'exit'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    var fileMenuButton = new Ext.Button( {
        id: 'file_main_menu_button',
        cls: 'x-btn-text',
        text: getTranslation( 'Plik' ),
        menu: new Ext.ux.suncode.Menu( itemsConfig )
    } );
    items.push( fileMenuButton );
    items.push( new Ext.Toolbar.Separator() );

    itemsConfig = new Array();
    
    subitemsConfig.push( {
        id: 'reload_integration_components_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'reload' ),
        text: getTranslation( 'Odśwież' ),
        functionName: 'reloadIntegrationComponents'
    } );
    subitemsConfig.push( {
        id: 'show_integration_components_plugins_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'plugin' ),
        text: getTranslation( 'Wtyczki' ),
        functionName: 'showIntegrationComponentsPlugins'
    } );
    subitemsConfig.push( {
        id: 'show_missing_integration_components_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'missing' ),
        text: getTranslation( 'Brakujące komponenty' ),
        functionName: 'showMissingIntegrationComponents'
    } );
    subitemsConfig.push( {
        id: 'show_deprecated_integration_components_main_menu_item',
        cls: 'x-btn-text-icon',
        iconCls: config.userConfig.showDeprecatedComponents ? 'x-Module-tickIcon' : 'x-Module-crossIcon',
        text: getTranslation( 'Pokaż przestarzałe komponenty' ),
        functionName: 'changeShowDeprecatedIntegrationComponents'
    } );

    itemConfig = Ext.apply( {
        id: 'integration_components_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'components' ),
        text: getTranslation( 'Komponenty integracyjne' ),
        submenu: new Ext.ux.suncode.Menu( subitemsConfig )
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();
    subitemsConfig = new Array();
    
    var editorMenuButton = new Ext.Button( {
        id: 'editor_main_menu_button',
        cls: 'x-btn-text',
        text: getTranslation( 'Edytor' ),
        menu: new Ext.ux.suncode.Menu( itemsConfig )
    } );
    items.push( editorMenuButton );
    items.push( new Ext.Toolbar.Separator() );

    itemsConfig = new Array();

    itemConfig = Ext.apply( {
        id: 'add_process_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'package_add' ),
        text: menuTextWithHotkey( getTranslation( 'Dodaj proces' ), 'Ctrl+N' ),
        functionName: 'createNewProcess',
        functionArg: {
            initialProcessNameMask: 'VER'
        }
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'validate_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'package_validate' ),
        text: menuTextWithHotkey( getTranslation( 'Waliduj' ), 'Ctrl+W' ),
        functionName: 'validateXpdl'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();
    
    itemConfig = Ext.apply( {
        id: 'translations_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'translations' ),
        text: getTranslation( 'Tłumaczenia' ),
        functionName: 'showPackageTranslations'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'separator'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'package_properties_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'properties' ),
        text: menuTextWithHotkey( getTranslation( 'Właściwości' ), 'F2' ),
        functionName: 'showPackageProperties',
        functionArg: Ext.getCmp( 'package_panel' ).getRootNode()
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    var packageMenuButton = new Ext.Button( {
        id: 'package_main_menu_button',
        cls: 'x-btn-text',
        text: getTranslation( 'Pakiet' ),
        menu: new Ext.ux.suncode.Menu( itemsConfig )
    } );
    items.push( packageMenuButton );
    items.push( new Ext.Toolbar.Separator() );

    itemsConfig = new Array();

    itemConfig = Ext.apply( {
        id: 'show_xpdl_archive_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'archive' ),
        text: getTranslation( 'Eksploruj' ),
        functionName: 'showXpdlArchive'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'show_packages_history_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'history' ),
        text: getTranslation( 'Historia pakietów' ),
        functionName: 'showPackagesHistory'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'change_card_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'change_card' ),
        text: getTranslation( 'Karta zmian' ),
        hidden: !config.userConfig.documentationView,
        functionName: 'showChangeCardWindow'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    var xpdlArchiveMenuButton = new Ext.Button( {
        id: 'xpdl_archive_main_menu_button',
        cls: 'x-btn-text',
        text: getTranslation( 'Archiwum' ),
        menu: new Ext.ux.suncode.Menu( itemsConfig )
    } );
    items.push( xpdlArchiveMenuButton );
    items.push( new Ext.Toolbar.Separator() );

    itemsConfig = new Array();

    itemConfig = Ext.apply( {
        id: 'advanced_view_main_menu_item',
        cls: 'x-btn-text-icon',
        iconCls: config.userConfig.advancedView ? 'x-Module-tickIcon' : 'x-Module-crossIcon',
        text: menuTextWithHotkey( getTranslation( 'Widok zaawansowany' ), 'Ctrl+B' ),
        functionName: 'changeAdvancedView'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
      id: 'experimental_view_main_menu_item',
      cls: 'x-btn-text-icon',
      iconCls: config.userConfig.experimentalView ? 'x-Module-tickIcon' : 'x-Module-crossIcon',
      text: getTranslation( 'Widok eksperymentalny' ),
      functionName: 'changeExperimentalView'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'tooltip_visibility_main_menu_item',
        cls: 'x-btn-text-icon',
        iconCls: config.userConfig.showTooltips ? 'x-Module-tickIcon' : 'x-Module-crossIcon',
        text: menuTextWithHotkey( getTranslation( 'Pokaż podpowiedzi' ), 'Ctrl+T' ),
        functionName: 'changeTooltipVisibility'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'animations_main_menu_item',
        cls: 'x-btn-text-icon',
        iconCls: config.userConfig.animationsOn ? 'x-Module-tickIcon' : 'x-Module-crossIcon',
        text: getTranslation( 'Animacje' ),
        functionName: 'changeAnimationsAbility'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'export_js_main_menu_item',
        cls: 'x-btn-text-icon',
        hidden: !Ext.ux.suncode.CompatibilityModeService.getMode( config.userConfig.compatibilityMode ).showExportJs( config.userConfig.exportJs ), 
        iconCls: config.userConfig.exportJs ? 'x-Module-tickIcon' : 'x-Module-crossIcon',
        text: addTooltipToField( getTranslation( 'Publikuj skrypty' ), null, null, true ),
        functionName: 'changeExportJs'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();
    
    itemConfig = Ext.apply( {
        id: 'export_java_code_main_menu_item',
        cls: 'x-btn-text-icon',
        hidden: !Ext.ux.suncode.CompatibilityModeService.getMode( config.userConfig.compatibilityMode ).showExportJavaCode( config.userConfig.exportJavaCode ), 
        iconCls: config.userConfig.exportJavaCode ? 'x-Module-tickIcon' : 'x-Module-crossIcon',
        text: addTooltipToField( getTranslation( 'Publikuj kod źródłowy' ), null, null, true ),
        functionName: 'changeExportJavaCode'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'documentation_view_main_menu_item',
        cls: 'x-btn-text-icon',
        iconCls: config.userConfig.documentationView ? 'x-Module-tickIcon' : 'x-Module-crossIcon',
        text: getTranslation( 'Widok dokumentacji' ),
        functionName: 'changeDocumentationView'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

  itemConfig = Ext.apply( {
    id: 'use_external_clipboard_menu_item',
    cls: 'x-btn-text-icon',
    iconCls: config.userConfig.useExternalClipboard ? 'x-Module-tickIcon' : 'x-Module-crossIcon',
    text: getTranslation( 'Użyj zewnętrznego schowka' ),
    functionName: 'changeUseExternalClipboard'
  }, itemConfig );
  itemsConfig.push( itemConfig );
  itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'simulation_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'package_simulation' ),
        text: getTranslation( 'Symulacja' ),
        functionName: 'simulation'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    var compatibilityModes = Ext.ux.suncode.CompatibilityModeService.getModes();
    	
    for ( var i = 0; i < compatibilityModes.length; i++ ) {
        var compatibilityMode = compatibilityModes[i];
        subitemsConfig.push( {
            id: 'compatibility_mode_' + compatibilityMode.getId() + '_main_menu_item',
            cls: 'x-btn-text-icon',
            iconCls: config.userConfig.compatibilityMode === compatibilityMode.getId() ? 'x-Module-tickIcon' : undefined,
            text: compatibilityMode.getName(),
            functionName: 'changeCompatibilityMode',
            functionArg: compatibilityMode.getId()
        } );
    }

    itemConfig = Ext.apply( {
        id: 'compatibility_mode_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'config' ),
        text: getTranslation( 'Tryb kompatybilności' ),
        submenu: new Ext.ux.suncode.Menu( subitemsConfig )
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();
    subitemsConfig = new Array();
    
    itemConfig = Ext.apply( {
        id: 'grid_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'grid' ),
        text: getTranslation( 'Przyciąganie do siatki' ),
        submenu: [ {
        	xtype: 'form',
        	frame: false,
            border: false,
            bodyCssClass: 'x-Module-container-padding',
            layoutConfig: {
                trackLabels: true
            },
        	items: [ {
        		xtype: 'checkbox',
                fieldLabel: getTranslation( 'Aktywne' ),
                inputValue: 'true',
                checked: config.userConfig.snapToGrid,
                listeners: {
                	check: this.onSnapToGridCheck
                }
            }, {
        		xtype: 'checkbox',
                fieldLabel: getTranslation( 'Pokaż siatkę' ),
                inputValue: 'true',
                ref: 'showGridItem',
                checked: config.userConfig.showGrid,
                hidden: !config.userConfig.snapToGrid,
                listeners: {
                	check: this.onShowGridCheck
                }
            }, {
            	xtype: 'numberfield',
            	fieldLabel: getTranslation( 'Rozmiar' ),
            	ref: 'gridSizeItem',
            	blankText: getTranslation( 'Pole jest wymagane' ),
              msgTarget: 'qtip',
            	width: 80,
            	enableKeyEvents: true,
            	allowBlank: false,
            	allowDecimals: false,
            	allowNegative: false,
            	maxValue: 20,
            	value: config.userConfig.gridSize,
            	hidden: !config.userConfig.snapToGrid,
            	listeners: {
            		scope: this,
            		change: this.onGridSizeChange,
            		specialkey: this.onGridSizeSpecialKey
            	}
            } ]
        } ]
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    var noXpdlTranslation = Ext.ux.suncode.I18NService.NO_XPDL_TRANSLATION_LANGUAGE;
    var supportedLanguages = Ext.ux.suncode.I18NService.getSupportedLanguages();
    subitemsConfig.push( {
      id: 'xpdl_translation_language_' + noXpdlTranslation + '_main_menu_item',
      cls: 'x-btn-text-icon',
      iconCls: config.userConfig.xpdlTranslationLanguage === noXpdlTranslation ? 'x-Module-tickIcon' : undefined,
      text: getTranslation( 'Brak' ),
      functionName: 'changeXpdlTranslationLanguage',
      functionArg: noXpdlTranslation
    } );

    for ( var i = 0; i < supportedLanguages.length; i++ ) {
      var supportedLanguage = supportedLanguages[i];
      subitemsConfig.push( {
        id: 'xpdl_translation_language_' + supportedLanguage + '_main_menu_item',
        cls: 'x-btn-text-icon',
        iconCls: config.userConfig.xpdlTranslationLanguage === supportedLanguage ? 'x-Module-tickIcon' : undefined,
        text: supportedLanguage.toUpperCase(),
        functionName: 'changeXpdlTranslationLanguage',
        functionArg: supportedLanguage
      } );
    }

    itemConfig = Ext.apply( {
      id: 'xpdl_translation_language_main_menu_item',
      cls: 'x-btn-text-icon',
      icon: getPluginImgPath( 'config' ),
      text: getTranslation( 'Język tłumaczenia pakietu' ),
      submenu: new Ext.ux.suncode.Menu( subitemsConfig )
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();
    subitemsConfig = new Array();

    subitemsConfig.push( {
        id: 'hover_color_main_menu_item',
        cls: 'x-btn-text',
        style: 'padding-left: 16px;',
        text: createMenuColorBox( getTranslation( 'Kolor podświetlenia' ), config.userConfig.hoverColor ),
        functionName: 'changeHoverColor'
    } );
    subitemsConfig.push( {
        id: 'distinction_color_main_menu_item',
        cls: 'x-btn-text',
        style: 'padding-left: 16px;',
        text: createMenuColorBox( getTranslation( 'Kolor wyróżnienia' ), config.userConfig.distinctionColor ),
        functionName: 'changeDistinctionColor'
    } );
    subitemsConfig.push( {
      id: 'incoming_transition_color_main_menu_item',
      cls: 'x-btn-text',
      style: 'padding-left: 16px;',
      text: createMenuColorBox( getTranslation( 'Kolor połączeń wchodzących' ), config.userConfig.incomingTransitionColor ),
      functionName: 'changeIncomingTransitionColor'
    } );
    subitemsConfig.push( {
      id: 'outgoing_transition_color_main_menu_item',
      cls: 'x-btn-text',
      style: 'padding-left: 16px;',
      text: createMenuColorBox( getTranslation( 'Kolor połączeń wychodzących' ), config.userConfig.outgoingTransitionColor ),
      functionName: 'changeOutgoingTransitionColor'
    } );

    itemConfig = Ext.apply( {
        id: 'colors_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'color_wheel' ),
        text: getTranslation( 'Kolory' ),
        submenu: new Ext.ux.suncode.Menu( subitemsConfig )
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();
    subitemsConfig = new Array();

    itemConfig = Ext.apply( {
      id: 'separator'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
      id: 'restore_main_menu_item',
      cls: 'x-btn-text-icon',
      icon: getPluginImgPath( 'restore' ),
      text: getTranslation( 'Przywróć domyślny wygląd formularzy' ),
      functionName: 'restoreFormsDefaultLook'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    var settingsMenuButton = new Ext.Button( {
        id: 'settings_main_menu_button',
        cls: 'x-btn-text',
        text: getTranslation( 'Ustawienia' ),
        menu: new Ext.ux.suncode.Menu( itemsConfig )
    } );
    items.push( settingsMenuButton );
    items.push( new Ext.Toolbar.Separator() );

    itemsConfig = new Array();

    var examplesRec = Ext.data.Record.create( [ {
        name: 'name',
        type: 'string'
    }, {
        name: 'path',
        type: 'string'
    } ] );

    itemConfig = Ext.apply( {
        id: 'examples_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'examples' ),
        text: getTranslation( 'Przykłady' ),
        menu: new Array(),
        store: new Ext.data.JsonStore( {
            proxy: new Ext.data.HttpProxy( {
                method: 'GET',
                url: 'api/example/getXpdls',
                listeners: {
                	exception: function( proxy, type, action, options, response, arg ) {
                		showServerFailure( response );
                	}
                }
            } ),
            reader: new Ext.data.JsonReader( {
                fields: examplesRec
            } ),
            fields: examplesRec,
            root: 'data'
        } ),
        listeners: {
            beforerender: loadExamples
        }
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'tutorials_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'tutorials' ),
        text: getTranslation( 'Tutoriale' ),
        functionName: 'tutorials'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'how_to_use_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'help' ),
        text: menuTextWithHotkey( getTranslation( 'Jak korzystać?' ), 'F1' ),
        functionName: 'help'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    itemConfig = Ext.apply( {
        id: 'about_main_menu_item',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'info' ),
        text: getTranslation( 'O programie' ),
        functionName: 'about'
    }, itemConfig );
    itemsConfig.push( itemConfig );
    itemConfig = new Object();

    var helpMenuButton = new Ext.Button( {
        id: 'help_main_menu_button',
        cls: 'x-btn-text',
        text: getTranslation( 'Pomoc' ),
        menu: new Ext.ux.suncode.Menu( itemsConfig )
    } );
    items.push( helpMenuButton );

    config = Ext.apply( {
        hidden: !config.editionMode,
        items: items,
        style: 'border-width: 0;'
    }, config );

    Ext.ux.suncode.MainPanelTopToolbar.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.MainPanelTopToolbar, Ext.Toolbar, {
    initComponent: function() {
        Ext.ux.suncode.MainPanelTopToolbar.superclass.initComponent.call( this );
        
        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
    	loadRecentFiles();
    },
    onSnapToGridCheck: function( field, checked ) {
    	var mainPanel = Ext.getCmp( 'main_panel' );
        mainPanel.changeSnapToGrid();
        var gridPanelConfig = field.ownerCt;
        var showGridItem = gridPanelConfig.showGridItem;
        var gridSizeItem = gridPanelConfig.gridSizeItem;
        var paperPanel = Ext.getCmp( 'paper_panel' );
        paperPanel.setSnapToGrid( checked );
    	
    	if ( checked ) {
    		showGridItem.show();
    		gridSizeItem.show();
    		
    		if ( mainPanel.getShowGrid() ) {
    			paperPanel.showGrids();
    		}
        } else {
        	showGridItem.hide();
        	gridSizeItem.hide();
        	paperPanel.hideGrids();
        }
    	
    	gridPanelConfig.ownerCt.doLayout();
    	
        updateUserConfig();
    },
    onShowGridCheck: function( field, checked ) {
    	var mainPanel = Ext.getCmp( 'main_panel' );
        mainPanel.changeShowGrid();
        var paperPanel = Ext.getCmp( 'paper_panel' );
        paperPanel.setShowGrid( checked );
    	
    	if ( checked ) {
    		paperPanel.showGrids();
        } else {
        	paperPanel.hideGrids();
        }
    	
        updateUserConfig();
    },
    onGridSizeChange: function( field, newValue, oldValue ) {
    	if ( field.isValid() ) {
    		this.updateGridSize( newValue );
    	}
    },
    onGridSizeSpecialKey: function( field, e ) {
    	if ( e.getKey() == e.ENTER && field.isValid() ) {
    		this.updateGridSize( field.getValue() );
    	}
    },
    updateGridSize: function( gridSize ) {
    	var mainPanel = Ext.getCmp( 'main_panel' );
        mainPanel.setGridSize( gridSize );
		var paperPanel = Ext.getCmp( 'paper_panel' );
		paperPanel.setGridSize( gridSize );
		
		if ( mainPanel.getShowGrid() ) {
			paperPanel.redrawGrids();
		}
        
    	updateUserConfig();
    }
} );