Ext.ux.suncode.AutoSavedWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.4;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoHeight: true,
        title: getTranslation( 'Utracone pliki' ),
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } ),
        items: [ new Ext.ux.suncode.AutoSavedPanel( config ) ]
    }, config );

    Ext.ux.suncode.AutoSavedWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AutoSavedWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.AutoSavedWindow.superclass.initComponent.call( this );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.AutoSavedPanel = function( config ) {
    config = Ext.apply( {
        height: 250,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        store: new Ext.data.Store( {
            data: config.files,
            reader: new Ext.data.JsonReader( {
                fields: Ext.data.Record.create( [ {
                    name: 'name',
                    type: 'string'
                }, {
                    name: 'path',
                    type: 'string'
                } ] )
            } )
        } ),
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                header: getTranslation( 'Nazwa pliku' ),
                dataIndex: 'name',
                align: 'left'
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak plików' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'open' ),
                tooltip: getTranslation( 'Otwórz' ),
                handler: this.openFile,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń' ),
                handler: this.deleteFile,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'clear' ),
                tooltip: getTranslation( 'Usuń wszystkie i zamknij' ),
                handler: this.deleteAllAndClose,
                scope: this
            } ]
        } ),
        listeners: {
            scope: this,
            rowdblclick: function( grid, rowIndex, e ) {
                this.openFile();
            }
        }
    }, config );

    Ext.ux.suncode.AutoSavedPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AutoSavedPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.AutoSavedPanel.superclass.initComponent.call( this );
    },
    openFile: function() {
    	var file = this.getSelectedFile();
    	if ( !file ) {
            return;
        }
    	
    	var path = file.get( 'path' );
    	var formPanel = new Ext.FormPanel( {
            renderTo: document.body,
            hidden: true,
            items: [ {
                xtype: 'textfield',
                name: 'path',
                value: path
            } ]
        } );
        var form = formPanel.getForm();
        form.submit( {
            url: 'api/xpdl/openFromAutoSaved',
            waitMsg: getTranslation( 'Trwa przetwarzanie pliku...' ),
            waitTitle: getTranslation( 'Proszę czekać' ),
            method: 'POST',
            timeout: 600,
            scope: this,
            success: function( form, action ) {
                if ( action.result.success ) {
                	Suncode.context( 'pwe' ).openedAutoSavedPath = path;
                	this.ownerCt.close();
                  var mainPanel = Ext.getCmp( 'main_panel' );
                	executeOpen( action.result );

                    if ( Ext.ux.suncode.XpdlErrors.hasErrors() ) {
                        var xpdlErrorsWindow = new Ext.ux.suncode.XpdlErrorsWindow();
                        xpdlErrorsWindow.show();
                    }

                  if ( mainPanel.isCurrentXpdlVersionOlder() ) {
                    showWarn( getTranslation( 'Mapa pakietu została utworzona w edytorze w wersji' )
                        + ' ' + mainPanel.getCurrentXpdlVersion() + '. '
                        + getTranslation( 'Aktualna wersja edytora to' )
                        + ' ' + mainPanel.getVersion() + '.' );
                  }
                } else {
                    showWarn( getTranslation( 'Wystąpił błąd.' ) );
                }
            },
            failure: function( form, action ) {
            	showServerFailure( action.response );
            }
        } );

        var task = new Ext.util.DelayedTask( function() {
            formPanel.destroy();
        }, this );
        task.delay( 3000 );
    },
    deleteFile: function() {
    	var file = this.getSelectedFile();
    	if ( !file ) {
            return;
        }
    	
    	Ext.Ajax.request( {
            url: 'api/xpdl/deleteAutoSaved',
            method: 'GET',
            params: {
            	path: file.get( 'path' )
            },
            scope: this,
            success: function( response, opts ) {
            	if ( parseBoolean( response.responseText ) ) {
            		removeRowAndMarkNext( this, file );
                    this.getView().refresh();
                } else {
                    showWarn( getTranslation( 'Wystąpił błąd.' ) );
                }
            },
            failure: function( response, opts ) {
            	showWarn( getTranslation( 'Wystąpił błąd.' ) );
            }
        } );
    },
    getSelectedFile: function() {
    	var file = this.getSelectionModel().getSelected();
        if ( !file ) {
            showWarn( getTranslation( 'Wybierz plik.' ) );
            return null;
        }
        return file;
    },
    deleteAllAndClose: function() {
    	Ext.Ajax.request( {
            url: 'api/xpdl/deleteAllAutoSaved',
            method: 'GET',
            scope: this,
            success: function( response, opts ) {
            	if ( parseBoolean( response.responseText ) ) {
            		this.getStore().removeAll();
                    this.getView().refresh();
                    this.ownerCt.close();
                } else {
                    showWarn( getTranslation( 'Wystąpił błąd.' ) );
                }
            },
            failure: function( response, opts ) {
            	showWarn( getTranslation( 'Wystąpił błąd.' ) );
            }
        } );
    }
} );