function deleteActivity( activityNode ) {
    var deleteQuestionText = '';

    switch ( activityNode.attributes.activityType ) {
        case Ext.ux.suncode.Constants.ROUTE:
            deleteQuestionText = getTranslation( 'Usunąć przekierowanie wraz z połączeniami?' );
            break;
        case Ext.ux.suncode.Constants.ACTIVITY:
            deleteQuestionText = getTranslation( 'Usunąć zadanie wraz z połączeniami?' );
            break;
        case Ext.ux.suncode.Constants.TOOL:
            deleteQuestionText = getTranslation( 'Usunąć narzędzie wraz z połączeniami?' );
            break;
        case Ext.ux.suncode.Constants.SUBFLOW:
            deleteQuestionText = getTranslation( 'Usunąć podproces wraz z połączeniami?' );
            break;
        default:
            break;
    }

    Ext.Msg.show( {
        title: getTranslation( 'Uwaga' ),
        msg: deleteQuestionText,
        buttons: {
            yes: getTranslation( 'Tak' ),
            no: getTranslation( 'Nie' )
        },
        fn: function( buttonId ) {
            if ( buttonId == 'yes' ) {
                executeDeleteActivity( activityNode );
            }
        },
        icon: Ext.Msg.QUESTION
    } );
}

function executeDeleteActivity( activityNode ) {
    var paper = Ext.getCmp( 'paper_panel' ).getActiveTab().paper;
    var actDefId = activityNode.attributes.activityDefId;
    paper.bpmn.removeMapObject( paper, 'activityDefId', actDefId );
    var processNode = activityNode.parentNode;
    processNode.removeActivity( activityNode );
    var processDefId = processNode.attributes.processDefId;
    Ext.ux.suncode.DocumentationService.onDeleteActivity( processNode, actDefId );
    Ext.ux.suncode.I18NService.onActivityRemove( processDefId, actDefId );
    paper.bpmn.eraseTrash( paper.helperTrash );
    paper.bpmn.eraseTrash( paper.hoverTrash );
}

function markActivityIncomingTransitions( activityNode ) {
  var paper = Ext.getCmp( 'paper_panel' ).getActiveTab().paper;
  var activityDefId = activityNode.attributes.activityDefId;
  paper.bpmn.markTaskIncomingConnections( paper, activityDefId );
}

function markActivityOutgoingTransitions( activityNode ) {
  var paper = Ext.getCmp( 'paper_panel' ).getActiveTab().paper;
  var activityDefId = activityNode.attributes.activityDefId;
  paper.bpmn.markTaskOutgoingConnections( paper, activityDefId );
}

function markAllActivityTransitions( activityNode ) {
  var paper = Ext.getCmp( 'paper_panel' ).getActiveTab().paper;
  var activityDefId = activityNode.attributes.activityDefId;
  paper.bpmn.markAllTaskConnections( paper, activityDefId );
}

function editActivitySpecification( activityNode ) {
    var win = new Ext.ux.suncode.ActivitySpecificationWindow( {
        activityNode: activityNode
    } );
    win.show();
}

function showActivityProperties( config ) {
    var mainPanel = Ext.getCmp( 'main_panel' );

    var activityPropertiesWindow = new Ext.ux.suncode.ActivityPropertiesWindow( {
        activityNode: config.activityNode,
        varRecord: config.varRecord,
        AV: mainPanel.getAdvancedView(),
        animationsOn: mainPanel.getAnimationsOn()
    } );
    activityPropertiesWindow.show();
}

function designActivityForm( activityNode ) {
	var activityFormDesigner = Ext.ux.suncode.Clipboard.getActivityFormDesigner();
	
	if ( Ext.isEmpty( activityFormDesigner ) ) {
		var maskId = 'build_form_mask';
		var mainPanel = Ext.getCmp( 'main_panel' );

	    try {
	        showLoadingMask( maskId, getTranslation( 'Trwa budowanie formularza...' ) );
	        var win = new Ext.ux.suncode.ActivityFormDesignerWindow( {
	            activityNode: activityNode,
	            formDesignerConfig: mainPanel.getFormDesignerConfig()
	        } );
	        Ext.ux.suncode.Clipboard.setActivityFormDesigner( win );
	        win.show();
	    }
	    finally {
	        removeLoadingMask( maskId );
	    }
	}
}

Ext.ux.suncode.ActivityPropertiesWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var activityNode = config.activityNode;
    var activityName = activityNode.attributes.activityName;
    var activityDefId = activityNode.attributes.activityDefId;
    var processNode = activityNode.parentNode;
    var processDefId = processNode.attributes.processDefId
    var packageNode = processNode.parentNode;
    var packageId = packageNode.attributes.packageId
    var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, activityName );
    var itemsConfig = new Object();
    var activityType = activityNode.attributes.activityType;
    var iconCls = '';
    var title = '';

    switch ( activityType ) {
        case Ext.ux.suncode.Constants.ROUTE:
            title = getTranslation( 'Właściwości przekierowania' ) + ' ' + activityNameTranslation;
            break;
        case Ext.ux.suncode.Constants.ACTIVITY:
            title = getTranslation( 'Właściwości zadania' ) + ' ' + activityNameTranslation;
            break;
        case Ext.ux.suncode.Constants.TOOL:
            title = getTranslation( 'Właściwości narzędzia' ) + ' ' + activityNameTranslation;
            break;
        case Ext.ux.suncode.Constants.SUBFLOW:
            title = getTranslation( 'Właściwości podprocesu' ) + ' ' + activityNameTranslation;
            break;
        default:
            break;
    }

    itemsConfig = Ext.apply( {
        activityNode: activityNode,
        varRecord: config.varRecord,
        windowWidth: windowWidth,
        AV: config.AV,
        animationsOn: config.animationsOn,
        activityType: activityType
    }, itemsConfig );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoScroll: true,
        autoHeight: true,
        title: title,
        items: [ new Ext.ux.suncode.ActivityPropertiesTabPanel( itemsConfig ) ],
        closable: true,
        iconCls: iconCls,
        tbar: new Ext.ux.suncode.ActivityPropertiesTopToolbar( itemsConfig )
    }, config );

    Ext.ux.suncode.ActivityPropertiesWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityPropertiesWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ActivityPropertiesWindow.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
        this.on( 'beforeshow', lockHotkeys );
        this.on( 'beforeclose', unlockHotkeys );
    },
    onAfterRender: function() {
        if ( this.initialConfig.activateTab ) {
            this.ActivityPropertiesTabPanel.activate( this.initialConfig.activateTab );
        }
    }
} );

Ext.ux.suncode.ActivityPropertiesTabPanel = function( config ) {
    var panelHeight = Ext.getBody().getViewSize().height * 0.8;
    var activityNode = config.activityNode;

    config = Ext.apply( {
        panelHeight: panelHeight
    }, config );

    var items = new Array();
    items.push( new Ext.ux.suncode.ActivityDefinitionPanel( config ) );
    if ( activityNode.attributes.activityType == Ext.ux.suncode.Constants.SUBFLOW ) {
        items.push( new Ext.ux.suncode.ActivitySubflowParamsPanel( config ) );
    }
    if ( activityNode.attributes.activityType != Ext.ux.suncode.Constants.ROUTE ) {
      items.push(new Ext.ux.suncode.ActivityFormPanel(config));
    }
    items.push( new Ext.ux.suncode.ActivityTransitionRestrictionPanel( config ) );
    if ( activityNode.attributes.activityType == Ext.ux.suncode.Constants.TOOL ) {
        config = Ext.apply( {
            nodeName: 'activity',
            node: activityNode
        }, config );

        items.push( new Ext.ux.suncode.ApplicationsPanel( config ) );
    }
    if ( config.AV && activityNode.attributes.activityType == Ext.ux.suncode.Constants.ACTIVITY ) {
        items.push( new Ext.ux.suncode.ActivityDeadlinesPanel( config ) );
    }
    if ( config.AV && activityNode.attributes.activityType == Ext.ux.suncode.Constants.ACTIVITY ) {
        items.push( new Ext.ux.suncode.ActivityAcceptancesPanel( config ) );
    }
    if ( config.AV && activityNode.attributes.activityType == Ext.ux.suncode.Constants.ACTIVITY ) {
        items.push( new Ext.ux.suncode.ActivityAdditionalsPanel( config ) );
    }

    config = Ext.apply( {
        items: items,
        activeTab: 0,
        autoHeight: true,
        enableTabScroll: true,
        border: false,
        ref: 'ActivityPropertiesTabPanel'
    }, config );

    Ext.ux.suncode.ActivityPropertiesTabPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityPropertiesTabPanel, Ext.TabPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityPropertiesTabPanel.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ActivityDefinitionPanel = function( config ) {
    var nextActLabel = addTooltipToField( getTranslation( 'Automatyczne przejście' ),
                    getTranslation( 'Automatycznie wyświetla po akceptacji kolejne zadanie do edycji' ) + ',<br>'
                                    + getTranslation( 'gdy jest ono przypisane do danego użytkownika' ) );
    var acceptConcLabel = addTooltipToField( getTranslation( 'Równoległa akceptacja' ),
                    getTranslation( 'Gdy opcja jest odznaczona, to użytkownik czeka' ) + ',<br>'
                                    + getTranslation( 'aż wykonają się wszystkie czynności związane z akceptacją (także narzędzia)' ) );
    var acceptSeqLabel = addTooltipToField( getTranslation( 'Kolejkowanie wykonywania zadań' ),
        getTranslation( 'Gdy opcja jest zaznaczona, wszystkie zadania tego typu (z dowolnego procesu)' ) + '<br>'
        + getTranslation( 'zostaną zakolejkowane i uruchomione sekwencyjnie' ) );
    var assigmentLabel = addTooltipToField( getTranslation( 'Przypisanie' ),
                    getTranslation( 'Określa zmienną procesu, na podstawie której zostanie ustalony wykonawca zadania' ) );
    var newDocAcceptLabel = addTooltipToField( getTranslation( 'Akceptacja dokumentem' ),
                    getTranslation( 'Jeżeli opcja jest aktywna, to podłączany do procesu dokument' ) + '<br>'
                                    + getTranslation( 'zaakceptuje i zakończy zadanie' ) );
    var allowMultipleActiveActivitiesLabel = addTooltipToField( getTranslation( 'Zezwól na równoległe zadania' ),
                    getTranslation( 'Pozwala na stworzenie wielu instancji tego zadania' ) + '<br>'
                                    + getTranslation( 'mimo istniejących już otwartych zadań tego typu' ) );

    var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
	  var packageId = packageNode.attributes.packageId;
    var activityNode = config.activityNode;
    var processNode = activityNode.parentNode;
    var processDefId = processNode.attributes.processDefId;
    var roleNameTranslation = getXpdlProcessParticipantNameTranslation(
        packageId, processDefId, activityNode.attributes.roleId, activityNode.attributes.activityPerformer );

    var assignmentTypes = [ [ 'role', getTranslation( 'Rola' ) ], [ 'newAssignment', getTranslation( 'Użytkownik' ) ],
                    [ 'superior', getTranslation( 'Przełożony' ) ], [ 'superior_role', getTranslation( 'Przełożony i rola' ) ] ];

    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        items: [ new Ext.ux.suncode.IdField( {
            anchor: '95%',
            fieldLabel: getTranslation( 'Identyfikator definicji zadania' ),
            value: activityNode.attributes.activityDefId,
            ref: '../../idItem',
            hidden: !config.AV,
            idMaxLength: Ext.ux.suncode.Constants.ACTIVITY_DEF_ID_MAX_LENGTH,
            idChanged: activityNode.attributes.idChanged
        } ), new Ext.ux.suncode.I18NTranslatedField( {
        	fieldLabel: getTranslation( 'Nazwa zadania' ),
        	anchor: '95%',
        	ref: '../../nameItem',
        	field: {
        		xtype: 'textfield',
                maxLength: 255,
                maxLengthText: getTranslation( 'Nazwa zadania nie może przekroczyć 255 znaków.' ),
                value: activityNode.attributes.activityName,
                allowBlank: false,
                blankText: getTranslation( 'Pole jest wymagane' ),
                listeners: {
                    scope: this,
                    blur: function( field ) {
                        if ( !activityNode.attributes.idChanged ) {
                            var actDefId = generateId( field.getValue(), Ext.ux.suncode.Constants.ACTIVITY_DEF_ID_MAX_LENGTH );
                            this.ownerCt.ownerCt.idItem.setValue( actDefId );
                        }
                    }
                }
            },
            getIdFieldFunction: function() {
            	return this.ownerCt.ownerCt.idItem;
            },
            getIdFieldScope: this,
            emptyIdMessage: getTranslation( 'Podaj nazwę zadania.' ),
            windowTitle: getTranslation( 'Tłumaczenia nazwy zadania' ),
            keyPrefix: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(',
            keyPostfix: ')',
            saveToCache: false,
            initialId: activityNode.attributes.activityDefId
        } ), new Ext.ux.suncode.ProcessesChooser( {
            excluded: [ config.activityNode.parentNode.attributes.processDefId ],
            fieldLabel: getTranslation( 'Nazwa podprocesu' ),
            anchor: '95%',
            value: activityNode.attributes.subflow.id,
            blankText: getTranslation( 'Pole jest wymagane' ),
            ref: '../../subflowIdItem',
            hidden: activityNode.attributes.activityType != Ext.ux.suncode.Constants.SUBFLOW,
            listeners: {
                scope: this,
                select: function( combo, record, index ) {
                    var subflowDefId = combo.getValue();

                    if ( Ext.isEmpty( subflowDefId ) || !combo.isValid() ) {
                        return;
                    }

                    var subflowParamsStore = this.ownerCt.subflowParamsPanel.getStore();
                    subflowParamsStore.removeAll();
                    var rec = subflowParamsStore.recordType;

                    var subflowNode = Ext.getCmp( 'package_panel' ).findProcess( subflowDefId );
                    var formalParameters = subflowNode.attributes.formalParameters;
                    for ( var i = 0; i < formalParameters.length; i++ ) {
                        var p = new rec( {
                            subflowParam: formalParameters[i].id,
                            actualParam: ''
                        } );
                        subflowParamsStore.add( p );
                    }

                    subflowParamsStore.commitChanges();
                }
            }
        } ), activityNode.attributes.activityType == Ext.ux.suncode.Constants.ACTIVITY ? {
            xtype: 'combo',
            fieldLabel: assigmentLabel,
            anchor: '95%',
            ref: '../../assignmentTypeItem',
            triggerAction: 'all',
            mode: 'local',
            store: new Ext.data.ArrayStore( {
                fields: [ 'type', 'typeName' ],
                data: assignmentTypes
            } ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            valueField: 'type',
            displayField: 'typeName',
            forceSelection: true,
            editable: false,
            value: activityNode.attributes.assignment.type,
            listeners: {
                scope: this,
                afterrender: function( combo ) {
                    combo.fireEvent( 'select', combo );

                    if ( !Ext.isEmpty( activityNode.attributes.assignment.type ) ) {
                        var assignmentValue = activityNode.attributes.assignment.value;
                        var assignmentException = activityNode.attributes.assignment.exception;

                        if ( activityNode.attributes.assignment.type != 'role' ) {
                            var f = this.ownerCt.ownerCt.assignmentValueItem.items.first();
                            var exc = this.ownerCt.ownerCt.assignmentExceptionItem;
                            f.setValue( assignmentValue );

                            if ( exc ) {
                                exc.items.first().setValue( assignmentException );
                            }
                        }
                    }
                },
                select: function( combo, record, index ) {
                    var assignment = combo.getValue();
                    if ( !combo.isValid() || Ext.isEmpty( assignment ) ) {
                        return;
                    }

                    this.removeAssignmentComponents();

                    switch ( assignment ) {
                        case 'newAssignment':
                        case 'superior':
                        case 'superior_role':
                            if ( assignment == 'newAssignment' ) {
                                this.insert( 4, {
                                    xtype: 'compositefield',
                                    fieldLabel: getTranslation( 'Wyjątek' ),
                                    anchor: '95%',
                                    ref: '../../assignmentExceptionItem',
                                    assignmentComponent: true,
                                    items: [ new Ext.ux.suncode.AllVariablesChooser( {
                                        variables: activityNode.parentNode.attributes.variables,
                                        formalParameters: activityNode.parentNode.attributes.formalParameters,
                                        acceptedFormalParams: [ 'Initiator' ]
                                    } ) ]
                                } );
                            }

                            this.insert( 4, new Ext.ux.suncode.AssignmentFiltersGrid( {
                                anchor: '95%',
                                ref: '../../assignmentFiltersItem',
                                assignmentComponent: true,
                                activityNode: activityNode
                            } ) );
                            this.insert( 4, {
                                xtype: 'compositefield',
                                fieldLabel: getTranslation( 'Nazwa zmiennej procesu' ),
                                anchor: '95%',
                                ref: '../../assignmentValueItem',
                                assignmentComponent: true,
                                items: [ new Ext.ux.suncode.AllVariablesChooser( {
                                    variables: activityNode.parentNode.attributes.variables,
                                    formalParameters: activityNode.parentNode.attributes.formalParameters,
                                    acceptedFormalParams: [ 'Initiator' ]
                                } ) ]
                            } );
                            break;
                        case 'role':
                            this.insert( 4, new Ext.ux.suncode.AssignmentFiltersGrid( {
                                anchor: '95%',
                                ref: '../../assignmentFiltersItem',
                                assignmentComponent: true,
                                activityNode: activityNode
                            } ) );
                            this.insert( 4, {
                                xtype: 'compositefield',
                                fieldLabel: getTranslation( 'Nazwa roli' ),
                                anchor: '95%',
                                ref: '../../assignmentValueItem',
                                assignmentComponent: true,
                                items: [ {
                                    xtype: 'displayfield',
                                    value: roleNameTranslation,
                                    flex: 1
                                } ]
                            } );
                            break;
                        default:
                            break;
                    }

                    this.doLayout();
                }
            }
        } : [ {
            xtype: 'displayfield',
            ref: '../../assignmentTypeItem',
            fieldLabel: getTranslation( 'Przypisanie' ),
            value: getTranslation( 'Rola' ),
            getValue: function() {
                return 'role';
            }
        }, {
            xtype: 'compositefield',
            fieldLabel: getTranslation( 'Nazwa roli' ),
            anchor: '95%',
            ref: '../../assignmentValueItem',
            assignmentComponent: true,
            items: [ {
                xtype: 'displayfield',
                value: roleNameTranslation,
                flex: 1
            } ]
        } ], {
            xtype: 'checkbox',
            fieldLabel: newDocAcceptLabel,
            ref: '../../newDocumentAcceptItem',
            checked: activityNode.attributes.newDocumentAccept,
            inputValue: 'true',
            hidden: activityNode.attributes.activityType != Ext.ux.suncode.Constants.ACTIVITY
        }, {
            xtype: 'checkbox',
            fieldLabel: allowMultipleActiveActivitiesLabel,
            ref: '../../allowMultipleActiveActivitiesItem',
            checked: activityNode.attributes.allowMultipleActiveActivities,
            inputValue: 'true'
        }, {
            xtype: 'checkbox',
            fieldLabel: acceptConcLabel,
            ref: '../../acceptConcurrentlyItem',
            checked: activityNode.attributes.acceptConcurrently,
            inputValue: 'true',
            listeners: {
                scope: this,
                check: function( field, checked ) {
                    var nextActItem = this.ownerCt.ownerCt.nextActItem;
                    var acceptedNextActsGrid = this.ownerCt.ownerCt.acceptedNextActsItem;

                    if ( checked ) {
                        nextActItem.setValue( false );
                        nextActItem.hide();
                        acceptedNextActsGrid.hide();
                    } else {
                        nextActItem.show();
                        acceptedNextActsGrid.show();
                    }
                }
            }
        }, {
            xtype: 'checkbox',
            fieldLabel: nextActLabel,
            ref: '../../nextActItem',
            checked: activityNode.attributes.nextActivity,
            inputValue: 'true',
            hidden: ( activityNode.attributes.activityType != Ext.ux.suncode.Constants.ACTIVITY || activityNode.attributes.acceptConcurrently ),
            listeners: {
                scope: this,
                check: function( field, checked ) {
                    var acceptedNextActsGrid = this.ownerCt.ownerCt.acceptedNextActsItem;

                    if ( checked ) {
                        acceptedNextActsGrid.enable();
                    } else {
                        acceptedNextActsGrid.disable();
                    }
                }
            }
        }, new Ext.ux.suncode.AcceptedNextActivitiesGrid( {
        	ref: '../../acceptedNextActsItem',
            anchor: '95%',
            disabled: !activityNode.attributes.nextActivity,
            hidden: ( activityNode.attributes.activityType != Ext.ux.suncode.Constants.ACTIVITY || activityNode.attributes.acceptConcurrently ),
            activityNode: activityNode,
            acceptedNextActivities: activityNode.attributes.acceptedNextActivities
        } ), activityNode.attributes.activityType == Ext.ux.suncode.Constants.TOOL ? {
          xtype: 'checkbox',
          fieldLabel: acceptSeqLabel,
          ref: '../../acceptSequentiallyItem',
          checked: activityNode.attributes.acceptSequentially,
          inputValue: 'true'
        } : [], {
            xtype: 'fieldset',
            anchor: '95%',
            title: getTranslation( 'Opis' ),
            layout: 'fit',
            items: [ new Ext.ux.suncode.I18NTranslatedField( {
            	ref: '../../../descrItem',
            	field: {
                    xtype: 'textarea',
                    inputType: 'text',
                    height: 150,
                    value: activityNode.attributes.activityDescr
                },
                getIdFieldFunction: function() {
                	return this.ownerCt.ownerCt.idItem;
                },
                getIdFieldScope: this,
                emptyIdMessage: getTranslation( 'Podaj nazwę zadania.' ),
                windowTitle: getTranslation( 'Tłumaczenia opisu zadania' ),
                keyPrefix: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(',
                keyPostfix: ')_DESC',
                saveToCache: false,
                initialId: activityNode.attributes.activityDefId,
                multilineTranslationFields: true
            } ) ]
        } ],
        title: getTranslation( 'Definicja' ),
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: config.windowWidth * 0.4,
        boxMinHeight: config.panelHeight,
        boxMaxHeight: config.panelHeight,
        autoScroll: true,
        border: false
    }, config );

    Ext.ux.suncode.ActivityDefinitionPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityDefinitionPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityDefinitionPanel.superclass.initComponent.call( this );;
    },
    removeAssignmentComponents: function() {
        var itemsToRemove = new Array();
        Ext.each( this.items.items, function( item, index, items ) {
            if ( item.assignmentComponent ) {
                itemsToRemove.push( item );
            }
        } );
        Ext.each( itemsToRemove, function( item, index, items ) {
            this.remove( item );
        }, this );
        this.doLayout();
    }
} );

Ext.ux.suncode.AssignmentFiltersGrid = function( config ) {
    var activityNode = config.activityNode;
    var assignmentFilters = activityNode.attributes.assignment.filters;

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'type',
                type: 'string'
            }, {
                name: 'value',
                type: 'string'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( assignmentFilters ) ) {
        store.loadData( assignmentFilters );
        store.commitChanges();
    }

    var filtersChooser = new Ext.ux.suncode.AssignmentFilterTypesChooser();
    var variablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: activityNode.parentNode.attributes.variables,
        formalParameters: activityNode.parentNode.attributes.formalParameters
    } );

    config = Ext.apply( {
        title: getTranslation( 'Filtry' ),
        store: store,
        height: 210,
        frame: false,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        flex: 1,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'type',
                header: getTranslation( 'Typ' ),
                dataIndex: 'type',
                align: 'left',
                editor: filtersChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( filtersChooser )
            }, {
                id: 'value',
                header: getTranslation( 'Wartość' ),
                dataIndex: 'value',
                align: 'left',
                editor: variablesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( variablesChooser )
            } ]
        } ),
        viewConfig: new Ext.grid.GridView( {
            forceFit: true
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        type: '',
                        value: ''
                    } );
                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                    grid.startEditing( store.getCount() - 1, 0 );
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz filtr do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            afteredit: function( e ) {
                e.grid.getStore().commitChanges();
            }
        }
    }, config );

    Ext.ux.suncode.AssignmentFiltersGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AssignmentFiltersGrid, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.AssignmentFiltersGrid.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ActivityFormPanel = function( config ) {
    var activityNode = config.activityNode;
    var formStyles = activityNode.attributes.formStyles;
    var formSettings = activityNode.attributes.formSettings;

    var varTypesChooser = new Ext.ux.suncode.TypesChooser( {
        utilization: 'form'
    } );

    config = Ext.apply( {
        id: 'activity_properties_form_panel',
        layout: 'fit',
        layoutConfig: {
            trackLabels: true
        },
        ref: 'formPanel',
        items: [ {
            xtype: 'tabpanel',
            activeTab: 0,
            enableTabScroll: true,
            border: false,
            items: [ {
                xtype: 'grid',
                title: getTranslation( 'Zmienne formularza' ),
                ref: '../varsPanel',
                columnLines: true,
                enableColumnResize: true,
                changes: {
                    editability: new HashMap(),
                    visibility: new HashMap()
                },
                store: new Ext.data.Store( {
                    reader: new Ext.data.JsonReader( {
                        fields: Ext.data.Record.create( [ {
                            name: 'id',
                            type: 'string'
                        }, {
                            name: 'name',
                            type: 'string'
                        }, {
                            name: 'type',
                            type: 'string'
                        }, {
                            name: 'editable',
                            type: 'string'
                        }, {
                            name: 'hidden',
                            type: 'string'
                        } ] )
                    } )
                } ),
                autoScroll: true,
                sm: new Ext.grid.RowSelectionModel(),
                colModel: new Ext.grid.ColumnModel( {
                    defaults: {
                        sortable: false,
                        menuDisabled: true,
                        css: 'vertical-align:middle;'
                    },
                    columns: [ {
                        id: 'id',
                        header: getTranslation( 'Identyfikator' ),
                        dataIndex: 'id',
                        align: 'left',
                        hidden: !config.AV,
                        hideable: config.AV
                    }, {
                        id: 'name',
                        header: getTranslation( 'Nazwa' ),
                        dataIndex: 'name',
                        align: 'left'
                    }, {
                        id: 'type',
                        header: getTranslation( 'Typ' ),
                        dataIndex: 'type',
                        align: 'left',
                        editor: varTypesChooser,
                        renderer: Ext.util.Format.ComboBoxRenderer( varTypesChooser )
                    }, {
                        id: 'editable',
                        header: getTranslation( 'Edytowalna' ),
                        dataIndex: 'editable',
                        align: 'center',
                        width: 35,
                        renderer: tickCrossValue
                    }, {
                        id: 'hidden',
                        header: getTranslation( 'Ukryta' ),
                        dataIndex: 'hidden',
                        align: 'center',
                        width: 35,
                        renderer: tickCrossValue
                    } ]
                } ),
                view: new Ext.grid.GridView( {
                    forceFit: true
                } ),
                tbar: new Ext.Toolbar( {
                    items: [ '->', {
                        xtype: 'button',
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'change' ),
                        tooltip: getTranslation( 'Zmień edytowalność zmiennych' ),
                        handler: this.toggleFormVariablesEditability,
                        scope: this
                    } ]
                } ),
                listeners: {
                    scope: this,
                    cellclick: function( grid, rowIndex, columnIndex, e ) {
                        var store = grid.getStore();
                        var colId = grid.getColumnModel().getColumnId( columnIndex );

                        if ( colId == 'editable' ) {
                            var rec = store.getAt( rowIndex );
                            this.toggleFormVariableEditability( rec, false );
                        } else if ( colId == 'hidden' ) {
                            var rec = store.getAt( rowIndex );
                            var type = rec.get( 'type' );

                            if ( type == 'variable_set' ) {
                                showWarn( getTranslation( 'Tabela dynamiczna nie może być zmienną ukrytą.' ) );
                                return;
                            }

                            this.toggleFormVariableVisibility( rec );
                        }
                    },
                    containercontextmenu: this.onVariablesPanelContainerContextMenu,
                    rowcontextmenu: this.onVariablesPanelRowContextMenu
                }
            }, {
                xtype: 'panel',
                title: getTranslation( 'Style' ),
                layout: 'form',
                autoScroll: true,
                frame: false,
                border: false,
                bodyCssClass: 'x-Module-container-padding',
                items: [ new Ext.ux.suncode.YesNoChooser( {
                  fieldLabel: getTranslation( 'Pokazuj linie' ),
                  anchor: '100%',
                  value: formStyles.showLines,
                  styleId: 'showLines',
                  listeners: {
                    scope: this,
                    change: this.changeFormStyle,
                    select: this.selectFormStyle
                  }
                } ) ]
            }, {
                xtype: 'panel',
                title: getTranslation( 'Ustawienia' ),
                layout: 'form',
                autoScroll: true,
                frame: false,
                border: false,
                bodyCssClass: 'x-Module-container-padding',
                items: [ {
                    xtype: 'checkbox',
                    fieldLabel: getTranslation( 'Pokazuj nazwy procesu i zadania' ),
                    anchor: '100%',
                    checked: formSettings.showProcessAndActivityNames,
                    inputValue: 'true',
                    settingId: 'showProcessAndActivityNames',
                    listeners: {
                        scope: this,
                        check: this.toggleFormSetting
                    }
                }, {
                    xtype: 'checkbox',
                    fieldLabel: getTranslation( 'Pokazuj komentarze' ),
                    anchor: '100%',
                    checked: formSettings.showComments,
                    inputValue: 'true',
                    settingId: 'showComments',
                    listeners: {
                        scope: this,
                        check: this.toggleFormSetting
                    }
                }, new Ext.ux.suncode.DocumentsViewLocationsChooser( {
                    settingId: 'documentsViewLocation',
                    value: formSettings.documentsViewLocation,
                    listeners: {
                        scope: this,
                        select: this.toggleDocumentsViewLocation
                    }
                } ) ]
            } ]
        } ],
        tbar: [ '->', new Ext.ux.suncode.CopyFormButton( {
        	activityNode: activityNode,
        	activityPropertiesPanel: this
        } ), {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'form' ),
            tooltip: getTranslation( 'Projektuj formularz' ),
            handler: this.designActivityForm,
            scope: this
        }, {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'change' ),
            tooltip: getTranslation( 'Przeładuj formularz' ),
            handler: this.reloadActivityForm,
            scope: this
        } ],
        title: getTranslation( 'Formularz' ),
        labelWidth: config.windowWidth * 0.4,
        boxMinHeight: config.panelHeight,
        boxMaxHeight: config.panelHeight,
        border: false
    }, config );

    Ext.ux.suncode.ActivityFormPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.loadFormGrids );
    },
    loadFormGrids: function() {
        var activityNode = this.initialConfig.activityNode;
        var formVariables = activityNode.attributes.form.variables;

        if ( !Ext.isEmpty( formVariables ) ) {
        	var store = this.varsPanel.getStore();
        	
            Ext.each( formVariables, function( variable, index, variables ) {
            	this.addFormVariableToGrid( store, variable );
            }, this );
            
            store.commitChanges();
        }
    },
    addFormVariableToGrid: function( store, variable ) {
    	var r = store.recordType;
    	var v = new r( {
            name: variable.name,
            type: variable.type,
            editable: variable.editable,
            hidden: variable.hidden,
            id: variable.varId
        } );
    	store.add( v );
    },
    reloadFormGrids: function() {
    	var varsPanel = this.varsPanel;
    	varsPanel.changes = {
            editability: new HashMap(),
            visibility: new HashMap()
        };
        var varsStore = varsPanel.getStore();
        varsStore.removeAll();

        this.loadFormGrids();
    },
    designActivityForm: function() {
        designActivityForm( this.initialConfig.activityNode );
    },
    selectFormStyle: function( combo, record, index ) {
        var activityNode = this.initialConfig.activityNode;
        activityNode.setFormStyle( combo.styleId, combo.getValue() );
    },
    changeFormStyle: function( field, newValue, oldValue ) {
      if ( Ext.isEmpty( newValue ) ) {
        var activityNode = this.initialConfig.activityNode;
        activityNode.setFormStyle( field.styleId, null );
      }
    },
    toggleFormSetting: function( field, value ) {
        var activityNode = this.initialConfig.activityNode;
        activityNode.setFormSetting( field.settingId, value );
    },
    toggleDocumentsViewLocation: function( combo ) {
        var value = combo.getValue();

        if ( !Ext.isEmpty( value ) && combo.isValid() ) {
            this.toggleFormSetting( combo, value );
        }
    },
    toggleFormVariablesEditability: function() {
        var store = this.varsPanel.getStore();

        store.each( function( rec ) {
            this.toggleFormVariableEditability( rec, true );
        }, this );
        
        this.storeParentWindowAsUnsaved();
    },
    toggleFormVariableEditability: function( rec, batchOperation ) {
    	var hidden = rec.get( 'hidden' );
    	if ( !hidden ) {
    		var currentValue = rec.get( 'editable' );
            rec.set( 'editable', !currentValue );
            rec.commit();
            this.varsPanel.changes.editability.put( rec.get( 'id' ), rec.get( 'editable' ) );
            
            if ( !batchOperation ) {
            	this.storeParentWindowAsUnsaved();
            }
    	} else if ( !batchOperation ) {
    		showWarn( getTranslation( 'Zmienna jest ukryta. Nie można zmienić edytowalności.' ) );
    	}
    },
    toggleFormVariableVisibility: function( rec ) {
        var currentValue = rec.get( 'hidden' );
        rec.set( 'hidden', !currentValue );
        var varId = rec.get( 'id' );
        var newHidden = rec.get( 'hidden' );
        this.varsPanel.changes.visibility.put( varId, newHidden );
        
        if ( newHidden ) {
        	rec.set( 'editable', true );
        	this.varsPanel.changes.editability.put( varId, true );
        }
        
        rec.commit();
        this.storeParentWindowAsUnsaved();
    },
    reloadActivityForm: function() {
        var warnMsg = getTranslation( 'Przeładowanie formularza bez odświeżenia pakietu nie zezwoli na:' );
        warnMsg += '<br>' + getTranslation( '- dodanie do formularza zmiennej lub tabeli dynamicznej' );
        warnMsg += '<br>' + getTranslation( '- usunięcie zmiennej lub tabeli dynamicznej z formularza' );
        warnMsg += '<br>' + getTranslation( '- zmianę identyfikatora pakietu' );
        warnMsg += '<br>' + getTranslation( '- zmianę identyfikatora definicji procesu' );
        warnMsg += '<br>' + getTranslation( '- zmianę identyfikatora definicji zadania' );
        warnMsg += '<br><br>' + getTranslation( 'Czy chcesz kontynuować?' );

        Ext.Msg.show( {
            title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
            msg: warnMsg,
            buttons: {
                yes: getTranslation( 'Tak' ),
                no: getTranslation( 'Nie' )
            },
            fn: function( buttonId ) {
                if ( buttonId == 'yes' ) {
                    this.executeReloadActivityForm();
                }
            },
            icon: Ext.Msg.QUESTION,
            scope: this
        } );
    },
    copyForm: function( choosenActivityNode ) {
    	var fromForm = choosenActivityNode.attributes.form;
        var toForm = this.initialConfig.activityNode.attributes.form;

        for ( var prop in fromForm ) {
            toForm[prop] = deepObjectCopy( fromForm[prop] );
        }
        
        this.reloadFormGrids();
    },
    executeReloadActivityForm: function() {
        var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
        var packageId = packageNode.attributes.packageId;
        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var processDefId = processNode.attributes.processDefId;
        var formTemplate = Ext.util.JSON.encode( Ext.ux.suncode.FormTemplateWriter.writeActivityFormTemplate( processDefId, activityNode ) );

        Ext.Ajax.request( {
            url: 'api/formtemplate/reloadActivityForm',
            method: 'POST',
            params: {
                packageId: packageId,
                formTemplate: formTemplate,
                activityDefinition: Ext.util.JSON.encode( {
                    Activity: xpdlActivity( activityNode )
                } )
            },
            success: function( response, opts ) {
                var result = Ext.util.JSON.decode( response.responseText );

                if ( result.reloaded ) {
                    Ext.Msg.show( {
                        title: getTranslation( 'Sukces' ),
                        msg: getTranslation( 'Przeładowano formularz.' ),
                        buttons: Ext.Msg.OK,
                        icon: Ext.Msg.INFO
                    } );
                } else {
                    var errorMessage = result.errorMessage;
                    var incorrectVariableId = result.incorrectVariableId;

                    if ( !Ext.isEmpty( incorrectVariableId ) ) {
                        errorMessage += '<br>' + getTranslation( 'Identyfikator' ) + ': ' + incorrectVariableId + '.';
                    }

                    showWarn( getTranslation( errorMessage ) );
                }
            },
            failure: function( response, opts ) {
            	showWarn( getTranslation( 'Wystąpił błąd.' ) );
            }
        } );
    },
    onVariablesPanelContainerContextMenu: function( grid, e ) {
      Ext.ux.suncode.Clipboard.getActivityFormComponents( function( variables ) {
        var menu = this.buildCopyPasteVariablesContextMenu( variables );
        showMenu( menu, e );
      }, this );
    },
    onVariablesPanelRowContextMenu: function( grid, rowIndex, e ) {
    	var selModel = grid.getSelectionModel();
    	selModel.selectRow( rowIndex, true );

      Ext.ux.suncode.Clipboard.getActivityFormComponents( function( variables ) {
        var menu = this.buildCopyPasteVariablesContextMenu( variables );
        showMenu( menu, e );
      }, this );
    },
    buildCopyPasteVariablesContextMenu: function( clipboardVariables ) {
      var grid = this.varsPanel;
      var selModel = grid.getSelectionModel();
      var rows = selModel.getSelections();

      return new Ext.menu.Menu( {
        items: [ {
          xtype: 'menuitem',
          cls: 'x-btn-text-icon',
          icon: getPluginImgPath( 'copy' ),
          text: getTranslation( 'Kopiuj pola' ),
          disabled: Ext.isEmpty( rows ),
          listeners: {
            scope: this,
            click: this.onCopyVariables
          }
        }, {
          xtype: 'menuitem',
          cls: 'x-btn-text-icon',
          icon: getPluginImgPath( 'paste' ),
          text: getTranslation( 'Wklej pola' ),
          disabled: Ext.isEmpty( clipboardVariables ),
          clipboardVariables: clipboardVariables,
          listeners: {
            scope: this,
            click: this.onPasteVariables
          }
        }, {
          xtype: 'menuitem',
          cls: 'x-btn-text-icon',
          icon: getPluginImgPath( 'paste' ),
          text: getTranslation( 'Wklej specjalnie' ),
          listeners: {
            scope: this,
            click: this.onPasteSpecial
          }
        } ]
      } );
    },
    onCopyVariables: function( menuItem, e ) {
    	var grid = this.varsPanel;
    	var selModel = grid.getSelectionModel();
        var rows = selModel.getSelections();
        var objects = new Array();

        Ext.each( rows, function( row, index, allRows ) {
        	var varId = row.get( 'id' );
        	
    		objects.push( {
    			item: this.getFormVariableItem( varId ),
    			objectDef: this.getFormVariableObjectDef( varId ),
    		} );
    	}, this );
    	
    	Ext.ux.suncode.Clipboard.setActivityFormComponents( objects );
    },
    getFormVariableObjectDef: function( varId ) {
    	var activityNode = this.initialConfig.activityNode;
    	var formVariables = activityNode.attributes.form.variables;
    	
    	if ( !Ext.isEmpty( formVariables ) ) {
            for ( var i = 0; i < formVariables.length; i++ ) {
            	var formVariable = formVariables[i];
            	
            	if ( formVariable.varId == varId ) {
            		return formVariable;
            	}
            }
    	}
    	
    	return null;
    },
    getFormVariableItem: function( varId ) {
    	var activityNode = this.initialConfig.activityNode;
    	var formTemplate = activityNode.attributes.form.template;
    	
    	if ( !Ext.isEmpty( formTemplate.rows ) ) {
            for ( var i = 0; i < formTemplate.rows.length; i++ ) {
                var row = formTemplate.rows[i];

                for ( var j = 0; j < row.items.length; j++ ) {
                    var item = row.items[j];

                    if ( item.id == varId ) {
                        return item;
                    }
                }
            }
        }
    	
    	return null;
    },
    onPasteVariables: function( menuItem, e ) {
      var clipboardVariables = menuItem.clipboardVariables;

      this.executePasteVariables( clipboardVariables );
    },
    executePasteVariables: function( clipboardVariables ) {
      var activityNode = this.initialConfig.activityNode;
      var presentComponentIds = this.collectPresentComponentIds();
      var duplicates = new Array();
      var store = this.varsPanel.getStore();

      Ext.each( clipboardVariables, function( clipboardVariable, index, allClipboardVariables ) {
        var objectDef = clipboardVariable.objectDef;
        var shouldPaste = true;

        switch ( objectDef.genre ) {
          case 'VARIABLE':
            if ( presentComponentIds.indexOf( objectDef.varId ) != -1 ) {
              shouldPaste = false;
              duplicates.push( {
                itemName: getTranslation( 'Pole' ),
                itemId: objectDef.varId
              } );
            }
            break;
          case 'VARIABLE_SET':
            if ( presentComponentIds.indexOf( objectDef.varId ) != -1 ) {
              shouldPaste = false;
              duplicates.push( {
                itemName: getTranslation( 'Tabela dynamiczna' ),
                itemId: objectDef.varId
              } );
            } else {
              var columns = objectDef.columns;

              for ( var k = 0; k < columns.length; k++ ) {
                var column = columns[k];

                if ( presentComponentIds.indexOf( column.varId ) != -1 ) {
                  shouldPaste = false;
                  duplicates.push( {
                    itemName: getTranslation( 'Tabela dynamiczna' ),
                    itemId: objectDef.varId,
                    subitemName: getTranslation( 'Kolumna' ),
                    subitemId: column.varId
                  } );
                  break;
                }
              }

              var dtButtons = objectDef.DTButtons;

              for ( var k = 0; k < dtButtons.length; k++ ) {
                var dtButton = dtButtons[i];

                if ( presentComponentIds.indexOf( dtButton.buttonId ) != -1 ) {
                  shouldPaste = false;
                  shouldPaste = false;
                  duplicates.push( {
                    itemName: getTranslation( 'Tabela dynamiczna' ),
                    itemId: objectDef.varId,
                    subitemName: getTranslation( 'Przycisk' ),
                    subitemId: dtButton.buttonId
                  } );
                  break;
                }
              }
            }
            break;
          default:
            shouldPaste = false;
            break;
        }

        if ( shouldPaste ) {
          activityNode.addVariable( objectDef, clipboardVariable.item );
          this.addFormVariableToGrid( store, objectDef );
        }
      }, this );

      store.commitChanges();

      if ( !Ext.isEmpty( duplicates ) ) {
        var warnMsg = getTranslation( 'Duplikaty pominięte podczas wklejania' );
        warnMsg += ':';

        Ext.each( duplicates, function( duplicate, index, allDuplicates ) {
          warnMsg += '<br>- ';
          warnMsg += duplicate.itemName.toLowerCase();
          warnMsg += ': ';
          warnMsg += duplicate.itemId;

          if ( !Ext.isEmpty( duplicate.subitemName ) && !Ext.isEmpty( duplicate.subitemId ) ) {
            warnMsg += ' (';
            warnMsg += duplicate.subitemName.toLowerCase();
            warnMsg += ': ';
            warnMsg += duplicate.subitemId;
            warnMsg += ')';
          }
        } );

        showWarn( warnMsg );
      }
    },
    collectPresentComponentIds: function() {
    	var ids = new Array();
    	var activityNode = this.initialConfig.activityNode;
    	var formVariables = activityNode.attributes.form.variables;
    	var httpLinks = activityNode.attributes.form.httpLinks;
    	var buttons = activityNode.attributes.form.buttons;
    	
    	if ( !Ext.isEmpty( formVariables ) ) {
            Ext.each( formVariables, function( formVariable, index, allFormVariables ) {
            	ids.push( formVariable.varId );
            } );
    	}
    	
    	if ( !Ext.isEmpty( httpLinks ) ) {
            Ext.each( httpLinks, function( httpLink, index, allHttpLinks ) {
            	ids.push( httpLink.actionName + '_button' );
            } );
    	}
    	
    	if ( !Ext.isEmpty( buttons ) ) {
            Ext.each( buttons, function( button, index, allButtons ) {
            	ids.push( button.actionName + '_button' );
            } );
    	}
    	
    	return ids;
    },
    onPasteSpecial: function() {
      var win = new Ext.ux.suncode.PasteSpecialWindow( {
        pasteSpecialFunction: function( variables ) {
          this.executePasteVariables( variables );
        },
        pasteSpecialScope: this,
        messageType: Ext.ux.suncode.Clipboard.activityFormComponentsMessageType
      } );
      win.show();
    }
} );

Ext.ux.suncode.ActivityTransitionRestrictionPanel = function( config ) {
    var activityNode = config.activityNode;
    var activityName = activityNode.attributes.activityName;
    var activityDefId = activityNode.attributes.activityDefId;
    var processNode = activityNode.parentNode;
    var processDefId = processNode.attributes.processDefId
    var packageNode = processNode.parentNode;
    var packageId = packageNode.attributes.packageId
    var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, activityName );
    var conditionTypes = [ [ 'XOR', getTranslation( 'Wykluczające' ) ], [ 'AND', getTranslation( 'Równoległe' ) ] ];

    config = Ext.apply( {
        title: getTranslation( 'Połączenia' ),
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: config.windowWidth * 0.4,
        height: config.panelHeight,
        autoScroll: true,
        items: [ {
            xtype: 'combo',
            fieldLabel: getTranslation( 'Łączenie zadań przychodzących' ),
            anchor: '98%',
            triggerAction: 'all',
            mode: 'local',
            store: new Ext.data.ArrayStore( {
                fields: [ 'join', 'joinName' ],
                data: conditionTypes
            } ),
            valueField: 'join',
            displayField: 'joinName',
            forceSelection: true,
            editable: false,
            emptyText: 'XOR',
            value: activityNode.attributes.transitionRestriction.join,
            listeners: {
                scope: this,
                select: this.changeJoinRestriction
            }
        }, {
            xtype: 'combo',
            fieldLabel: getTranslation( 'Łączenie zadań wychodzących' ),
            anchor: '98%',
            triggerAction: 'all',
            mode: 'local',
            store: new Ext.data.ArrayStore( {
                fields: [ 'split', 'splitName' ],
                data: conditionTypes
            } ),
            valueField: 'split',
            displayField: 'splitName',
            forceSelection: true,
            editable: false,
            emptyText: 'XOR',
            value: activityNode.attributes.transitionRestriction.split,
            listeners: {
                scope: this,
                select: this.changeSplitRestriction
            }
        }, {
            xtype: 'panel',
            title: getTranslation( 'Połączenia warunkowe dla zadania' ) + ' ' + activityNameTranslation,
            layout: 'fit',
            anchor: '98%',
            height: 600,
            frame: false,
            items: new Ext.ux.suncode.TransitionConditionsGrid( config )
        } ]
    }, config );

    Ext.ux.suncode.ActivityTransitionRestrictionPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityTransitionRestrictionPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityTransitionRestrictionPanel.superclass.initComponent.call( this );
    },
    changeJoinRestriction: function( combo, record, index ) {
        var conditionType = combo.getValue();

        if ( combo.isValid() && !Ext.isEmpty( conditionType ) ) {
            this.initialConfig.activityNode.setJoinTransitionRestriction( conditionType );
        }
    },
    changeSplitRestriction: function( combo, record, index ) {
        var conditionType = combo.getValue();

        if ( combo.isValid() && !Ext.isEmpty( conditionType ) ) {
            var activityDefId = this.initialConfig.activityNode.attributes.activityDefId;
            var paper = Ext.getCmp( 'paper_panel' ).getActiveTab().paper;
            paper.bpmn.changeConditionalLinesTypeForActivity( paper, activityDefId, conditionType );
            this.initialConfig.activityNode.setSplitTransitionRestriction( conditionType );
        }
    }
} );

Ext.ux.suncode.ActivityDeadlinesPanel = function( config ) {
    var activityNode = config.activityNode;

    var deadlinesStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'exceptionName',
                type: 'string'
            }, {
                name: 'execution',
                type: 'string'
            } ] )
        } )
    } );

    if ( activityNode.attributes.deadlines.length > 0 ) {
        deadlinesStore.loadData( activityNode.attributes.deadlines );
        deadlinesStore.commitChanges();
    }

    var executionsChooser = new Ext.ux.suncode.DeadlineExecutionsChooser( {} );

    config = Ext.apply( {
        title: getTranslation( 'Terminy ostateczne' ),
        height: config.panelHeight,
        store: deadlinesStore,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        layout: 'fit',
        ref: 'deadlinesGrid',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'exceptionName',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'exceptionName',
                align: 'left'
            }, {
                id: 'execution',
                header: getTranslation( 'Wykonanie' ),
                dataIndex: 'execution',
                align: 'left',
                editor: executionsChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( executionsChooser )
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak terminów ostatecznych dla zadania' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj termin ostateczny' ),
                handler: this.addDeadline,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj termin ostateczny' ),
                handler: this.editDeadline,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń termin ostateczny' ),
                handler: this.removeDeadline,
                scope: this
            } ]
        } ),
        listeners: {
            scope: this,
            rowdblclick: function( grid, rowIndex, e ) {
                this.editDeadline();
            }
        }
    }, config );

    Ext.ux.suncode.ActivityDeadlinesPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityDeadlinesPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityDeadlinesPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var tbar = this.getTopToolbar();
        var txt = '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość terminów ostatecznych' ) + ': ' + this.getStore().getCount()
                        + '</b></font>';
        tbar.insert( 0, txt );
    },
    updateTitle: function() {
        var tbar = this.getTopToolbar();
        var txtInfo = tbar.items.first();
        txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość terminów ostatecznych' ) + ': ' + this.getStore().getCount()
                        + '</b></font>' );
    },
    addDeadline: function() {
        var win = new Ext.ux.suncode.DeadlineDefWindow( {
            activityNode: this.initialConfig.activityNode,
            saveTo: this,
            varRecord: this.getStore().recordType
        } );
        win.show();
    },
    editDeadline: function() {
        var deadline = this.getSelectedDeadline();
        if ( !deadline ) {
            return;
        }

        var win = new Ext.ux.suncode.DeadlineDefWindow( {
            deadline: this.initialConfig.activityNode.findDeadline( deadline.get( 'exceptionName' ) ),
            activityNode: this.initialConfig.activityNode,
            saveTo: this,
            varRecord: deadline
        } );
        win.show();
    },
    removeDeadline: function() {
        var deadline = this.getSelectedDeadline();
        if ( !deadline ) {
            return;
        }
        this.initialConfig.activityNode.removeDeadline( deadline.get( 'exceptionName' ) );
        removeRowAndMarkNext( this, deadline );
        this.updateTitle();
    },
    getSelectedDeadline: function() {
        var deadline = this.getSelectionModel().getSelected();
        if ( !deadline ) {
            showWarn( getTranslation( 'Wybierz termin ostateczny.' ) );
            return null;
        }
        return deadline;
    }
} );

Ext.ux.suncode.ActivityAcceptancesPanel = function( config ) {
    var activityNode = config.activityNode;

    var acceptancesStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'acceptVar',
                type: 'string'
            }, {
                name: 'checkVar',
                type: 'string'
            }, {
                name: 'resultVar',
                type: 'string'
            }, {
                name: 'buttonName',
                type: 'string'
            }, {
                name: 'id',
                type: 'string'
            } ] )
        } )
    } );

    if ( activityNode.attributes.acceptances.length > 0 ) {
        acceptancesStore.loadData( activityNode.attributes.acceptances );
        acceptancesStore.commitChanges();
    }

    var allVariablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: activityNode.parentNode.attributes.variables,
        formalParameters: activityNode.parentNode.attributes.formalParameters
    } );
    var activityAcceptButtonsChooser = new Ext.ux.suncode.ActivityAcceptButtonsChooser( {
        activityNode: activityNode
    } );

    config = Ext.apply( {
        id: 'activity_properties_acceptances_panel',
        title: getTranslation( 'Akceptacje' ),
        height: config.panelHeight,
        store: acceptancesStore,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        layout: 'fit',
        ref: 'acceptancesGrid',
        activityAcceptButtonsChooser: activityAcceptButtonsChooser,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'acceptVar',
                header: getTranslation( 'Lista akceptujących' ),
                dataIndex: 'acceptVar',
                align: 'left',
                editor: allVariablesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser )
            }, {
                id: 'checkVar',
                header: getTranslation( 'Pełna lista akceptujących' ),
                dataIndex: 'checkVar',
                align: 'left',
                editor: allVariablesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser )
            }, {
                id: 'resultVar',
                header: getTranslation( 'Zmienna wynikowa' ),
                dataIndex: 'resultVar',
                align: 'left',
                editor: allVariablesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser )
            }, {
                id: 'buttonName',
                header: getTranslation( 'Nazwa przycisku' ),
                dataIndex: 'buttonName',
                align: 'left',
                editor: activityAcceptButtonsChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( activityAcceptButtonsChooser )
            }, {
                id: 'id',
                header: 'id',
                dataIndex: 'id',
                align: 'left',
                hidden: true,
                hideable: false
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak akceptacji dla zadania' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj akceptację' ),
                handler: this.addAcceptance,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj akceptację' ),
                handler: this.editAcceptance,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń akceptację' ),
                handler: this.removeAcceptance,
                scope: this
            } ]
        } ),
        listeners: {
            scope: this,
            rowdblclick: function( grid, rowIndex, e ) {
                this.editAcceptance();
            }
        }
    }, config );

    Ext.ux.suncode.ActivityAcceptancesPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityAcceptancesPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityAcceptancesPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var tbar = this.getTopToolbar();
        var txt = '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość akceptacji' ) + ': ' + this.getStore().getCount() + '</b></font>';
        tbar.insert( 0, txt );
    },
    updateTitle: function() {
        var tbar = this.getTopToolbar();
        var txtInfo = tbar.items.first();
        txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość akceptacji' ) + ': ' + this.getStore().getCount()
                        + '</b></font>' );
    },
    addAcceptance: function() {
        var win = new Ext.ux.suncode.AcceptanceDefWindow( {
            activityNode: this.initialConfig.activityNode,
            saveTo: this,
            varRecord: this.getStore().recordType,
            assignmentTypeItem: this.ownerCt.ownerCt.assignmentTypeItem
        } );
        win.show();
    },
    editAcceptance: function() {
        var acceptance = this.getSelectedAcceptance();
        if ( !acceptance ) {
            return;
        }

        var win = new Ext.ux.suncode.AcceptanceDefWindow( {
            acceptance: this.initialConfig.activityNode.findAcceptance( acceptance.get( 'id' ) ),
            activityNode: this.initialConfig.activityNode,
            saveTo: this,
            varRecord: acceptance,
            assignmentTypeItem: this.ownerCt.ownerCt.assignmentTypeItem
        } );
        win.show();
    },
    removeAcceptance: function() {
        var acceptance = this.getSelectedAcceptance();
        if ( !acceptance ) {
            return;
        }
        this.initialConfig.activityNode.removeAcceptance( acceptance.get( 'id' ) );
        removeRowAndMarkNext( this, acceptance );
        this.updateTitle();
    },
    getSelectedAcceptance: function() {
        var acceptance = this.getSelectionModel().getSelected();
        if ( !acceptance ) {
            showWarn( getTranslation( 'Wybierz akceptację.' ) );
            return null;
        }
        return acceptance;
    },
    reloadActivityAcceptButtonsChooser: function() {
        var store = this.activityAcceptButtonsChooser.getStore();
        var rec = store.recordType;

        Ext.each( this.initialConfig.activityNode.attributes.form.buttons, function( button, index, buttons ) {
            if ( button.genre == 'ACTION_ACCEPT_BUTTON' ) {
                var btn = new rec( {
                    actionName: button.actionName,
                    buttonName: button.buttonName
                } );
                store.add( btn );
            }
        } );

        store.commitChanges();
    },
    reloadAcceptancesStore: function() {
        var acceptances = this.initialConfig.activityNode.attributes.acceptances;

        if ( acceptances.length > 0 ) {
            var store = this.getStore();
            store.loadData( acceptances );
            store.commitChanges();
        }
    }
} );

Ext.ux.suncode.ActivityAdditionalsPanel = function( config ) {
    var activityNode = config.activityNode;
    var mainPanel = Ext.getCmp( 'main_panel' );
    var compatibilityMode = mainPanel.getCompatibilityMode();
    var items = new Array();

    var defaultsStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'varId',
                type: 'string'
            }, {
                name: 'varValue',
                type: 'string'
            } ] )
        } )
    } );

    var checkAppendicesStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'docClassName',
                type: 'string'
            } ] )
        } )
    } );

    var additionalJsChecksStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'additionalJsCheck',
                type: 'string'
            } ] )
        } )
    } );

    var extraDataChooserTreeChildren = new Array();

    var defaults = activityNode.attributes.additionals.defaults;
    if ( !Ext.isEmpty( defaults ) ) {
        defaultsStore.loadData( defaults );
        defaultsStore.commitChanges();
    }

    var checkAppendices = activityNode.attributes.additionals.checkAppendices;
    if ( !Ext.isEmpty( checkAppendices ) ) {
        checkAppendicesStore.loadData( checkAppendices );
        checkAppendicesStore.commitChanges();
    }

    var additionalJsChecks = activityNode.attributes.additionals.additionalJsChecks;
    if ( !Ext.isEmpty( additionalJsChecks ) ) {
        additionalJsChecksStore.loadData( additionalJsChecks );
        additionalJsChecksStore.commitChanges();
    }

    var extraDataChooserConfigs = activityNode.attributes.additionals.extraDataChooserConfigs;
    if ( !Ext.isEmpty( extraDataChooserConfigs ) ) {
        var processNode = activityNode.parentNode;

        for ( var i = 0; i < extraDataChooserConfigs.length; i++ ) {
            var extraDataChooserConfig = extraDataChooserConfigs[i];
            var variable = processNode.findVariable( extraDataChooserConfig.dataChooserId );

            if ( variable ) {
                extraDataChooserTreeChildren.push( {
                    text: getExtraDataChooserConfigNodeText( variable.name, extraDataChooserConfig.attributes ),
                    icon: getPluginImgPath( 'parameters' ),
                    leaf: true,
                    extraConfig: extraDataChooserConfig
                } );
            }
        }
    }

    var allVariablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: activityNode.parentNode.attributes.variables,
        formalParameters: activityNode.parentNode.attributes.formalParameters,
        excludedFormalParams: [ 'Initiator', 'ProccessId', 'ActivityId', 'Transaction' ]
    } );
    var defaultValuesChooser = new Ext.ux.suncode.DefaultValuesChooser( {} );
    var docClassChooser = new Ext.ux.suncode.SystemDocumentClassesChooser( {} );
    
    if ( compatibilityMode.showActivityAdditionalsDefaultSettings( defaults ) ) {
    	items.push( {
            xtype: 'panel',
            title: addTooltipToField( getTranslation( 'Ustawienia domyślne' ), null, null, true ),
            layout: 'fit',
            items: [ {
                xtype: 'editorgrid',
                ref: '../../defaultsPanel',
                columnLines: true,
                enableColumnResize: true,
                store: defaultsStore,
                autoScroll: true,
                sm: new Ext.grid.RowSelectionModel( {
                    singleSelect: true
                } ),
                colModel: new Ext.grid.ColumnModel( {
                    defaults: {
                        sortable: false,
                        menuDisabled: true
                    },
                    columns: [ {
                        id: 'varId',
                        header: getTranslation( 'Nazwa zmiennej procesu' ),
                        dataIndex: 'varId',
                        align: 'left',
                        editor: allVariablesChooser,
                        renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser )
                    }, {
                        id: 'varValue',
                        header: getTranslation( 'Wartość' ),
                        dataIndex: 'varValue',
                        align: 'left',
                        editor: defaultValuesChooser,
                        renderer: Ext.util.Format.ComboBoxRenderer( defaultValuesChooser )
                    } ]
                } ),
                view: new Ext.grid.GridView( {
                    forceFit: true
                } ),
                tbar: new Ext.Toolbar( {
                    items: [ '->', {
                        xtype: 'button',
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'add' ),
                        tooltip: getTranslation( 'Dodaj' ),
                        handler: function() {
                            var grid = this.ownerCt.ownerCt;
                            var store = grid.getStore();
                            var a = store.recordType;
                            var rec = new a( {
                                varId: '',
                                varValue: ''
                            } );
                            grid.stopEditing();
                            store.add( rec );
                            store.commitChanges();
                        }
                    }, {
                        xtype: 'button',
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'delete' ),
                        tooltip: getTranslation( 'Usuń' ),
                        handler: function() {
                            var grid = this.ownerCt.ownerCt;
                            var selModel = grid.getSelectionModel();
                            var rows = selModel.getSelections();
                            if ( rows.length == 0 ) {
                                showWarn( getTranslation( 'Wybierz ustawienie domyślne do usunięcia.' ) );
                                return;
                            }
                            removeRowAndMarkNext( grid, rows[0] );
                            grid.getView().refresh();
                        }
                    } ]
                } ),
                listeners: {
                    validateedit: function( e ) {
                        var store = e.grid.getStore();
                        if ( !Ext.isEmpty( e.value ) && store.findExact( 'varId', e.value ) != -1 ) {
                            showWarn( getTranslation( 'Ustawienie domyślne zostało już dodane.' ) );
                            return false;
                        }
                    },
                    afteredit: function( e ) {
                        e.record.commit();
                    }
                }
            } ]
        } );
    }
    if ( compatibilityMode.showActivityAdditionalsCheckAppendices( checkAppendices ) ) {
    	items.push( {
            xtype: 'panel',
            title: addTooltipToField( getTranslation( 'Weryfikacja podłączenia dokumentów' ), null, null, true ),
            layout: 'fit',
            items: [ {
                xtype: 'editorgrid',
                ref: '../../checkAppendicesPanel',
                columnLines: true,
                enableColumnResize: true,
                store: checkAppendicesStore,
                autoScroll: true,
                sm: new Ext.grid.RowSelectionModel( {
                    singleSelect: true
                } ),
                colModel: new Ext.grid.ColumnModel( {
                    defaults: {
                        sortable: false,
                        menuDisabled: true
                    },
                    columns: [ {
                        id: 'docClassName',
                        header: getTranslation( 'Klasa dokumentów' ),
                        dataIndex: 'docClassName',
                        align: 'left',
                        editor: docClassChooser,
                        renderer: Ext.util.Format.ComboBoxRenderer( docClassChooser )
                    } ]
                } ),
                view: new Ext.grid.GridView( {
                    forceFit: true
                } ),
                tbar: new Ext.Toolbar( {
                    items: [ '->', {
                        xtype: 'button',
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'add' ),
                        tooltip: getTranslation( 'Dodaj' ),
                        handler: function() {
                            var grid = this.ownerCt.ownerCt;
                            var store = grid.getStore();
                            var a = store.recordType;
                            var rec = new a( {
                                varId: '',
                                varValue: ''
                            } );
                            grid.stopEditing();
                            store.add( rec );
                            store.commitChanges();
                        }
                    }, {
                        xtype: 'button',
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'delete' ),
                        tooltip: getTranslation( 'Usuń' ),
                        handler: function() {
                            var grid = this.ownerCt.ownerCt;
                            var selModel = grid.getSelectionModel();
                            var rows = selModel.getSelections();
                            if ( rows.length == 0 ) {
                                showWarn( getTranslation( 'Wybierz klasę dokumentów do usunięcia.' ) );
                                return;
                            }
                            removeRowAndMarkNext( grid, rows[0] );
                            grid.getView().refresh();
                        }
                    } ]
                } )
            } ]
        } );
    }
    if ( compatibilityMode.showActivityAdditionalsAdditionalJsChecks( additionalJsChecks ) ) {
    	items.push( {
            xtype: 'panel',
            title: addTooltipToField( getTranslation( 'Walidacje akceptacji' ), null, null, true ),
            layout: 'fit',
            items: [ {
                xtype: 'editorgrid',
                ref: '../../additionalJsChecksPanel',
                columnLines: true,
                enableColumnResize: true,
                store: additionalJsChecksStore,
                autoScroll: true,
                sm: new Ext.grid.RowSelectionModel( {
                    singleSelect: true
                } ),
                colModel: new Ext.grid.ColumnModel( {
                    defaults: {
                        sortable: false,
                        menuDisabled: true
                    },
                    columns: [ {
                        id: 'additionalJsCheck',
                        header: getTranslation( 'Funkcja' ),
                        dataIndex: 'additionalJsCheck',
                        align: 'left',
                        editor: new Ext.form.TextField( {
                            inputType: 'text',
                            maskRe: /[a-zA-Z0-9_$]/
                        } )
                    } ]
                } ),
                view: new Ext.grid.GridView( {
                    forceFit: true
                } ),
                tbar: new Ext.Toolbar( {
                    items: [ '->', {
                        xtype: 'button',
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'add' ),
                        tooltip: getTranslation( 'Dodaj' ),
                        handler: function() {
                            var grid = this.ownerCt.ownerCt;
                            var store = grid.getStore();
                            var a = store.recordType;
                            var rec = new a( {
                                additionalJsCheck: ''
                            } );
                            grid.stopEditing();
                            store.add( rec );
                            store.commitChanges();
                        }
                    }, {
                        xtype: 'button',
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'delete' ),
                        tooltip: getTranslation( 'Usuń' ),
                        handler: function() {
                            var grid = this.ownerCt.ownerCt;
                            var selModel = grid.getSelectionModel();
                            var rows = selModel.getSelections();
                            if ( rows.length == 0 ) {
                                showWarn( getTranslation( 'Wybierz funkcję do usunięcia.' ) );
                                return;
                            }
                            removeRowAndMarkNext( grid, rows[0] );
                            grid.getView().refresh();
                        }
                    } ]
                } )
            } ]
        } );
    }
    items.push( {
        xtype: 'treepanel',
        title: getTranslation( 'Atrybuty dynamicznych list' ),
        ref: '../extraDataChooserConfigsTreePanel',
        layout: 'fit',
        useArrows: true,
        autoScroll: true,
        animate: config.animationsOn,
        containerScroll: true,
        bodyCssClass: 'x-Module-whiteBody',
        tbar: new Ext.Toolbar( {
            buttons: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj konfigurację' ),
                handler: function() {
                    var win = new Ext.ux.suncode.ExtraDataChooserConfigWindow( {
                        activityNode: activityNode,
                        treePanel: this.ownerCt.ownerCt
                    } );
                    win.show();
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj konfigurację' ),
                handler: function() {
                    var treePanel = this.ownerCt.ownerCt;
                    var selModel = treePanel.getSelectionModel();
                    var attrNode = selModel.getSelectedNode();

                    if ( attrNode ) {
                        var win = new Ext.ux.suncode.ExtraDataChooserConfigWindow( {
                            activityNode: activityNode,
                            treePanel: treePanel,
                            attrNode: attrNode
                        } );
                        win.show();
                    } else {
                        showWarn( getTranslation( 'Wybierz konfigurację do edycji.' ) );
                    }
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń konfigurację' ),
                handler: function() {
                    var treePanel = this.ownerCt.ownerCt;
                    var selModel = treePanel.getSelectionModel();
                    var attrNode = selModel.getSelectedNode();

                    if ( attrNode ) {
                        attrNode.remove();
                    } else {
                        showWarn( getTranslation( 'Wybierz konfigurację do usunięcia.' ) );
                    }
                }
            } ]
        } ),
        root: new Ext.tree.AsyncTreeNode( {
            text: getTranslation( 'Konfiguracje' ),
            icon: getPluginImgPath( 'contents' ),
            expanded: true,
            leaf: false,
            children: extraDataChooserTreeChildren
        } ),
        hasExtraConfig: function( dataChooserId ) {
            var hasExtraConfig = false;

            this.getRootNode().eachChild( function( child ) {
                if ( child.attributes.extraConfig.dataChooserId == dataChooserId ) {
                    hasExtraConfig = true;
                    return false;
                }
            } );

            return hasExtraConfig;
        },
        listeners: {
            scope: this,
            dblclick: function( node, e ) {
                if ( node.isLeaf() ) {
                    var win = new Ext.ux.suncode.ExtraDataChooserConfigWindow( {
                        activityNode: activityNode,
                        treePanel: this.extraDataChooserConfigsTreePanel,
                        attrNode: node
                    } );
                    win.show();
                }
            }
        }
    } );
    
    config = Ext.apply( {
        title: getTranslation( 'Dodatki' ),
        layout: 'fit',
        height: config.panelHeight,
        border: false,
        ref: '../additionalsPanel',
        items: [ {
            xtype: 'tabpanel',
            activeTab: 0,
            enableTabScroll: true,
            border: false,
            items: [ items ]
        } ]
    }, config );

    Ext.ux.suncode.ActivityAdditionalsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityAdditionalsPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityAdditionalsPanel.superclass.initComponent.call( this );
    },
    readDefaults: function() {
        var defaults = new Array();
        
        if ( !Ext.isEmpty( this.defaultsPanel ) ) {
        	var store = this.defaultsPanel.getStore();

            store.each( function( rec ) {
                var varId = rec.get( 'varId' );

                if ( !Ext.isEmpty( varId ) ) {
                    var varValue = rec.get( 'varValue' );

                    defaults.push( {
                        varId: varId,
                        varValue: varValue
                    } );
                }
            } );
        }

        return defaults;
    },
    readCheckAppendices: function() {
        var checkAppendices = new Array();
        
        if ( !Ext.isEmpty( this.checkAppendicesPanel ) ) {
        	var store = this.checkAppendicesPanel.getStore();

            store.each( function( rec ) {
                var docClassName = rec.get( 'docClassName' );

                if ( !Ext.isEmpty( docClassName ) ) {
                    checkAppendices.push( {
                        docClassName: docClassName
                    } );
                }
            } );
        }

        return checkAppendices;
    },
    readAdditionalJsChecks: function() {
        var additionalJsChecks = new Array();
        
        if ( !Ext.isEmpty( this.additionalJsChecksPanel ) ) {
        	var additionalJsChecksStore = this.additionalJsChecksPanel.getStore();

            additionalJsChecksStore.each( function( rec ) {
                var additionalJsCheck = rec.get( 'additionalJsCheck' );

                if ( !Ext.isEmpty( additionalJsCheck ) ) {
                    additionalJsChecks.push( {
                        additionalJsCheck: additionalJsCheck
                    } );
                }
            } );
        }

        return additionalJsChecks;
    },
    readExtraDataChooserConfigs: function() {
        var extraConfigs = new Array();
        var rootNode = this.extraDataChooserConfigsTreePanel.getRootNode();

        rootNode.eachChild( function( child ) {
            extraConfigs.push( child.attributes.extraConfig );
        } );

        return extraConfigs;
    }
} );

Ext.ux.suncode.ActivitySubflowParamsPanel = function( config ) {
    var activityNode = config.activityNode;

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'subflowParam',
                type: 'string'
            }, {
                name: 'actualParam',
                type: 'string'
            } ] )
        } )
    } );

    var subflowDefId = activityNode.attributes.subflow.id;
    if ( !Ext.isEmpty( subflowDefId ) ) {
        var subflowParams = new Array();
        var subflowNode = Ext.getCmp( 'package_panel' ).findProcess( subflowDefId );
        
        if ( !Ext.isEmpty( subflowNode ) ) {
        	var formalParameters = subflowNode.attributes.formalParameters;
            var subflowActualParams = activityNode.attributes.subflow.params;

            for ( var i = 0; i < formalParameters.length; i++ ) {
                var actualParam = subflowActualParams[i] ? subflowActualParams[i].actualParam : '';

                subflowParams.push( {
                    subflowParam: formalParameters[i].id,
                    actualParam: actualParam
                } );
            }

            store.loadData( subflowParams );
            store.commitChanges();
        }
    }

    var allVariablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: activityNode.parentNode.attributes.variables,
        formalParameters: activityNode.parentNode.attributes.formalParameters
    } );

    config = Ext.apply( {
        title: getTranslation( 'Parametry podprocesu' ),
        store: store,
        height: config.panelHeight,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        ref: 'subflowParamsPanel',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'subflowParam',
                header: getTranslation( 'Parametr podprocesu' ),
                dataIndex: 'subflowParam',
                align: 'left',
                editable: false
            }, {
                id: 'actualParam',
                header: getTranslation( 'Aktualny parametr' ),
                dataIndex: 'actualParam',
                align: 'left',
                editor: allVariablesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser )
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak parametrów podprocesu' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'match' ),
                tooltip: getTranslation( 'Dopasuj parametry' ),
                handler: this.matchParameters,
                scope: this
            } ]
        } ),
        listeners: {
            afteredit: function( e ) {
                e.record.commit();
            }
        }
    }, config );

    Ext.ux.suncode.ActivitySubflowParamsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivitySubflowParamsPanel, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivitySubflowParamsPanel.superclass.initComponent.call( this );
    },
    matchParameters: function() {
        var store = this.getStore();
        var storeCount = store.getCount();
        var editorStore = null;

        if ( storeCount > 0 ) {
            var cm = this.getColumnModel();
            var colIndex = cm.getIndexById( 'actualParam' );
            editorStore = cm.getCellEditor( colIndex, 0 ).field.getStore();
        }

        for ( var i = 0; i < storeCount; i++ ) {
            var rec = store.getAt( i );

            if ( Ext.isEmpty( rec.get( 'actualParam' ) ) ) {
                var subflowParam = rec.get( 'subflowParam' );

                if ( editorStore.findExact( 'id', subflowParam ) != -1 ) {
                    rec.set( 'actualParam', subflowParam );
                    rec.commit();
                }
            }
        }
    }
} );

Ext.ux.suncode.ActivityPropertiesTopToolbar = function( config ) {
    var mainPanel = Ext.getCmp( 'main_panel' );
    var activityNode = config.activityNode;
    var varRecord = config.varRecord;
    var items = new Array();

    var savePropertiesButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'save' ),
        tooltip: getTranslation( 'Zapisz' ),
        scope: this,
        handler: function() {
            var win = this.ownerCt;
            var newActivityName = win.nameItem.getValue();
            var oldActivityDefId = activityNode.attributes.activityDefId;
            var newActivityDefId = win.idItem.getValue();
            var processNode = activityNode.parentNode;
            var processDefId = processNode.attributes.processDefId;
            var assignmentType = win.assignmentTypeItem.getValue();
            var assignmentValue = '';
            var assignmentFilters = new Array();
            var assignmentException = '';

            if ( Ext.isEmpty( newActivityDefId ) || Ext.isEmpty( newActivityName ) ) {
                showWarn( getTranslation( 'Podaj nazwę zadania.' ) );
                return;
            } else if ( newActivityName.length > 255 ) {
                showWarn( getTranslation( 'Nazwa zadania nie może przekroczyć 255 znaków.' ) );
                return;
            } else if ( oldActivityDefId != newActivityDefId && !processNode.isIdUnique( newActivityDefId ) ) {
                showWarn( getTranslation( 'Wygenerowany identyfikator definicji zadania nie jest unikalny.' ) );
                return;
            }

            if ( activityNode.attributes.activityType == Ext.ux.suncode.Constants.SUBFLOW ) {
                var subflowId = win.subflowIdItem.getValue();

                if ( Ext.isEmpty( subflowId ) ) {
                    showWarn( getTranslation( 'Wybierz podproces.' ) );
                    return;
                }

                var subflowParams = new Array();
                var isOk = true;
                win.ActivityPropertiesTabPanel.subflowParamsPanel.getStore().each( function( rec ) {
                    var actualParam = rec.get( 'actualParam' );

                    if ( Ext.isEmpty( actualParam ) ) {
                        isOk = false;
                        return false;
                    }

                    subflowParams.push( {
                        actualParam: actualParam
                    } );
                } );

                if ( !isOk ) {
                    showWarn( getTranslation( 'Podaj wszystkie aktualne parametry.' ) );
                    return;
                }

                activityNode.updateSubflowInfo( {
                    id: subflowId,
                    params: subflowParams
                } );
            }

            if ( !Ext.isEmpty( assignmentType ) ) {
                assignmentValue = win.assignmentValueItem.items.first().getValue();

                if ( Ext.isEmpty( assignmentValue ) ) {
                    showWarn( getTranslation( 'Podaj wartość przypisania zadania.' ) );
                    return;
                }

                if ( !Ext.isEmpty( win.assignmentFiltersItem ) ) {
                    win.assignmentFiltersItem.getStore().each( function( rec ) {
                        var type = rec.get( 'type' );
                        var value = rec.get( 'value' );

                        if ( !Ext.isEmpty( type ) && !Ext.isEmpty( value ) ) {
                            assignmentFilters.push( {
                                type: type,
                                value: value
                            } );
                        }
                    } );
                }

                if ( !Ext.isEmpty( win.assignmentExceptionItem ) ) {
                    assignmentException = win.assignmentExceptionItem.items.first().getValue();

                    if ( assignmentValue == assignmentException ) {
                        showWarn( getTranslation( 'Wartość przypisania i wyjątek nie mogą być takie same.' ) );
                        return;
                    }
                }
            } else {
                showWarn( getTranslation( 'Podaj przypisanie zadania.' ) );
                return;
            }

            var nextActivity = win.nextActItem.getValue();
            var acceptedNextActivities = new Array();

            if ( nextActivity ) {
                win.acceptedNextActsItem.getStore().each( function( rec ) {
                    var nextActDefId = rec.get( 'activityDefId' );

                    if ( !Ext.isEmpty( nextActDefId ) ) {
                        acceptedNextActivities.push( {
                            activityDefId: nextActDefId
                        } );
                    }
                } );
            }

            activityNode.updateActivityDef( {
                activityDefId: newActivityDefId,
                activityName: newActivityName,
                activityDescr: win.descrItem.getValue(),
                nextActivity: nextActivity,
                acceptedNextActivities: acceptedNextActivities,
                acceptConcurrently: win.acceptConcurrentlyItem.getValue(),
                acceptSequentially: win.acceptSequentiallyItem ? win.acceptSequentiallyItem.getValue() : false,
                newDocumentAccept: win.newDocumentAcceptItem.getValue(),
                allowMultipleActiveActivities: win.allowMultipleActiveActivitiesItem.getValue(),
                assignment: {
                    type: assignmentType,
                    value: assignmentValue,
                    filters: assignmentFilters,
                    exception: assignmentException
                }
            } );

            activityNode.parentNode.updateAllNextActivities( oldActivityDefId, newActivityDefId );

            if ( win.additionalsPanel ) {
            	if ( win.additionalsPanel.rendered ) {
            		activityNode.setAdditional( 'defaults', win.additionalsPanel.readDefaults() );
            	}
            	if ( win.additionalsPanel.rendered ) {
            		activityNode.setAdditional( 'checkAppendices', win.additionalsPanel.readCheckAppendices() );
            	}
            	if ( win.additionalsPanel.rendered ) {
            		activityNode.setAdditional( 'additionalJsChecks', win.additionalsPanel.readAdditionalJsChecks() );
            	}
            	if ( win.additionalsPanel.rendered ) {
            		activityNode.setAdditional( 'extraDataChooserConfigs', win.additionalsPanel.readExtraDataChooserConfigs() );
            	}
            }

            Ext.ux.suncode.DocumentationService.onUpdateActivity( processNode, oldActivityDefId, newActivityDefId );
            
            var formPanel = Ext.getCmp( 'activity_properties_form_panel' );

            if ( !Ext.isEmpty( formPanel ) ) {
              formPanel.varsPanel.changes.editability.each( function( variableId, editable ) {
                activityNode.setFormVariableEditability( variableId, editable );
              }, this );
              formPanel.varsPanel.changes.visibility.each( function( variableId, hidden ) {
                activityNode.setFormVariableVisibility( variableId, hidden );
              }, this );
            }

            var paper = Ext.getCmp( 'paper_panel' ).getActiveTab().paper;
            paper.bpmn.updateActivity( paper, {
                processDefId: processDefId,
                oldActDefId: oldActivityDefId,
                newActDefId: newActivityDefId,
                actName: newActivityName
            } );
            
            if ( oldActivityDefId != newActivityDefId ) {
            	Ext.ux.suncode.I18NService.onActivityDefIdChange( processDefId, oldActivityDefId, newActivityDefId );
            	Ext.ux.suncode.I18NService.updatePackageTranslationsFromCaches( [ win.nameItem, win.descrItem ] );
            }

            if ( !Ext.isEmpty( varRecord ) ) {
              varRecord.set( 'activityName', newActivityName );
              varRecord.commit();
            }

            processNode.sortActivities();

            mainPanel.setSaved( false );
            this.ownerCt.close();
        }
    } );
    items.push( savePropertiesButton );

    if ( mainPanel.getDocumentationView() ) {
        var editSpecificationButton = new Ext.Button( {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'specification' ),
            tooltip: getTranslation( 'Specyfikacja' ),
            scope: this,
            handler: function() {
                this.ownerCt.close();
                editActivitySpecification( activityNode );
            }
        } );
        items.push( editSpecificationButton );
    }

    var closeWindowButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        scope: this,
        handler: function() {
            this.ownerCt.close();
        }
    } );
    items.push( closeWindowButton );

    config = Ext.apply( {
        items: items
    }, config );

    Ext.ux.suncode.ActivityPropertiesTopToolbar.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityPropertiesTopToolbar, Ext.Toolbar, {
    initComponent: function() {
        Ext.ux.suncode.ActivityPropertiesTopToolbar.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.CopyFormButton = function( config ) {
    config = Ext.apply( {
    	cls: 'x-btn-icon',
        icon: getPluginImgPath( 'copy' ),
        tooltip: getTranslation( 'Kopiuj formularz z innego zadania' ),
        handler: this.showCopyActivityFormWindow,
        scope: this
    }, config );

    Ext.ux.suncode.CopyFormButton.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.CopyFormButton, Ext.Button, {
    initComponent: function() {
        Ext.ux.suncode.CopyFormButton.superclass.initComponent.call( this );
    },
    showCopyActivityFormWindow: function() {
    	var win = new Ext.ux.suncode.CopyFromActivityWindow( {
            activityNode: this.initialConfig.activityNode,
            copyFunction: function( choosenActivityNode ) {
            	var activityPropertiesPanel = this.initialConfig.activityPropertiesPanel;
                var activityFormDesignerWindow = this.initialConfig.activityFormDesignerWindow;
                
                if ( !Ext.isEmpty( activityPropertiesPanel ) && Ext.isFunction( activityPropertiesPanel.copyForm ) ) {
                	activityPropertiesPanel.copyForm( choosenActivityNode );
                	Ext.getCmp('main_panel').setSaved(false);
                }
                
                if ( !Ext.isEmpty( activityFormDesignerWindow ) && Ext.isFunction( activityFormDesignerWindow.copyForm ) ) {
                	activityFormDesignerWindow.copyForm( choosenActivityNode );
                }
            },
            copyScope: this
        } );
        win.show();
    }
} );