Ext.ux.suncode.SimulationConfigWindow = function() {
    var config = new Object();
    var windowWidth = Ext.getBody().getViewSize().width * 0.4;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoScroll: true,
        title: getTranslation( 'Konfiguracja symulacji' ),
        items: new Ext.ux.suncode.SimulationConfigPanel(),
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                cancel: false,
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.SimulationConfigWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.SimulationConfigWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.SimulationConfigWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.simulationConfigPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.SimulationConfigPanel = function() {
    var config = new Object();
    var speedArray = [ [ 0.1, getTranslation( 'Bardzo niska' ) ], [ 0.2, getTranslation( 'Niska' ) ], [ 0.3, getTranslation( 'Średnia' ) ],
                    [ 0.4, getTranslation( 'Wysoka' ) ], [ 0.5, getTranslation( 'Bardzo wysoka' ) ] ];
    var timeArray = [ [ 2, getTranslation( '2 sekundy' ) ], [ 4, getTranslation( '4 sekundy' ) ], [ 6, getTranslation( '6 sekund' ) ],
                    [ 8, getTranslation( '8 sekund' ) ], [ 10, getTranslation( '10 sekund' ) ] ];

    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'simulationConfigPanel',
        items: [ {
            xtype: 'combo',
            name: 'speed',
            triggerAction: 'all',
            fieldLabel: getTranslation( 'Prędkość symulacji' ),
            anchor: '100%',
            mode: 'local',
            store: new Ext.data.ArrayStore( {
                fields: [ 'speed', 'speedName' ],
                data: speedArray
            } ),
            submitValue: true,
            hiddenName: 'speedValue',
            valueField: 'speed',
            displayField: 'speedName',
            forceSelection: true,
            editable: false,
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' )
        }, {
            xtype: 'checkbox',
            fieldLabel: getTranslation( 'Pokaż formularze' ),
            name: 'showForms',
            anchor: '100%',
            inputValue: 'true'
        }, {
            xtype: 'combo',
            name: 'formDisplayTime',
            triggerAction: 'all',
            fieldLabel: getTranslation( 'Czas wyświetlania formularza' ),
            anchor: '100%',
            mode: 'local',
            store: new Ext.data.ArrayStore( {
                fields: [ 'time', 'timeName' ],
                data: timeArray
            } ),
            submitValue: true,
            hiddenName: 'formDisplayTimeValue',
            valueField: 'time',
            displayField: 'timeName',
            forceSelection: true,
            editable: false,
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' )
        }, {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'distinctionColorContainer',
            fieldLabel: getTranslation( 'Kolor wyróżnienia' ),
            items: [ {
                xtype: 'textfield',
                inputType: 'text',
                anchor: '95%',
                color: '#ffffff',
                readOnly: true,
                flex: 1,
                style: 'background: #ffffff;'
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'color_wheel' ),
                tooltip: getTranslation( 'Wybierz kolor wyróżnienia' ),
                flex: 0,
                handler: this.chooseDistinctionColor,
                scope: this
            } ]
        }, {
            xtype: 'checkbox',
            fieldLabel: getTranslation( 'Pokaż całą mapę procesu' ),
            name: 'fitMap',
            anchor: '100%',
            inputValue: 'true'
        }, {
            xtype: 'checkbox',
            fieldLabel: getTranslation( 'Pokaż podsumowanie' ),
            name: 'showSummary',
            anchor: '100%',
            inputValue: 'true'
        }, {
            xtype: 'checkbox',
            fieldLabel: getTranslation( 'Animacje' ),
            name: 'animationsOn',
            anchor: '100%',
            inputValue: 'true'
        }, {
            xtype: 'fieldset',
            hidden: true,
            items: [ {
                xtype: 'textfield',
                name: 'distinctionColor',
                ref: '../distinctionColorItem'
            } ]
        } ]
    }, config );

    Ext.ux.suncode.SimulationConfigPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.SimulationConfigPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.SimulationConfigPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.loadSimulationConfig, this );
    },
    chooseDistinctionColor: function( button, e ) {
        closeColorChooser();

        var me = this;
        var distinctionColorField = this.distinctionColorContainer.items.first();
        var distinctionColorItem = this.distinctionColorItem;
        var colorChooser = new Ext.ux.suncode.ColorChooser( {
            title: getTranslation( 'Kolor wyróżnienia' ),
            e: e,
            color: distinctionColorField.color,
            saveFunction: function( choosenColor ) {
                distinctionColorField.getEl().setStyle( 'background', choosenColor );
                distinctionColorField.color = choosenColor;
                distinctionColorItem.setValue( choosenColor );
                me.storeParentWindowAsUnsaved();
            }
        } );
        colorChooser.show();
    },
    loadSimulationConfig: function() {
        this.getForm().load( {
            url: 'api/simulationconfig/get',
            method: 'GET',
            scope: this,
            success: function( form, action ) {
                var config = Ext.util.JSON.decode( action.response.responseText );
                var distinctionColor = config.data.distinctionColor;
                var distinctionColorField = this.distinctionColorContainer.items.first();
                distinctionColorField.getEl().setStyle( 'background', distinctionColor );
                distinctionColorField.color = distinctionColor;
            },
            failure: function( form, action ) {
            	showServerFailure( action.response );
            }
        } );
    },
    saveForm: function() {
        var form = this.getForm();

        if ( form.isValid() ) {
            form.submit( {
                url: 'api/simulationconfig/set',
                method: 'POST',
                scope: this,
                success: function( form, action ) {
                    if ( parseBoolean( action.response.responseText ) ) {
                        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();

                        if ( processPanel ) {
                            var distinctionColorItem = this.distinctionColorItem;
                            var paper = processPanel.paper;
                            paper.simul.setDistinctionColor( paper, distinctionColorItem.getValue() );
                        }

                        this.ownerCt.closeWindow();
                    } else {
                        showWarn( getTranslation( 'Wystąpił błąd.' ) );
                    }
                },
                failure: function( form, action ) {
                	showServerFailure( action.response );
                }
            } );
        }
    }
} );

function initProcessSimulation( config ) {
    var paperPanelToolbar = Ext.getCmp( 'paper_panel' ).getTopToolbar();
    paperPanelToolbar.disableAllButtons();

    Ext.Ajax.request( {
        url: 'api/simulationconfig/get',
        method: 'GET',
        success: function( response, opts ) {
            paperPanelToolbar.enableAllButtons();
            var simulInfo = Ext.getCmp( 'main_panel' ).getSimulationInfo();
            var simulationConfig = Ext.util.JSON.decode( response.responseText ).data;
            simulationConfig = Ext.apply( simulInfo, simulationConfig );
            simulationConfig = Ext.apply( config, simulationConfig );
            var paper = Ext.getCmp( 'paper_panel' ).getActiveTab().paper;

            if ( config.markCurrentActivity ) {
                simulationConfig = Ext.apply( {
                    fastFlow: true
                }, simulationConfig );
                paper.simul.markCurrentActivity( simulationConfig );
            } else {
                paper.simul.simulateProcess( simulationConfig );
            }
        },
        failure: function( response, opts ) {
            paperPanelToolbar.enableAllButtons();
            showWarn( getTranslation( 'Wystąpił błąd.' ) );
        }
    } );
}

Ext.ux.suncode.ActivityHistoryWindow = function( config ) {
    var size = Ext.getBody().getViewSize();

    config = Ext.apply( {
        autoWidth: true,
        autoHeight: true,
        modal: true,
        resizable: false,
        title: getTranslation( 'Podgląd formularza' ),
        closable: false,
        items: [ {
            xtype: 'component',
            autoEl: {
                tag: 'iframe',
                frameborder: 0,
                width: size.width * 0.8,
                height: size.height * 0.8,
                src: Suncode.context( 'pwe' ).contextPath + '/ShowDetailHistory.do?histActivityId=' + config.activityId + '&ProcessId='
                                + config.processId
            }
        } ]
    }, config );

    Ext.ux.suncode.ActivityHistoryWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityHistoryWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ActivityHistoryWindow.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ProcessSimulationResultsWindow = function( config ) {
    var size = Ext.getBody().getViewSize();
    var width = size.width * 0.95;
    var height = size.height * 0.85;

    config = Ext.apply( {
        width: width,
        autoHeight: true,
        modal: true,
        resizable: false,
        title: getTranslation( 'Wyniki symulacji' ),
        closable: true,
        layout: 'fit',
        items: [ {
            xtype: 'tabpanel',
            activeTab: 0,
            autoHeight: true,
            enableTabScroll: true,
            border: false,
            ref: 'summaryTabPanel',
            items: [ new Ext.ux.suncode.ParticipantsStatPanel( {
                height: height
            } ), new Ext.ux.suncode.TasksStatPanel( {
                height: height
            } ), new Ext.ux.suncode.ProcessHistoryPanel( {
                height: height,
                processHistory: config.processHistory
            } ) ]
        } ]
    }, config );

    Ext.ux.suncode.ProcessSimulationResultsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessSimulationResultsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ProcessSimulationResultsWindow.superclass.initComponent.call( this );

        this.on( 'beforeshow', lockHotkeys );
        this.on( 'beforeclose', unlockHotkeys );
    }
} );

Ext.ux.suncode.ParticipantsStatPanel = function( config ) {
    config = Ext.apply( {
        layout: 'fit',
        ref: 'participantsStatPanel',
        title: getTranslation( 'Statystyka uczestników' ),
        border: false
    }, config );

    Ext.ux.suncode.ParticipantsStatPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ParticipantsStatPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.ParticipantsStatPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var drawTask = new Ext.util.DelayedTask( this.drawStat, this );
        drawTask.delay( 10 );
    },
    drawStat: function() {
        Raphael.fn.simul.drawParticipantsStatPie( this );
    }
} );

Ext.ux.suncode.TasksStatPanel = function( config ) {
    config = Ext.apply( {
        layout: 'fit',
        ref: 'tasksStatPanel',
        title: getTranslation( 'Statystyka zadań' ),
        border: false
    }, config );

    Ext.ux.suncode.TasksStatPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TasksStatPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.TasksStatPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var drawTask = new Ext.util.DelayedTask( this.drawStat, this );
        drawTask.delay( 10 );
    },
    drawStat: function() {
        Raphael.fn.simul.drawTasksStatPie( this );
    }
} );

Ext.ux.suncode.ProcessHistoryPanel = function( config ) {
    var processHistory = config.processHistory;

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'activityName',
                type: 'string'
            }, {
                name: 'activityState',
                type: 'string'
            }, {
                name: 'activityPerformer',
                type: 'string'
            }, {
                name: 'activityCreated',
                type: 'string'
            }, {
                name: 'activityFinished',
                type: 'string'
            }, {
                name: 'processId',
                type: 'string'
            }, {
                name: 'activityId',
                type: 'string'
            } ] )
        } )
    } );

    if ( processHistory && processHistory.length > 0 ) {
        store.loadData( processHistory );
        store.commitChanges();
    }

    config = Ext.apply( {
        title: getTranslation( 'Historia procesu' ),
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: false,
                menuDisabled: false,
                css: 'vertical-align:middle;'
            },
            columns: [ {
                id: 'activityName',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'activityName',
                align: 'left'
            }, {
                id: 'activityState',
                header: getTranslation( 'Status' ),
                dataIndex: 'activityState',
                align: 'left'
            }, {
                id: 'activityPerformer',
                header: getTranslation( 'Wykonawca' ),
                dataIndex: 'activityPerformer',
                align: 'left'
            }, {
                id: 'activityCreated',
                header: getTranslation( 'Czas utworzenia' ),
                dataIndex: 'activityCreated',
                align: 'left'
            }, {
                id: 'activityFinished',
                header: getTranslation( 'Czas zakończenia' ),
                dataIndex: 'activityFinished',
                align: 'left'
            }, {
                id: 'activityDetails',
                header: getTranslation( 'Szczegóły' ),
                dataIndex: 'activityDetails',
                align: 'center',
                width: 50,
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                    return '<img src=\"' + getPluginImgPath( 'form' ) + '\">';
                }
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak wykonanych zadań' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true,
            listeners: {
                beforerowselect: function( sm, rowIndex, keepExisting, record ) {
                    return false;
                }
            }
        } ),
        tbar: new Ext.Toolbar( {
            items: [ {
                xtype: 'tbtext',
                text: '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość zadań' ) + ': ' + store.getCount() + '</b></font>'
            } ]
        } )
    }, config );

    Ext.ux.suncode.ProcessHistoryPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessHistoryPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProcessHistoryPanel.superclass.initComponent.call( this );

        this.on( 'cellclick', this.showActivityDetails, this );
    },
    showActivityDetails: function( grid, rowIndex, columnIndex, e ) {
        var store = grid.getStore();
        var colId = grid.getColumnModel().getColumnId( columnIndex );

        if ( colId == 'activityDetails' ) {
            var rec = store.getAt( rowIndex );
            var processId = rec.get( 'processId' );
            var activityId = rec.get( 'activityId' );

            showActivityDetails( processId, activityId );
        }
    }
} );