Ext.ux.suncode.ProcessMapImageService = {
    generateImage: function( processPanel ) {
        var me = this;
        var paper = processPanel.paper;
        paper.bpmn.eraseAllTrashes( paper );
        var svg = paper.canvas;
        var canvasEl = Ext.DomHelper.append( document.body, {
            tag: 'canvas',
            width: svg.width.baseVal.value,
            height: svg.height.baseVal.value,
            style: {
                display: 'none'
            }
        }, true );
        var canvas = Ext.getDom( canvasEl );

        canvg( canvas, this.getSvgHtml( svg ), {
            renderCallback: function() {
                var processMapImage = canvas.toDataURL( 'image/png' );
                canvasEl.remove();
                me.finalizeGenerateImage( processPanel.processDefId, processMapImage );
            }
        } );
    },
    getSvgHtml: function( svg ) {
    	if ( !Ext.isEmpty( svg.outerHTML ) ) {
    		return svg.outerHTML;
    	} else {
    		var wrapper = document.createElement( 'div' );
    	    wrapper.appendChild( svg.cloneNode( true ) );
    	    
    	    return wrapper.innerHTML;
    	}
    },
    finalizeGenerateImage: function( processDefId, processMapImage ) {
    	  var mainPanel = Ext.getCmp( 'main_panel' );
        var processNode = Ext.getCmp( 'package_panel' ).findProcess( processDefId );
        var processDefId = processNode.attributes.processDefId;
        var processName = processNode.attributes.processName;
        var fileName = getXpdlProcessNameTranslation( processDefId, processName );
        
        var form = jQuery( '<form/>', { action: 'api/processmapimage/generate', method:'post' } );
        form.append( jQuery( '<input>', { type: 'text', name: 'fileName', value: fileName } ) );
        form.append( jQuery( '<input>', { type: 'text', name: 'processMapImage', value: processMapImage } ) );
        
        var iframe = jQuery( '#download-frame' );
        iframe.empty();
        iframe.append( form );
        
        mainPanel.setCheckSavedOnUnload( false );
        
        form.submit();
        
        var task = new Ext.util.DelayedTask( function() {
            mainPanel.setCheckSavedOnUnload( true );
        }, this );
        task.delay( 1000 );
    }
};