Ext.ux.suncode.IntegrationComponentService = {
  FORM_DESTINATION: 'FORM',
  VARIABLE_DESTINATION: 'VARIABLE',
  VARIABLE_SET_DESTINATION: 'VARIABLESET',
  BUTTON_DESTINATION: 'BUTTON',
  DT_BUTTON_DESTINATION: 'DT_BUTTON',
  LABEL_DESTINATION: 'LABEL',
  FUNCTION_TYPE: 'function',
  VARIABLE_TYPE: 'variable',
  STRING_TYPE: 'string',
  BOOLEAN_TYPE: 'boolean',
  VARIABLE_TYPES_MATRIX: {
    'STRING': 'string',
    'TEXTAREA': 'string',
    'DATETIME': 'datetime',
    'DATE': 'date',
    'INTEGER': 'integer',
    'FLOAT': 'float',
    'BOOLEAN': 'boolean',
    'AMOUNT': 'float',
    'RADIOBUTTON': 'string',
    'CHECKBOX': 'string',
    'LISTBOX': 'string',
    'LISTBOX_EDIT': 'string',
    'LISTBOX_NO_FILTER': 'string',
    'LISTBOX_EDIT_NO_FILTER': 'string',
    'LISTBOX_NO_LAZY': 'string',
    'LISTBOX_NO_FILTER_NO_LAZY': 'string',
    'USERLIST': 'string',
    'USERLISTLISTBOX': 'string',
    'ROLEUSERS': 'string',
    'ROLEUSERS_NO_FILTER': 'string',
    'DATA_CHOOSER': 'string'
  },
  PARAMETER_TYPES_TRANSLATION: new Object(),
  DESTINATION_TYPES_TRANSLATION: new Object(),
  ALL_ACCESSIBILITY: 'ALL',
  SERVER_ACCESSIBILITY: 'SERVER',
  BROWSER_ACCESSIBILITY: 'BROWSER',
  COMPONENT_TYPES: {
    DATA_CHOOSER: 'DATA_CHOOSER',
    FORM_ACTION: 'FORM_ACTION',
    VALIDATOR: 'VALIDATOR',
    VARIABLES_SETTER: 'VARIABLES_SETTER',
    APPLICATION: 'APPLICATION',
    EVENT_ACTION: 'EVENT_ACTION',
  },
  CONTEXT_VARIABLE_ID_PREFIX: 'context:',
  registry: {
    formActions: new HashMap(),
    validators: new HashMap(),
    variablesSetters: new HashMap(),
    applications: new HashMap(),
    dataChoosers: new HashMap(),
    eventActions: new HashMap(),
    systemFunctions: new HashMap()
  },
  pluginInfos: new HashMap(),
  initTranslations: function() {
    Ext.apply( this.PARAMETER_TYPES_TRANSLATION, {
      'string': getTranslation( 'Tekstowy' ),
      'string[]': getTranslation( 'Tablica tekstów' ),
      'integer': getTranslation( 'Całkowity' ),
      'integer[]': getTranslation( 'Tablica całkowitych' ),
      'float': getTranslation( 'Zmiennoprzecinkowy' ),
      'float[]': getTranslation( 'Tablica zmiennoprzecinkowych' ),
      'date': getTranslation( 'Datowy' ),
      'date[]': getTranslation( 'Tablica datowych' ),
      'datetime': getTranslation( 'Data i czas' ),
      'datetime[]': getTranslation( 'Tablica dat i czasów' ),
      'boolean': getTranslation( 'Logiczny' ),
      'boolean[]': getTranslation( 'Tablica logicznych' ),
      'variable': getTranslation( 'Zmienna' ),
      'variable[]': getTranslation( 'Tablica zmiennych' ),
      'function': getTranslation( 'Funkcja' ),
      'function[]': getTranslation( 'Tablica funkcji' )
    } );

    Ext.apply( this.DESTINATION_TYPES_TRANSLATION, {
      'FORM': getTranslation( 'Formularz' ),
      'VARIABLE': getTranslation( 'Zmienna formularza' ),
      'VARIABLESET': getTranslation( 'Tabela dynamiczna' ),
      'BUTTON': getTranslation( 'Przycisk formularza' ),
      'DT_BUTTON': getTranslation( 'Przycisk tabeli dynamicznej' ),
      'LABEL': getTranslation( 'Etykieta' )
    } );
  },
  buildImage: function( component ) {
    if ( !Ext.isEmpty( component.icon ) ) {
      var icon = component.icon;

      switch ( icon.type ) {
        case 'BASE64':
          return '<img src="' + icon.icon + '"/>';
        case 'CSS':
          return '<div class="' + icon.icon + '"> </div>';
        default:
          return '';
      }
    } else {
      return '';
    }
  },
  getDestination: function( component, expected ) {
    expected = Ext.isArray( expected ) ? expected : [ expected ];
    var dest = null;

    Ext.each( component.destinations, function( destination, index, destinations ) {
      var type = destination.type;

      Ext.each( expected, function( expectedType, innerIndex, expectedTypes ) {
        if ( type === expectedType ) {
          dest = destination;
          return false;
        }
      } );

      if ( !Ext.isEmpty( dest ) ) {
        return false;
      }
    } );

    return dest;
  },
  translateDestinationType: function( type ) {
    return this.DESTINATION_TYPES_TRANSLATION[type];
  },
  getDestinationTypesWithTranslations: function() {
    var data = new Array();

    Ext.iterate( this.DESTINATION_TYPES_TRANSLATION, function( type, translation, allTypes ) {
      data.push( {
        value: type,
        text: translation
      } );
    } );

    return data;
  },
  hasDestination: function( component, expected, isAcceptButton ) {
    var destination = this.getDestination( component, expected );

    return !Ext.isEmpty( destination ) && ( !isAcceptButton || isAcceptButton && destination.acceptButtonAllowed !== false );
  },
  filterCategoriesByDestination: function( categories, expected, isAcceptButton ) {
    var filteredCategories = new Object();

    if ( !Ext.isEmpty( categories ) ) {
      Ext.iterate( categories, function( category, components, allCategories ) {
        var filteredComponents = new Array();

        Ext.each( components, function( component, index, allComponents ) {
          if ( this.hasDestination( component, expected, isAcceptButton ) ) {
            filteredComponents.push( component );
          }
        }, this );

        if ( !Ext.isEmpty( filteredComponents ) ) {
          filteredCategories[category] = filteredComponents;
        }
      }, this );
    }

    return filteredCategories;
  },
  filterCategoriesByDeprecated: function( categories ) {
    var filteredCategories = new Object();

    if ( !Ext.isEmpty( categories ) ) {
      var showDeprecated = Ext.getCmp( 'main_panel' ).getShowDeprecatedIntegrationComponents();

      Ext.iterate( categories, function( category, components, allCategories ) {
        var filteredComponents = new Array();

        Ext.each( components, function( component, index, allComponents ) {
          if ( showDeprecated || !component.deprecated ) {
            filteredComponents.push( component );
          }
        } );

        if ( !Ext.isEmpty( filteredComponents ) ) {
          filteredCategories[category] = filteredComponents;
        }
      } );
    }

    return filteredCategories;
  },
  startDrawingApplication: function( component ) {
    var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
    processPanel.addToStorage( 'applicationIntegrationComponent', component );
    processPanel.addToStorage( 'addApplicationFromIntegrationComponent', true );
    processPanel.objToDrawType = 'applicationIntegrationComponent';
    processPanel.onMouseMove();
  },
  addApplicationFromIntegrationComponent: function( processNode, activityNode, component, condition, parameters, extraConfig ) {
    var processApplication = processNode.findApplication( component.id );

    if ( Ext.isEmpty( processApplication ) ) {
      this.addApplicationToProcess( processNode, component );
    }

    this.addApplicationToActivity( activityNode, component, condition, parameters, extraConfig );
  },
  addApplicationToProcess: function( processNode, component ) {
    var app = new Object();
    app = Ext.apply( {
      id: component.id,
      name: component.name,
      appType: component.toolAgent,
      realization: {
        agent: component.id,
        mode: ''
      },
      parameters: [],
      descr: component.description,
      integrationComponent: true
    }, app );

    processNode.addApplication( app );
  },
  addApplicationToActivity: function( activityNode, component, condition, parameters, extraConfig ) {
    var app = new Object();
    app = Ext.apply( {
      id: component.id,
      name: component.name,
      appType: component.toolAgent,
      customDescription: extraConfig.customDescription,
      errorHandling: extraConfig.errorHandling,
      condition: condition,
      inactive: extraConfig.inactive,
      parameters: parameters,
      integrationComponent: true
    }, app );

    activityNode.addApplication( app );
  },
  getIntegrationComponent: function( categories, id ) {
    var component = null;

    if ( !Ext.isEmpty( categories ) ) {
      Ext.iterate( categories, function( category, components, allCategories ) {
        for ( var i = 0; i < components.length; i++ ) {
          if ( components[i].id == id ) {
            component = components[i];
            return false;
          }
        }
      } );
    }

    return component;
  },
  changeByVariableId: function( components, oldVarId, newVarId ) {
    for ( var i = 0; i < components.length; i++ ) {
      var component = components[i];

      this.changeComponentByVariableId( component, oldVarId, newVarId );
    }
  },
  changeComponentByVariableId: function( component, oldVarId, newVarId ) {
    var parameters = component.parameters;
    var condition = component.condition;
    var errorHandling = component.errorHandling;

    Ext.iterate( parameters, function( id, value, object ) {
      if ( Ext.isArray( value ) ) {
        Ext.each( value, function( oneValue, index, values ) {
          this.changeParameterValueByVariableId( oneValue, oldVarId, newVarId );
        }, this );
      } else {
        this.changeParameterValueByVariableId( value, oldVarId, newVarId );
      }
    }, this );

    this.changeParameterValueByVariableId( condition, oldVarId, newVarId );

    if ( !Ext.isEmpty( errorHandling ) ) {
      this.changeParameterValueByVariableId( errorHandling.comment, oldVarId, newVarId );
      this.changeParameterValueByVariableId( errorHandling.addErrorToComment, oldVarId, newVarId );
      this.changeParameterValueByVariableId( errorHandling.userMessage, oldVarId, newVarId );

      if ( !Ext.isEmpty( errorHandling.setters ) ) {
        this.changeParameterValueByVariableId( errorHandling.setters.variables, oldVarId, newVarId );
        this.changeParameterValueByVariableId( errorHandling.setters.values, oldVarId, newVarId );
      }
    }
  },
  changeParameterValueByVariableId: function( value, oldVarId, newVarId ) {
    if ( !Ext.isEmpty( value ) ) {
      if ( value.type == this.VARIABLE_TYPE && value.value == oldVarId ) {
        value.value = newVarId;
      } else if ( value.type == this.FUNCTION_TYPE && !Ext.isEmpty( value.value ) ) {
        var functionParameters = value.value.parameters;

        if ( !Ext.isEmpty( functionParameters ) ) {
          for ( var i = 0; i < functionParameters.length; i++ ) {
            var functionParameter = functionParameters[i];

            if ( Ext.isArray( functionParameter ) ) {
              for ( var j = 0; j < functionParameter.length; j++ ) {
                this.changeParameterValueByVariableId( functionParameter[j], oldVarId, newVarId );
              }
            } else {
              this.changeParameterValueByVariableId( functionParameter, oldVarId, newVarId );
            }
          }
        }
      }
    }
  },
  mergeTemplates: function( processTemplate, activityTemplate ) {
    var mergedTemplate = {
      id: processTemplate.id
    };
    var mergedComponents = new Array();
    var processComponents = processTemplate.components;
    var activityComponents = activityTemplate.components;

    Ext.each( processComponents, function( processComponent, outerIndex, allProcessComponents ) {
      var current = null;

      Ext.each( activityComponents, function( activityComponent, innerIndex, allActivityComponents ) {
        if ( processComponent.templateComponentId == activityComponent.templateComponentId ) {
          current = activityComponent;
          return false;
        }
      } );

      var mergedComponent = {
        id: processComponent.id,
        templateComponentId: processComponent.templateComponentId,
        customDescription: processComponent.customDescription,
        condition: deepObjectCopy( processComponent.condition ),
        confirmation: deepObjectCopy( processComponent.confirmation ),
        error: deepObjectCopy( processComponent.error ),
        parameters: deepObjectCopy( processComponent.parameters )
      };

      if ( !Ext.isEmpty( current ) ) {
        var activityComponentCustomDescription = current.customDescription;
        var activityComponentCondition = current.condition;
        var activityComponentParameters = current.parameters;
        var activityComponentConfirmation = current.confirmation;
        var activityComponentError = current.error;

        if ( !Ext.isEmpty( activityComponentCustomDescription ) ) {
          mergedComponent = Ext.apply( mergedComponent, {
            customDescription: activityComponentCustomDescription
          } );
        }

        if ( !Ext.isEmpty( activityComponentCondition ) ) {
          mergedComponent = Ext.apply( mergedComponent, {
            condition: activityComponentCondition
          } );
        }

        if ( !Ext.isEmpty( activityComponentConfirmation ) ) {
          if ( !Ext.isEmpty( activityComponentConfirmation.title ) ) {
            mergedComponent.confirmation = Ext.apply( mergedComponent.confirmation, {
              title: activityComponentConfirmation.title
            } );
          }

          if ( !Ext.isEmpty( activityComponentConfirmation.message ) ) {
            mergedComponent.confirmation = Ext.apply( mergedComponent.confirmation, {
              message: activityComponentConfirmation.message
            } );
          }
        }

        if ( !Ext.isEmpty( activityComponentError ) && !Ext.isEmpty( activityComponentError.message ) ) {
          mergedComponent.error = Ext.apply( mergedComponent.error, {
            message: activityComponentError.message
          } );
        }

        Ext.iterate( mergedComponent.parameters, function( id, param, object ) {
          if ( Ext.isDefined( activityComponentParameters[id] ) ) {
            mergedComponent.parameters[id] = deepObjectCopy( activityComponentParameters[id] );
          }
        } );
      }

      mergedComponents.push( mergedComponent );
    }, this );

    mergedTemplate = Ext.apply( mergedTemplate, {
      components: mergedComponents
    } );

    return mergedTemplate;
  },
  areParametersTheSame: function( first, second ) {
    if ( first === null || second === null ) {
      return first === second;
    }

    if ( Ext.isArray( first ) ) {
      if ( Ext.isArray( second ) && first.length == second.length ) {
        for ( var i = 0; i < first.length; i++ ) {
          var firstParameter = first[i];
          var secondParameter = second[i];

          if ( !this.areParametersTheSame( firstParameter, secondParameter ) ) {
            return false;
          }
        }

        return true;
      }

      return false;
    }

    if ( first.type != second.type ) {
      return false;
    }

    if ( first.type == this.FUNCTION_TYPE && !Ext.isEmpty( first.value ) && !Ext.isEmpty( second.value ) ) {
      if ( first.value.name != second.value.name ) {
        return false;
      }

      var firstParameters = first.value.parameters;
      var firstParameterTypes = first.value.parameterTypes;
      var secondParameters = second.value.parameters;
      var secondParameterTypes = second.value.parameterTypes;

      if ( firstParameters.length != secondParameters.length ) {
        return false;
      }

      for ( var i = 0; i < firstParameters.length; i++ ) {
        var firstParameter = firstParameters[i];
        var firstParameterType = firstParameterTypes[i];
        var secondParameter = secondParameters[i];
        var secondParameterType = secondParameterTypes[i];
        var result = this.areParameterTypesTheSame( firstParameterType, secondParameterType ) &&
            this.areParametersTheSame( firstParameter, secondParameter );

        if ( !result ) {
          return false;
        }
      }

      return true;
    }

    return first.value === second.value;
  },
  areParameterTypesTheSame: function( first, second ) {
    if ( first === null || second === null ) {
      return first === second;
    }

    if ( first.type != second.type ) {
      return false;
    }

    return first.array === second.array;
  },
  registerComponent: function( registry, id, registration ) {
    registry.put( id, registration );
  },
  getComponentRegistration: function( registry, id ) {
    return registry.get( id );
  },
  registerFormAction: function( id, registration ) {
    this.registerComponent( this.registry.formActions, id, registration );
  },
  getFormActionRegistration: function( id ) {
    return this.getComponentRegistration( this.registry.formActions, id );
  },
  registerValidator: function( id, registration ) {
    this.registerComponent( this.registry.validators, id, registration );
  },
  getValidatorRegistration: function( id ) {
    return this.getComponentRegistration( this.registry.validators, id );
  },
  registerVariablesSetter: function( id, registration ) {
    this.registerComponent( this.registry.variablesSetters, id, registration );
  },
  getVariablesSetterRegistration: function( id ) {
    return this.getComponentRegistration( this.registry.variablesSetters, id );
  },
  registerApplication: function( id, registration ) {
    this.registerComponent( this.registry.applications, id, registration );
  },
  getApplicationRegistration: function( id ) {
    return this.getComponentRegistration( this.registry.applications, id );
  },
  registerDataChooser: function( id, registration ) {
    this.registerComponent( this.registry.dataChoosers, id, registration );
  },
  getDataChooserRegistration: function( id ) {
    return this.getComponentRegistration( this.registry.dataChoosers, id );
  },
  registerEventAction: function( id, registration ) {
    this.registerComponent( this.registry.eventActions, id, registration );
  },
  getEventActionRegistration: function( id ) {
    return this.getComponentRegistration( this.registry.eventActions, id );
  },
  registerSystemFunction: function( name, parameters, registration, returnType ) {
    var key = this.buildSystemFunctionRegistryKey( name, parameters, returnType );

    this.registry.systemFunctions.put( key, registration );
  },
  getSystemFunctionRegistration: function( name, parameterTypes, parameterDefinitions, returnType ) {
    var parameters = this.buildSystemFunctionParameters( parameterTypes, parameterDefinitions );
    var key = this.buildSystemFunctionRegistryKey( name, parameters, returnType );
    var registration = this.registry.systemFunctions.get( key );

    if ( Ext.isEmpty( registration ) ) {
      key = this.buildSystemFunctionRegistryKey( name, parameters, null );
      registration = this.registry.systemFunctions.get( key );

      if ( Ext.isEmpty( registration ) ) {
        return this.registry.systemFunctions.get( name );
      } else {
        return registration;
      }
    } else {
      return registration;
    }
  },
  buildSystemFunctionRegistryKey: function( name, parameters, returnType ) {
    var key = name;

    if ( Ext.isArray( parameters ) ) {
      var params = new Array();

      Ext.each( parameters, function( parameter, index, allParameters ) {
        var param = parameter.type;

        if ( parameter.array ) {
          param += '[]';
        }

        param += ' ';
        param += parameter.id;

        params.push( param );
      } );

      key += '(';
      key += params.join( ',' );
      key += ')';
    }

    if ( !Ext.isEmpty( returnType ) ) {
      key += 'return ';
      key += returnType;
    }

    return key;
  },
  buildSystemFunctionParameters: function( parameterTypes, parameterDefinitions ) {
    var parameters = new Array();

    if ( Ext.isArray( parameterTypes ) && Ext.isArray( parameterDefinitions ) ) {
      Ext.each( parameterTypes, function( parameterType, index, allParameterTypes ) {
        var definition = parameterDefinitions[index];

        parameters.push( {
          type: parameterType.type,
          id: !Ext.isEmpty( definition ) ? definition.id : '',
          array: parameterType.array
        } );
      } );
    }

    return parameters;
  },
  storePluginInfo: function( id, pluginInfo ) {
    this.pluginInfos.put( id, pluginInfo );
  },
  getAllPluginNames: function() {
    var names = new Array();

    this.pluginInfos.each( function( id, pluginInfo ) {
      names.push( pluginInfo.name );
    } );

    return names;
  },
  getMissingIntegrationComponents: function() {
    var missingComponents = new Array();
    this.crawlIntegrationComponents( false, Ext.emptyFn, function( information ) {
      missingComponents.push( {
        processName: information.processName,
        activityName: information.activityName,
        object: information.object,
        componentId: information.componentId
      } );
    } );

    return missingComponents;
  },
  getIntegrationComponentsUtilization: function() {
    var componentsUtilization = new HashMap();
    this.crawlIntegrationComponents( false, function( information ) {
      var componentId = information.componentId;
      var array = componentsUtilization.get( componentId );
      if ( Ext.isEmpty( array ) ) {
        array = new Array();
      }
      array.push( {
        processName: information.processName,
        activityName: information.activityName,
        object: information.object,
        componentId: information.componentId
      } );
      componentsUtilization.put( componentId, array );
    }, Ext.emptyFn );

    return componentsUtilization;
  },
  getComponentsUsingVariable: function( processNode, varId ) {
    var components = new Array();
    var categoriesMaps = this.getCategoriesMaps();
    var me = this;
    var func = function( information ) {
      var component = information.component;

      if ( me.doesComponentUseVariable( component, varId ) ) {
        components.push( {
          processDefId: information.processDefId,
          activityDefId: information.activityDefId,
          activityName: information.activityName,
          objectName: information.object,
          customDescription: component.customDescription,
          component: component,
          objectOwner: information.objectOwner,
          objectName: information.objectName,
          objectType: information.componentType,
          objectContainer: information.componentContainer
        } );
      }
    };
    this.crawlIntegrationComponentsInProcess( processNode, categoriesMaps, true, func, func );

    return components;
  },
  doesComponentUseVariable: function( component, varId ) {
    var uses = false;
    var parameters = component.parameters;
    var condition = component.condition;
    var confirmation = component.confirmation;
    var error = component.error;
    var errorHandling = component.errorHandling;

    Ext.iterate( parameters, function( id, value, object ) {
      if ( Ext.isArray( value ) ) {
        Ext.each( value, function( oneValue, index, values ) {
          if ( this.doesParameterValueUseVariable( oneValue, varId ) ) {
            uses = true;
            return false;
          }
        }, this );
      } else {
        if ( this.doesParameterValueUseVariable( value, varId ) ) {
          uses = true;
          return false;
        }
      }
    }, this );

    if ( this.doesParameterValueUseVariable( condition, varId ) ) {
      uses = true;
    }

    if ( !Ext.isEmpty( confirmation ) ) {
      if ( this.doesParameterValueUseVariable( confirmation.title, varId ) ) {
        uses = true;
      }
      if ( this.doesParameterValueUseVariable( confirmation.message, varId ) ) {
        uses = true;
      }
    }

    if ( !Ext.isEmpty( error ) ) {
      if ( this.doesParameterValueUseVariable( error.message, varId ) ) {
        uses = true;
      }
    }

    if ( !Ext.isEmpty( errorHandling ) ) {
      switch ( errorHandling.type ) {
        case 'STOP':
          if ( this.doesParameterValueUseVariable( errorHandling.comment, varId ) ) {
            uses = true;
          }
          if ( this.doesParameterValueUseVariable( errorHandling.addErrorToComment, varId ) ) {
            uses = true;
          }
          if ( this.doesParameterValueUseVariable( errorHandling.userMessage, varId ) ) {
            uses = true;
          }
          break;
        case 'CONTINUE':
          if ( this.doesParameterValueUseVariable( errorHandling.comment, varId ) ) {
            uses = true;
          }
          if ( this.doesParameterValueUseVariable( errorHandling.addErrorToComment, varId ) ) {
            uses = true;
          }
          if ( this.doesParameterValueUseVariable( errorHandling.setters.variables, varId ) ) {
            uses = true;
          }
          if ( this.doesParameterValueUseVariable( errorHandling.setters.values, varId ) ) {
            uses = true;
          }
          break;
        default:
          break;
      }
    }

    return uses;
  },
  doesParameterValueUseVariable: function( value, varId ) {
    var uses = false;

    if ( !Ext.isEmpty( value ) ) {
      if ( Ext.isArray( value ) ) {
        Ext.each( value, function( oneValue, index, values ) {
          if ( this.doesParameterValueUseVariable( oneValue, varId ) ) {
            uses = true;
            return false;
          }
        }, this );
      } else if ( value.type == this.VARIABLE_TYPE && value.value == varId ) {
        uses = true;
      } else if ( value.type == this.FUNCTION_TYPE && !Ext.isEmpty( value.value ) ) {
        var functionParameters = value.value.parameters;

        if ( !Ext.isEmpty( functionParameters ) ) {
          Ext.each( functionParameters, function( functionParameter, index, allFunctionParameter ) {
            if ( this.doesParameterValueUseVariable( functionParameter, varId ) ) {
              uses = true;
              return false;
            }
          }, this );
        }
      }
    }

    return uses;
  },
  showComponentsUsingVariableWarning: function( warning, utilizationWindowConfig ) {
    Ext.Msg.show( {
      title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
      msg: warning,
      buttons: {
        yes: getTranslation( 'Pokaż wykorzystanie' ),
        cancel: getTranslation( 'Anuluj' )
      },
      fn: function( buttonId ) {
        switch ( buttonId ) {
          case 'yes':
            var win = new Ext.ux.suncode.VariableUtilizationWindow( utilizationWindowConfig );
            win.show();
            break;
          default:
            break;
        }
      },
      icon: Ext.Msg.QUESTION,
      scope: this
    } );
  },
  crawlIntegrationComponents: function( allowDuplications, ifFunction, elseFunction ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var packageNode = packagePanel.getRootNode();

    if ( packageNode.hasChildNodes() ) {
      var categoriesMaps = this.getCategoriesMaps();

      packageNode.eachChild( function( processNode ) {
        this.crawlIntegrationComponentsInProcess( processNode, categoriesMaps, allowDuplications, ifFunction, elseFunction );
      }, this );
    }
  },
  crawlIntegrationComponentsInProcess: function( processNode, categoriesMaps, allowDuplications, ifFunction, elseFunction ) {
    var processDefId = processNode.attributes.processDefId;
    var processName = processNode.attributes.processName;
    var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );
    var validatorsMap = categoriesMaps.validatorsMap;
    var variablesSettersMap = categoriesMaps.variablesSettersMap;
    var dataChoosersMap = categoriesMaps.dataChoosersMap;
    var formActionsMap = categoriesMaps.formActionsMap;
    var eventActionsMap = categoriesMaps.eventActionsMap;

    if ( !Ext.isEmpty( processNode.attributes.variables ) ) {
      Ext.each( processNode.attributes.variables, function( variable, index, variables ) {
        if ( !Ext.isEmpty( variable.formActions ) ) {
          this.crawlIntegrationComponentsInObject( processNode, null, allowDuplications,
              formActionsMap, ifFunction, elseFunction, variable.formActions,
              getTranslation( 'Akcja formularza na zmiennej procesu' ) + ': ' + variable.name,
              null, getTranslation( 'Zmienna procesu' ) + ' (' + variable.name + ')',
              getTranslation( 'Akcja formularza' ) );
        }

        if ( !Ext.isEmpty( variable.eventActions ) ) {
          this.crawlIntegrationComponentsInObject( processNode, null, allowDuplications,
              eventActionsMap, ifFunction, elseFunction, variable.eventActions,
              getTranslation( 'Zdarzenie na zmiennej procesu' ) + ': ' + variable.name,
              null, getTranslation( 'Zmienna procesu ' ) + ' (' + variable.name + ')',
              getTranslation( 'Zdarzenie' ) );
        }

        if ( variable.type == 'DATA_CHOOSER' && !Ext.isEmpty( variable.definition.id ) ) {
          var information = {
            processDefId: processDefId,
            processName: processNameTranslation,
            object: getTranslation( 'Dynamiczna lista w zmiennej procesu' ) + ': ' + variable.name,
            objectOwner: getTranslation( 'Zmienna' ) + ' (' + variable.name + ')',
            objectName: getTranslation( 'Dynamiczna lista' ),
            component: variable.definition,
            componentId: variable.definition.id,
            componentType: this.COMPONENT_TYPES.DATA_CHOOSER,
            componentContainer: variable
          };

          if ( dataChoosersMap.get( variable.definition.id ) ) {
            ifFunction.apply( this, [ information ] );
          } else {
            elseFunction.apply( this, [ information ] );
          }
        }
      }, this );
    }

    if ( !Ext.isEmpty( processNode.attributes.tables ) ) {
      Ext.each( processNode.attributes.tables, function( table, index, tables ) {
        if ( !Ext.isEmpty( table.formActions ) ) {
          this.crawlIntegrationComponentsInObject( processNode, null, allowDuplications,
              formActionsMap, ifFunction, elseFunction, table.formActions,
              getTranslation( 'Akcja formularza na tabeli globalnej' ) + ': ' + table.name,
              null, getTranslation( 'Tabela globalna' ) + ' (' + table.name + ')',
              getTranslation( 'Akcja formularza' ) );
        }

        if ( !Ext.isEmpty( table.eventActions ) ) {
          this.crawlIntegrationComponentsInObject( processNode, null, allowDuplications,
              eventActionsMap, ifFunction, elseFunction, table.eventActions,
              getTranslation( 'Zdarzenie na tabeli globalnej' ) + ': ' + table.name,
              null, getTranslation( 'Tabela globalna' ) + ' (' + table.name + ')',
              getTranslation( 'Zdarzenie' ) );
        }
      }, this );
    }

    if ( !Ext.isEmpty( processNode.attributes.templates.validators ) ) {
      Ext.each( processNode.attributes.templates.validators, function( template, index, templates ) {
        var usedValidators = new Array();

        if ( !Ext.isEmpty( template.components ) ) {
          Ext.each( template.components, function( validator, index, validators ) {
            if ( allowDuplications || usedValidators.indexOf( validator.id ) == -1 ) {
              var information = {
                processDefId: processDefId,
                processName: processNameTranslation,
                object: getTranslation( 'Szablon mechanizmów sprawdzających formularz' ) + ': '
                    + template.name,
                objectName: getTranslation( 'Szablon mechanizmów sprawdzających formularz' ) + ': '
                    + ' (' + template.name + ')',
                component: validator,
                componentId: validator.id,
                componentType: this.COMPONENT_TYPES.VALIDATOR,
                componentContainer: template.components
              };

              if ( validatorsMap.get( validator.id ) ) {
                ifFunction.apply( this, [ information ] );
              } else {
                elseFunction.apply( this, [ information ] );
              }

              usedValidators.push( validator.id );
            }
          }, this );
        }
      }, this );
    }

    if ( !Ext.isEmpty( processNode.attributes.templates.variablesSetters ) ) {
      Ext.each( processNode.attributes.templates.variablesSetters, function( template, index, templates ) {
        var usedVariablesSetters = new Array();

        if ( !Ext.isEmpty( template.components ) ) {
          Ext.each( template.components, function( variablesSetter, index, variablesSetters ) {
            if ( allowDuplications || usedVariablesSetters.indexOf( variablesSetter.id ) == -1 ) {
              var information = {
                processDefId: processDefId,
                processName: processNameTranslation,
                object: getTranslation( 'Szablon mechanizmów uruchamianych po akceptacji' ) + ': '
                    + template.name,
                objectName: getTranslation( 'Szablon mechanizmów uruchamianych po akceptacji' ) + ': '
                    + ' (' + template.name + ')',
                component: variablesSetter,
                componentId: variablesSetter.id,
                componentType: this.COMPONENT_TYPES.VARIABLES_SETTER,
                componentContainer: template.components
              };

              if ( variablesSettersMap.get( variablesSetter.id ) ) {
                ifFunction.apply( this, [ information ] );
              } else {
                elseFunction.apply( this, [ information ] );
              }

              usedVariablesSetters.push( variablesSetter.id );
            }
          }, this );
        }
      }, this );
    }

    if ( processNode.hasChildNodes() ) {
      var applicationsMap = categoriesMaps.applicationsMap;

      processNode.eachChild( function( activityNode ) {
        var activityName = activityNode.attributes.activityName;
        var activityDefId = activityNode.attributes.activityDefId;
        var packageNode = processNode.parentNode;
        var packageId = packageNode.attributes.packageId
        var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, activityName );

        if ( !Ext.isEmpty( activityNode.attributes.form.actions ) ) {
          this.crawlIntegrationComponentsInObject( processNode, activityNode, allowDuplications,
              formActionsMap, ifFunction, elseFunction, activityNode.attributes.form.actions,
              getTranslation( 'Globalna akcja formularza' ),
              this.COMPONENT_TYPES.FORM_ACTION, null, getTranslation( 'Globalna akcja formularza' ) );
        }

        if ( !Ext.isEmpty( activityNode.attributes.form.events ) ) {
          this.crawlIntegrationComponentsInObject( processNode, activityNode, allowDuplications,
              eventActionsMap, ifFunction, elseFunction, activityNode.attributes.form.events,
              getTranslation( 'Globalne zdarzenie formularza' ),
              this.COMPONENT_TYPES.EVENT_ACTION, null, getTranslation( 'Globalne zdarzenie formularza' ) );
        }

        if ( !Ext.isEmpty( activityNode.attributes.form.variables ) ) {
          Ext.each( activityNode.attributes.form.variables, function( variable, index, variables ) {
            var isVariableSet = variable.type == 'VARIABLE_SET';
            var objectName = isVariableSet ? variable.name : processNode.findVariable( variable.varId ).name;
            var objectNamePrefix = isVariableSet ? getTranslation( 'Tabela dynamiczna' )
                : getTranslation( 'Zmienna formularza' );

            if ( !Ext.isEmpty( variable.formActions ) ) {
              var objectType = isVariableSet ? getTranslation( 'Akcja formularza na tabeli dynamicznej' )
                  : getTranslation( 'Akcja formularza na zmiennej formularza' );

              this.crawlIntegrationComponentsInObject( processNode, activityNode, allowDuplications,
                  formActionsMap, ifFunction, elseFunction, variable.formActions,
                  objectType + ': ' + objectName, this.COMPONENT_TYPES.FORM_ACTION,
                  objectNamePrefix + ' (' + objectName + ')',
                  getTranslation( 'Akcja formularza' ) );
            }

            if ( !Ext.isEmpty( variable.eventActions ) ) {
              var objectType = isVariableSet ? getTranslation( 'Zdarzenie na tabeli dynamicznej' )
                  : getTranslation( 'Zdarzenie na zmiennej formularza' );

              this.crawlIntegrationComponentsInObject( processNode, activityNode, allowDuplications,
                  eventActionsMap, ifFunction, elseFunction, variable.eventActions,
                  objectType + ': ' + objectName, this.COMPONENT_TYPES.EVENT_ACTION,
                  objectNamePrefix + ' (' + objectName + ')',
                  getTranslation( 'Zdarzenie' ) );
            }

            if ( isVariableSet && !Ext.isEmpty( variable.DTButtons ) ) {
              Ext.each( variable.DTButtons, function( dtButton, dtButtonIndex, dtButtons ) {
                if ( !Ext.isEmpty( dtButton.formActions ) ) {
                  this.crawlIntegrationComponentsInObject( processNode, activityNode, allowDuplications,
                      formActionsMap, ifFunction, elseFunction, dtButton.formActions,
                      getTranslation( 'Akcja formularza na przycisku tabeli dynamicznej' ) + ': ' + dtButton.name,
                      this.COMPONENT_TYPES.FORM_ACTION, getTranslation( 'Przycisk tabeli dynamicznej' ) + ' (' + dtButton.name + ')',
                      getTranslation( 'Akcja formularza' ) );
                }

                if ( !Ext.isEmpty( dtButton.eventActions ) ) {
                  this.crawlIntegrationComponentsInObject( processNode, activityNode, allowDuplications,
                      eventActionsMap, ifFunction, elseFunction, dtButton.eventActions,
                      getTranslation( 'Zdarzenie na przycisku tabeli dynamicznej' ) + ': ' + dtButton.name,
                      this.COMPONENT_TYPES.EVENT_ACTION, getTranslation( 'Przycisk tabeli dynamicznej' ) + ' (' + dtButton.name + ')',
                      getTranslation( 'Zdarzenie' ) );
                }
              }, this );
            }
          }, this );
        }

        if ( !Ext.isEmpty( activityNode.attributes.form.labelActions ) ) {
          Ext.each( activityNode.attributes.form.labelActions, function( labelAction, index, labelActions ) {
            if ( !Ext.isEmpty( labelAction.formActions ) ) {
              var labelText = processNode.findLabel( labelAction.labelId ).name;

              this.crawlIntegrationComponentsInObject( processNode, activityNode, allowDuplications,
                  formActionsMap, ifFunction, elseFunction, labelAction.formActions,
                  getTranslation( 'Akcja formularza na etykiecie' ) + ': ' + labelText,
                  this.COMPONENT_TYPES.FORM_ACTION, getTranslation( 'Etykieta' ) + ' (' + labelText + ')',
                  getTranslation( 'Akcja formularza' ) );
            }
          }, this );
        }

        if ( !Ext.isEmpty( activityNode.attributes.form.httpLinks ) ) {
          Ext.each( activityNode.attributes.form.httpLinks, function( httpLink, index, httpLinks ) {
            if ( !Ext.isEmpty( httpLink.formActions ) ) {
              this.crawlIntegrationComponentsInObject( processNode, activityNode, allowDuplications,
                  formActionsMap, ifFunction, elseFunction, httpLink.formActions,
                  getTranslation( 'Akcja formularza na przycisku' ) + ': ' + httpLink.buttonName,
                  this.COMPONENT_TYPES.FORM_ACTION, getTranslation( 'Przycisk' ) + ' (' + httpLink.buttonName + ')',
                  getTranslation( 'Akcja formularza' ) );
            }

            if ( !Ext.isEmpty( httpLink.eventActions ) ) {
              this.crawlIntegrationComponentsInObject( processNode, activityNode, allowDuplications,
                  eventActionsMap, ifFunction, elseFunction, httpLink.eventActions,
                  getTranslation( 'Zdarzenie na przycisku' ) + ': ' + httpLink.buttonName,
                  this.COMPONENT_TYPES.EVENT_ACTION, getTranslation( 'Przycisk' ) + ' (' + httpLink.buttonName + ')',
                  getTranslation( 'Zdarzenie' ) );
            }
          }, this );
        }

        if ( !Ext.isEmpty( activityNode.attributes.form.buttons ) ) {
          Ext.each( activityNode.attributes.form.buttons, function( button, index, buttons ) {
            var usedValidators = new Array();
            var usedVariablesSetters = new Array();

            if ( !Ext.isEmpty( button.formActions ) ) {
              this.crawlIntegrationComponentsInObject( processNode, activityNode, allowDuplications,
                  formActionsMap, ifFunction, elseFunction, button.formActions,
                  getTranslation( 'Akcja formularza na przycisku' ) + ': ' + button.buttonName,
                  this.COMPONENT_TYPES.FORM_ACTION, getTranslation( 'Przycisk' ) + ' (' + button.buttonName + ')',
                  getTranslation( 'Akcja formularza' ) );
            }

            if ( !Ext.isEmpty( button.eventActions ) ) {
              this.crawlIntegrationComponentsInObject( processNode, activityNode, allowDuplications,
                  eventActionsMap, ifFunction, elseFunction, button.eventActions,
                  getTranslation( 'Zdarzenie na przycisku' ) + ': ' + button.buttonName,
                  this.COMPONENT_TYPES.EVENT_ACTION, getTranslation( 'Przycisk' ) + ' (' + button.buttonName + ')',
                  getTranslation( 'Zdarzenie' ) );
            }

            if ( !Ext.isEmpty( button.validators ) ) {
              Ext.each( button.validators, function( validator, index, validators ) {
                if ( allowDuplications || usedValidators.indexOf( validator.id ) == -1 ) {
                  var information = {
                    processDefId: processDefId,
                    processName: processNameTranslation,
                    activityDefId: activityDefId,
                    activityName: activityNameTranslation,
                    object: getTranslation( 'Mechanizm sprawdzający formularz w przycisku' ) + ': '
                        + button.buttonName,
                    objectOwner: getTranslation( 'Przycisk akceptacji' ) + ' (' + button.buttonName + ')',
                    objectName: getTranslation( 'Mechanizm sprawdzający formularz' ),
                    component: validator,
                    componentId: validator.id,
                    componentType: this.COMPONENT_TYPES.VALIDATOR,
                    componentContainer: button.validators
                  };

                  if ( validatorsMap.get( validator.id ) ) {
                    ifFunction.apply( this, [ information ] );
                  } else {
                    elseFunction.apply( this, [ information ] );
                  }

                  usedValidators.push( validator.id );
                }
              }, this );
            }

            if ( !Ext.isEmpty( button.variablesSetters ) ) {
              Ext.each( button.variablesSetters, function( variablesSetter, index, variablesSetters ) {
                if ( allowDuplications || usedVariablesSetters.indexOf( variablesSetter.id ) == -1 ) {
                  var information = {
                    processDefId: processDefId,
                    processName: processNameTranslation,
                    activityDefId: activityDefId,
                    activityName: activityNameTranslation,
                    object: getTranslation( 'Mechanizm uruchamiany po akceptacji w przycisku' ) + ': '
                        + button.buttonName,
                    objectOwner: getTranslation( 'Przycisk akceptacji' ) + ' (' + button.buttonName + ')',
                    objectName: getTranslation( 'Mechanizm uruchamiany po akceptacji' ),
                    component: variablesSetter,
                    componentId: variablesSetter.id,
                    componentType: this.COMPONENT_TYPES.VARIABLES_SETTER,
                    componentContainer: button.variablesSetters
                  };

                  if ( variablesSettersMap.get( variablesSetter.id ) ) {
                    ifFunction.apply( this, [ information ] );
                  } else {
                    elseFunction.apply( this, [ information ] );
                  }

                  usedVariablesSetters.push( variablesSetter.id );
                }
              }, this );
            }

            if ( !Ext.isEmpty( button.validatorsTemplates ) ) {
              Ext.each( button.validatorsTemplates, function( validatorsTemplate, index, validatorsTemplates ) {
                if ( !Ext.isEmpty( validatorsTemplate.components ) ) {
                  Ext.each( validatorsTemplate.components, function( validator, index, validators ) {
                    if ( allowDuplications || usedValidators.indexOf( validator.id ) == -1 ) {
                      var information = {
                        processDefId: processDefId,
                        processName: processNameTranslation,
                        activityDefId: activityDefId,
                        activityName: activityNameTranslation,
                        object: getTranslation( 'Mechanizm sprawdzający formularz w przycisku' ) + ': '
                            + button.buttonName,
                        objectOwner: getTranslation( 'Przycisk akceptacji' ) + ' (' + button.buttonName + ')',
                        objectName: getTranslation( 'Mechanizm sprawdzający formularz' ),
                        component: validator,
                        componentId: validator.id,
                        componentType: this.COMPONENT_TYPES.VALIDATOR,
                        componentContainer: validatorsTemplate.components
                      };

                      if ( validatorsMap.get( validator.id ) ) {
                        ifFunction.apply( this, [ information ] );
                      } else {
                        elseFunction.apply( this, [ information ] );
                      }

                      usedValidators.push( validator.id );
                    }
                  }, this );
                }
              }, this );
            }

            if ( !Ext.isEmpty( button.variablesSettersTemplates ) ) {
              Ext.each( button.validatorsTemplates, function( variablesSettersTemplate, index, variablesSettersTemplates ) {
                if ( !Ext.isEmpty( variablesSettersTemplate.components ) ) {
                  Ext.each( variablesSettersTemplate.components, function( variablesSetter, index, variablesSetters ) {
                    if ( allowDuplications || usedVariablesSetters.indexOf( variablesSetter.id ) == -1 ) {
                      var information = {
                        processDefId: processDefId,
                        processName: processNameTranslation,
                        activityDefId: activityDefId,
                        activityName: activityNameTranslation,
                        object: getTranslation( 'Mechanizm uruchamiany po akceptacji w przycisku' )
                            + ': ' + button.buttonName,
                        objectOwner: getTranslation( 'Przycisk akceptacji' ) + ' (' + button.buttonName + ')',
                        objectName: getTranslation( 'Mechanizm uruchamiany po akceptacji' ),
                        component: variablesSetter,
                        componentId: variablesSetter.id,
                        componentType: this.COMPONENT_TYPES.VARIABLES_SETTER,
                        componentContainer: variablesSettersTemplate.components
                      };

                      if ( variablesSettersMap.get( variablesSetter.id ) ) {
                        ifFunction.apply( this, [ information ] );
                      } else {
                        elseFunction.apply( this, [ information ] );
                      }

                      usedVariablesSetters.push( variablesSetter.id );
                    }
                  }, this );
                }
              }, this );
            }
          }, this );
        }

        if ( activityNode.attributes.activityType == Ext.ux.suncode.Constants.TOOL ) {
          var used = new Array();

          Ext.each( activityNode.attributes.applications, function( application, index, applications ) {
            if ( application.integrationComponent ) {
              if ( allowDuplications || used.indexOf( application.id ) == -1 ) {
                var information = {
                  processDefId: processDefId,
                  processName: processNameTranslation,
                  activityDefId: activityDefId,
                  activityName: activityNameTranslation,
                  object: getTranslation( 'Aplikacja' ) + ': ' + application.name,
                  objectOwner: getTranslation( 'Aplikacja' ) + ' (' + application.name + ')',
                  component: application,
                  componentId: application.id,
                  componentType: this.COMPONENT_TYPES.APPLICATION,
                  componentContainer: activityNode.attributes.applications
                };

                if ( applicationsMap.get( application.id ) ) {
                  ifFunction.apply( this, [ information ] );
                } else {
                  elseFunction.apply( this, [ information ] );
                }

                used.push( application.id );
              }
            }
          }, this );
        }
      }, this );
    }
  },
  getCategoriesMaps: function() {
    var mainPanel = Ext.getCmp( 'main_panel' );

    return {
      formActionsMap: this.convertCategoriesToMap( mainPanel.getFormActionsIntegrationComponentCategories() ),
      validatorsMap: this.convertCategoriesToMap( mainPanel.getValidatorsIntegrationComponentCategories() ),
      variablesSettersMap: this.convertCategoriesToMap( mainPanel.getVariablesSettersIntegrationComponentCategories() ),
      applicationsMap: this.convertCategoriesToMap( mainPanel.getApplicationsIntegrationComponentCategories() ),
      dataChoosersMap: this.convertCategoriesToMap( mainPanel.getDataChoosersIntegrationComponentCategories() ),
      eventActionsMap: this.convertCategoriesToMap( mainPanel.getEventActionsCategories() )
    };
  },
  convertCategoriesToMap: function( categories ) {
    var map = new HashMap();

    if ( !Ext.isEmpty( categories ) ) {
      Ext.iterate( categories, function( category, components, allCategories ) {
        Ext.each( components, function( component, index, allComponents ) {
          map.put( component.id, {
            name: component.name
          } );
        }, this );
      }, this );
    }

    return map;
  },
  crawlIntegrationComponentsInObject: function( processNode, activityNode, allowDuplications,
      componentsMap, ifFunction, elseFunction, components, object, componentType, objectOwner, objectName ) {
    var used = new Array();
    var processDefId = processNode.attributes.processDefId;
    var processName = processNode.attributes.processName;
    var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );
    var activityName = activityNode ? activityNode.attributes.activityName : null;
    var activityDefId = activityNode ? activityNode.attributes.activityDefId : null;
    var packageNode = processNode.parentNode;
    var packageId = packageNode.attributes.packageId
    var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, activityName );

    Ext.each( components, function( component, index, allComponent ) {
      if ( allowDuplications || used.indexOf( component.id ) == -1 ) {
        var componentInfo = componentsMap.get( component.id );
        var information = {
          processDefId: processDefId,
          processName: processNameTranslation,
          activityDefId: activityDefId,
          activityName: activityNameTranslation,
          object: object,
          objectOwner: objectOwner,
          objectName: componentInfo ? objectName + ' (' + componentInfo.name + ')' : objectName,
          component: component,
          componentId: component.id,
          componentType: componentType,
          componentContainer: components
        };

        if ( !Ext.isEmpty( componentInfo ) ) {
          ifFunction.apply( this, [ information ] );
        } else {
          elseFunction.apply( this, [ information ] );
        }

        used.push( component.id );
      }
    }, this );
  },
  getParameterTypeTranslation: function( parameterType ) {
    var translation = this.PARAMETER_TYPES_TRANSLATION[parameterType];

    return !Ext.isEmpty( translation ) ? translation : parameterType;
  },
  getReplacementLabel: function( deprecated, replacement ) {
    if ( !Ext.isEmpty( replacement ) ) {
      if ( replacement.name === deprecated.name ) {
        return replacement.id;
      } else {
        return replacement.name;
      }
    } else {
      return null;
    }
  },
  hasAnyValidDtButton: function( component ) {
    if ( Ext.isArray( component.dtButtons ) ) {
      var valid = false;

      Ext.each( component.dtButtons, function( dtButton, index, dtButtons ) {
        if ( !( Ext.isEmpty( dtButton.name ) && Ext.isEmpty( dtButton.icon ) ) ) {
          valid = true;
          return false;
        }
      } );

      return valid;
    } else {
      return false;
    }
  },
  getValidDtButtons: function( component ) {
    var dtButtons = new Array();

    if ( Ext.isArray( component.dtButtons ) ) {
      Ext.each( component.dtButtons, function ( dtButton, index, allDtButtons ) {
        if ( !( Ext.isEmpty( dtButton.name ) && Ext.isEmpty( dtButton.icon ) ) ) {
          dtButtons.push( dtButton );
        }
      } );
    }

    return dtButtons;
  },
  doesValueBreakAccessibilityRule: function( value, accessibility ) {
    var breaks = false;

    if ( !Ext.isEmpty( value ) ) {
      if ( Ext.isArray( value ) ) {
        Ext.each( value, function( oneValue, index, values ) {
          if ( this.doesValueBreakAccessibilityRule( oneValue, accessibility ) ) {
            breaks = true;
            return false;
          }
        }, this );
      } else if ( value.type == this.FUNCTION_TYPE && !Ext.isEmpty( value.value ) ) {
        var mainPanel = Ext.getCmp( 'main_panel' );
        var systemFunction = mainPanel.getSystemFunction( value.value.name, value.value.parameterTypes );

        if ( Ext.isEmpty( systemFunction )
            || ( systemFunction.accessibility != this.ALL_ACCESSIBILITY
                && systemFunction.accessibility != accessibility ) ) {
          breaks = true;
        } else {
          var functionParameters = value.value.parameters;

          if ( !Ext.isEmpty( functionParameters ) ) {
            Ext.each( functionParameters, function( functionParameter, index, allFunctionParameter ) {
              if ( this.doesValueBreakAccessibilityRule( functionParameter, accessibility ) ) {
                breaks = true;
                return false;
              }
            }, this );
          }
        }
      }
    }

    return breaks;
  },
  validateComponentsPaste: function( categories, components, processNode, optionalValidation ) {
    var result = {
      valid: new Array(),
      incompatible: new Array(),
      missing: new HashMap(),
      isAnyValid: function() {
        return !Ext.isEmpty( this.valid );
      },
      getValid: function() {
        return this.valid;
      },
      isAnyInvalid: function() {
        return !( Ext.isEmpty( this.incompatible ) && this.missing.isEmpty() );
      },
      getInvalidMessage: function() {
        var msg = '';

        if ( !Ext.isEmpty( this.incompatible ) ) {
          msg += getTranslation( 'Wymienione komponenty korzystają z niekompatybilnych' );
          if ( !Ext.isEmpty( optionalValidation ) && !Ext.isEmpty( optionalValidation.invalidMessagePart ) ) {
            msg += ', ';
            msg += optionalValidation.invalidMessagePart;
          }
          msg += ' ';
          msg += getTranslation( 'lub nieistniejących w procesie zmiennych' );
          msg += ':';

          Ext.each( this.incompatible, function( one, index, all ) {
            msg += '<br>&nbsp;&nbsp;&nbsp;&nbsp;- <b>';
            msg += one.componentName;
            msg += '</b> (';
            msg += one.variableIds.join( ', ' );
            msg += ')';
          } );
        }

        if ( !this.missing.isEmpty() ) {
          if ( !Ext.isEmpty( msg ) ) {
            msg += '<br><br>';
          }

          msg += getTranslation( 'Wymienione komponenty są niedostępne' );
          msg += ':';

          this.missing.each( function( key, value ) {
            msg += '<br>&nbsp;&nbsp;&nbsp;&nbsp;- <b>';
            msg += key;
            msg += '</b>';
          } );
        }

        return msg;
      }
    };

    Ext.each( components, function( component, index, allComponents ) {
      var componentDef = this.getIntegrationComponent( categories, component.id );

      if ( Ext.isEmpty( componentDef ) ) {
        result.missing.put( component.id, true );
      } else {
        var incompatible = this.getIncompatibleVariablesUsedInComponent(
            componentDef, component, processNode, optionalValidation );

        if ( !Ext.isEmpty( incompatible ) ) {
          result.incompatible.push( {
            componentName: componentDef.name,
            variableIds: incompatible
          } );
        } else {
          result.valid.push( component );
        }
      }
    }, this );

    return result;
  },
  getIncompatibleVariablesUsedInComponent: function( componentDef, component, processNode, optionalValidation ) {
    var incompatible = new Array();
    var parameters = component.parameters;
    var condition = component.condition;
    var confirmation = component.confirmation;
    var error = component.error;
    var errorHandling = component.errorHandling;

    Ext.iterate( parameters, function( id, value, object ) {
      var compatibility = {
        acceptAnyType: false,
        acceptAnyPlacement: false,
        array: false
      };

      Ext.each( componentDef.parameters, function( parameter, parameterIndex, allParameters ) {
        if ( parameter.id == id ) {
          compatibility = Ext.apply( compatibility, {
            acceptAnyType: parameter.type === this.VARIABLE_TYPE,
            type: parameter.type,
            acceptAnyPlacement: parameter.type === this.VARIABLE_TYPE,
            array: parameter.array
          } );
          return false;
        }
      }, this );

      if ( Ext.isArray( value ) ) {
        Ext.each( value, function( oneValue, index, values ) {
          incompatible = incompatible.concat(
              this.getIncompatibleVariablesUsedInParameterValue(
                  oneValue, processNode, optionalValidation, compatibility ) );
        }, this );
      } else {
        incompatible = incompatible.concat(
            this.getIncompatibleVariablesUsedInParameterValue(
                value, processNode, optionalValidation, compatibility ) );
      }
    }, this );

    incompatible = incompatible.concat(
        this.getIncompatibleVariablesUsedInParameterValue( condition, processNode, optionalValidation,{
          acceptAnyType: false,
          type: this.FUNCTION_TYPE,
          acceptAnyPlacement: false,
          array: false
        } ) );

    if ( !Ext.isEmpty( confirmation ) ) {
      incompatible = incompatible.concat(
          this.getIncompatibleVariablesUsedInParameterValue( confirmation.title, processNode, optionalValidation, {
            acceptAnyType: false,
            type: this.STRING_TYPE,
            acceptAnyPlacement: false,
            array: false
          } ) );
      incompatible = incompatible.concat(
          this.getIncompatibleVariablesUsedInParameterValue( confirmation.message, processNode, optionalValidation, {
            acceptAnyType: false,
            type: this.STRING_TYPE,
            acceptAnyPlacement: false,
            array: false
          } ) );
    }

    if ( !Ext.isEmpty( error ) ) {
      incompatible = incompatible.concat(
          this.getIncompatibleVariablesUsedInParameterValue( error.message, processNode, optionalValidation, {
            acceptAnyType: false,
            type: this.STRING_TYPE,
            acceptAnyPlacement: false,
            array: false
          } ) );
    }

    if ( !Ext.isEmpty( errorHandling ) ) {
      switch ( errorHandling.type ) {
        case 'STOP':
          incompatible = incompatible.concat(
              this.getIncompatibleVariablesUsedInParameterValue( errorHandling.comment, processNode, optionalValidation, {
                acceptAnyType: false,
                type: this.STRING_TYPE,
                acceptAnyPlacement: false,
                array: false
              } ) );
          incompatible = incompatible.concat(
              this.getIncompatibleVariablesUsedInParameterValue( errorHandling.addErrorToComment, processNode, optionalValidation, {
                acceptAnyType: false,
                type: this.BOOLEAN_TYPE,
                acceptAnyPlacement: false,
                array: false
              } ) );
          incompatible = incompatible.concat(
              this.getIncompatibleVariablesUsedInParameterValue( errorHandling.userMessage, processNode, optionalValidation, {
                acceptAnyType: false,
                type: this.STRING_TYPE,
                acceptAnyPlacement: false,
                array: false
              } ) );
          break;
        case 'CONTINUE':
          incompatible = incompatible.concat(
              this.getIncompatibleVariablesUsedInParameterValue( errorHandling.comment, processNode, optionalValidation, {
                acceptAnyType: false,
                type: this.STRING_TYPE,
                acceptAnyPlacement: false,
                array: false
              } ) );
          incompatible = incompatible.concat(
              this.getIncompatibleVariablesUsedInParameterValue( errorHandling.addErrorToComment, processNode, optionalValidation, {
                acceptAnyType: false,
                type: this.BOOLEAN_TYPE,
                acceptAnyPlacement: false,
                array: false
              } ) );
          incompatible = incompatible.concat(
              this.getIncompatibleVariablesUsedInParameterValue( errorHandling.setters.variables, processNode, optionalValidation, {
                acceptAnyType: true,
                type: this.VARIABLE_TYPE,
                acceptAnyPlacement: true,
                array: true
              } ) );
          incompatible = incompatible.concat(
              this.getIncompatibleVariablesUsedInParameterValue( errorHandling.setters.values, processNode, optionalValidation, {
                acceptAnyType: false,
                type: this.STRING_TYPE,
                acceptAnyPlacement: false,
                array: false
              } ) );
          break;
        default:
          break;
      }
    }

    return incompatible;
  },
  getIncompatibleVariablesUsedInParameterValue: function( value, processNode, optionalValidation, compatibility ) {
    var incompatible = new Array();

    if ( !Ext.isEmpty( value ) ) {
      if ( Ext.isArray( value ) ) {
        Ext.each( value, function( oneValue, index, values ) {
          incompatible = incompatible.concat(
              this.getIncompatibleVariablesUsedInParameterValue(
                  oneValue, processNode, optionalValidation, compatibility ) );
        }, this );
      } else if ( value.type == this.VARIABLE_TYPE && !Ext.isEmpty( value.value ) ) {
        var variableId = value.value;

        if ( !variableId.startsWith( this.CONTEXT_VARIABLE_ID_PREFIX ) ) {
          var variable = this.getVariable( processNode, variableId );

          if ( Ext.isEmpty( variable )
              || ( !compatibility.acceptAnyType && compatibility.type !== this.VARIABLE_TYPES_MATRIX[variable.type] )
              || ( !compatibility.acceptAnyPlacement && !compatibility.array && variable.placement === 'table' ) ) {
            incompatible.push( variableId );
          } else if ( !Ext.isEmpty( optionalValidation ) && Ext.isFunction( optionalValidation.func ) ) {
            var validateFunction = optionalValidation.func;
            var validateScope = !Ext.isEmpty( optionalValidation.scope ) ? optionalValidation.scope : window;

            if ( !validateFunction.apply( validateScope, [ variableId ] ) ) {
              incompatible.push( variableId );
            }
          }
        }
      } else if ( value.type == this.FUNCTION_TYPE && !Ext.isEmpty( value.value ) ) {
        var mainPanel = Ext.getCmp( 'main_panel' );
        var systemFunction = mainPanel.getSystemFunction( value.value.name, value.value.parameterTypes );
        var functionParameters = value.value.parameters;

        if ( !( Ext.isEmpty( systemFunction ) || Ext.isEmpty( functionParameters ) ) ) {
          Ext.each( functionParameters, function( functionParameter, index, allFunctionParameter ) {
            var systemFunctionParameter = systemFunction.parameters[index];

            incompatible = incompatible.concat(
                this.getIncompatibleVariablesUsedInParameterValue( functionParameter, processNode, optionalValidation, {
                  acceptAnyType: systemFunctionParameter.type === this.VARIABLE_TYPE,
                  type: systemFunctionParameter.type,
                  acceptAnyPlacement: systemFunctionParameter.type === this.VARIABLE_TYPE,
                  array: systemFunctionParameter.array
                } ) );
          }, this );
        }
      }
    }

    return incompatible;
  },
  getVariable: function( processNode, id ) {
    var variable = processNode.findVariable( id );

    if ( Ext.isEmpty( variable ) ) {
      return processNode.findFormalParam( id );
    } else {
      return variable;
    }
  },
  validateVariableEdit: function( variable ) {
    if ( !Ext.isEmpty( variable ) && variable.type == 'DATA_CHOOSER' && !Ext.isEmpty( variable.definition.id ) ) {
      var dataChoosersCategories = Ext.getCmp( 'main_panel' ).getDataChoosersIntegrationComponentCategories();
      var dataChooserComponentDef = this.getIntegrationComponent( dataChoosersCategories, variable.definition.id );

      if ( Ext.isEmpty( dataChooserComponentDef ) ) {
        showWarn( getTranslation( 'Komponent dynamicznej listy o identyfikatorze' )
            + ' ' + variable.definition.id + ' ' + getTranslation( 'nie istnieje' ) + '.' );
        return false;
      }
    }

    return true
  },
  hasVariablesMissingInComponents: function( components, ids ) {
    return !Ext.isEmpty( this.getVariablesMissingInComponents( components, ids ) );
  },
  hasVariablesMissingInComponent: function( component, ids ) {
    return !Ext.isEmpty( this.getVariablesMissingInComponent( component, ids ) );
  },
  getVariablesMissingInComponents: function( components, ids ) {
    var missing = new Array();

    if ( !Ext.isEmpty( components ) ) {
      Ext.each( components, function( component, componentIndex, allComponents ) {
        if ( !component.inactive ) {
          missing = missing.concat( this.getVariablesMissingInComponent( component, ids ) );
        }
      }, this );
    }

    return missing;
  },
  getVariablesMissingInComponent: function( component, ids ) {
    var missing = new Array();
    var componentId = component.id;
    var parameters = component.parameters;
    var condition = component.condition;
    var confirmation = component.confirmation;
    var error = component.error;
    var errorHandling = component.errorHandling;

    Ext.iterate( parameters, function( id, value, object ) {
      if ( Ext.isArray( value ) ) {
        Ext.each( value, function( oneValue, index, values ) {
          missing = missing.concat( this.getVariablesMissingInValue( componentId, oneValue, ids ) );
        }, this );
      } else {
        missing = missing.concat( this.getVariablesMissingInValue( componentId, value, ids ) );
      }
    }, this );

    missing = missing.concat( this.getVariablesMissingInValue( componentId, condition, ids ) );

    if ( !Ext.isEmpty( confirmation ) ) {
      missing = missing.concat( this.getVariablesMissingInValue( componentId, confirmation.title, ids ) );
      missing = missing.concat( this.getVariablesMissingInValue( componentId, confirmation.message, ids ) );
    }

    if ( !Ext.isEmpty( error ) ) {
      missing = missing.concat( this.getVariablesMissingInValue( componentId, error.message, ids ) );
    }

    if ( !Ext.isEmpty( errorHandling ) ) {
      switch ( errorHandling.type ) {
        case 'STOP':
          missing = missing.concat( this.getVariablesMissingInValue( componentId, errorHandling.comment, ids ) );
          missing = missing.concat( this.getVariablesMissingInValue( componentId, errorHandling.addErrorToComment, ids ) );
          missing = missing.concat( this.getVariablesMissingInValue( componentId, errorHandling.userMessage, ids ) );
          break;
        case 'CONTINUE':
          missing = missing.concat( this.getVariablesMissingInValue( componentId, errorHandling.comment, ids ) );
          missing = missing.concat( this.getVariablesMissingInValue( componentId, errorHandling.addErrorToComment, ids ) );
          missing = missing.concat( this.getVariablesMissingInValue( componentId, errorHandling.setters.variable, ids ) );
          missing = missing.concat( this.getVariablesMissingInValue( componentId, errorHandling.setters.values, ids ) );
          break;
        default:
          break;
      }
    }

    return missing;
  },
  getVariablesMissingInValue: function( componentId, value, ids ) {
    var missing = new Array();

    if ( !Ext.isEmpty( value ) ) {
      if ( Ext.isArray( value ) ) {
        Ext.each( value, function( oneValue, index, values ) {
          missing = missing.concat( this.getVariablesMissingInValue( componentId, oneValue, ids ) );
        }, this );
      } else if ( value.type == this.VARIABLE_TYPE && !Ext.isEmpty( value.value ) ) {
        var variableId = value.value;

        if ( !variableId.startsWith( this.CONTEXT_VARIABLE_ID_PREFIX ) && ids.indexOf( variableId ) == -1 ) {
          missing.push( {
            componentId: componentId,
            variableId: variableId
          } );
        }
      } else if ( value.type == this.FUNCTION_TYPE && !Ext.isEmpty( value.value ) ) {
        var mainPanel = Ext.getCmp( 'main_panel' );
        var systemFunction = mainPanel.getSystemFunction( value.value.name, value.value.parameterTypes );
        var functionParameters = value.value.parameters;

        if ( !( Ext.isEmpty( systemFunction ) || Ext.isEmpty( functionParameters ) ) ) {
          Ext.each( functionParameters, function( functionParameter, index, allFunctionParameter ) {
            var systemFunctionParameter = systemFunction.parameters[index];

            missing = missing.concat( this.getVariablesMissingInValue( componentId, functionParameter, ids ) );
          }, this );
        }
      }
    }

    return missing;
  },
  hasAnyEventTypeName: function( component, eventTypeNames ) {
    if ( !Ext.isEmpty( component.events ) ) {
      var events = component.events;

      for ( var j = 0; j < events.length; j++ ) {
        var eventName = events[j].name;

        if ( eventTypeNames.indexOf ( eventName ) != -1 ) {
          return true;
        }
      }
    }

    return false;
  },
  showDependentEventsRemovalWarning: function( func, scope, args ) {
    var warnMsg = getTranslation( 'Operacja spowoduje usunięcie akcji zależnych.' );
    warnMsg += '<br><br>' + getTranslation( 'Czy chcesz kontynuować?' );

    Ext.Msg.show( {
      title: '<font color="#E16E6E" weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
      msg: warnMsg,
      buttons: {
        yes: getTranslation( 'Tak' ),
        no: getTranslation( 'Nie' )
      },
      fn: function( buttonId ) {
        if ( buttonId == 'yes' && Ext.isFunction( func ) && Ext.isArray( args ) ) {
          var funcScope = !Ext.isEmpty( scope ) ? scope : window;
          func.apply( funcScope, args );
        }
      },
      icon: Ext.Msg.QUESTION,
      scope: this
    } );
  }
};