Ext.ux.suncode.IntegrationComponentContextMenu = function( config ) {
  var items = new Array();
  var categories = config.categories;
  var components = config.components;

  if ( !Ext.isEmpty( components ) ) {
    Ext.each( components, function( component, idx, allComponents ) {
      var componentId = component.id;
      var componentDef = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( categories, componentId );
      var isGlobal = !Ext.isEmpty( component.globalId );

      items.push( {
        xtype: 'menuitem',
        cls: isGlobal ? 'x-btn-text-icon' : 'x-btn-text',
        icon: isGlobal ? getPluginImgPath( 'global' ) : null,
        text: !Ext.isEmpty( componentDef ) ? componentDef.name : componentId,
        menu: [ {
          xtype: 'menuitem',
          cls: 'x-btn-text-icon',
          icon: getPluginImgPath( 'edit' ),
          text: getTranslation( 'Edytuj' ),
          componentIndex: idx,
          listeners: {
            scope: this,
            click: this.onEditComponent
          }
        }, {
          xtype: 'menuitem',
          cls: 'x-btn-text-icon',
          icon: getPluginImgPath( 'delete' ),
          text: getTranslation( 'Usuń' ),
          componentIndex: idx,
          listeners: {
            scope: this,
            click: this.onDeleteComponent
          }
        } ]
      } );
    }, this );
  }

  config = Ext.apply( {
    items: items
  }, config );

  Ext.ux.suncode.IntegrationComponentContextMenu.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentContextMenu, Ext.menu.Menu, {
  initComponent: function() {
    Ext.ux.suncode.IntegrationComponentContextMenu.superclass.initComponent.call( this );
  },
  onEditComponent: function( item, e ) {
    var globalDefinition = this.initialConfig.globalDefinition;
    var componentIndex = item.componentIndex;
    var component = this.getComponentByIndex( componentIndex );

    if ( !( globalDefinition || Ext.isEmpty( component.globalId ) ) ) {
      var warnMsg = getTranslation( 'Komponent jest globalny.' );
      warnMsg += ' ' + getTranslation( 'Edycja parametrów spowoduje ich zmianę we wszystkich zadaniach.' );
      warnMsg += ' ' + getTranslation( 'Zapisanie okna parametrów będzie miało natychmiastowy skutek.' );
      warnMsg += '<br><br>' + getTranslation( 'Czy chcesz kontynuować?' );

      Ext.Msg.show( {
        title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
        msg: warnMsg,
        buttons: {
          yes: getTranslation( 'Tak' ),
          no: getTranslation( 'Nie' )
        },
        fn: function( buttonId ) {
          if ( buttonId == 'yes' ) {
            this.editComponentParameters( componentIndex, component );
          }
        },
        icon: Ext.Msg.QUESTION,
        scope: this
      } );
    } else {
      this.editComponentParameters( componentIndex, component );
    }
  },
  editComponentParameters: function( componentIndex, component ) {
    var categories = this.initialConfig.categories;
    var componentId = component.id;
    var componentDef = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( categories, componentId );

    if ( !Ext.isEmpty( componentDef ) ) {
      var win = new Ext.ux.suncode.IntegrationComponentParametersWindow( {
        title: this.initialConfig.parametersWindowTitlePrefix + ': ' + componentDef.name,
        component: componentDef,
        customDescription: component.customDescription,
        condition: component.condition,
        inactive: component.inactive,
        parameters: component.parameters,
        processNode: this.initialConfig.processNode,
        conditionalExecutionEnabled: this.initialConfig.conditionalExecutionEnabled,
        inactiveEnabled: this.initialConfig.inactiveEnabled,
        bindTo: this.getBindTo( componentDef ),
        destinationType: this.initialConfig.destinationType,
        acceptButton: this.initialConfig.acceptButton,
        tableId: this.initialConfig.tableId,
        buttonId: this.initialConfig.buttonId,
        availableVariables: this.initialConfig.availableVariables,
        missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
        missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
        systemFunctionsAccessibility: this.initialConfig.systemFunctionsAccessibility,
        validateFieldFunction: this.initialConfig.validateFieldFunction,
        validateFieldScope: this.initialConfig.validateFieldScope,
        saveFunction: function( condition, values, extraConfig ) {
          var editFunction = this.initialConfig.editFunction;

          if ( Ext.isFunction( editFunction ) ) {
            var editScope = !Ext.isEmpty( this.initialConfig.editScope ) ? this.initialConfig.editScope : window;
            editFunction.apply( editScope, [ componentIndex, condition, values, extraConfig ] );
          }
        },
        saveScope: this,
        getComponentRegistrationFunction: this.initialConfig.getComponentRegistrationFunction,
        getComponentRegistrationScope: this.initialConfig.getComponentRegistrationScope
      } );
      win.show();
    } else {
      showWarn( getTranslation( 'Komponent nie istnieje.' ) );
    }
  },
  getBindTo: function( componentDef ) {
    var getBindToFunction = this.initialConfig.getBindToFunction;

    if ( Ext.isFunction( getBindToFunction ) ) {
      var getBindToScope = !Ext.isEmpty( this.initialConfig.getBindToScope ) ? this.initialConfig.getBindToScope : window;
      return getBindToFunction.apply( getBindToScope, [ componentDef ] );
    } else {
      return null;
    }
  },
  onDeleteComponent: function( item, e ) {
    var globalDefinition = this.initialConfig.globalDefinition;
    var componentIndex = item.componentIndex;
    var component = this.getComponentByIndex( componentIndex );

    if ( !( globalDefinition || Ext.isEmpty( component.globalId ) ) ) {
      showWarn( getTranslation( 'Globalny komponent nie może być usunięty.' ) );
      return;
    }

    var deleteFunction = this.initialConfig.deleteFunction;

    if ( Ext.isFunction( deleteFunction ) ) {
      var deleteScope = !Ext.isEmpty( this.initialConfig.deleteScope ) ? this.initialConfig.deleteScope : window;
      deleteFunction.apply( deleteScope, [ componentIndex ] );
    }
  },
  getComponentByIndex: function( index ) {
    return this.initialConfig.components[index];
  }
} );