Ext.ux.suncode.FormHttpLinkDefPanel = function( config ) {
    var component = config.component;
    var objectDef = component.definition.objectDef;
    var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
	  var packageId = packageNode.attributes.packageId;
    var activityNode = config.activityNode;
    var activityDefId = activityNode.attributes.activityDefId;
    var processNode = activityNode.parentNode;
    var processDefId = processNode.attributes.processDefId;
    var drawingPanel = Ext.getCmp( 'drawing_panel' );
    var mainPanel = Ext.getCmp( 'main_panel' );
    var animationsOn = mainPanel.getAnimationsOn();
    var formActionsCategories = mainPanel.getFormActionsIntegrationComponentCategories();
    var eventTypes = mainPanel.getEventTypesForHttpLink();
    var eventActionsCategories = mainPanel.getEventActionsCategories();
    var nameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId +
		  ')_HTTPLINK(' + Ext.ux.suncode.I18NService.replaceHttpLinkId( objectDef.buttonName ) +')';

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'varId',
                type: 'string'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( objectDef.params ) ) {
        store.loadData( objectDef.params );
        store.commitChanges();
    }

    var allVariablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: activityNode.parentNode.attributes.variables,
        formalParameters: activityNode.parentNode.attributes.formalParameters
    } );

    var specification = component.idAssigned ? Ext.ux.suncode.DocumentationService.getButtonSpecification( activityNode, objectDef.actionName )
                    : new Object();

    config = Ext.apply( {
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: 250,
        autoHeight: true,
        ref: 'httpLinkDefPanel',
        layoutConfig: {
            trackLabels: true
        },
        items: [ {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Nazwa akcji' ),
            anchor: '100%',
            ref: 'actionNameItem',
            value: objectDef.actionName,
            hidden: true
        }, new Ext.ux.suncode.I18NTranslatedField( {
        	fieldLabel: getTranslation( 'Nazwa przycisku' ),
        	anchor: '100%',
            ref: 'nameItem',
        	field: {
                xtype: 'textfield',
                value: objectDef.buttonName,
                listeners: {
                    scope: this,
                    blur: function( field ) {
                        var actionName = generateId( field.getValue() );
                        this.actionNameItem.setValue( actionName );
                        this.editFormActionsBindTo();
                    }
                }
            },
            getIdFieldFunction: function() {
            	return this.nameItem;
            },
            getIdFieldScope: this,
            emptyIdMessage: getTranslation( 'Podaj nazwę przycisku.' ),
            windowTitle: getTranslation( 'Tłumaczenia nazwy przycisku' ),
            keyPrefix: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_HTTPLINK(',
            keyPostfix: ')',
            saveToCache: true,
            cache: !Ext.isEmpty( objectDef.translations ) && !Ext.isEmpty( objectDef.translations[nameTranslationKey] ) ? {
    			key: nameTranslationKey,
    			translations: objectDef.translations[nameTranslationKey]
    		} : new Object(),
            initialId: component.idAssigned ? Ext.ux.suncode.I18NService.replaceHttpLinkId( objectDef.buttonName ) : null,
            idReplacementStrategy: Ext.ux.suncode.I18NService.replaceHttpLinkId
        } ), new Ext.ux.suncode.TypesChooser( {
            utilization: 'httpLink',
            typeItemValue: objectDef.type,
            listeners: {
                scope: this,
                select: function( combo, record, index ) {
                    var value = combo.getValue();

                    if ( value == 'UrlLink' ) {
                        Ext.getCmp( 'js_coding_button' ).disable();
                        this.paramsItem.enable();
                        this.formActionsGrid.hide();
                        this.eventActionsGrid.hide();
                        this.urlItem.show();
                        this.saveFormItem.show();
                    } else if ( value == 'JavaScriptLink' ) {
                        Ext.getCmp( 'js_coding_button' ).enable();
                        this.paramsItem.enable();
                        this.formActionsGrid.hide();
                        this.eventActionsGrid.hide();
                        this.urlItem.show();
                        this.saveFormItem.show();
                    } else if ( value == 'Actions' ) {
                        Ext.getCmp( 'js_coding_button' ).disable();
                          this.paramsItem.disable();
                        this.formActionsGrid.show();
                        this.eventActionsGrid.show();
                        this.urlItem.hide();
                        this.saveFormItem.hide();
                    } else {
                        Ext.getCmp( 'js_coding_button' ).disable();
                        this.paramsItem.disable();
                        this.formActionsGrid.hide();
                        this.eventActionsGrid.hide();
                        this.urlItem.show();
                        this.saveFormItem.show();
                    }
                }
            }
        } ), {
            xtype: 'compositefield',
            fieldLabel: getTranslation( 'Nazwa funkcji / URL / konfiguracja okna' ),
            anchor: '100%',
            ref: 'urlItem',
            hidden: objectDef.type == 'Actions',
            items: [ {
                xtype: 'textfield',
                inputType: 'text',
                flex: 1,
                value: objectDef.url,
                stripCharsRe: /\(|\)/g
            }, {
                xtype: 'button',
                id: 'js_coding_button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'scripts' ),
                tooltip: getTranslation( 'Przygotuj definicję funkcji' ),
                flex: 0,
                handler: this.showJSCodingWindow,
                scope: this,
                hidden: !config.AV || objectDef.type != 'JavaScriptLink'
            } ]
        }, {
            xtype: 'checkbox',
            fieldLabel: getTranslation( 'Zapisz formularz' ),
            anchor: '100%',
            ref: 'saveFormItem',
            hidden: objectDef.type == 'Actions',
            checked: objectDef.saveForm,
            inputValue: 'true'
        }, new Ext.ux.suncode.ButtonDestinationsChooser( {
            value: objectDef.destination
        } ), new Ext.ux.suncode.SystemIconsChooser( {
            icon: objectDef.icon
        } ), new Ext.ux.suncode.SystemColorsChooser( {
            color: objectDef.color
        } ), {
            xtype: 'panel',
            layout: 'accordion',
            layoutConfig: {
                animate: animationsOn,
                fill: false
            },
            style: {
                marginBottom: '5px'
            },
            bodyStyle: {
                border: 0
            },
            items: [ {
                xtype: 'editorgrid',
                title: getTranslation( 'Parametry przycisku' ),
                store: store,
                height: 250,
                collapsed: true,
                enableColumnResize: false,
                enableDragDrop: true,
                ddGroup: 'dd_parameters',
                columnLines: true,
                autoScroll: true,
                frame: false,
                disabled: ( objectDef.type == 'UrlLink' || objectDef.type == 'JavaScriptLink' ) ? false : true,
                ref: '../paramsItem',
                colModel: new Ext.grid.ColumnModel( {
                    defaults: {
                        sortable: true,
                        menuDisabled: true
                    },
                    columns: [ new Ext.grid.RowNumberer(), {
                        id: 'varId',
                        header: getTranslation( 'Parametr' ),
                        dataIndex: 'varId',
                        align: 'left',
                        editor: allVariablesChooser,
                        renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser )
                    } ]
                } ),
                viewConfig: new Ext.grid.GridView( {
                    forceFit: true
                } ),
                sm: new Ext.grid.RowSelectionModel( {
                    singleSelect: true,
                    listeners: {
                        beforerowselect: function( sm, i, ke, row ) {
                            sm.grid.ddText = '<b style="font-size: 12px;">' + row.get( 'varId' ) + '</b>';
                        }
                    }
                } ),
                tbar: new Ext.Toolbar( {
                    items: [ '->', {
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'add' ),
                        tooltip: getTranslation( 'Dodaj' ),
                        handler: function() {
                            var grid = this.ownerCt.ownerCt;
                            var store = grid.getStore();
                            var v = store.recordType;
                            var rec = new v( {
                                varId: ''
                            } );
                            grid.stopEditing();
                            store.add( rec );
                            store.commitChanges();
                            grid.startEditing( store.getCount() - 1, 1 );
                        }
                    }, {
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'delete' ),
                        tooltip: getTranslation( 'Usuń' ),
                        handler: function() {
                            var grid = this.ownerCt.ownerCt;
                            var selModel = grid.getSelectionModel();
                            var rows = selModel.getSelections();
                            if ( rows.length == 0 ) {
                                showWarn( getTranslation( 'Wybierz parametr do usunięcia.' ) );
                                return;
                            }
                            removeRowAndMarkNext( grid, rows[0] );
                            grid.getView().refresh();
                        }
                    } ]
                } ),
                listeners: {
                    afteredit: function( e ) {
                        e.grid.getStore().commitChanges();
                    },
                    render: function( grid ) {
                        new Ext.dd.DropTarget( grid.getEl(), {
                            ddGroup: 'dd_parameters',
                            copy: false,
                            grid: grid,
                            notifyOver: notifyOverGrid,
                            notifyDrop: notifyDropGrid
                        } );
                    }
                }
            }, new Ext.ux.suncode.IntegrationComponentTable( {
                ref: '../formActionsGrid',
                hidden: objectDef.type != 'Actions',
                title: getTranslation( 'Akcje formularza' ),
                height: 250,
                collapsed: true,
                frame: false,
                components: objectDef.formActions,
                filteredCategories: Ext.ux.suncode.IntegrationComponentService.filterCategoriesByDestination(
                    formActionsCategories, Ext.ux.suncode.IntegrationComponentService.BUTTON_DESTINATION, false ),
                allCategories: formActionsCategories,
                processNode: processNode,
                pasteComponentsValidation: {
                    func: function( variableId ) {
                        var presentVariableIds = this.getPresentVariableIds();

                        return presentVariableIds.includes( variableId );
                    },
                    scope: drawingPanel,
                    invalidMessagePart: getTranslation( 'niewystępujących na formularzu' )
                },
                enableCopyPasteMenu: true,
                conditionalExecutionEnabled: true,
                inactiveEnabled: true,
                parametersWindowTitlePrefix: getTranslation( 'Parametry akcji formularza' ),
                availableVariables: config.availableVariables,
                missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
                missingVariablesValidatorScope: config.missingVariablesValidatorScope,
                systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
                getBindToFunction: function( component ) {
                    var buttonDestination = Ext.ux.suncode.IntegrationComponentService.BUTTON_DESTINATION;
                    var destination = Ext.ux.suncode.IntegrationComponentService.getDestination( component, buttonDestination );

                    return !Ext.isEmpty( destination ) ? {
                        id: destination.bindTo,
                        value: this.actionNameItem.getValue()
                    } : null;
                },
                getBindToScope: this,
                getComponentRegistrationFunction: function( id ) {
                	return Ext.ux.suncode.IntegrationComponentService.getFormActionRegistration( id );
                },
                getComponentRegistrationScope: this,
                copyComponentsFunction: function( components ) {
                	Ext.ux.suncode.Clipboard.setIntegrationComponentFormActions( components );
                },
                copyComponentsScope: this,
                handleCopiedComponentsFunction: function( func, scope ) {
                  Ext.ux.suncode.Clipboard.getIntegrationComponentFormActions( function( formActions ) {
                    if ( Ext.isFunction( func ) ) {
                      var components = new Array();

                      if ( !Ext.isEmpty( formActions ) ) {
                        var service = Ext.ux.suncode.IntegrationComponentService;
                        var categories = Ext.getCmp( 'main_panel' ).getFormActionsIntegrationComponentCategories();

                        Ext.each( formActions, function( component, index, allComponents ) {
                          var componentDef = service.getIntegrationComponent( categories, component.id );

                          if ( !Ext.isEmpty( componentDef ) && service.hasDestination( componentDef, service.BUTTON_DESTINATION, false ) ) {
                            components.push( component );
                          }
                        } );
                      }

                      scope = !Ext.isEmpty( scope ) ? scope : window;
                      func.apply( scope, [ components ] );
                    }
                  }, this );
                },
                handleCopiedComponentsScope: this,
                pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentFormActionsMessageType,
                validateFieldFunction: config.validateIntegrationComponentFieldFunction,
                validateFieldScope: config.validateIntegrationComponentFieldScope,
                validateRowFunction: drawingPanel.validateVariablesInIntegrationComponent,
                validateRowScope: drawingPanel,
                destinationType: Ext.ux.suncode.IntegrationComponentService.BUTTON_DESTINATION,
                acceptButton: false,
                buttonId: objectDef.actionName
            } ), new Ext.ux.suncode.IntegrationComponentTable( {
                ref: '../eventActionsGrid',
                hidden: objectDef.type != 'Actions',
                title: getTranslation( 'Zdarzenia' ),
                height: 250,
                collapsed: true,
                frame: false,
                eventMode: true,
                eventTypes: eventTypes,
                components: objectDef.eventActions,
                filteredCategories: eventActionsCategories,
                allCategories: eventActionsCategories,
                processNode: processNode,
                pasteComponentsValidation: {
                  func: function( variableId ) {
                    var presentVariableIds = this.getPresentVariableIds();

                    return presentVariableIds.includes( variableId );
                  },
                  scope: drawingPanel,
                  invalidMessagePart: getTranslation( 'niewystępujących na formularzu' )
                },
                enableCopyPasteMenu: true,
                conditionalExecutionEnabled: true,
                inactiveEnabled: true,
                parametersWindowTitlePrefix: getTranslation( 'Parametry zdarzenia' ),
                availableVariables: config.availableVariables,
                missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
                missingVariablesValidatorScope: config.missingVariablesValidatorScope,
                systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
                getComponentRegistrationFunction: function( id ) {
                  return Ext.ux.suncode.IntegrationComponentService.getEventActionRegistration( id );
                },
                getComponentRegistrationScope: this,
                copyComponentsFunction: function( components ) {
                  Ext.ux.suncode.Clipboard.setIntegrationComponentEventActions( components );
                },
                copyComponentsScope: this,
                handleCopiedComponentsFunction: function( func, scope ) {
                  Ext.ux.suncode.Clipboard.getIntegrationComponentEventActions( function( eventActions ) {
                    if ( Ext.isFunction( func ) ) {
                      scope = !Ext.isEmpty( scope ) ? scope : window;
                      func.apply( scope, [ eventActions ] );
                    }
                  }, this );
                },
                handleCopiedComponentsScope: this,
                pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentEventActionsMessageType,
                validateFieldFunction: config.validateIntegrationComponentFieldFunction,
                validateFieldScope: config.validateIntegrationComponentFieldScope,
                validateRowFunction: drawingPanel.validateVariablesInIntegrationComponent,
                validateRowScope: drawingPanel
            } ) ]
        }, new Ext.ux.suncode.SpecificationDescriptionArea( {
            processNode: processNode,
            description: specification.description
        } ) ]
    }, config );

    Ext.ux.suncode.FormHttpLinkDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FormHttpLinkDefPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.FormHttpLinkDefPanel.superclass.initComponent.call( this );
    },
    editFormActionsBindTo: function() {
        this.formActionsGrid.editBindToParameter();
    },
    editHttpLink: function() {
        var hlDef = this.readDef();
        if ( !hlDef ) {
            return;
        }

        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var packageNode = processNode.parentNode;
        var packageId = packageNode.attributes.packageId;
        var processDefId = processNode.attributes.processDefId;
        var activityDefId = activityNode.attributes.activityDefId;
        var component = this.initialConfig.component;
        var item = component.items.first();
        var objectDef = component.definition.objectDef;
        Ext.apply( objectDef, hlDef );

        item.setText( getXpdlHttpLinkNameTranslation ( packageId, processDefId, activityDefId, objectDef.buttonName, objectDef.buttonName ) );
        item.setIconClass( Ext.ux.suncode.UtilService.resolveIconCls( objectDef.icon ) );

        Ext.ux.suncode.UtilService.resolveFormButtonColor( item, objectDef.color );

        component.idAssigned = true;

        var specification = this.readSpecification();
        Ext.ux.suncode.DocumentationService.editButtonSpecification( activityNode, hlDef.actionName, hlDef.actionName, specification );

        var drawingPanel = Ext.getCmp( 'drawing_panel' );
        drawingPanel.analyzeVariablesMissingInIntegrationComponents( component );
        drawingPanel.analyzeFormActionsOverlay( component );
        drawingPanel.analyzeEventActionsOverlay( component );
        drawingPanel.recalculateLayoutPack( component.ownerCt );
        this.ownerCt.closeDefWindow();
    },
    readDef: function() {
        var hlDef = new Object();
        var actionName = this.actionNameItem.getValue();
        var buttonName = this.nameItem.getValue();
        var type = this.typeItem.getValue();
        var url = this.urlItem.items.first().getValue();
        var saveForm = this.saveFormItem.getValue();
        var params = new Array();
        var store = this.paramsItem.getStore();

        if ( Ext.isEmpty( actionName ) || Ext.isEmpty( buttonName ) ) {
            showWarn( getTranslation( 'Podaj nazwę przycisku.' ) );
            return null;
        } else if ( Ext.isEmpty( type ) ) {
            showWarn( getTranslation( 'Podaj typ przycisku.' ) );
            return null;
        } else if ( type != 'Actions' && Ext.isEmpty( url ) ) {
            showWarn( getTranslation( 'Podaj nazwę funkcji / URL / konfigurację okna.' ) );
            return null;
        } else if ( this.checkDuplication( actionName ) ) {
            showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o tym samym identyfikatorze został już dodany do formularza.' ) );
            return null;
        }

        if ( !this.paramsItem.disabled ) {
            for ( var i = 0; i < store.getCount(); i++ ) {
                var param = store.getAt( i );
                var varId = param.get( 'varId' );

                if ( Ext.isEmpty( varId ) ) {
                    showWarn( getTranslation( 'Uzupełnij poprawnie parametry.' ) );
                    return null;
                }

                var paramDef = {
                    varId: varId
                };

                params.push( paramDef );
            }
        }

        hlDef = Ext.apply( {
            actionName: actionName,
            buttonName: buttonName,
            destination: this.destinationItem.getValue(),
            type: type,
            url: url,
            saveForm: saveForm,
            icon: this.iconsChooser.getValue(),
            color: this.colorsChooser.getValue(),
            params: params,
            formActions: this.formActionsGrid.readComponents(),
            eventActions: this.eventActionsGrid.readComponents(),
            translations: Ext.ux.suncode.I18NService.getPackageTranslationsFromCaches( [ this.nameItem ] ),
            genre: 'HTTP_LINK'
        }, hlDef );

        return hlDef;
    },
    checkDuplication: function( actionName ) {
        var component = this.initialConfig.component;

        if ( component.idAssigned && component.definition.objectDef.actionName == actionName ) {
            return false;
        } else {
            var drawingPanel = Ext.getCmp( 'drawing_panel' );
            var isDuplicated = false;

            drawingPanel.items.each( function( item ) {
                item.items.each( function( subitem ) {
                	var definition = subitem.definition;
                    var objectDef = definition.objectDef;

                    switch ( objectDef.genre ) {
	                    case 'VARIABLE':
	                        if ( subitem.idAssigned &&
	                        		( objectDef.varId == actionName || objectDef.varId == actionName + '_button' ) ) {
	                            isDuplicated = true;
	                            return false;
	                        }
	                        break;
                        case 'VARIABLE_SET':
                        	if ( subitem.idAssigned ) {
                        		if ( objectDef.varId == actionName || objectDef.varId == actionName + '_button' ) {
                                    isDuplicated = true;
                                    return false;
                                } else {
                                    var columns = objectDef.columns;

                                    for ( var i = 0; i < columns.length; i++ ) {
                                        var column = columns[i];

                                        if ( column.varId == actionName || column.varId == actionName + '_button' ) {
                                            isDuplicated = true;
                                            return false;
                                        }
                                    }
                                    
                                    var dtButtons = objectDef.DTButtons;

                                    for ( var i = 0; i < dtButtons.length; i++ ) {
                                        var dtButton = dtButtons[i];

                                        if ( dtButton.buttonId == actionName || dtButton.buttonId == actionName + '_button' ) {
                                            isDuplicated = true;
                                            return false;
                                        }
                                    }
                                }
                            }
                        	break;
                        case 'LABEL':
                            if ( subitem.idAssigned && objectDef.id == actionName + '_button' ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        case 'HTTP_LINK':
                        case 'ACTION_ACCEPT_BUTTON':
                        case 'GENERATE_PDF_BUTTON':
                        case 'ADD_FILE_BUTTON':
                        case 'BARCODE_PRINT':
                            if ( subitem.idAssigned && objectDef.actionName == actionName ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        default:
                            break;
                    }
                } );

                if ( isDuplicated ) {
                    return false;
                }
            } );

            return isDuplicated;
        }
    },
    showJSCodingWindow: function() {
        var type = this.typeItem.getValue();
        var functionName = this.urlItem.items.first().getValue();
        var store = this.paramsItem.getStore();

        if ( type != 'JavaScriptLink' ) {
            showWarn( getTranslation( 'Opcja dostępna tylko dla typu "Funkcja JavaScript".' ) );
            return;
        }

        if ( Ext.isEmpty( functionName ) ) {
            showWarn( getTranslation( 'Podaj nazwę funkcji.' ) );
            return;
        }

        var params = new Array();
        for ( var i = 0; i < store.getCount(); i++ ) {
            var param = store.getAt( i );
            var varId = param.get( 'varId' );

            if ( Ext.isEmpty( varId ) ) {
                showWarn( getTranslation( 'Uzupełnij poprawnie parametry.' ) );
                return;
            }

            params.push( varId );
        }

        var win = new Ext.ux.suncode.JsCodingWindow( {
            winTitle: getTranslation( 'Definicja funkcji akcji na zdarzeniach' ),
            sourceCodeType: 'JS_HTTP_LINK',
            functionName: functionName,
            options: {
                parameters: params
            }
        } );
        win.show();
    },
    readSpecification: function() {
        var specification = new Object();
        specification = Ext.apply( {
            description: this.specificationDescriptionItem.getSpecificationDescription()
        }, specification );

        return specification;
    }
} );