Ext.ux.suncode.ActionAcceptButtonDefPanel = function( config ) {
    var component = config.component;
    var objectDef = component.definition.objectDef;
    var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
	  var packageId = packageNode.attributes.packageId;
    var activityNode = config.activityNode;
    var activityDefId = activityNode.attributes.activityDefId;
    var processNode = activityNode.parentNode;
    var processDefId = processNode.attributes.processDefId;
    var drawingPanel = Ext.getCmp( 'drawing_panel' );
    var mainPanel = Ext.getCmp( 'main_panel' );
    var animationsOn = mainPanel.getAnimationsOn();
    var variables = activityNode.parentNode.attributes.variables;
    var actions = new Array();
    var validatorsCategories = mainPanel.getValidatorsIntegrationComponentCategories();
    var variablesSettersCategories = mainPanel.getVariablesSettersIntegrationComponentCategories();
    var formActionsCategories = mainPanel.getFormActionsIntegrationComponentCategories();
    var eventTypes = mainPanel.getEventTypesForAcceptButton();
    var eventActionsCategories = mainPanel.getEventActionsCategories();
    var compatibilityMode = mainPanel.getCompatibilityMode();

    var dcIncludesStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'dataChooserId',
                type: 'string'
            } ] )
        } )
    } );
    var dcExcludesStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'dataChooserId',
                type: 'string'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( objectDef.actions ) ) {
        for ( var i = 0; i < objectDef.actions.length; i++ ) {
            var actionObj = objectDef.actions[i];

            actions.push( {
                text: getActionAcceptButtonActionNodeText( actionObj.attributions, actionObj.conditions ),
                icon: getPluginImgPath( 'action' ),
                leaf: true,
                action: actionObj
            } );
        }
    }
    if ( !Ext.isEmpty( objectDef.dcIncludes ) ) {
        dcIncludesStore.loadData( objectDef.dcIncludes );
        dcIncludesStore.commitChanges();
    }
    if ( !Ext.isEmpty( objectDef.dcExcludes ) ) {
        dcExcludesStore.loadData( objectDef.dcExcludes );
        dcExcludesStore.commitChanges();
    }

    var includedDataChoosersChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: variables,
        acceptedTypes: [ 'DATA_CHOOSER' ]
    } );
    var excludedDataChoosersChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: variables,
        acceptedTypes: [ 'DATA_CHOOSER' ]
    } );

    var nameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId +
    	')_ACTIONBUTTON(' + objectDef.actionName +')';
    var specification = component.idAssigned ? Ext.ux.suncode.DocumentationService.getButtonSpecification( activityNode, objectDef.actionName )
                    : new Object();

    config = Ext.apply( {
    	frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: 250,
        autoHeight: true,
        ref: 'buttonDefPanel',
        layoutConfig: {
            trackLabels: true
        },
        validatorsTemplates: component.idAssigned ? objectDef.validatorsTemplates : [],
        variablesSettersTemplates: component.idAssigned ? objectDef.variablesSettersTemplates : [],
        forwardToReset: false,
        items: [ new Ext.ux.suncode.IdField( {
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa akcji' ),
            allowBlank: true,
            value: objectDef.actionName,
            ref: 'actionNameItem',
            hidden: !config.AV,
            idChanged: component.idAssigned,
            afterSetIdFunction: function( oldId, newId ) {
                this.changeActionParam( oldId, newId );
                this.editFormActionsBindTo();
            },
            afterSetIdScope: this
        } ), new Ext.ux.suncode.I18NTranslatedField( {
        	fieldLabel: getTranslation( 'Nazwa przycisku' ),
        	anchor: '100%',
            ref: 'buttonNameItem',
        	field: {
                xtype: 'textfield',
                value: objectDef.buttonName,
                listeners: {
                    scope: this,
                    blur: this.buttonNameTyped
                }
            },
            getIdFieldFunction: function() {
            	return this.actionNameItem;
            },
            getIdFieldScope: this,
            emptyIdMessage: getTranslation( 'Podaj nazwę przycisku.' ),
            windowTitle: getTranslation( 'Tłumaczenia nazwy przycisku' ),
            keyPrefix: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_ACTIONBUTTON(',
            keyPostfix: ')',
            saveToCache: true,
            cache: !Ext.isEmpty( objectDef.translations[nameTranslationKey] ) ? {
            	key: nameTranslationKey,
            	translations: objectDef.translations[nameTranslationKey]
            } : new Object(),
            initialId: component.idAssigned ? objectDef.actionName : null
        } ), {
            xtype: 'compositefield',
            fieldLabel: addTooltipToField( getTranslation( 'Funkcja' ), null, null, true ),
            anchor: '100%',
            ref: 'jsActionItem',
            hidden: !compatibilityMode.showAcceptButtonJsAction( objectDef.jsAction ),
            items: [ new Ext.ux.suncode.AcceptButtonFunctionsChooser( {
                jsAction: objectDef.jsAction
            } ), {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'generate' ),
                tooltip: getTranslation( 'Generuj domyślną nazwę funkcji' ),
                flex: 0,
                handler: this.generateDefaultJsActionName,
                scope: this
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'scripts' ),
                tooltip: getTranslation( 'Przygotuj definicję funkcji' ),
                flex: 0,
                handler: this.showJSCodingWindow,
                scope: this,
                hidden: !config.AV
            } ]
        }, {
            xtype: 'checkbox',
            fieldLabel: getTranslation( 'Sprawdzaj formularz' ),
            anchor: '100%',
            ref: 'checkFormItem',
            checked: objectDef.checkForm,
            inputValue: 'true'
        }, {
            xtype: 'checkbox',
            fieldLabel: getTranslation( 'Zapisuj formularz przed akceptacją' ),
            anchor: '100%',
            ref: 'saveBeforeAcceptItem',
            checked: objectDef.saveBeforeAccept,
            inputValue: 'true'
        }, {
            xtype: 'compositefield',
            fieldLabel: getTranslation( 'Występowanie' ),
            anchor: '100%',
            ref: 'destinationItem',
            items: [ new Ext.ux.suncode.AcceptButtonDestinationsChooser( {
                value: objectDef.destination
            } ), {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'clear' ),
                tooltip: getTranslation( 'Wyczyść' ),
                flex: 0,
                handler: this.clearDestination,
                scope: this
            } ]
        }, {
            xtype: 'compositefield',
            fieldLabel: getTranslation( 'Przekieruj do' ),
            anchor: '100%',
            ref: 'forwardToItem',
            items: [ new Ext.ux.suncode.ActivityForwardChooser( {
                activityNode: activityNode,
                buttonDefPanel: this,
                forwardTo: objectDef.forwardTo
            } ), {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'clear' ),
                tooltip: getTranslation( 'Wyczyść' ),
                flex: 0,
                handler: this.clearForwardTo,
                scope: this
            } ]
        }, new Ext.ux.suncode.SystemIconsChooser( {
            icon: objectDef.icon
        } ), new Ext.ux.suncode.SystemColorsChooser( {
          color: objectDef.color
        } ), new Ext.ux.suncode.ActionAcceptButtonOverrideSettingChooser( {
        	fieldLabel: getTranslation( 'Równoległa akceptacja' ),
            ref: 'acceptConcurrentlyItem',
            value: objectDef.acceptConcurrently,
            listeners: {
            	scope: this,
            	afterrender: function( field ) {
            		if ( objectDef.nextActivity == 'true' ) {
            			setTimeout( function() {
            				field.hide();
            			}, 1 );
            		}
            	},
            	select: function( combo, record, index ) {
            		var acceptConcurrently = combo.getValue();
                    var nextActItem = this.nextActItem;
                    var acceptedNextActsGrid = this.acceptedNextActsItem;

                    if ( acceptConcurrently == 'true' ) {
                        nextActItem.setValue( 'false' );
                        nextActItem.hide();
                        acceptedNextActsGrid.hide();
                    } else {
                        nextActItem.show();
                        acceptedNextActsGrid.show();
                    }
                }
            }
        } ), new Ext.ux.suncode.ActionAcceptButtonOverrideSettingChooser( {
        	fieldLabel: getTranslation( 'Automatyczne przejście' ),
            ref: 'nextActItem',
            value: objectDef.nextActivity,
            listeners: {
            	scope: this,
            	afterrender: function( field ) {
            		if ( objectDef.acceptConcurrently == 'true' ) {
            			setTimeout( function() {
            				field.hide();
            			}, 1 );
            		}
            	},
            	select: function( combo, record, index ) {
            		var nextActivity = combo.getValue();
            		var acceptConcurrentlyItem = this.acceptConcurrentlyItem;
                    var acceptedNextActsGrid = this.acceptedNextActsItem;

                    if ( nextActivity == 'true' ) {
                    	acceptConcurrentlyItem.setValue( 'false' );
                    	acceptConcurrentlyItem.hide();
                    	acceptedNextActsGrid.enable();
                    } else {
                    	acceptConcurrentlyItem.show();
                    	acceptedNextActsGrid.disable();
                    }
                }
            }
        } ), new Ext.ux.suncode.AcceptedNextActivitiesGrid( {
        	ref: 'acceptedNextActsItem',
            anchor: '100%',
            disabled: objectDef.nextActivity != 'true',
            hidden: objectDef.acceptConcurrently == 'true',
            activityNode: activityNode,
            acceptedNextActivities: objectDef.acceptedNextActivities
        } ), {
            xtype: 'panel',
            layout: 'accordion',
            layoutConfig: {
                animate: animationsOn,
                fill: false
            },
            style: {
                marginBottom: '5px'
            },
            bodyStyle: {
                border: 0
            },
            items: [ {
                xtype: 'treepanel',
                height: 250,
                title: getTranslation( 'Akcje' ),
                animCollapse: animationsOn,
                ref: '../actionsTreePanel',
                collapsed: true,
                useArrows: true,
                autoScroll: true,
                animate: animationsOn,
                containerScroll: true,
                frame: false,
                bodyCssClass: 'x-Module-whiteBody',
                tbar: new Ext.Toolbar( {
                    buttons: [ '->', {
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'add' ),
                        tooltip: getTranslation( 'Dodaj akcję' ),
                        handler: function() {
                            var win = new Ext.ux.suncode.ActionAcceptButtonActionWindow( {
                                activityNode: activityNode,
                                treePanel: this.ownerCt.ownerCt
                            } );
                            win.show();
                        }
                    }, {
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'edit' ),
                        tooltip: getTranslation( 'Edytuj akcję' ),
                        handler: function() {
                            var treePanel = this.ownerCt.ownerCt;
                            var selModel = treePanel.getSelectionModel();
                            var actionNode = selModel.getSelectedNode();

                            if ( actionNode && actionNode.isLeaf() ) {
                                var win = new Ext.ux.suncode.ActionAcceptButtonActionWindow( {
                                    activityNode: activityNode,
                                    treePanel: treePanel,
                                    actionNode: actionNode
                                } );
                                win.show();
                            } else {
                                showWarn( getTranslation( 'Wybierz akcję do edycji.' ) );
                            }
                        }
                    }, {
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'delete' ),
                        tooltip: getTranslation( 'Usuń akcję' ),
                        handler: function() {
                            var treePanel = this.ownerCt.ownerCt;
                            var selModel = treePanel.getSelectionModel();
                            var actionNode = selModel.getSelectedNode();

                            if ( actionNode && actionNode.isLeaf() ) {
                                actionNode.remove();
                            } else {
                                showWarn( getTranslation( 'Wybierz akcję do usunięcia.' ) );
                            }
                        }
                    } ]
                } ),
                root: new Ext.tree.AsyncTreeNode( {
                    text: getTranslation( 'Akcje' ),
                    icon: getPluginImgPath( 'contents' ),
                    expanded: true,
                    leaf: false,
                    children: actions
                } ),
                listeners: {
                    scope: this,
                    dblclick: function( node, e ) {
                        if ( node.isLeaf() ) {
                            var win = new Ext.ux.suncode.ActionAcceptButtonActionWindow( {
                                activityNode: activityNode,
                                treePanel: this.actionsTreePanel,
                                actionNode: node
                            } );
                            win.show();
                        }
                    }
                }
            }, {
                xtype: 'editorgrid',
                height: 250,
                store: dcIncludesStore,
                title: addTooltipToField( getTranslation( 'Walidowane dynamiczne listy' ), null, null ),
                ref: '../dcIncludesGrid',
                collapsed: true,
                enableColumnResize: true,
                columnLines: true,
                autoScroll: true,
                frame: false,
                hidden: ( !config.AV || !compatibilityMode.showAcceptButtonDcIncludes( objectDef.dcIncludes ) ),
                colModel: new Ext.grid.ColumnModel( {
                    defaults: {
                        sortable: false,
                        menuDisabled: true
                    },
                    columns: [ {
                        id: 'dataChooserId',
                        header: getTranslation( 'Dynamiczna lista' ),
                        dataIndex: 'dataChooserId',
                        align: 'left',
                        editor: includedDataChoosersChooser,
                        renderer: Ext.util.Format.ComboBoxRenderer( includedDataChoosersChooser )
                    } ]
                } ),
                viewConfig: new Ext.grid.GridView( {
                    forceFit: true
                } ),
                sm: new Ext.grid.RowSelectionModel( {
                    singleSelect: true
                } ),
                tbar: new Ext.Toolbar( {
                    buttons: [ '->', {
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'add' ),
                        tooltip: getTranslation( 'Dodaj' ),
                        handler: function() {
                            var grid = this.ownerCt.ownerCt;
                            var store = grid.getStore();
                            var a = store.recordType;
                            var rec = new a( {
                                dataChooserId: ''
                            } );
                            grid.stopEditing();
                            store.add( rec );
                            store.commitChanges();
                        }
                    }, {
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'delete' ),
                        tooltip: getTranslation( 'Usuń' ),
                        handler: function() {
                            var grid = this.ownerCt.ownerCt;
                            var selModel = grid.getSelectionModel();
                            var rows = selModel.getSelections();
                            if ( rows.length == 0 ) {
                                showWarn( getTranslation( 'Wybierz dynamiczną listę do usunięcia.' ) );
                                return;
                            }
                            removeRowAndMarkNext( grid, rows[0] );
                            grid.getView().refresh();
                        }
                    } ]
                } ),
                listeners: {
                    afteredit: function( e ) {
                        e.record.commit();
                    }
                }
            }, {
                xtype: 'editorgrid',
                height: 250,
                store: dcExcludesStore,
                title: addTooltipToField( getTranslation( 'Niewalidowane dynamiczne listy' ), null, null ),
                ref: '../dcExcludesGrid',
                collapsed: true,
                enableColumnResize: true,
                columnLines: true,
                autoScroll: true,
                frame: false,
                hidden: ( !config.AV || !compatibilityMode.showAcceptButtonDcExcludes( objectDef.dcExcludes ) ),
                colModel: new Ext.grid.ColumnModel( {
                    defaults: {
                        sortable: false,
                        menuDisabled: true
                    },
                    columns: [ {
                        id: 'dataChooserId',
                        header: getTranslation( 'Dynamiczna lista' ),
                        dataIndex: 'dataChooserId',
                        align: 'left',
                        editor: excludedDataChoosersChooser,
                        renderer: Ext.util.Format.ComboBoxRenderer( excludedDataChoosersChooser )
                    } ]
                } ),
                viewConfig: new Ext.grid.GridView( {
                    forceFit: true
                } ),
                sm: new Ext.grid.RowSelectionModel( {
                    singleSelect: true
                } ),
                tbar: new Ext.Toolbar( {
                    buttons: [ '->', {
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'add' ),
                        tooltip: getTranslation( 'Dodaj' ),
                        handler: function() {
                            var grid = this.ownerCt.ownerCt;
                            var store = grid.getStore();
                            var a = store.recordType;
                            var rec = new a( {
                                dataChooserId: ''
                            } );
                            grid.stopEditing();
                            store.add( rec );
                            store.commitChanges();
                        }
                    }, {
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'delete' ),
                        tooltip: getTranslation( 'Usuń' ),
                        handler: function() {
                            var grid = this.ownerCt.ownerCt;
                            var selModel = grid.getSelectionModel();
                            var rows = selModel.getSelections();
                            if ( rows.length == 0 ) {
                                showWarn( getTranslation( 'Wybierz dynamiczną listę do usunięcia.' ) );
                                return;
                            }
                            removeRowAndMarkNext( grid, rows[0] );
                            grid.getView().refresh();
                        }
                    } ]
                } ),
                listeners: {
                    afteredit: function( e ) {
                        e.record.commit();
                    }
                }
            }, new Ext.ux.suncode.IntegrationComponentTable( {
                ref: '../validatorsGrid',
                title: getTranslation( 'Mechanizmy sprawdzające formularz' ),
                height: 250,
                collapsed: true,
                frame: false,
                components: objectDef.validators,
                filteredCategories: validatorsCategories,
                allCategories: validatorsCategories,
                processNode: processNode,
                enableCopyPasteMenu: true,
                conditionalExecutionEnabled: true,
                inactiveEnabled: true,
                parametersWindowTitlePrefix: getTranslation( 'Parametry mechanizmu sprawdzającego formularz' ),
                templateMode: true,
                templates: component.idAssigned ? activityNode.findMergedValidatorsTemplates( objectDef.validatorsTemplates ) : [],
                generateTemplateIdFunction: function() {
                	var counter = 1;
                    var templateId = 'template' + counter;

                    while ( this.findValidatorsTemplate( templateId ) ) {
                        counter++;
                        templateId = 'template' + counter;

                        if ( counter > 999 ) {
                        	templateId = 'template' + Ext.id();
                            break;
                        }
                    }
                    
                    return templateId;
                },
                generateTemplateIdScope: processNode,
                componentsTableTitle: getTranslation( 'Mechanizmy sprawdzające formularz' ),
                noComponentsMessage: getTranslation( 'Brak mechanizmów sprawdzających formularz.' ),
                systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
                getTemplatesFunction: function() {
                	return this.getValidatorsTemplates();
                },
                getTemplatesScope: processNode,
                getTemplateFunction: function( templateId ) {
                	return this.findValidatorsTemplate( templateId );
                },
                getTemplateScope: processNode,
                addTemplateFunction: function( template ) {
                	processNode.addValidatorsTemplate( template );
                	clearArray( this.validatorsTemplates );
                	this.validatorsTemplates.push( {
                		id: template.id,
                		components: []
                	} );
                },
                addTemplateScope: this,
                useTemplateFunction: function( template ) {
                	this.validatorsTemplates.push( {
                		id: template.id,
                		components: []
                	} );
                },
                useTemplateScope: this,
                updateTemplateComponentFunction: function( templateId, templateComponentId, componentId, condition,
                		parameters, extraConfig ) {
                	var integrationComponentService = Ext.ux.suncode.IntegrationComponentService;
                	Ext.each( this.validatorsTemplates, function( template, outerIndex, templates ) {
                		if ( template.id == templateId ) {
                			var validator = processNode.findValidatorsTemplateComponent( templateId, templateComponentId );
                			var current = null;
                			var addNew = false;
                			var modified = false;
                			Ext.each( template.components, function( v, innerIndex, vs ) {
                        		if ( v.templateComponentId == templateComponentId ) {
                        			current = v;
                        			return false;
                        		}
                        	} );
                			
                			if ( Ext.isEmpty( current ) ) {
                				current = {
                					id: componentId,
                					templateComponentId: templateComponentId,
                					customDescription: null,
                					condition: null,
                					confirmation: new Object(),
                					error: new Object(),
                					parameters: new Object()
                				};
                				addNew = true;
                			}
                			
                			if ( validator.customDescription !== extraConfig.customDescription ) {
            					current = Ext.apply( current, {
            						customDescription: extraConfig.customDescription
                    			} );
            					modified = true;
            				}
            				
            				if ( !integrationComponentService.areParametersTheSame(
            						validator.condition, condition ) ) {
            					current = Ext.apply( current, {
                    				condition: condition
                    			} );
            					modified = true;
            				}
            				
            				if ( Ext.isEmpty( validator.confirmation ) && !Ext.isEmpty( extraConfig.confirmation ) &&
            						!Ext.isEmpty( extraConfig.confirmation.title ) ) {
            					current.confirmation = Ext.apply( current.confirmation, {
            						title: extraConfig.confirmation.title
                    			} );
            					modified = true;
            				} else if ( !Ext.isEmpty( validator.confirmation ) && !Ext.isEmpty( extraConfig.confirmation ) &&
            						!integrationComponentService.areParametersTheSame(
            						validator.confirmation.title, extraConfig.confirmation.title ) ) {
            					current.confirmation = Ext.apply( current.confirmation, {
            						title: extraConfig.confirmation.title
                    			} );
            					modified = true;
            				}
            				
            				if ( Ext.isEmpty( validator.confirmation ) && !Ext.isEmpty( extraConfig.confirmation ) &&
            						!Ext.isEmpty( extraConfig.confirmation.message ) ) {
            					current.confirmation = Ext.apply( current.confirmation, {
            						message: extraConfig.confirmation.message
                    			} );
            					modified = true;
            				} else if ( !Ext.isEmpty( validator.confirmation ) && !Ext.isEmpty( extraConfig.confirmation ) &&
            						!integrationComponentService.areParametersTheSame(
            						validator.confirmation.message, extraConfig.confirmation.message ) ) {
            					current.confirmation = Ext.apply( current.confirmation, {
            						message: extraConfig.confirmation.message
                    			} );
            					modified = true;
            				}
            				
            				if ( Ext.isEmpty( validator.error ) && !Ext.isEmpty( extraConfig.error ) &&
            						!Ext.isEmpty( extraConfig.error.message ) ) {
            					current.error = Ext.apply( current.error, {
            						message: extraConfig.error.message
                    			} );
            					modified = true;
            				} else if ( !Ext.isEmpty( validator.error ) && !Ext.isEmpty( extraConfig.error ) &&
            						!integrationComponentService.areParametersTheSame(
            						validator.error.message, extraConfig.error.message ) ) {
            					current.error = Ext.apply( current.error, {
            						message: extraConfig.error.message
                    			} );
            					modified = true;
            				}
            				
            				Ext.iterate( validator.parameters, function( id, param, object ) {
            					if ( !integrationComponentService.areParametersTheSame(
            							param, parameters[id] ) ) {
            						current.parameters[id] = parameters[id];
            						modified = true;
            					}
            				} );

            				if ( addNew ) {
            					if ( modified ) {
            						template.components.push( current );
            					}
            				} else if ( !modified ) {
            					Ext.each( template.components, function( v, innerIndex, vs ) {
                            		if ( v.templateComponentId == templateComponentId ) {
                            			template.components.splice( innerIndex, 1 );
                            			return false;
                            		}
                            	} );
            				}

            				return false;
                		}
                	} );
                },
                updateTemplateComponentScope: this,
                removeTemplateFunction: function( templateId ) {
                	for ( var i = 0; i < this.validatorsTemplates.length; i++ ) {
                		if ( this.validatorsTemplates[i].id == templateId ) {
                			this.validatorsTemplates.splice( i, 1 );
                			return;
                		}
                	}
                },
                removeTemplateScope: this,
                getComponentRegistrationFunction: function( id ) {
                	return Ext.ux.suncode.IntegrationComponentService.getValidatorRegistration( id );
                },
                getComponentRegistrationScope: this,
                copyComponentsFunction: function( components ) {
                	Ext.ux.suncode.Clipboard.setIntegrationComponentValidators( components );
                },
                copyComponentsScope: this,
                handleCopiedComponentsFunction: function( func, scope ) {
                  Ext.ux.suncode.Clipboard.getIntegrationComponentValidators( function( validators ) {
                    if ( Ext.isFunction( func ) ) {
                      scope = !Ext.isEmpty( scope ) ? scope : window;
                      func.apply( scope, [ validators ] );
                    }
                  }, this );
                },
                handleCopiedComponentsScope: this,
                pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentValidatorsMessageType,
                templatesWindowTitle: getTranslation( 'Szablony mechanizmów sprawdzających formularz' ),
                pastView: compatibilityMode.showAcceptButtonOldValidators( objectDef.oldValidators ),
                showPastViewFunction: function() {
                	this.validatorsGrid.hide();
                	this.oldValidatorsGrid.show();
                	this.oldValidatorsGrid.expand();
                },
                showPastViewScope: this
            } ), new Ext.ux.suncode.ClassDefinitionGrid( {
                ref: '../oldValidatorsGrid',
                title: addTooltipToField( getTranslation( 'Mechanizmy sprawdzające formularz' ), null, null, true ),
                height: 250,
                collapsed: true,
                frame: false,
                hidden: true,
                classes: objectDef.oldValidators,
                getClassFunction: mainPanel.getAcceptValidator,
                getClassScope: mainPanel,
                classesChooser: new Ext.ux.suncode.ClassesChooser( {
                    classes: mainPanel.getAcceptValidators()
                } ),
                presentView: true,
                showPresentViewFunction: function() {
                	this.oldValidatorsGrid.hide();
                	this.validatorsGrid.show();
                	this.validatorsGrid.expand();
                },
                showPresentViewScope: this
            } ), new Ext.ux.suncode.IntegrationComponentTable( {
                ref: '../variablesSettersGrid',
                title: getTranslation( 'Mechanizmy uruchamiane po akceptacji' ),
                height: 250,
                collapsed: true,
                frame: false,
                components: objectDef.variablesSetters,
                filteredCategories: variablesSettersCategories,
                allCategories: variablesSettersCategories,
                processNode: processNode,
                enableCopyPasteMenu: true,
                conditionalExecutionEnabled: true,
                inactiveEnabled: true,
                parametersWindowTitlePrefix: getTranslation( 'Parametry mechanizmu uruchamianego po akceptacji' ),
                templateMode: true,
                templates: component.idAssigned ? activityNode.findMergedVariablesSettersTemplates( objectDef.variablesSettersTemplates ) : [],
                generateTemplateIdFunction: function() {
                	var counter = 1;
                    var templateId = 'template' + counter;

                    while ( this.findVariablesSettersTemplate( templateId ) ) {
                        counter++;
                        templateId = 'template' + counter;

                        if ( counter > 999 ) {
                        	templateId = 'template' + Ext.id();
                            break;
                        }
                    }
                    
                    return templateId;
                },
                generateTemplateIdScope: processNode,
                componentsTableTitle: getTranslation( 'Mechanizmy uruchamiane po akceptacji' ),
                noComponentsMessage: getTranslation( 'Brak mechanizmów uruchamianych po akceptacji.' ),
                systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
                getTemplatesFunction: function() {
                	return this.getVariablesSettersTemplates();
                },
                getTemplatesScope: processNode,
                getTemplateFunction: function( templateId ) {
                	return this.findVariablesSettersTemplate( templateId );
                },
                getTemplateScope: processNode,
                addTemplateFunction: function( template ) {
                	processNode.addVariablesSettersTemplate( template );
                	clearArray( this.variablesSettersTemplates );
                	this.variablesSettersTemplates.push( {
                		id: template.id,
                		components: []
                	} );
                },
                addTemplateScope: this,
                useTemplateFunction: function( template ) {
                	this.variablesSettersTemplates.push( {
                		id: template.id,
                		components: []
                	} );
                },
                useTemplateScope: this,
                updateTemplateComponentFunction: function( templateId, templateComponentId, componentId, condition,
                		parameters, extraConfig ) {
                	var integrationComponentService = Ext.ux.suncode.IntegrationComponentService;
                	Ext.each( this.variablesSettersTemplates, function( template, outerIndex, templates ) {
                		if ( template.id == templateId ) {
                			var variablesSetter = processNode.findVariablesSettersTemplateComponent( templateId, templateComponentId );
                			var current = null;
                			var addNew = false;
                			var modified = false;
                			Ext.each( template.components, function( vs, innerIndex, vss ) {
                        		if ( vs.templateComponentId == templateComponentId ) {
                        			current = vs;
                        		}
                        	} );
                			
                			if ( Ext.isEmpty( current ) ) {
                				current = {
                					id: componentId,
                					templateComponentId: templateComponentId,
                					customDescription: null,
                					condition: null,
                					parameters: new Object()
                				};
                				addNew = true;
                			}
                			
                			if ( variablesSetter.customDescription !== extraConfig.customDescription ) {
            					current = Ext.apply( current, {
            						customDescription: extraConfig.customDescription
                    			} );
            					modified = true;
            				}
            				
            				if ( !integrationComponentService.areParametersTheSame(
            						variablesSetter.condition, condition ) ) {
            					current = Ext.apply( current, {
                    				condition: condition
                    			} );
            					modified = true;
            				}
            				
            				Ext.iterate( variablesSetter.parameters, function( id, param, object ) {
            					if ( !integrationComponentService.areParametersTheSame(
            							param, parameters[id] ) ) {
            						current.parameters[id] = parameters[id];
            						modified = true;
            					}
            				} );
            				
            				if ( addNew ) {
            					if ( modified ) {
            						template.components.push( current );
            					}
            				} else if ( !modified ) {
            					Ext.each( template.components, function( v, innerIndex, vs ) {
                            		if ( v.templateComponentId == templateComponentId ) {
                            			template.components.splice( innerIndex, 1 );
                            			return false;
                            		}
                            	} );
            				}
                			
                			return false;
                		}
                	} );
                },
                updateTemplateComponentScope: this,
                removeTemplateFunction: function( templateId ) {
                	for ( var i = 0; i < this.variablesSettersTemplates.length; i++ ) {
                		if ( this.variablesSettersTemplates[i].id == templateId ) {
                			this.variablesSettersTemplates.splice( i, 1 );
                			return;
                		}
                	}
                },
                removeTemplateScope: this,
                getComponentRegistrationFunction: function( id ) {
                	return Ext.ux.suncode.IntegrationComponentService.getVariablesSetterRegistration( id );
                },
                getComponentRegistrationScope: this,
                copyComponentsFunction: function( components ) {
                	Ext.ux.suncode.Clipboard.setIntegrationComponentVariablesSetters( components );
                },
                copyComponentsScope: this,
                handleCopiedComponentsFunction: function( func, scope ) {
                  Ext.ux.suncode.Clipboard.getIntegrationComponentVariablesSetters( function( variablesSetters ) {
                    if ( Ext.isFunction( func ) ) {
                      scope = !Ext.isEmpty( scope ) ? scope : window;
                      func.apply( scope, [ variablesSetters ] );
                    }
                  }, this );
                },
                handleCopiedComponentsScope: this,
                pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentVariablesSettersMessageType,
                templatesWindowTitle: getTranslation( 'Szablony mechanizmów uruchamianych po akceptacji' ),
                pastView: compatibilityMode.showAcceptButtonOldVariablesSetters( objectDef.oldVariablesSetters ),
                showPastViewFunction: function() {
                	this.variablesSettersGrid.hide();
                	this.oldVariablesSettersGrid.show();
                	this.oldVariablesSettersGrid.expand();
                },
                showPastViewScope: this
            } ), new Ext.ux.suncode.ClassDefinitionGrid( {
                ref: '../oldVariablesSettersGrid',
                title: addTooltipToField( getTranslation( 'Mechanizmy uruchamiane po akceptacji' ), null, null, true ),
                height: 250,
                collapsed: true,
                frame: false,
                hidden: true,
                classes: objectDef.oldVariablesSetters,
                getClassFunction: mainPanel.getVariablesSetter,
                getClassScope: mainPanel,
                classesChooser: new Ext.ux.suncode.ClassesChooser( {
                    classes: mainPanel.getVariablesSetters()
                } ),
                presentView: true,
                showPresentViewFunction: function() {
                	this.oldVariablesSettersGrid.hide();
                	this.variablesSettersGrid.show();
                	this.variablesSettersGrid.expand();
                },
                showPresentViewScope: this
            } ), new Ext.ux.suncode.IntegrationComponentTable( {
                ref: '../formActionsGrid',
                title: getTranslation( 'Akcje formularza' ),
                height: 250,
                collapsed: true,
                frame: false,
                components: objectDef.formActions,
                filteredCategories: Ext.ux.suncode.IntegrationComponentService.filterCategoriesByDestination(
                    formActionsCategories, Ext.ux.suncode.IntegrationComponentService.BUTTON_DESTINATION, true ),
                allCategories: formActionsCategories,
                processNode: processNode,
                pasteComponentsValidation: {
                    func: function( variableId ) {
                        var presentVariableIds = this.getPresentVariableIds();

                        return presentVariableIds.includes( variableId );
                    },
                    scope: drawingPanel,
                    invalidMessagePart: getTranslation( 'niewystępujących na formularzu' )
                },
                enableCopyPasteMenu: true,
                conditionalExecutionEnabled: true,
                inactiveEnabled: true,
                parametersWindowTitlePrefix: getTranslation( 'Parametry akcji formularza' ),
                availableVariables: config.availableVariables,
                missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
                missingVariablesValidatorScope: config.missingVariablesValidatorScope,
                systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
                getBindToFunction: function( component ) {
                    var buttonDestination = Ext.ux.suncode.IntegrationComponentService.BUTTON_DESTINATION;
                    var destination = Ext.ux.suncode.IntegrationComponentService.getDestination( component, buttonDestination );

                    return !Ext.isEmpty( destination ) ? {
                        id: destination.bindTo,
                        value: this.actionNameItem.getValue()
                    } : null;
                },
                getBindToScope: this,
                getComponentRegistrationFunction: function( id ) {
                	return Ext.ux.suncode.IntegrationComponentService.getFormActionRegistration( id );
                },
                getComponentRegistrationScope: this,
                copyComponentsFunction: function( components ) {
                	Ext.ux.suncode.Clipboard.setIntegrationComponentFormActions( components );
                },
                copyComponentsScope: this,
                handleCopiedComponentsFunction: function( func, scope ) {
                  Ext.ux.suncode.Clipboard.getIntegrationComponentFormActions( function( formActions ) {
                    if ( Ext.isFunction( func ) ) {
                      var components = new Array();

                      if ( !Ext.isEmpty( formActions ) ) {
                        var service = Ext.ux.suncode.IntegrationComponentService;
                        var categories = Ext.getCmp( 'main_panel' ).getFormActionsIntegrationComponentCategories();

                        Ext.each( formActions, function( component, index, allComponents ) {
                          var componentDef = service.getIntegrationComponent( categories, component.id );

                          if ( !Ext.isEmpty( componentDef ) && service.hasDestination( componentDef, service.BUTTON_DESTINATION, true ) ) {
                            components.push( component );
                          }
                        } );
                      }

                      scope = !Ext.isEmpty( scope ) ? scope : window;
                      func.apply( scope, [ components ] );
                    }
                  }, this );
                },
                handleCopiedComponentsScope: this,
                pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentFormActionsMessageType,
                validateFieldFunction: config.validateIntegrationComponentFieldFunction,
                validateFieldScope: config.validateIntegrationComponentFieldScope,
                validateRowFunction: drawingPanel.validateVariablesInIntegrationComponent,
                validateRowScope: drawingPanel,
                destinationType: Ext.ux.suncode.IntegrationComponentService.BUTTON_DESTINATION,
                acceptButton: true,
                buttonId: objectDef.actionName
            } ), new Ext.ux.suncode.IntegrationComponentTable( {
                ref: '../eventActionsGrid',
                title: getTranslation( 'Zdarzenia' ),
                height: 250,
                collapsed: true,
                frame: false,
                eventMode: true,
                eventTypes: eventTypes,
                components: objectDef.eventActions,
                filteredCategories: eventActionsCategories,
                allCategories: eventActionsCategories,
                processNode: processNode,
                pasteComponentsValidation: {
                  func: function( variableId ) {
                    var presentVariableIds = this.getPresentVariableIds();

                    return presentVariableIds.includes( variableId );
                  },
                  scope: drawingPanel,
                  invalidMessagePart: getTranslation( 'niewystępujących na formularzu' )
                },
                enableCopyPasteMenu: true,
                conditionalExecutionEnabled: true,
                inactiveEnabled: true,
                parametersWindowTitlePrefix: getTranslation( 'Parametry zdarzenia' ),
                availableVariables: config.availableVariables,
                missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
                missingVariablesValidatorScope: config.missingVariablesValidatorScope,
                systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
                getComponentRegistrationFunction: function( id ) {
                  return Ext.ux.suncode.IntegrationComponentService.getEventActionRegistration( id );
                },
                getComponentRegistrationScope: this,
                copyComponentsFunction: function( components ) {
                  Ext.ux.suncode.Clipboard.setIntegrationComponentEventActions( components );
                },
                copyComponentsScope: this,
                handleCopiedComponentsFunction: function( func, scope ) {
                  Ext.ux.suncode.Clipboard.getIntegrationComponentEventActions( function( eventActions ) {
                    if ( Ext.isFunction( func ) ) {
                      scope = !Ext.isEmpty( scope ) ? scope : window;
                      func.apply( scope, [ eventActions ] );
                    }
                  }, this );
                },
                handleCopiedComponentsScope: this,
                pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentEventActionsMessageType,
                validateFieldFunction: config.validateIntegrationComponentFieldFunction,
                validateFieldScope: config.validateIntegrationComponentFieldScope,
                validateRowFunction: drawingPanel.validateVariablesInIntegrationComponent,
                validateRowScope: drawingPanel
            } ) ]
        }, new Ext.ux.suncode.SpecificationDescriptionArea( {
            processNode: activityNode.parentNode,
            description: specification.description
        } ) ]
    }, config );

    Ext.ux.suncode.ActionAcceptButtonDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActionAcceptButtonDefPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActionAcceptButtonDefPanel.superclass.initComponent.call( this );
    },
    editFormButton: function() {
        var btnDef = this.readDef();
        if ( !btnDef ) {
            return;
        }

        var component = this.initialConfig.component;
        var item = component.items.first();
        var objectDef = component.definition.objectDef;
        Ext.apply( objectDef, btnDef );

        item.setText( objectDef.buttonName );
        item.setIconClass( Ext.ux.suncode.UtilService.resolveIconCls( objectDef.icon ) );

        Ext.ux.suncode.UtilService.resolveFormButtonColor(item, objectDef.color);

        if ( !Ext.isEmpty( objectDef.destination ) && objectDef.destination == 'GROUPFORM' ) {
            item.addClass( 'x-Module-hiddenFormObject' );
        } else {
            item.removeClass( 'x-Module-hiddenFormObject' );
        }
        component.idAssigned = true;

        var acceptancesPanel = Ext.getCmp( 'activity_properties_acceptances_panel' );

        if ( acceptancesPanel ) {
            acceptancesPanel.reloadActivityAcceptButtonsChooser();
            acceptancesPanel.reloadAcceptancesStore();
        }

        var activityNode = this.initialConfig.activityNode;
        var specification = this.readSpecification();
        Ext.ux.suncode.DocumentationService.editButtonSpecification( activityNode, btnDef.actionName, btnDef.actionName, specification );

        var drawingPanel = Ext.getCmp( 'drawing_panel' );
        drawingPanel.analyzeVariablesMissingInIntegrationComponents( component );
        drawingPanel.analyzeFormActionsOverlay( component );
        drawingPanel.analyzeEventActionsOverlay( component );
        drawingPanel.recalculateLayoutPack( component.ownerCt );
        this.ownerCt.closeDefWindow();
    },
    readDef: function() {
        var objectDef = this.initialConfig.component.definition.objectDef;
        var btnDef = new Object();
        var actionName = this.actionNameItem.getValue();
        var buttonName = this.buttonNameItem.getValue();
        var forwardTo = this.forwardToItem.items.first().getValue();

        if ( Ext.isEmpty( actionName ) || Ext.isEmpty( buttonName ) ) {
            showWarn( getTranslation( 'Podaj nazwę przycisku.' ) );
            return null;
        } else if ( this.checkDuplication( actionName ) ) {
            showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o tym samym identyfikatorze został już dodany do formularza.' ) );
            return null;
        }

        var actionsRootNode = this.actionsTreePanel.getRootNode();
        var actions = new Array();
        if ( actionsRootNode.hasChildNodes() ) {
            actionsRootNode.eachChild( function( actionNode ) {
                actions.push( actionNode.attributes.action );
            } );
        }
        
        var oldValidators = this.oldValidatorsGrid.readClasses();
        if ( !oldValidators ) {
            return null;
        }
        
        var oldVariablesSetters = this.oldVariablesSettersGrid.readClasses();
        if ( !oldVariablesSetters ) {
            return null;
        }
        
        var nextActivity = this.nextActItem.getValue();
        var acceptedNextActivities = new Array();

        if ( nextActivity == 'true' ) {
        	this.acceptedNextActsItem.getStore().each( function( rec ) {
                var nextActDefId = rec.get( 'activityDefId' );

                if ( !Ext.isEmpty( nextActDefId ) ) {
                    acceptedNextActivities.push( {
                        activityDefId: nextActDefId
                    } );
                }
            } );
        }

        btnDef = Ext.apply( {
            actionName: actionName,
            buttonName: buttonName,
            jsAction: this.jsActionItem.items.first().getValue(),
            checkForm: this.checkFormItem.getValue(),
            saveBeforeAccept: this.saveBeforeAcceptItem.getValue(),
            destination: this.destinationItem.items.first().getValue(),
            forwardTo: forwardTo,
            forwardToChanged: forwardTo !== objectDef.forwardTo && !this.forwardToReset,
            forwardToReset: this.forwardToReset,
            previousForwardTo: objectDef.forwardTo,
            icon: this.iconsChooser.getValue(),
            color: this.colorsChooser.getValue(),
            acceptConcurrently: this.acceptConcurrentlyItem.getValue(),
            nextActivity: nextActivity,
            acceptedNextActivities: acceptedNextActivities,
            actions: actions,
            dcIncludes: this.readDCValidationGrid( this.dcIncludesGrid ),
            dcExcludes: this.readDCValidationGrid( this.dcExcludesGrid ),
            validators: this.validatorsGrid.readComponents(),
            oldValidators: oldValidators,
            validatorsTemplates: this.validatorsTemplates,
            variablesSetters: this.variablesSettersGrid.readComponents(),
            oldVariablesSetters: oldVariablesSetters,
            variablesSettersTemplates: this.variablesSettersTemplates,
            formActions: this.formActionsGrid.readComponents(),
            eventActions: this.eventActionsGrid.readComponents(),
            translations: Ext.ux.suncode.I18NService.getPackageTranslationsFromCaches( [ this.buttonNameItem ] ),
            genre: 'ACTION_ACCEPT_BUTTON'
        }, btnDef );
        
        return btnDef;
    },
    checkDuplication: function( actionName ) {
        var component = this.initialConfig.component;

        if ( component.idAssigned && component.definition.objectDef.actionName == actionName ) {
            return false;
        } else {
            var drawingPanel = Ext.getCmp( 'drawing_panel' );
            var isDuplicated = false;

            drawingPanel.items.each( function( item ) {
                item.items.each( function( subitem ) {
                    var definition = subitem.definition;
                    var objectDef = definition.objectDef;

                    switch ( objectDef.genre ) {
	                    case 'VARIABLE':
	                        if ( subitem.idAssigned &&
	                        		( objectDef.varId == actionName || objectDef.varId == actionName + '_button' ) ) {
	                            isDuplicated = true;
	                            return false;
	                        }
	                        break;
                        case 'VARIABLE_SET':
                        	if ( subitem.idAssigned ) {
                        		if ( objectDef.varId == actionName || objectDef.varId == actionName + '_button' ) {
                                    isDuplicated = true;
                                    return false;
                                } else {
                                    var columns = objectDef.columns;

                                    for ( var i = 0; i < columns.length; i++ ) {
                                        var column = columns[i];

                                        if ( column.varId == actionName || column.varId == actionName + '_button' ) {
                                            isDuplicated = true;
                                            return false;
                                        }
                                    }
                                    
                                    var dtButtons = objectDef.DTButtons;

                                    for ( var i = 0; i < dtButtons.length; i++ ) {
                                        var dtButton = dtButtons[i];

                                        if ( dtButton.buttonId == actionName || dtButton.buttonId == actionName + '_button' ) {
                                            isDuplicated = true;
                                            return false;
                                        }
                                    }
                                }
                            }
                        	break;
                        case 'LABEL':
                            if ( subitem.idAssigned && objectDef.id == actionName + '_button' ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        case 'HTTP_LINK':
                        case 'ACTION_ACCEPT_BUTTON':
                        case 'GENERATE_PDF_BUTTON':
                        case 'ADD_FILE_BUTTON':
                        case 'BARCODE_PRINT':
                            if ( subitem.idAssigned && objectDef.actionName == actionName ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        default:
                            break;
                    }
                } );

                if ( isDuplicated ) {
                    return false;
                }
            } );

            return isDuplicated;
        }
    },
    readDCValidationGrid: function( grid ) {
        var dcs = new Array();
        var store = grid.getStore();

        store.each( function( rec ) {
            var dataChooserId = rec.get( 'dataChooserId' );

            if ( !Ext.isEmpty( dataChooserId ) ) {
                dcs.push( {
                    dataChooserId: dataChooserId
                } );
            }
        } );

        return dcs;
    },
    buttonNameTyped: function( field ) {
        if ( !this.initialConfig.component.idAssigned ) {
            var actionNameItem = this.actionNameItem;
            var oldActionName = actionNameItem.getValue();
            var actionName = generateId( field.getValue() );
            actionNameItem.setValue( actionName );
            this.changeActionParam( oldActionName, actionName );
            this.editFormActionsBindTo();
        }
    },
    editFormActionsBindTo: function() {
        this.formActionsGrid.editBindToParameter();
    },
    changeActionParam: function( oldActionName, actionName ) {
        var forwardToChooser = this.forwardToItem.items.first();

        if ( Ext.isEmpty( forwardToChooser.getValue() ) ) {
            return;
        }

        var actionsRootNode = this.actionsTreePanel.getRootNode();
        if ( actionsRootNode.hasChildNodes() ) {
            actionsRootNode.eachChild( function( actionNode ) {
                var attributions = actionNode.attributes.action.attributions;
                for ( var i = 0; i < attributions.length; i++ ) {
                    var attribution = attributions[i];
                    if ( attribution.varId == 'Action' && attribution.value == oldActionName ) {
                        attribution.value = actionName;
                        return false;
                    }
                }
            } );
        }
    },
    clearForwardTo: function() {
        var forwardToChooser = this.forwardToItem.items.first();

        if ( Ext.isEmpty( forwardToChooser.getValue() ) ) {
            return;
        }

        var oldActionName = this.actionNameItem.getValue();
        forwardToChooser.setValue( '' );

        var actionsRootNode = this.actionsTreePanel.getRootNode();
        if ( actionsRootNode.hasChildNodes() ) {
            actionsRootNode.eachChild( function( actionNode ) {
                var attributions = actionNode.attributes.action.attributions;
                for ( var i = 0; i < attributions.length; i++ ) {
                    var attribution = attributions[i];
                    if ( attribution.varId == 'Action' && attribution.value == oldActionName ) {
                        if ( attributions.length == 1 ) {
                            actionNode.remove();
                        } else {
                            attributions.splice( i, 1 );
                            actionNode.setText( getActionAcceptButtonActionNodeText( attributions, actionNode.attributes.action.conditions ) );
                        }

                        return false;
                    }
                }
            } );
        }

        this.forwardToReset = true;
    },
    clearDestination: function() {
        var destinationChooser = this.destinationItem.items.first();
        destinationChooser.setValue( '' );
    },
    generateDefaultJsActionName: function() {
        var buttonName = this.buttonNameItem.getValue();

        if ( Ext.isEmpty( buttonName ) ) {
            showWarn( 'Podaj nazwę przycisku.' );
            return;
        }

        var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
        var packageName = packageNode.attributes.packageName;
        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var processName = processNode.attributes.processName;
        var activityName = activityNode.attributes.activityName;
        var name = generateId( packageName );
        name += '_';
        name += generateId( processName );
        name += '_';
        name += generateId( activityName );
        name += '_';
        name += generateId( buttonName );

        this.jsActionItem.items.first().setValue( name );
    },
    showJSCodingWindow: function() {
        var functionName = this.jsActionItem.items.first().getValue();

        if ( Ext.isEmpty( functionName ) ) {
            showWarn( getTranslation( 'Podaj nazwę funkcji.' ) );
            return;
        }

        if ( functionName.endsWith( '()' ) ) {
            functionName = functionName.substring( 0, functionName.length - 2 );
        }

        var win = new Ext.ux.suncode.JsCodingWindow( {
            winTitle: getTranslation( 'Definicja funkcji przycisku akceptacji' ),
            sourceCodeType: 'JS_ACTION_ACCEPT_BUTTON',
            functionName: functionName,
            options: {}
        } );
        win.show();
    },
    readSpecification: function() {
        var specification = new Object();
        specification = Ext.apply( {
            description: this.specificationDescriptionItem.getSpecificationDescription()
        }, specification );

        return specification;
    }
} );