Ext.ux.suncode.SpecificationDescriptionArea = function( config ) {
    var mainPanel = Ext.getCmp( 'main_panel' );
    var processNode = config.processNode;
    var description = config.description;

    config = Ext.apply( {
        title: getTranslation( 'Opis specyfikacyjny' ),
        ref: 'specificationDescriptionItem',
        hidden: !mainPanel.getDocumentationView(),
        items: [ {
            xtype: 'panel',
            height: 150,
            bodyCssClass: 'x-Module-specificationDescriptionBody',
            ref: 'preview',
            tbar: new Ext.Toolbar( {
                buttons: [ {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'edit' ),
                    tooltip: getTranslation( 'Edytuj' ),
                    handler: this.showEditor,
                    scope: this
                } ]
            } ),
            html: this.formatDescription( processNode, description )
        }, {
            xtype: 'panel',
            height: 150,
            layout: 'fit',
            hidden: true,
            ref: 'editor',
            tbar: new Ext.Toolbar( {
                buttons: [ {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'specification' ),
                    tooltip: getTranslation( 'Podgląd opisu' ),
                    handler: this.showPreview,
                    scope: this
                } ]
            } ),
            items: [ {
                xtype: 'textarea',
                name: config.fieldName ? config.fieldName : 'specificationDescription',
                anchor: '100%',
                enableKeyEvents: true,
                value: description,
                ref: 'editorArea',
                listeners: {
                    scope: this,
                    keyup: this.onKeyUp
                }
            } ]
        } ]
    }, config );

    Ext.ux.suncode.SpecificationDescriptionArea.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.SpecificationDescriptionArea, Ext.form.FieldSet, {
    initComponent: function() {
        Ext.ux.suncode.SpecificationDescriptionArea.superclass.initComponent.call( this );
    },
    variablePrefix: 'variable_',
    activityPrefix: 'activity_',
    participantPrefix: 'participant_',
    attachmentNamePrefix: 'attachmentname_',
    attachmentPreviewPrefix: 'attachmentpreview_',
    formatDescription: function( processNode, description ) {
        if ( !Ext.isEmpty( description ) ) {
            var style = this.buildFormattedStyle();
            description = description.replaceAll( '\n', '<br>' );
            description = this.formatProcessVariables( processNode, description, style );
            description = this.formatActivities( processNode, description, style );
            description = this.formatParticipants( processNode, description, style );
            description = this.formatAttachments( processNode, description, style );
        }

        return description;
    },
    buildFormattedStyle: function() {
        var mainPanel = Ext.getCmp( 'main_panel' );
        var style = 'cursor: pointer;';
        style += 'color: ' + mainPanel.getDistinctionColor() + ';';

        return style;
    },
    formatProcessVariables: function( processNode, description, style ) {
        var processDefId = processNode.attributes.processDefId;
        var regex = new RegExp( '{' + this.variablePrefix + '\\w+}' );
        var matches = null;

        while ( !Ext.isEmpty( ( matches = description.match( regex ) ) ) ) {
            for ( var i = 0; i < matches.length; i++ ) {
                var match = matches[i];
                var varId = match.substring( 1 + this.variablePrefix.length, match.length - 1 );
                var variable = processNode.findVariable( varId );

                if ( !Ext.isEmpty( variable ) ) {
                    var replacement = '<span style="' + style + '" onclick="showProcessVariableDefinition(\'' + processDefId + '\', \'' + varId
                                    + '\');">' + variable.name + '</span>';

                    description = description.replaceAll( match, replacement );
                } else {
                    description = description.replaceAll( match, varId );
                }
            }
        }

        return description;
    },
    formatActivities: function( processNode, description, style ) {
        var processDefId = processNode.attributes.processDefId;
        var regex = new RegExp( '{' + this.activityPrefix + '\\w+}' );
        var matches = null;

        while ( !Ext.isEmpty( ( matches = description.match( regex ) ) ) ) {
            for ( var i = 0; i < matches.length; i++ ) {
                var match = matches[i];
                var activityDefId = match.substring( 1 + this.activityPrefix.length, match.length - 1 );
                var activityNode = processNode.findChild( 'activityDefId', activityDefId );

                if ( !Ext.isEmpty( activityNode ) ) {
                    var replacement = '<span style="' + style + '" onclick="showActivityDefinition(\'' + processDefId + '\', \'' + activityDefId
                                    + '\');">' + activityNode.attributes.activityName + '</span>';

                    description = description.replaceAll( match, replacement );
                } else {
                    description = description.replaceAll( match, activityDefId );
                }
            }
        }

        return description;
    },
    formatParticipants: function( processNode, description, style ) {
        var processDefId = processNode.attributes.processDefId;
        var regex = new RegExp( '{' + this.participantPrefix + '\\w+}' );
        var matches = null;

        while ( !Ext.isEmpty( ( matches = description.match( regex ) ) ) ) {
            for ( var i = 0; i < matches.length; i++ ) {
                var match = matches[i];
                var roleId = match.substring( 1 + this.participantPrefix.length, match.length - 1 );
                var participant = processNode.findRole( roleId );

                if ( !Ext.isEmpty( participant ) ) {
                    var replacement = '<span style="' + style + '" onclick="showParticipantDefinition(\'' + processDefId + '\', \'' + roleId
                                    + '\');">' + participant.roleName + '</span>';

                    description = description.replaceAll( match, replacement );
                } else {
                    description = description.replaceAll( match, roleId );
                }
            }
        }

        return description;
    },
    formatAttachments: function( processNode, description, style ) {
      description = this.formatAttachmentsByPrefix( processNode, description, style, this.attachmentNamePrefix );
      description = this.formatAttachmentsByPrefix( processNode, description, style, this.attachmentPreviewPrefix );

      return description;
    },
    formatAttachmentsByPrefix: function( processNode, description, style, prefix ) {
      var attachmentDirectory = processNode.attributes.attachmentDirectory;
      var regex = new RegExp( '{' + prefix + '\\w+}' );
      var matches = null;

      while ( !Ext.isEmpty( ( matches = description.match( regex ) ) ) ) {
        for ( var i = 0; i < matches.length; i++ ) {
          var match = matches[i];
          var attachmentId = match.substring( 1 + prefix.length, match.length - 1 );
          var attachment = Ext.ux.suncode.DocumentationService.getAttachment( processNode, attachmentId );

          if ( !Ext.isEmpty( attachment ) ) {
            var replacement = '<span style="' + style + '" onclick="downloadAttachment(\'' + attachmentDirectory + '\', \'' + attachment.fileName
                + '\');">' + attachment.name + '</span>';

            description = description.replaceAll( match, replacement );
          } else {
            description = description.replaceAll( match, attachmentId );
          }
        }
      }

      return description;
    },
    showEditor: function() {
        this.preview.hide();
        this.editor.show();
        this.editor.editorArea.focus();
    },
    showPreview: function() {
        this.editor.hide();
        this.setPreviewDescription();
        this.preview.show();
    },
    setPreviewDescription: function() {
        var description = this.editor.editorArea.getValue();
        var processNode = this.initialConfig.processNode;
        this.preview.update( this.formatDescription( processNode, description ) );
    },
    onKeyUp: function( field, e ) {
        var key = e.getKey();

        if ( e.ctrlKey && key == e.SPACE ) {
            this.showHelpMenu( field, false );
        } else if ( e.shiftKey && key == 219 ) {
            this.showHelpMenu( field, true );
        }
    },
    showHelpMenu: function( field, bracket ) {
        var processVariablesMenuItems = new Array();
        var activitiesMenuItems = new Array();
        var participantsMenuItems = new Array();
        var attachmentsMenuItems = new Array();
        var processNode = this.initialConfig.processNode;
        var variables = processNode.attributes.variables;
        var participants = processNode.attributes.participants;
        var attachments = processNode.attributes.specification.attachmentSpecifications;
        var filterMarker = bracket ? '{' : ' ';
        var filter = field.getPreviousText( filterMarker );

        if ( !Ext.isEmpty( variables ) ) {
        	var anySuggestion = false;
        	
            for ( var i = 0; i < variables.length; i++ ) {
                var variable = variables[i];
                var suggestion = ( !Ext.isEmpty( filter ) && variable.name.toLowerCase().includes( filter.toLowerCase() ) );

                processVariablesMenuItems.push( this.buildProcessVariableMenuItem( variable, bracket, filter, suggestion ) );
                
                if ( suggestion ) {
                	anySuggestion = true;
                }
            }
            
            if ( anySuggestion ) {
            	this.applySuggestions( processVariablesMenuItems );
            }
        } else {
        	processVariablesMenuItems.push( this.buildEmptyListMenuItem() );
        }

        if ( processNode.hasChildNodes() ) {
        	var anySuggestion = false;
        	
            processNode.eachChild( function( activityNode ) {
            	var activityName = activityNode.attributes.activityName;
            	var suggestion = ( !Ext.isEmpty( filter ) && activityName.toLowerCase().includes( filter.toLowerCase() ) );
            	
            	activitiesMenuItems.push( this.buildActivityMenuItem( activityNode, bracket, filter, suggestion ) );
            	
            	if ( suggestion ) {
                	anySuggestion = true;
                }
            }, this );
            
            if ( anySuggestion ) {
            	this.applySuggestions( activitiesMenuItems );
            }
        } else {
        	activitiesMenuItems.push( this.buildEmptyListMenuItem() );
        }
        
        if ( !Ext.isEmpty( participants ) ) {
        	var anySuggestion = false;
        	
            for ( var i = 0; i < participants.length; i++ ) {
                var participant = participants[i];
                var suggestion = ( !Ext.isEmpty( filter ) && participant.roleName.toLowerCase().includes( filter.toLowerCase() ) );

                participantsMenuItems.push( this.buildParticipantMenuItem( participant, bracket, filter, suggestion ) );
                
                if ( suggestion ) {
                	anySuggestion = true;
                }
            }
            
            if ( anySuggestion ) {
            	this.applySuggestions( participantsMenuItems );
            }
        } else {
        	participantsMenuItems.push( this.buildEmptyListMenuItem() );
        }

        if ( !Ext.isEmpty( attachments ) ) {
          var anySuggestion = false;

          for ( var i = 0; i < attachments.length; i++ ) {
            var attachment = attachments[i];
            var attachmentName = attachment.name;
            var suggestion = ( !Ext.isEmpty( filter ) && attachmentName.toLowerCase().includes( filter.toLowerCase() ) );

            if ( this.shouldBuildAttachmentOptionsMenuItem( attachment.fileName ) ) {
              attachmentsMenuItems.push( this.buildAttachmentOptionsMenuItem( attachment, bracket, filter, suggestion ) );
            } else {
              attachmentsMenuItems.push( this.buildAttachmentNameMenuItem( attachment, bracket, filter, suggestion, attachment.name ) );
            }

            if ( suggestion ) {
              anySuggestion = true;
            }
          }

          if ( anySuggestion ) {
            this.applySuggestions( attachmentsMenuItems );
          }
        } else {
          attachmentsMenuItems.push( this.buildEmptyListMenuItem() );
        }
        
        var menu = new Ext.menu.Menu( {
            items: [ {
                text: getTranslation( 'Zmienne procesu' ),
                menu: new Ext.menu.Menu( {
                    items: processVariablesMenuItems
                } )
            }, {
                text: getTranslation( 'Zadania' ),
                menu: new Ext.menu.Menu( {
                    items: activitiesMenuItems
                } )
            }, {
                text: getTranslation( 'Uczestnicy' ),
                menu: new Ext.menu.Menu( {
                    items: participantsMenuItems
                } )
            }, {
              text: getTranslation( 'Załączniki' ),
              menu: new Ext.menu.Menu( {
                items: attachmentsMenuItems
              } )
            } ]
        } );
        menu.showAt( field.getPosition() );
    },
    buildProcessVariableMenuItem: function( variable, bracket, filter, suggestion ) {
        return new Ext.menu.Item( {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'variable' ),
            text: variable.name,
            variableId: variable.id,
            bracket: bracket,
            filter: filter,
            suggestion: suggestion,
            scope: this,
            handler: this.onProcessVariableMenuItemClick
        } );
    },
    buildActivityMenuItem: function( activityNode, bracket, filter, suggestion ) {
        var icon = '';

        switch ( activityNode.attributes.activityType ) {
            case Ext.ux.suncode.Constants.ROUTE:
                icon = getPluginImgPath( 'route_small' );
                break;
            case Ext.ux.suncode.Constants.ACTIVITY:
                icon = getPluginImgPath( 'activity_small' );
                break;
            case Ext.ux.suncode.Constants.TOOL:
                icon = getPluginImgPath( 'tool_small' );
                break;
            case Ext.ux.suncode.Constants.SUBFLOW:
                icon = getPluginImgPath( 'subflow_small' );
                break;
            default:
                break;
        }

        return new Ext.menu.Item( {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: icon,
            text: activityNode.attributes.activityName,
            activityDefId: activityNode.attributes.activityDefId,
            bracket: bracket,
            filter: filter,
            suggestion: suggestion,
            scope: this,
            handler: this.onActivityMenuItemClick
        } );
    },
    buildParticipantMenuItem: function( participant, bracket, filter, suggestion ) {
        var icon = '';

        switch ( participant.roleType ) {
            case 'ROLE':
                icon = getPluginImgPath( 'role' );
                break;
            case 'SYSTEM':
                icon = getPluginImgPath( 'system' );
                break;
            case 'RESOURCE':
                icon = getPluginImgPath( 'buffer' );
                break;
            default:
                break;
        }

        return new Ext.menu.Item( {
            xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: icon,
            text: participant.roleName,
            roleId: participant.roleId,
            bracket: bracket,
            filter: filter,
            suggestion: suggestion,
            scope: this,
            handler: this.onParticipantMenuItemClick
        } );
    },
    shouldBuildAttachmentOptionsMenuItem: function( fileName ) {
      return fileName.toLowerCase().endsWith( '.jpg' )
          || fileName.toLowerCase().endsWith( '.jpeg' )
          || fileName.toLowerCase().endsWith( '.png' );
    },
    buildAttachmentOptionsMenuItem: function( attachment, bracket, filter, suggestion ) {
      return new Ext.menu.Item( {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'attachment' ),
        text: attachment.name,
        menu: new Ext.menu.Menu( {
          items: [ this.buildAttachmentNameMenuItem( attachment, bracket, filter, suggestion, getTranslation( 'Wstaw nazwę' ) ),
            this.buildAttachmentPreviewMenuItem( attachment, bracket, filter, suggestion ) ]
        } )
      } );
    },
    buildAttachmentNameMenuItem: function( attachment, bracket, filter, suggestion, label ) {
      return new Ext.menu.Item( {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'attachment' ),
        text: label,
        attachmentId: attachment.id,
        bracket: bracket,
        filter: filter,
        suggestion: suggestion,
        scope: this,
        handler: this.onAttachmentNameMenuItemClick
      } );
    },
    buildAttachmentPreviewMenuItem: function( attachment, bracket, filter, suggestion ) {
      return new Ext.menu.Item( {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'attachment' ),
        text: getTranslation( 'Wstaw podgląd' ),
        attachmentId: attachment.id,
        bracket: bracket,
        filter: filter,
        suggestion: suggestion,
        scope: this,
        handler: this.onAttachmentPreviewMenuItemClick
      } );
    },
    buildEmptyListMenuItem: function() {
        return {
            xtype: 'menuitem',
            cls: 'x-btn-text',
            text: getTranslation( 'Pusta lista' ),
            disabled: true
        };
    },
    applySuggestions: function( array ) {
    	var me = this;
    	array.sort( function( a, b ) {
    		return me.sortMenuItems( a, b );
    	} );
    	
    	Ext.each( array, function( element, index, elements ) {
    		if ( !element.suggestion ) {
    			array.splice( index, 0, new Ext.menu.Separator() );
    			array.splice( index, 0, new Ext.form.Label( {
    	    		text: getTranslation( 'Pozostałe' ),
    	    		cls: 'x-Module-bold'
    	    	} ) );
    			return false;
    		}
    	} );
    	
    	array.unshift( new Ext.menu.Separator() );
    	array.unshift( new Ext.form.Label( {
    		text: getTranslation( 'Sugestie' ),
    		cls: 'x-Module-bold'
    	} ) );
    },
    sortMenuItems: function( a, b ) {
    	if ( a.suggestion ) {
        if ( b.suggestion ) {
          if ( a.text > b.text ) {
            return 1;
          }
        }
      } else if ( b.suggestion ) {
        return 1;
      } else if ( a.text > b.text ) {
        return 1;
      }
      return -1;
    },
    onProcessVariableMenuItemClick: function( item, e ) {
        this.onMenuItemClick( this.variablePrefix, item.variableId, item.bracket, item.filter );
    },
    onActivityMenuItemClick: function( item, e ) {
        this.onMenuItemClick( this.activityPrefix, item.activityDefId, item.bracket, item.filter );
    },
    onParticipantMenuItemClick: function( item, e ) {
        this.onMenuItemClick( this.participantPrefix, item.roleId, item.bracket, item.filter );
    },
    onAttachmentNameMenuItemClick: function( item, e ) {
      this.onMenuItemClick( this.attachmentNamePrefix, item.attachmentId, item.bracket, item.filter );
    },
    onAttachmentPreviewMenuItemClick: function( item, e ) {
      this.onMenuItemClick( this.attachmentPreviewPrefix, item.attachmentId, item.bracket, item.filter );
    },
    onMenuItemClick: function( prefix, id, bracket, filter ) {
        var text = bracket ? '' : '{';
        text += prefix + id + '}';

        this.editor.editorArea.insertAtCursor( text, filter );
    },
    getSpecificationDescription: function() {
        return this.editor.editorArea.getValue();
    },
    setSpecificationDescription: function( description ) {
        this.editor.editorArea.setValue( description );
        this.setPreviewDescription();
    }
} );