Ext.ux.suncode.DocumentationService = {
    databaseTableIdName: 'name',
    integrationIdName: 'name',
    programmingTaskIdName: 'name',
    scheduledTaskIdName: 'name',
    documentClassIdName: 'name',
    documentLinkIdName: 'name',
    projectExclusionIdName: 'name',
    attachmentIdName: 'id',
    attachmentFileNameProperty: 'fileName',
    activitiesOrderSequencePositionIdName: 'activityDefId',
    variableSpecificationDescriptionPrefix: 'variable_',
    activitySpecificationDescriptionPrefix: 'activity_',
    participantSpecificationDescriptionPrefix: 'participant_',
    initProcessSpecification: function() {
        return {
            activitySpecifications: {},
            applicationSpecifications: {},
            participantSpecifications: {},
            variableSpecifications: {},
            tableSpecifications: {},
            tableButtonSpecifications: {},
            assumptionsAndScope: {
                clientName: '',
                systemLink: '',
                processInitiationMethod: '',
                analysisTeam: {
                    companySideMembers: [],
                    clientSideMembers: []
                },
                projectTeam: {
                    companySideMembers: [],
                    clientSideMembers: []
                },
                generalProcessDescription: '',
                emailNotificationsDescription: '',
                processesPerMonth: 0,
                usersInProcess: 0
            },
            activitiesOrder: {
            	type: 'ADDITION',
            	sequence: []
            },
            dtButtonsSupplied: true,
            databaseTableSpecifications: [],
            integrationSpecifications: [],
            programmingTaskSpecifications: [],
            scheduledTaskSpecifications: [],
            documentClassSpecifications: [],
            documentLinkSpecifications: [],
            projectExclusionSpecifications: [],
            attachmentSpecifications: []
        };
    },
    initActivitySpecification: function() {
        return {
            emailNotificationsDescription: '',
            generalActivityDescription: '',
            buttonSpecifications: {},
            dtButtonSpecifications: {},
            formVariableSpecifications: {},
            transitionSpecifications: {},
            viewDocumentClasses: []
        };
    },
    initFormVariableSpecification: function() {
        return {
            description: '',
            autoUpdateSpecifications: {}
        };
    },
    getObjectSpecification: function( specifications, id ) {
        var specification = specifications[id];

        return !Ext.isEmpty( specification ) ? specification : new Object();
    },
    addObjectSpecification: function( specifications, id, specification ) {
        specifications[id] = specification;
    },
    renameObjectSpecification: function( specifications, previousId, currentId ) {
        if ( previousId !== currentId ) {
            var specification = this.getObjectSpecification( specifications, previousId );
            var specificationCopy = Ext.apply( {}, specification );
            this.deleteObjectSpecification( specifications, previousId );
            this.addObjectSpecification( specifications, currentId, specificationCopy );
        }
    },
    editObjectSpecification: function( specifications, previousId, currentId, specification ) {
        this.deleteObjectSpecification( specifications, previousId );
        this.addObjectSpecification( specifications, currentId, specification );
    },
    deleteObjectSpecification: function( specifications, id ) {
        delete specifications[id];
    },
    addActivitySpecification: function( processNode, id, specification ) {
        var specifications = processNode.attributes.specification.activitySpecifications;
        this.addObjectSpecification( specifications, id, specification );
        this.addActivitiesOrderSequencePosition( processNode, id );
    },
    renameActivitySpecification: function( processNode, previousId, currentId ) {
        var specifications = processNode.attributes.specification.activitySpecifications;
        this.renameObjectSpecification( specifications, previousId, currentId );
    },
    editActivitySpecification: function( processNode, previousId, currentId, specification ) {
        var specifications = processNode.attributes.specification.activitySpecifications;
        this.editObjectSpecification( specifications, previousId, currentId, specification );
    },
    deleteActivitySpecification: function( processNode, id ) {
        var specifications = processNode.attributes.specification.activitySpecifications;
        this.deleteObjectSpecification( specifications, id );
    },
    getApplicationSpecification: function( processNode, id ) {
        var specifications = processNode.attributes.specification.applicationSpecifications;

        return this.getObjectSpecification( specifications, id );
    },
    addApplicationSpecification: function( processNode, id, specification ) {
        var specifications = processNode.attributes.specification.applicationSpecifications;
        this.addObjectSpecification( specifications, id, specification );
    },
    editApplicationSpecification: function( processNode, previousId, currentId, specification ) {
        var specifications = processNode.attributes.specification.applicationSpecifications;
        this.editObjectSpecification( specifications, previousId, currentId, specification );
    },
    deleteApplicationSpecification: function( processNode, id ) {
        var specifications = processNode.attributes.specification.applicationSpecifications;
        this.deleteObjectSpecification( specifications, id );
    },
    getParticipantSpecification: function( processNode, id ) {
        var specifications = processNode.attributes.specification.participantSpecifications;

        return this.getObjectSpecification( specifications, id );
    },
    addParticipantSpecification: function( processNode, id, specification ) {
        var specifications = processNode.attributes.specification.participantSpecifications;
        this.addObjectSpecification( specifications, id, specification );
    },
    editParticipantSpecification: function( processNode, previousId, currentId, specification ) {
        var specifications = processNode.attributes.specification.participantSpecifications;
        this.editObjectSpecification( specifications, previousId, currentId, specification );
    },
    deleteParticipantSpecification: function( processNode, id ) {
        var specifications = processNode.attributes.specification.participantSpecifications;
        this.deleteObjectSpecification( specifications, id );
    },
    getVariableSpecification: function( processNode, id ) {
        var specifications = processNode.attributes.specification.variableSpecifications;

        return this.getObjectSpecification( specifications, id );
    },
    addVariableSpecification: function( processNode, id, specification ) {
        var specifications = processNode.attributes.specification.variableSpecifications;
        this.addObjectSpecification( specifications, id, specification );
    },
    editVariableSpecification: function( processNode, previousId, currentId, specification ) {
        var specifications = processNode.attributes.specification.variableSpecifications;
        this.editObjectSpecification( specifications, previousId, currentId, specification );
    },
    deleteVariableSpecification: function( processNode, id ) {
        var specifications = processNode.attributes.specification.variableSpecifications;
        this.deleteObjectSpecification( specifications, id );
    },
    getTableSpecification: function( processNode, id ) {
      var specifications = processNode.attributes.specification.tableSpecifications;

      return this.getObjectSpecification( specifications, id );
    },
    addTableSpecification: function( processNode, id, specification ) {
      var specifications = processNode.attributes.specification.tableSpecifications;
      this.addObjectSpecification( specifications, id, specification );
    },
    editTableSpecification: function( processNode, previousId, currentId, specification ) {
      var specifications = processNode.attributes.specification.tableSpecifications;
      this.editObjectSpecification( specifications, previousId, currentId, specification );
    },
    deleteTableSpecification: function( processNode, id ) {
      var specifications = processNode.attributes.specification.tableSpecifications;
      this.deleteObjectSpecification( specifications, id );
    },
    getTableButtonSpecification: function( processNode, id ) {
      var specifications = processNode.attributes.specification.tableButtonSpecifications;

      return this.getObjectSpecification( specifications, id );
    },
    addTableButtonSpecification: function( processNode, id, specification ) {
      var specifications = processNode.attributes.specification.tableButtonSpecifications;
      this.addObjectSpecification( specifications, id, specification );
    },
    editTableButtonSpecification: function( processNode, previousId, currentId, specification ) {
      var specifications = processNode.attributes.specification.tableButtonSpecifications;
      this.editObjectSpecification( specifications, previousId, currentId, specification );
    },
    deleteTableButtonSpecification: function( processNode, id ) {
      var specifications = processNode.attributes.specification.tableButtonSpecifications;
      this.deleteObjectSpecification( specifications, id );
    },
    setAssumptionsAndScope: function( processNode, assumptionsAndScope ) {
        processNode.attributes.specification.assumptionsAndScope = assumptionsAndScope;
    },
    setActivitiesOrder: function( processNode, activitiesOrder ) {
        processNode.attributes.specification.activitiesOrder = activitiesOrder;
    },
    addActivitiesOrderSequencePosition: function( processNode, activityDefId ) {
    	this.addObject( processNode.attributes.specification.activitiesOrder.sequence, {
        	activityDefId: activityDefId
        } );
    },
    updateActivitiesOrderSequencePosition: function( processNode, oldActivityDefId, newActivityDefId ) {
    	this.editObject( processNode.attributes.specification.activitiesOrder.sequence, this.activitiesOrderSequencePositionIdName,
    			oldActivityDefId, {
    		activityDefId: newActivityDefId
    	} );
    },
    deleteActivitiesOrderSequencePosition: function( processNode, activityDefId ) {
    	this.deleteObject( processNode.attributes.specification.activitiesOrder.sequence, this.activitiesOrderSequencePositionIdName,
    			activityDefId );
    },
    getObject: function( array, idName, idValue ) {
        for ( var i = 0; i < array.length; i++ ) {
            var object = array[i];

            if ( object[idName] === idValue ) {
                return object;
            }
        }

        return null;
    },
    addObject: function( array, objectDef ) {
        array.push( objectDef );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    editObject: function( array, idName, idValue, objectDef ) {
        for ( var i = 0; i < array.length; i++ ) {
            var object = array[i];

            if ( object[idName] === idValue ) {
                array[i] = objectDef;
                Ext.getCmp( 'main_panel' ).setSaved( false );
            }
        }
    },
    deleteObject: function( array, idName, idValue ) {
        for ( var i = 0; i < array.length; i++ ) {
            var object = array[i];

            if ( object[idName] === idValue ) {
                array.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
            }
        }
    },
    getDatabaseTable: function( processNode, name ) {
        var array = processNode.attributes.specification.databaseTableSpecifications;

        return this.getObject( array, this.databaseTableIdName, name );
    },
    addDatabaseTable: function( processNode, def ) {
        var array = processNode.attributes.specification.databaseTableSpecifications;
        this.addObject( array, def );
    },
    editDatabaseTable: function( processNode, id, def ) {
        var array = processNode.attributes.specification.databaseTableSpecifications;
        this.editObject( array, this.databaseTableIdName, id, def );
    },
    deleteDatabaseTable: function( processNode, id ) {
        var array = processNode.attributes.specification.databaseTableSpecifications;
        this.deleteObject( array, this.databaseTableIdName, id );
    },
    updateDatabaseTableUtilizationInActivities: function( processNode, oldActivityDefId, newActivityDefId ) {
        var databaseTableSpecifications = processNode.attributes.specification.databaseTableSpecifications;

        if ( !Ext.isEmpty( databaseTableSpecifications ) ) {
            for ( var i = 0; i < databaseTableSpecifications.length; i++ ) {
                var databaseTableSpecification = databaseTableSpecifications[i];
                var utilizationInActivities = databaseTableSpecification.utilizationInActivities;

                if ( !Ext.isEmpty( utilizationInActivities ) ) {
                    for ( var j = 0; j < utilizationInActivities.length; j++ ) {
                        var utilizationInActivity = utilizationInActivities[j];

                        if ( utilizationInActivity.activityDefId === oldActivityDefId ) {
                            utilizationInActivities[j].activityDefId = newActivityDefId;
                        }
                    }
                }
            }
        }
    },
    deleteDatabaseTableUtilizationInActivities: function( processNode, activityDefId ) {
        var databaseTableSpecifications = processNode.attributes.specification.databaseTableSpecifications;

        if ( !Ext.isEmpty( databaseTableSpecifications ) ) {
            for ( var i = 0; i < databaseTableSpecifications.length; i++ ) {
                var databaseTableSpecification = databaseTableSpecifications[i];
                var utilizationInActivities = databaseTableSpecification.utilizationInActivities;

                if ( !Ext.isEmpty( utilizationInActivities ) ) {
                    var current = new Array();

                    for ( var j = 0; j < utilizationInActivities.length; j++ ) {
                        var utilizationInActivity = utilizationInActivities[j];

                        if ( utilizationInActivity.activityDefId !== activityDefId ) {
                            current.push( utilizationInActivity );
                        }
                    }

                    utilizationInActivities.splice( 0, utilizationInActivities.length );
                    databaseTableSpecification.utilizationInActivities = current;
                }
            }
        }
    },
    getIntegration: function( processNode, name ) {
        var array = processNode.attributes.specification.integrationSpecifications;

        return this.getObject( array, this.integrationIdName, name );
    },
    addIntegration: function( processNode, def ) {
        var array = processNode.attributes.specification.integrationSpecifications;
        this.addObject( array, def );
    },
    editIntegration: function( processNode, id, def ) {
        var array = processNode.attributes.specification.integrationSpecifications;
        this.editObject( array, this.integrationIdName, id, def );
    },
    deleteIntegration: function( processNode, id ) {
        var array = processNode.attributes.specification.integrationSpecifications;
        this.deleteObject( array, this.integrationIdName, id );
    },
    getProgrammingTask: function( processNode, name ) {
        var array = processNode.attributes.specification.programmingTaskSpecifications;

        return this.getObject( array, this.programmingTaskIdName, name );
    },
    addProgrammingTask: function( processNode, def ) {
        var array = processNode.attributes.specification.programmingTaskSpecifications;
        this.addObject( array, def );
    },
    editProgrammingTask: function( processNode, id, def ) {
        var array = processNode.attributes.specification.programmingTaskSpecifications;
        this.editObject( array, this.programmingTaskIdName, id, def );
    },
    deleteProgrammingTask: function( processNode, id ) {
        var array = processNode.attributes.specification.programmingTaskSpecifications;
        this.deleteObject( array, this.programmingTaskIdName, id );
    },
    updateProgrammingTaskExecutionLocation: function( processNode, oldActivityDefId, newActivityDefId ) {
        var programmingTaskSpecifications = processNode.attributes.specification.programmingTaskSpecifications;

        if ( !Ext.isEmpty( programmingTaskSpecifications ) ) {
            for ( var i = 0; i < programmingTaskSpecifications.length; i++ ) {
                var programmingTaskSpecification = programmingTaskSpecifications[i];

                if ( programmingTaskSpecification.executionLocation === oldActivityDefId ) {
                    programmingTaskSpecification.executionLocation = newActivityDefId;
                }
            }
        }
    },
    deleteProgrammingTaskExecutionLocation: function( processNode, activityDefId ) {
        var programmingTaskSpecifications = processNode.attributes.specification.programmingTaskSpecifications;

        if ( !Ext.isEmpty( programmingTaskSpecifications ) ) {
            for ( var i = 0; i < programmingTaskSpecifications.length; i++ ) {
                var programmingTaskSpecification = programmingTaskSpecifications[i];

                if ( programmingTaskSpecification.executionLocation === activityDefId ) {
                    programmingTaskSpecification.executionLocation = '';
                }
            }
        }
    },
    getScheduledTask: function( processNode, name ) {
        var array = processNode.attributes.specification.scheduledTaskSpecifications;

        return this.getObject( array, this.scheduledTaskIdName, name );
    },
    addScheduledTask: function( processNode, def ) {
        var array = processNode.attributes.specification.scheduledTaskSpecifications;
        this.addObject( array, def );
    },
    editScheduledTask: function( processNode, id, def ) {
        var array = processNode.attributes.specification.scheduledTaskSpecifications;
        this.editObject( array, this.scheduledTaskIdName, id, def );
    },
    deleteScheduledTask: function( processNode, id ) {
        var array = processNode.attributes.specification.scheduledTaskSpecifications;
        this.deleteObject( array, this.scheduledTaskIdName, id );
    },
    getDocumentClass: function( processNode, name ) {
      var array = processNode.attributes.specification.documentClassSpecifications;

      return this.getObject( array, this.documentClassIdName, name );
    },
    addDocumentClass: function( processNode, def ) {
      var array = processNode.attributes.specification.documentClassSpecifications;
      this.addObject( array, def );
    },
    editDocumentClass: function( processNode, id, def ) {
      var array = processNode.attributes.specification.documentClassSpecifications;
      this.editObject( array, this.documentClassIdName, id, def );
    },
    deleteDocumentClass: function( processNode, id ) {
      var array = processNode.attributes.specification.documentClassSpecifications;
      this.deleteObject( array, this.documentClassIdName, id );
    },
    getDocumentLink: function( processNode, name ) {
      var array = processNode.attributes.specification.documentLinkSpecifications;

      return this.getObject( array, this.documentLinkIdName, name );
    },
    addDocumentLink: function( processNode, def ) {
      var array = processNode.attributes.specification.documentLinkSpecifications;
      this.addObject( array, def );
    },
    editDocumentLink: function( processNode, id, def ) {
      var array = processNode.attributes.specification.documentLinkSpecifications;
      this.editObject( array, this.documentLinkIdName, id, def );
    },
    deleteDocumentLink: function( processNode, id ) {
      var array = processNode.attributes.specification.documentLinkSpecifications;
      this.deleteObject( array, this.documentLinkIdName, id );
    },
    getProjectExclusion: function( processNode, name ) {
      var array = processNode.attributes.specification.projectExclusionSpecifications;

      return this.getObject( array, this.projectExclusionIdName, name );
    },
    addProjectExclusion: function( processNode, def ) {
      var array = processNode.attributes.specification.projectExclusionSpecifications;
      this.addObject( array, def );
    },
    editProjectExclusion: function( processNode, id, def ) {
      var array = processNode.attributes.specification.projectExclusionSpecifications;
      this.editObject( array, this.projectExclusionIdName, id, def );
    },
    deleteProjectExclusion: function( processNode, id ) {
      var array = processNode.attributes.specification.projectExclusionSpecifications;
      this.deleteObject( array, this.projectExclusionIdName, id );
    },
    getAttachment: function( processNode, name ) {
      var array = processNode.attributes.specification.attachmentSpecifications;

      return this.getObject( array, this.attachmentIdName, name );
    },
    getAttachmentByFileName: function( processNode, name ) {
      var array = processNode.attributes.specification.attachmentSpecifications;

      return this.getObject( array, this.attachmentFileNameProperty, name );
    },
    addAttachment: function( processNode, def ) {
      var array = processNode.attributes.specification.attachmentSpecifications;
      this.addObject( array, def );
    },
    editAttachment: function( processNode, id, def ) {
      var array = processNode.attributes.specification.attachmentSpecifications;
      this.editObject( array, this.attachmentIdName, id, def );
    },
    deleteAttachment: function( processNode, id ) {
      var array = processNode.attributes.specification.attachmentSpecifications;
      this.deleteObject( array, this.attachmentIdName, id );
    },
    setActivitySpecification: function( activityNode, values ) {
        var specification = activityNode.attributes.specification;
        specification = Ext.apply( specification, values );
        var processNode = activityNode.parentNode;
        var activityDefId = activityNode.attributes.activityDefId;
        this.editActivitySpecification( processNode, activityDefId, activityDefId, specification );
    },
    getButtonSpecification: function( activityNode, id ) {
        var specifications = activityNode.attributes.specification.buttonSpecifications;

        return this.getObjectSpecification( specifications, id );
    },
    addButtonSpecification: function( activityNode, id, specification ) {
        var specifications = activityNode.attributes.specification.buttonSpecifications;
        this.addObjectSpecification( specifications, id, specification );
    },
    editButtonSpecification: function( activityNode, previousId, currentId, specification ) {
        var specifications = activityNode.attributes.specification.buttonSpecifications;
        this.editObjectSpecification( specifications, previousId, currentId, specification );
    },
    deleteButtonSpecification: function( activityNode, id ) {
        var specifications = activityNode.attributes.specification.buttonSpecifications;
        this.deleteObjectSpecification( specifications, id );
    },
    getDtButtonSpecification: function( activityNode, id ) {
        var specifications = activityNode.attributes.specification.dtButtonSpecifications;

        return this.getObjectSpecification( specifications, id );
    },
    addDtButtonSpecification: function( activityNode, id, specification ) {
        var specifications = activityNode.attributes.specification.dtButtonSpecifications;
        this.addObjectSpecification( specifications, id, specification );
    },
    editDtButtonSpecification: function( activityNode, previousId, currentId, specification ) {
        var specifications = activityNode.attributes.specification.dtButtonSpecifications;
        this.editObjectSpecification( specifications, previousId, currentId, specification );
    },
    deleteDtButtonSpecification: function( activityNode, id ) {
        var specifications = activityNode.attributes.specification.dtButtonSpecifications;
        this.deleteObjectSpecification( specifications, id );
    },
    getFormVariableSpecification: function( activityNode, id ) {
        var specifications = activityNode.attributes.specification.formVariableSpecifications;

        return this.getObjectSpecification( specifications, id );
    },
    addFormVariableSpecification: function( activityNode, id, specification ) {
        var specifications = activityNode.attributes.specification.formVariableSpecifications;
        this.addObjectSpecification( specifications, id, specification );
    },
    renameFormVariableSpecification: function( activityNode, previousId, currentId ) {
        var specifications = activityNode.attributes.specification.formVariableSpecifications;
        this.renameObjectSpecification( specifications, previousId, currentId );
    },
    editFormVariableSpecification: function( activityNode, previousId, currentId, specification ) {
        var specifications = activityNode.attributes.specification.formVariableSpecifications;
        this.editObjectSpecification( specifications, previousId, currentId, specification );
    },
    deleteFormVariableSpecification: function( activityNode, id ) {
        var specifications = activityNode.attributes.specification.formVariableSpecifications;
        this.deleteObjectSpecification( specifications, id );
    },
    getTransitionSpecification: function( activityNode, id ) {
        var specifications = activityNode.attributes.specification.transitionSpecifications;

        return this.getObjectSpecification( specifications, id );
    },
    addTransitionSpecification: function( activityNode, id, specification ) {
        var specifications = activityNode.attributes.specification.transitionSpecifications;
        this.addObjectSpecification( specifications, id, specification );
    },
    editTransitionSpecification: function( activityNode, previousId, currentId, specification ) {
        var specifications = activityNode.attributes.specification.transitionSpecifications;
        this.editObjectSpecification( specifications, previousId, currentId, specification );
    },
    deleteTransitionSpecification: function( activityNode, id ) {
        var specifications = activityNode.attributes.specification.transitionSpecifications;
        this.deleteObjectSpecification( specifications, id );
    },
    getAutoUpdateSpecification: function( activityNode, formVariableId, id ) {
        var formVariableSpecification = this.getFormVariableSpecification( activityNode, formVariableId );

        if ( Ext.isDefined( formVariableSpecification.autoUpdateSpecifications ) ) {
            var specifications = formVariableSpecification.autoUpdateSpecifications;

            return this.getObjectSpecification( specifications, id );
        } else {
            return new Object();
        }
    },
    addAutoUpdateSpecification: function( activityNode, formVariableId, id, specification ) {
        var formVariableSpecification = this.addOrGetFormVariableSpecificationForAutoUpdate( activityNode, formVariableId );
        var specifications = formVariableSpecification.autoUpdateSpecifications;
        this.addObjectSpecification( specifications, id, specification );
    },
    renameAutoUpdateSpecification: function( activityNode, formVariableId, previousId, currentId ) {
        var formVariableSpecification = this.getFormVariableSpecification( activityNode, formVariableId );

        if ( Ext.isDefined( formVariableSpecification.autoUpdateSpecifications ) ) {
            var specifications = formVariableSpecification.autoUpdateSpecifications;
            this.renameObjectSpecification( specifications, previousId, currentId );
        }
    },
    editAutoUpdateSpecification: function( activityNode, formVariableId, previousId, currentId, specification ) {
        var formVariableSpecification = this.addOrGetFormVariableSpecificationForAutoUpdate( activityNode, formVariableId );
        var specifications = formVariableSpecification.autoUpdateSpecifications;
        this.editObjectSpecification( specifications, previousId, currentId, specification );
    },
    deleteAutoUpdateSpecification: function( activityNode, formVariableId, id ) {
        var formVariableSpecification = this.getFormVariableSpecification( activityNode, formVariableId );

        if ( Ext.isDefined( formVariableSpecification.autoUpdateSpecifications ) ) {
            var specifications = formVariableSpecification.autoUpdateSpecifications;
            this.deleteObjectSpecification( specifications, id );
        }
    },
    addOrGetFormVariableSpecificationForAutoUpdate: function( activityNode, id ) {
        var specifications = activityNode.attributes.specification.formVariableSpecifications;
        var specification = specifications[id];

        if ( Ext.isEmpty( specification ) ) {
            specification = this.initFormVariableSpecification();
            this.addFormVariableSpecification( activityNode, id, specification );
        } else {
            if ( !Ext.isDefined( specification.autoUpdateSpecifications ) ) {
                specification = Ext.apply( {
                    autoUpdateSpecifications: {}
                }, specification );
            }
            this.editFormVariableSpecification( activityNode, id, id, specification );
        }

        return specification;
    },
    updateSpecificationDescriptionsForVarId: function( processNode, previousId, currentId ) {
        this.updateSpecificationDescriptions( processNode, this.variableSpecificationDescriptionPrefix, previousId, currentId );

        if ( processNode.hasChildNodes() ) {
            processNode.eachChild( function( activityNode ) {
                this.renameFormVariableSpecification( activityNode, previousId, currentId );
            }, this );
        }
    },
    updateSpecificationDescriptionsForActivityDefId: function( processNode, previousId, currentId ) {
        this.updateSpecificationDescriptions( processNode, this.activitySpecificationDescriptionPrefix, previousId, currentId );
    },
    updateSpecificationDescriptionsForRoleId: function( processNode, previousId, currentId ) {
        this.updateSpecificationDescriptions( processNode, this.participantSpecificationDescriptionPrefix, previousId, currentId );
    },
    updateSpecificationDescriptions: function( processNode, prefix, previousId, currentId ) {
        var text = '{' + prefix + previousId + '}';
        var replacement = '{' + prefix + currentId + '}';
        var activitySpecifications = processNode.attributes.specification.activitySpecifications;

        if ( !Ext.isEmpty( activitySpecifications ) ) {
            Ext.iterate( activitySpecifications, function( id, specification, object ) {
                var newDescription = '';

                if ( !Ext.isEmpty( specification.generalActivityDescription ) ) {
                    newDescription = specification.generalActivityDescription.replaceAll( text, replacement );
                }

                Ext.apply( specification, {
                    generalActivityDescription: newDescription
                } );
            } );
        }

        this.updateBasicSpecificationDescriptions( processNode.attributes.specification.applicationSpecifications, text, replacement );
        this.updateBasicSpecificationDescriptions( processNode.attributes.specification.participantSpecifications, text, replacement );
        this.updateBasicSpecificationDescriptions( processNode.attributes.specification.variableSpecifications, text, replacement );
        this.updateBasicSpecificationDescriptions( processNode.attributes.specification.tableSpecifications, text, replacement );
        this.updateBasicSpecificationDescriptions( processNode.attributes.specification.tableButtonSpecifications, text, replacement );

        if ( processNode.hasChildNodes() ) {
            processNode.eachChild( function( activityNode ) {
                this.updateBasicSpecificationDescriptions( activityNode.attributes.specification.buttonSpecifications, text, replacement );
                this.updateBasicSpecificationDescriptions( activityNode.attributes.specification.dtButtonSpecifications, text, replacement );
                this.updateBasicSpecificationDescriptions( activityNode.attributes.specification.transitionSpecifications, text, replacement );
                this.updateBasicSpecificationDescriptions( activityNode.attributes.specification.formVariableSpecifications, text, replacement );
            }, this );
        }
    },
    updateBasicSpecificationDescriptions: function( specifications, text, replacement ) {
        if ( !Ext.isEmpty( specifications ) ) {
            Ext.iterate( specifications, function( id, specification, object ) {
                var newDescription = '';

                if ( !Ext.isEmpty( specification.description ) ) {
                    newDescription = specification.description.replaceAll( text, replacement );
                }

                Ext.apply( specification, {
                    description: newDescription
                } );
            } );
        }
    },
    setProcessSpecifications: function( processSpecifications ) {
        var packagePanel = Ext.getCmp( 'package_panel' );

        Ext.each( processSpecifications, function( processSpecification, length, all ) {
            var processDefId = processSpecification.id;
            var processNode = packagePanel.findProcess( processDefId );

            if ( !Ext.isEmpty( processNode ) ) {
            	var activitiesOrderSequence = new Array();
            	
                Ext.iterate( processSpecification.activitySpecifications, function( activityDefId, activitySpecification, activitySpecifications ) {
                    var activityNode = packagePanel.findActivity( processDefId, activityDefId );

                    if ( !Ext.isEmpty( activityNode ) ) {
                    	activitiesOrderSequence.push( {
                    		activityDefId: activityDefId
                    	} );
                    	
                        this.setNodeSpecification( activityNode, activitySpecification );
                    }
                }, this );
                
                if ( !Ext.isEmpty( processSpecification.activitiesOrder.sequence ) ) {
                	var usedActivities = new Array();
                	
                	Ext.each( processSpecification.activitiesOrder.sequence, function( position, index, positions ) {
                		usedActivities.push( position.activityDefId );
                	} );
                	
                	Ext.iterate( processSpecification.activitySpecifications, function( activityDefId, activitySpecification,
                			activitySpecifications ) {
                		if ( usedActivities.indexOf( activityDefId ) == -1 ) {
                			var activityNode = packagePanel.findActivity( processDefId, activityDefId );

                            if ( !Ext.isEmpty( activityNode ) ) {
                            	processSpecification.activitiesOrder.sequence.push( {
                            		activityDefId: activityDefId
                            	} );
                            }
                		}
                    }, this );
                } else {
                	Ext.apply( processSpecification.activitiesOrder, {
                		sequence: activitiesOrderSequence
                	} );
                }

                if ( Ext.isEmpty( processSpecification.tableSpecifications ) ) {
                  processSpecification = Ext.apply( processSpecification, {
                    tableSpecifications: {}
                  } );
                }

                if ( Ext.isEmpty( processSpecification.tableButtonSpecifications ) ) {
                  processSpecification = Ext.apply( processSpecification, {
                    tableButtonSpecifications: {}
                  } );
                }
                
                this.setNodeSpecification( processNode, processSpecification );
            }
        }, this );
    },
    setNodeSpecification: function( node, specification ) {
        Ext.apply( node.attributes, {
            specification: specification
        } );
    },
    generateDocumentation: function( processDefId, finalizeTask ) {
        var msg = getTranslation( 'Trwa generowanie dokumentacji.' ) + ' ' + getTranslation( 'Proszę czekać na pojawienie się okna pobierania.' );
        Ext.getCmp( 'main_panel' ).maskScreen( msg );
        var processNode = Ext.getCmp( 'package_panel' ).findProcess( processDefId );
        var activityNodes = new Array();

        if ( processNode.hasChildNodes() ) {
            processNode.eachChild( function( activityNode ) {
                activityNodes.push( activityNode );
            } );
        }

        this.supplyProcessSpecification( processNode, activityNodes, finalizeTask );
    },
    supplyProcessSpecification: function( processNode, activityNodes, finalizeTask ) {
        if ( !Ext.isEmpty( activityNodes ) ) {
            this.applyActivityFormImage( processNode, activityNodes, finalizeTask );
        } else {
            this.applyProcessMapImage( processNode, finalizeTask );
        }
    },
    applyActivityFormImage: function( processNode, activityNodes, finalizeTask ) {
        var activityNode = activityNodes.pop();

        if ( !Ext.isEmpty( activityNode.attributes.form.variables ) ) {
            var setFormImageTask = new Ext.ux.suncode.RunnableTask( {
                handler: this.supplyProcessSpecification,
                scope: this,
                args: [ processNode, activityNodes, finalizeTask ]
            } );

            var win = new Ext.Window( {
                width: Ext.getBody().getViewSize().width * 0.9,
                y: 10,
                items: [ new Ext.ux.suncode.ActivityFormDesignerDrawingPanel( {
                    activityNode: activityNode,
                    setFormImageTask: setFormImageTask,
                    hideHiddenVariables: true,
                    formDesignerConfig: {
                		    gridActive: false,
                        copyModeActive: false,
                        integrationComponentsVisible: false
                	  }
                } ) ]
            } );
            win.show();
        } else {
            this.supplyProcessSpecification( processNode, activityNodes, finalizeTask );
        }
    },
    applyProcessMapImage: function( processNode, finalizeTask ) {
        var me = this;
        var processDefId = processNode.attributes.processDefId;
        var paperPanel = Ext.getCmp( 'paper_panel' );
        var processPanel = paperPanel.find( 'processDefId', processDefId )[0];
        var paper = processPanel.paper;
        paper.bpmn.eraseAllTrashes( paper );
        var svg = paper.canvas;
        var canvasEl = Ext.DomHelper.append( document.body, {
            tag: 'canvas',
            width: svg.width.baseVal.value,
            height: svg.height.baseVal.value,
            style: {
                display: 'none'
            }
        }, true );
        var canvas = Ext.getDom( canvasEl );

        canvg( canvas, this.getSvgHtml( svg ), {
            renderCallback: function() {
                var specification = processNode.attributes.specification;
                specification = Ext.apply( specification, {
                    processMapImage: canvas.toDataURL( 'image/png' )
                } );

                canvasEl.remove();
                me.finalizeGenerateDocumentation( processNode, finalizeTask );
            }
        } );
    },
    getSvgHtml: function( svg ) {
    	if ( !Ext.isEmpty( svg.outerHTML ) ) {
    		return svg.outerHTML;
    	} else {
    		var wrapper = document.createElement( 'div' );
    	    wrapper.appendChild( svg.cloneNode( true ) );
    	    
    	    return wrapper.innerHTML;
    	}
    },
    finalizeGenerateDocumentation: function( processNode, finalizeTask ) {
        var processDefId = processNode.attributes.processDefId;
        var processName = processNode.attributes.processName;
        var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );
        var fileName = getTranslation( 'Dokumentacja procesu' ) + ' ' + processNameTranslation;
        var mainPanel = Ext.getCmp( 'main_panel' );
        var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
        var packageId = packageNode.attributes.packageId;
        var xpdl = writeXpdl( packageNode );
        var specification = processNode.attributes.specification;
        specification = Ext.apply( specification, {
            id: processNode.attributes.processDefId
        } );
        
        var form = jQuery( '<form/>', { action: 'api/documentation/generate', method: 'post' } );
        form.append( jQuery( '<input>', { type: 'text', name: 'fileName', value: fileName } ) );
        form.append( jQuery( '<input>', { type: 'text', name: 'xpdl', value: LZString.compressToBase64( Ext.util.JSON.encode( xpdl ) ) } ) );
        form.append( jQuery( '<input>', { type: 'text', name: 'processSpecification', value: LZString.compressToBase64( Ext.util.JSON.encode( specification ) ) } ) );
        form.append( jQuery( '<input>', { type: 'text', name: 'attachmentDirectory', value: processNode.attributes.attachmentDirectory } ) );
        form.append( jQuery( '<input>', { type: 'text', name: 'packageId', value: packageId } ) );
        form.append( jQuery( '<input>', { type: 'text', name: 'processDefId', value: processDefId } ) );

        var iframe = jQuery( '#download-frame' );
        iframe.empty();
        iframe.append( form );
        
        mainPanel.setCheckSavedOnUnload( false );
        
        form.submit();

        var task = new Ext.util.DelayedTask( function() {
            this.resetProcessSpecificationTemporaryData( specification );
            mainPanel.unmaskScreen();
            mainPanel.setCheckSavedOnUnload( true );

            if ( !Ext.isEmpty( finalizeTask ) ) {
                finalizeTask.run();
            }
        }, this );
        task.delay( 3000 );
    },
    resetProcessSpecificationTemporaryData: function( specification ) {
        delete specification.processMapImage;

        if ( !Ext.isEmpty( specification.activitySpecifications ) ) {
            Ext.iterate( specification.activitySpecifications, function( activityDefId, activitySpecification, activitySpecifications ) {
                delete activitySpecification.formImage;
            }, this );
        }
    },
    onUpdateActivity: function( processNode, oldActivityDefId, newActivityDefId ) {
        this.renameActivitySpecification( processNode, oldActivityDefId, newActivityDefId );
        this.updateDatabaseTableUtilizationInActivities( processNode, oldActivityDefId, newActivityDefId );
        this.updateProgrammingTaskExecutionLocation( processNode, oldActivityDefId, newActivityDefId );
        this.updateSpecificationDescriptionsForActivityDefId( processNode, oldActivityDefId, newActivityDefId );
        this.updateActivitiesOrderSequencePosition( processNode, oldActivityDefId, newActivityDefId );
    },
    onDeleteActivity: function( processNode, activityDefId ) {
        this.deleteDatabaseTableUtilizationInActivities( processNode, activityDefId );
        this.deleteProgrammingTaskExecutionLocation( processNode, activityDefId );
        this.deleteActivitySpecification( processNode, activityDefId );
        this.deleteActivitiesOrderSequencePosition( processNode, activityDefId );
    }
};