Ext.ux.suncode.ChangeCardWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.6;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoHeight: true,
        title: getTranslation( 'Karta zmian' ),
        disableCloseValidation: true,
        items: [ new Ext.ux.suncode.ChangeCardPanel( config ) ]
    }, config );

    Ext.ux.suncode.ChangeCardWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ChangeCardWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ChangeCardWindow.superclass.initComponent.call( this );

        this.on( 'beforeshow', lockHotkeys );
        this.on( 'beforeclose', unlockHotkeys );
    }
} );

Ext.ux.suncode.ChangeCardPanel = function( config ) {
    var packageId = config.packageId;
    var processDefId = config.processDefId;

    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        autoHeight: true,
        buttonAlign: 'center',
        items: [ {
            xtype: 'panel',
            layout: 'column',
            defaults: {
                autoHeight: true,
                frame: false,
                border: false,
                bodyCssClass: 'x-Module-container-padding',
                layout: 'form',
                labelWidth: 150,
                columnWidth: 0.5
            },
            items: [ {
                xtype: 'panel',
                title: getTranslation( 'Wersja bazowa' ),
                versionItemName: 'baseVersionValue',
                processVersionItemName: 'baseVersionProcessVersion',
                items: [ new Ext.ux.suncode.ChangeCardSourcesChooser( {
                    hiddenName: 'baseVersionSource',
                    packageId: packageId,
                    processDefId: processDefId
                } ) ]
            }, {
                xtype: 'panel',
                title: getTranslation( 'Wersja porównywana' ),
                versionItemName: 'comparedVersionValue',
                processVersionItemName: 'comparedVersionProcessVersion',
                items: [ new Ext.ux.suncode.ChangeCardSourcesChooser( {
                    hiddenName: 'comparedVersionSource',
                    packageId: packageId,
                    processDefId: processDefId
                } ) ]
            } ]
        } ],
        buttons: [ {
            cls: 'x-btn-text',
            text: getTranslation( 'Generuj' ),
            tooltip: getTranslation( 'Generuj kartę zmian' ),
            handler: this.downloadChangeCard,
            scope: this
        } ]
    }, config );

    Ext.ux.suncode.ChangeCardPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ChangeCardPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ChangeCardPanel.superclass.initComponent.call( this );
    },
    downloadChangeCard: function() {
        var form = this.getForm();

        if ( form.isValid() ) {
            var msg = getTranslation( 'Trwa generowanie karty zmian.' ) + ' ' + getTranslation( 'Proszę czekać na pojawienie się okna pobierania.' );
            var mainPanel = Ext.getCmp( 'main_panel' );
            mainPanel.maskScreen( msg );
            var values = form.getValues();
            
            var downloadForm = jQuery( '<form/>', { action: 'api/documentation/generateChangeCard', method:'post' } );
            downloadForm.append( jQuery( '<input>', { type: 'text', name: 'packageId', value: this.initialConfig.packageId } ) );
            downloadForm.append( jQuery( '<input>', { type: 'text', name: 'processDefId', value: this.initialConfig.processDefId } ) );
            downloadForm.append( jQuery( '<input>', { type: 'text', name: 'fileName', value: getTranslation( 'Karta zmian' ) } ) );
            downloadForm.append( jQuery( '<input>', { type: 'text', name: 'changeCardSubtitle', value: this.getSubtitle() } ) );
            
            Ext.iterate( values, function( id, value, object ) {
            	downloadForm.append( jQuery( '<input>', { type: 'text', name: id, value: LZString.compressToBase64( value ) } ) );
            } );
            
            var iframe = jQuery( '#download-frame' );
            iframe.empty();
            iframe.append( downloadForm );
            
            mainPanel.setCheckSavedOnUnload( false );
            
            downloadForm.submit();
            
            var task = new Ext.util.DelayedTask( function() {
            	mainPanel.unmaskScreen();
                mainPanel.setCheckSavedOnUnload( true );
            } );
            task.delay( 3000 );
        }
    },
    getSubtitle: function() {
        var subtitle = getTranslation( 'Wersja bazowa' ) + ': ';
        subtitle += this.getSubtitleVersionPhrase( 'base' ) + ', ';
        subtitle += getTranslation( 'Wersja porównywana' ) + ': ';
        subtitle += this.getSubtitleVersionPhrase( 'compared' );

        return subtitle;
    },
    getSubtitleVersionPhrase: function( prefix ) {
        var form = this.getForm();

        switch ( form.findField( prefix + 'VersionSource' ).getValue() ) {
            case 'CURRENTPROCESS':
                return getTranslation( 'Aktualny proces' ).toLowerCase();
            case 'PROCESSVERSION':
                return form.findField( prefix + 'VersionValue' ).getRawValue();
            default:
                return '';
        }
    }
} );

Ext.ux.suncode.ChangeCardSourcesChooser = function( config ) {
    var sources = [ [ 'CURRENTPROCESS', getTranslation( 'Aktualny proces' ) ], [ 'PROCESSVERSION', getTranslation( 'Wersja procesu' ) ] ];

    config = Ext.apply( {
        fieldLabel: getTranslation( 'Źródło' ),
        mode: 'local',
        anchor: '100%',
        store: new Ext.data.ArrayStore( {
            fields: [ 'source', 'sourceName' ],
            data: sources
        } ),
        valueField: 'source',
        displayField: 'sourceName',
        triggerAction: 'all',
        forceSelection: true,
        allowBlank: false,
        blankText: getTranslation( 'Wybierz źródło' ),
        editable: false
    }, config );

    Ext.ux.suncode.ChangeCardSourcesChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ChangeCardSourcesChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.ChangeCardSourcesChooser.superclass.initComponent.call( this );

        this.on( 'select', this.onSourceSelect, this );
    },
    onSourceSelect: function( combo, record, index ) {
        var source = combo.getValue();

        if ( !Ext.isEmpty( source ) ) {
            var maskId = 'set_parameters_mask';

            try {
                showLoadingMask( maskId, getTranslation( 'Trwa ustawianie parametrów...' ) );
                var packagePanel = Ext.getCmp( 'package_panel' );
                var packageNode = packagePanel.getRootNode();
                var versionPanel = this.ownerCt;
                var versionItem = versionPanel.versionItem;
                var processVersionItem = versionPanel.processVersionItem;

                if ( !Ext.isEmpty( versionItem ) ) {
                    versionPanel.remove( versionItem );
                }
                if ( !Ext.isEmpty( processVersionItem ) ) {
                    versionPanel.remove( processVersionItem );
                }

                switch ( source ) {
                    case 'CURRENTPROCESS':
                        var processDefId = this.initialConfig.processDefId;
                        var processNode = packagePanel.findProcess( processDefId );

                        versionPanel.add( {
                            xtype: 'panel',
                            hidden: true,
                            ref: 'versionItem',
                            items: [ {
                                xtype: 'textfield',
                                name: versionPanel.versionItemName,
                                hidden: true,
                                value: Ext.util.JSON.encode( processNode.attributes.specification )
                            }, {
                                xtype: 'textfield',
                                name: 'xpdl',
                                hidden: true,
                                value: Ext.util.JSON.encode( writeXpdl( packageNode ) )
                            } ]
                        } );
                        break;
                    case 'PROCESSVERSION':
                        versionPanel.add( [ new Ext.ux.suncode.ProcessVersionsChooser( {
                            hiddenName: versionPanel.versionItemName,
                            ref: 'versionItem',
                            packageId: this.initialConfig.packageId,
                            processDefId: this.initialConfig.processDefId
                        } ), {
                            xtype: 'panel',
                            hidden: true,
                            ref: 'processVersionItem',
                            items: [ {
                                xtype: 'textfield',
                                name: versionPanel.processVersionItemName,
                                hidden: true
                            } ]
                        } ] );
                        break;
                    default:
                        break;
                }

                versionPanel.doLayout();
                versionPanel.ownerCt.ownerCt.ownerCt.syncShadow();
            }
            finally {
                removeLoadingMask( maskId );
            }
        }
    }
} );

Ext.ux.suncode.ProcessVersionsChooser = function( config ) {
    var record = Ext.data.Record.create( [ {
        name: 'processVersion',
        type: 'string'
    }, {
        name: 'specificationFile',
        type: 'string'
    } ] );

    var store = new Ext.data.JsonStore( {
        proxy: new Ext.data.HttpProxy( {
            method: 'GET',
            url: 'api/xpdl/getProcessVersions',
            listeners: {
            	exception: function( proxy, type, action, options, response, arg ) {
            		showServerFailure( response );
            	}
            }
        } ),
        reader: new Ext.data.JsonReader( {
            fields: record
        } ),
        autoDestroy: true,
        batch: true,
        fields: record,
        root: 'data',
        baseParams: {
            packageId: config.packageId,
            processDefId: config.processDefId
        }
    } );

    config = Ext.apply( {
        fieldLabel: getTranslation( 'Wersja procesu' ),
        anchor: '100%',
        allowBlank: false,
        blankText: getTranslation( 'Wybierz wersję' ),
        store: store,
        triggerAction: 'all',
        mode: 'remote',
        forceSelection: true,
        displayField: 'processVersion',
        valueField: 'specificationFile',
        editable: false
    }, config );

    Ext.ux.suncode.ProcessVersionsChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessVersionsChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.ProcessVersionsChooser.superclass.initComponent.call( this );

        this.on( 'select', this.onProcessVersionSelect, this );
    },
    onProcessVersionSelect: function( combo, record, index ) {
        var value = combo.getValue();

        if ( !Ext.isEmpty( value ) ) {
            var versionPanel = this.ownerCt;
            var form = this.ownerCt.ownerCt.ownerCt.getForm();
            var processVersionField = form.findField( versionPanel.processVersionItemName );

            if ( !Ext.isEmpty( processVersionField ) ) {
                var processVersion = record.get( 'processVersion' );
                processVersionField.setValue( processVersion );
            }
        }
    }
} );