Ext.ux.suncode.FunctionsMenuWindow = function( config ) {
    config = Ext.apply( {
        height: 300,
        layout: 'fit',
        header: false,
        cls: 'x-Module-window-header-hidden',
        frame: false,
        shadow: false,
        closable: false,
        draggable: false,
        resizable: false,
        toFront: Ext.emptyFn,
        items: [ new Ext.ux.suncode.FunctionsMenuGrid( {
        	returnType: config.returnType,
        	inArray: config.inArray,
        	accessibility: config.accessibility,
        	recommendations: config.recommendations,
          availableVariables: config.availableVariables,
          missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
          missingVariablesValidatorScope: config.missingVariablesValidatorScope
        }) ]
    }, config );

    Ext.ux.suncode.FunctionsMenuWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FunctionsMenuWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.FunctionsMenuWindow.superclass.initComponent.call( this );
    },
    getMenuPanel: function() {
        return this.menuPanel;
    },
    handleMenuText: function( menuText ) {
      var sortFunctions = [ function( record, id ) {
        var regex = new RegExp( '^' + Ext.escapeRe( menuText ), 'i' );
        var extendedName = record.get( 'extendedName' );

        return regex.test( extendedName );
      }, function( record, id ) {
        var regex = new RegExp( Ext.escapeRe( menuText ), 'i' );
        var extendedName = record.get( 'extendedName' );
        var description  = record.get( 'description' );

        return regex.test( extendedName ) || regex.test( description );
      } ];
      var menuPanel = this.getMenuPanel();
      var store = menuPanel.getStore();

      Ext.each( sortFunctions, function( sortFunction, index, allSortFunctions ) {
        store.filterBy( sortFunction );

        if ( store.getCount() > 0 ) {
          return false;
        }
      } );

      if ( store.getCount() > 0 ) {
        var selModel = menuPanel.getSelectionModel();
        selModel.selectFirstRow();
      }
    },
    onDown: function() {
        var menuPanel = this.getMenuPanel();
        var store = menuPanel.getStore();

        if ( store.getCount() > 0 ) {
            var selModel = menuPanel.getSelectionModel();

            if ( selModel.hasNext() ) {
                selModel.selectRow( selModel.last + 1 );
                this.syncScroll( selModel.last + 1 );
            } else {
                selModel.selectFirstRow();
                this.syncScroll( 0 );
            }
        }
    },
    onUp: function() {
        var menuPanel = this.getMenuPanel();
        var store = menuPanel.getStore();

        if ( store.getCount() > 0 ) {
            var selModel = menuPanel.getSelectionModel();

            if ( selModel.hasPrevious() ) {
                selModel.selectRow( selModel.last - 1 );
                this.syncScroll( selModel.last - 1 );
            } else {
                selModel.selectLastRow();
                this.syncScroll( store.getCount() - 1 );
            }
        }
    },
    syncScroll: function( rowIndex ) {
    	var menuPanel = this.getMenuPanel();
    	var view = menuPanel.getView();
        view.syncFocusEl( view.ensureVisible( rowIndex, 0, false ) );
    },
    chooseMenuOption: function() {
        var menuPanel = this.getMenuPanel();
        var selModel = menuPanel.getSelectionModel();
        var record = selModel.getSelected();

        if ( !Ext.isEmpty( record ) ) {
            var functionName = record.get( 'name' );
            var functionParameterTypes = record.get( 'parameterTypes' );
            var customField = this.initialConfig.customField;

            if ( !Ext.isEmpty( functionParameterTypes ) ) {
                var win = new Ext.ux.suncode.FunctionParametersWindow( {
                    functionName: functionName,
                    functionParameterTypes: functionParameterTypes,
                    contextVariables: this.initialConfig.contextVariables,
                    processNode: this.initialConfig.processNode,
                    returnType: this.initialConfig.returnType,
                    inArray: this.initialConfig.inArray,
                    accessibility: this.initialConfig.accessibility,
                    previousWindow: this.initialConfig.previousWindow,
                    availableVariables: this.initialConfig.availableVariables,
                    validateFieldFunction: this.initialConfig.validateFieldFunction,
                    validateFieldScope: this.initialConfig.validateFieldScope,
                    missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
                    missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
                    customField: customField,
                    xPos: this.initialConfig.x,
                    y: this.initialConfig.y,
                    listeners: {
                    	show: function( win ) {
                    		fitWindowToView( win, function( x ) {
                    			return ( Ext.getBody().getWidth() - win.getWidth() );
                    		}, function( y ) {
                    			return ( y - win.getHeight() - 25 );
                    		} );
                    	}
                    }
                } );
                win.show();
            } else {
                var setFunctionFunc = customField.setFunction;

                if ( Ext.isFunction( setFunctionFunc ) ) {
                    setFunctionFunc.apply( customField, [ functionName, [], [] ] );
                }
            }
        }
    }
} );

Ext.ux.suncode.FunctionsMenuGrid = function( config ) {
	var returnType = config.returnType;
	var inArray = config.inArray;
	var accessibility = config.accessibility;
	var recommendations = config.recommendations;
    var mainPanel = Ext.getCmp( 'main_panel' );
    var systemFunctions = mainPanel.getSystemFunctions( returnType, inArray, accessibility, recommendations );

    var store = new Ext.data.Store( {
        data: !Ext.isEmpty( systemFunctions ) ? systemFunctions : [],
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            }, {
                name: 'extendedName',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            }, {
                name: 'parameterTypes'
            } ] )
        } )
    } );

    config = Ext.apply( {
        ref: 'menuPanel',
        store: store,
        columnLines: true,
        autoScroll: true,
        border: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: false,
                menuDisabled: true
            },
            columns: [ {
                id: 'extendedName',
                header: getTranslation( 'Nazwa i parametry' ),
                dataIndex: 'extendedName',
                align: 'left',
                renderer: function ( value, metaData, record, rowIndex, colIndex, store ) {
                	if ( Ext.isArray( recommendations ) && recommendations.indexOf( record.get( 'name' ) ) != -1 ) {
                    	metaData.style += 'font-weight: bold;';
                    }
                	
                    return value;
                }
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                  if ( !Ext.isEmpty( value ) ) {
                    metaData.attr = 'ext:qtip="' + value + '"';
                    return wrapColumnValue( value.ellipse( 150 ) );
                  } else {
                    return '';
                  }
                }
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak funkcji' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        listeners: {
            scope: this,
            viewready: this.onViewReady,
            cellmousedown: this.onCellMouseDown
        }
    }, config );

    Ext.ux.suncode.FunctionsMenuGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FunctionsMenuGrid, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.FunctionsMenuGrid.superclass.initComponent.call( this );
    },
    onViewReady: function( grid ) {
        var store = grid.getStore();

        if ( store.getCount() > 0 ) {
            var selModel = grid.getSelectionModel();
            selModel.selectFirstRow();
        }
    },
    onCellMouseDown: function( grid, rowIndex, columnIndex, e ) {
        this.ownerCt.chooseMenuOption();
    }
} );

Ext.ux.suncode.FunctionParametersWindow = function( config ) {
	  var viewSize = Ext.getBody().getViewSize();
    var viewWidth = viewSize.width;
    var windowWidth = viewWidth * 0.5;
    var x = ( config.xPos + windowWidth < viewWidth ) ? config.xPos : viewWidth - windowWidth - 25;
    var functionName = config.functionName;
    var returnType = config.returnType;
    var inArray = config.inArray;
    var accessibility = config.accessibility;
    var winTitle = getTranslation( 'Funkcja' ) + ' ' + functionName;
    var functionDescription = '';
    var deprecated = false;
    var deprecationDescription = '';
    var replacement = '';
    var extendedName = '';
    var functionParameterTypes = config.functionParameterTypes;
    var mainPanel = Ext.getCmp( 'main_panel' );
    var systemFunction = mainPanel.getSystemFunction( functionName, functionParameterTypes );
    var overloadings = mainPanel.getSystemFunctionOverloadings( functionName, returnType, inArray, accessibility );
    var equivalents = mainPanel.getSystemFunctionEquivalents( returnType, inArray, accessibility, functionParameterTypes );
    var customFormConfig = mainPanel.getCustomFormConfig();
    var processNode = config.processNode;
    var currentParameters = config.currentParameters;
    var availableVariables = config.availableVariables;
    var validateFieldFunction = config.validateFieldFunction;
    var validateFieldScope = config.validateFieldScope;
    var missingVariablesValidatorFunction = config.missingVariablesValidatorFunction;
    var missingVariablesValidatorScope = config.missingVariablesValidatorScope;
    var customForm = new Object();

    if ( !Ext.isEmpty( systemFunction ) ) {
        functionDescription = systemFunction.description;
        deprecated = systemFunction.deprecated;
        deprecationDescription = systemFunction.deprecationDescription;
        replacement = systemFunction.functionReplacement;
        extendedName = systemFunction.extendedName;
        
        if ( !Ext.isEmpty( systemFunction.parameters ) ) {
        	customForm = Ext.apply( customForm, {
        		fields: deepObjectCopy( systemFunction.parameters )
        	} );
        	
        	if ( !Ext.isEmpty( currentParameters ) ) {
        		var values = new Object();
        		
	        	Ext.each( systemFunction.parameters, function( parameter, index, parameters ) {
	                var customValue = currentParameters[index];
	                values[parameter.id] = customValue;
	            }, this );
	        	
	        	customForm = Ext.apply( customForm, {
	        		values: values
	        	} );
        	}
        }
        
        var componentReg = Ext.ux.suncode.IntegrationComponentService
        	.getSystemFunctionRegistration( functionName, functionParameterTypes, systemFunction.parameters, systemFunction.returnType );
        customForm = Ext.apply( {
            buildForm: !Ext.isEmpty( componentReg ) ? componentReg.buildForm : null,
            validateForm: !Ext.isEmpty( componentReg ) ? componentReg.validateForm : null,
            apiVersion: !Ext.isEmpty( componentReg ) ? componentReg.apiVersion : null
        }, customForm );
    }
    
    var tbarItems = new Array();
    tbarItems.push( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'save' ),
        tooltip: getTranslation( 'Zapisz' ),
        handler: this.saveForm,
        scope: this
    } );
    tbarItems.push( {
    	cls: 'x-btn-icon',
        icon: getPluginImgPath( 'save_all' ),
        tooltip: getTranslation( 'Zapisz wszystkie' ),
        handler: this.saveAllWindows,
        scope: this
    } );
    tbarItems.push( {
    	ref: 'toggleTypeVisibilityButton',
        cls: 'x-btn-icon',
        icon: customFormConfig.typesVisible ? getPluginImgPath( 'type_visibility_off' ) :
        	getPluginImgPath( 'type_visibility_on' ),
        tooltip: customFormConfig.typesVisible ? getTranslation( 'Ukryj typy' ) :
        	getTranslation( 'Pokaż typy' ),
        enableToggle: true,
        handler: this.toggleTypeVisibility,
        scope: this
    } );
    tbarItems.push( {
      ref: 'toggleFunctionPrettyFormatButton',
      cls: 'x-btn-icon',
      icon: customFormConfig.functionPrettyFormat ? getPluginImgPath( 'function_pretty_format_off' ) :
          getPluginImgPath( 'function_pretty_format_on' ),
      tooltip: customFormConfig.functionPrettyFormat ? getTranslation( 'Wyłącz formatowanie funkcji' ) :
          getTranslation( 'Włącz formatowanie funkcji' ),
      enableToggle: true,
      handler: this.toggleFunctionPrettyFormat,
      scope: this
    } );
    tbarItems.push( {
    	cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close_all' ),
        tooltip: getTranslation( 'Zamknij wszystkie' ),
        handler: this.closeAllWindows,
        scope: this
    } );
    tbarItems.push( new Ext.ux.suncode.CloseWindowButton( {
    	win: this
    } ) );
    tbarItems.push( '->' );
    if ( overloadings.length > 1 ) {
    	tbarItems.push( new Ext.ux.suncode.FunctionOverloadingsChooser( {
        	width: windowWidth * 0.4,
        	overloadings: overloadings,
        	value: extendedName,
        	listeners: {
    			scope: this,
    			select: this.onOverloadingSelect
    		}
        } ) );
    } else {
    	tbarItems.push( {
            xtype: 'tbtext',
            text: extendedName
        } );
    }
    
    var information = {
        deprecated: deprecated,
        deprecatedMessage: getTranslation( 'Funkcja jest przestarzała' ),
        deprecationDescription: deprecationDescription,
        replacement: replacement,
        replacementMessage: getTranslation( 'Zastąpiona nową funkcją' ),
        descriptionValue: functionDescription
    };
    
    if ( equivalents.length > 1 ) {
    	information = Ext.apply( information, {
    		nameChooser: new Ext.ux.suncode.FunctionEquivalentsChooser( {
             	fieldLabel: getTranslation( 'Nazwa' ),
              	anchor: '100%',
               	equivalents: equivalents,
               	value: functionName,
            	listeners: {
        			scope: this,
        			select: this.onEquivalentSelect
        		}
            } )
    	} );
    } else {
    	information = Ext.apply( information, {
    		nameValue: functionName
    	} );
    }

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        bodyStyle: {
        	maxHeight: viewSize.height * 0.8 + 'px'
        },
        autoScroll: true,
        x: x,
        title: winTitle,
        onEsc: Ext.emptyFn,
        tbar: new Ext.Toolbar( {
            items: tbarItems
        } ),
        items: [ new Ext.ux.suncode.CustomForm( {
            ref: 'parametersPanel',
            processNode: processNode,
            customForm: customForm,
            focusFirstParameter: true,
            information: information,
            onFieldEnterTask: new Ext.ux.suncode.RunnableTask( {
                handler: this.saveForm,
                scope: this
            } ),
            contextVariables: config.contextVariables,
            systemFunctionsAccessibility: accessibility,
            customFormConfig: customFormConfig,
            availableVariables: availableVariables,
            validateFieldFunction: validateFieldFunction,
            validateFieldScope: validateFieldScope,
            missingVariablesValidatorFunction: missingVariablesValidatorFunction,
            missingVariablesValidatorScope: missingVariablesValidatorScope,
            previousWindow: this
        } ) ]
    }, config );

    Ext.ux.suncode.FunctionParametersWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FunctionParametersWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.FunctionParametersWindow.superclass.initComponent.call( this );

        this.on( 'resize', this.onWindowResize ,this );
    },
    onWindowResize: function( win, width, height  ) {
      var parametersPanel = this.parametersPanel;
      parametersPanel.recalculateTableWidths();
    },
    saveForm: function( savePreviousWindow ) {
    	var parametersPanel = this.parametersPanel;
    	var parameters = parametersPanel.getParametersValuesAsArray();
    	
    	if ( parameters !== null ) {
    		var functionName = this.initialConfig.functionName;
            var parameterTypes = this.initialConfig.functionParameterTypes;
            var previousWindow = this.initialConfig.previousWindow;
            var customField = this.initialConfig.customField;
            var saveFunction = this.initialConfig.saveFunction;
            
            if ( !Ext.isEmpty( customField ) ) {
            	var setFunctionFunc = customField.setFunction;

                if ( customField.isVisible() && Ext.isFunction( setFunctionFunc ) ) {
                    setFunctionFunc.apply( customField, [ functionName, parameters, parameterTypes ] );
                }
            }
            
            if ( Ext.isFunction( saveFunction ) ) {
            	var saveScope = !Ext.isEmpty( this.initialConfig.saveScope ) ? this.initialConfig.saveScope : window;
                saveFunction.apply( saveScope, [ functionName, parameters, parameterTypes ] );
            }

            this.closeWindow();
            
            if ( savePreviousWindow === true && !Ext.isEmpty( previousWindow ) && Ext.isFunction( previousWindow.saveAllWindows ) ) {
            	var saveAllWindowsFunction = previousWindow.saveAllWindows;
            	saveAllWindowsFunction.apply( previousWindow, [] );
            }
    	}
    },
    saveAllWindows: function() {
    	this.saveForm( true );
    },
    toggleTypeVisibility: function() {
    	var parametersPanel = this.parametersPanel;
    	var areVisible = parametersPanel.areTypesVisible();
    	this.changeTypeVisibility( areVisible );
    	parametersPanel.updateCustomFormConfig();
    },
    changeTypeVisibility: function( areVisible ) {
    	var parametersPanel = this.parametersPanel;
    	var button = this.getTopToolbar().toggleTypeVisibilityButton;
    	
    	if ( areVisible ) {
        	parametersPanel.hideTypes();
            button.setTooltip( getTranslation( 'Pokaż typy' ) );
            button.setIcon( getPluginImgPath( 'type_visibility_on' ) );
        } else {
        	parametersPanel.showTypes();
            button.setTooltip( getTranslation( 'Ukryj typy' ) );
            button.setIcon( getPluginImgPath( 'type_visibility_off' ) );
        }
        
        var customField = this.initialConfig.customField;
        var previousWin = customField.getParentWindow();
        
        if ( !Ext.isEmpty( previousWin ) && Ext.isFunction( previousWin.changeTypeVisibility ) ) {
        	previousWin.changeTypeVisibility.apply( previousWin, [ areVisible ] );
        }
    },
    toggleFunctionPrettyFormat: function() {
      var parametersPanel = this.parametersPanel;
      var prettyFormat = parametersPanel.areFunctionsPrettyFormatted();
      this.changeFunctionPrettyFormat( prettyFormat );
      parametersPanel.updateCustomFormConfig();
    },
    changeFunctionPrettyFormat: function( prettyFormat ) {
      var parametersPanel = this.parametersPanel;
      var button = this.getTopToolbar().toggleFunctionPrettyFormatButton;

      if ( prettyFormat ) {
        parametersPanel.switchOffFunctionPrettyFormat();
        button.setTooltip( getTranslation( 'Włącz formatowanie funkcji' ) );
        button.setIcon( getPluginImgPath( 'function_pretty_format_on' ) );
      } else {
        parametersPanel.switchOnFunctionPrettyFormat();
        button.setTooltip( getTranslation( 'Wyłącz formatowanie funkcji' ) );
        button.setIcon( getPluginImgPath( 'function_pretty_format_off' ) );
      }

      var customField = this.initialConfig.customField;
      var previousWin = customField.getParentWindow();

      if ( !Ext.isEmpty( previousWin ) && Ext.isFunction( previousWin.changeFunctionPrettyFormat ) ) {
        previousWin.changeFunctionPrettyFormat.apply( previousWin, [ prettyFormat ] );
      }
    },
    closeWindow: function( closePreviousWindow ) {
    	var previousWindow = this.initialConfig.previousWindow;
        this.close();
        
        if ( closePreviousWindow === true && !Ext.isEmpty( previousWindow ) && Ext.isFunction( previousWindow.closeAllWindows ) ) {
        	var closeAllWindowsFunction = previousWindow.closeAllWindows;
        	closeAllWindowsFunction.apply( previousWindow, [] );
        }
    },
    closeAllWindows: function() {
    	this.closeWindow( true );
    },
    onOverloadingSelect: function( combo, record, index ) {
		if( combo.isValid() ) {
			var functionName = record.get( 'name' );
			var functionParameterTypes = record.get( 'parameterTypes' );
			this.reloadWindow( functionName, functionParameterTypes, null );
		}
    },
    onEquivalentSelect: function( combo, record, index ) {
    	if( combo.isValid() ) {
    		var functionName = record.get( 'name' );
			var functionParameterTypes = record.get( 'parameterTypes' );
			var parametersPanel = this.parametersPanel;
	    	var parameters = parametersPanel.getParametersValuesAsArray( {
          skipValidation: true
        } );
			this.reloadWindow( functionName, functionParameterTypes, parameters );
    	}
    },
    reloadWindow: function( functionName, functionParameterTypes, parameters ) {
      var currentPosition = this.getPosition();
      this.closeWindow();
      var win = new Ext.ux.suncode.FunctionParametersWindow( {
        functionName: functionName,
        functionParameterTypes: functionParameterTypes,
        contextVariables: this.initialConfig.contextVariables,
        processNode: this.initialConfig.processNode,
        returnType: this.initialConfig.returnType,
        inArray: this.initialConfig.inArray,
        accessibility: this.initialConfig.accessibility,
        availableVariables: this.initialConfig.availableVariables,
        validateFieldFunction: this.initialConfig.validateFieldFunction,
        validateFieldScope: this.initialConfig.validateFieldScope,
        missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
        missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
        previousWindow: this.initialConfig.previousWindow,
        customField: this.initialConfig.customField,
        currentParameters: parameters,
        saveFunction: this.initialConfig.saveFunction,
        saveScope: this.initialConfig.saveScope,
        xPos: currentPosition[0],
        y: currentPosition[1],
        listeners: {
          show: function( win ) {
            fitWindowToView( win, function( x ) {
              return ( Ext.getBody().getWidth() - win.getWidth() );
            }, function( y ) {
              return ( y - win.getHeight() - 25 );
            } );
          }
        }
      } );
      win.show();
    }
} );

Ext.ux.suncode.FunctionOverloadingsChooser = function( config ) {
	config = Ext.apply( {
		triggerAction: 'all',
		mode: 'local',
		store: new Ext.data.Store( {
			data: config.overloadings,
			reader: new Ext.data.JsonReader( {
	            fields: Ext.data.Record.create( [ {
					name: 'name',
					type: 'string'
				}, {
					name: 'extendedName',
					type: 'string'
				}, {
					name: 'parameterTypes'
				} ] )
	        } )
		} ),
		valueField: 'extendedName',
		displayField: 'extendedName',
		resizable: true,
		forceSelection: true,
		editable: false
	}, config );

	Ext.ux.suncode.FunctionOverloadingsChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FunctionOverloadingsChooser, Ext.form.ComboBox, {
	initComponent: function() {
		Ext.ux.suncode.FunctionOverloadingsChooser.superclass.initComponent.call( this );
	}
} );

Ext.ux.suncode.FunctionEquivalentsChooser = function( config ) {
	var tpl = new Ext.XTemplate( '<tpl for=".">', '<div class="x-Module-comboTemplateItem">', '<div><font '
			+ getTemplateStyle() + '><b>' + getTranslation( 'Nazwa funkcji' ) + ': '
			+ '</b></font><span>{name}</span></div>', '<div><font ' + getTemplateStyle() + '><b>'
			+ getTranslation( 'Opis funkcji' ) + ': ' + '</b></font><span>{description}</span></div></div>',
			'<tpl if="xindex !== xcount">', '<hr ' + getHRLineStyle() + '>', '</tpl>', '</tpl>' );
	tpl = tpl.compile();
	
	config = Ext.apply( {
		triggerAction: 'all',
		mode: 'local',
		store: new Ext.data.Store( {
			data: config.equivalents,
			reader: new Ext.data.JsonReader( {
	            fields: Ext.data.Record.create( [ {
					name: 'name',
					type: 'string'
				}, {
					name: 'description',
					type: 'string'
				}, {
					name: 'extendedName',
					type: 'string'
				}, {
					name: 'parameterTypes'
				} ] )
	        } )
		} ),
		tpl : tpl,
		itemSelector : 'div.x-Module-comboTemplateItem',
		valueField: 'name',
		displayField: 'name',
		resizable: true,
		forceSelection: true
	}, config );

	Ext.ux.suncode.FunctionEquivalentsChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FunctionEquivalentsChooser, Ext.form.ComboBox, {
	initComponent: function() {
		Ext.ux.suncode.FunctionEquivalentsChooser.superclass.initComponent.call( this );
	}
} );