Ext.ux.suncode.Clipboard = {
  integrationComponentParameterValueMessageType: 'pweIntegrationComponentParameterValue',
  integrationComponentFormActionsMessageType: 'pweIntegrationComponentFormActions',
  integrationComponentValidatorsMessageType: 'pweIntegrationComponentValidators',
  integrationComponentVariablesSettersMessageType: 'pweIntegrationComponentVariablesSetters',
  integrationComponentApplicationsMessageType: 'pweIntegrationComponentApplications',
  integrationComponentDataChoosersMessageType: 'pweIntegrationComponentDataChoosers',
  integrationComponentEventActionsMessageType: 'pweIntegrationComponentEventActions',
  activityFormComponentsMessageType: 'pweActivityFormComponents',
  processVariablesMessageType: 'pweProcessVariables',
	integrationComponent: {
		parameterValue: null,
		formActions: null,
		validators: null,
		variablesSetters: null,
		applications: null,
		dataChoosers: null,
    eventActions: null
	},
  activityFormComponents: null,
  processVariables: null,
	activityFormPreview: {
		windows: new Array(),
		get: function() {
			return this.windows;
		},
		add: function( win ) {
			this.windows.push( win );
		},
		reset: function() {
			clearArray( this.windows );
		}
	},
	activityFormDesigner: {
		window: null,
		get: function() {
			return this.window;
		},
		set: function( win ) {
			this.window = win;
		},
		reset: function() {
			delete this.window;
			this.window = null;
		}
	},
	reset: function() {
		this.activityFormPreview.reset();
		this.activityFormDesigner.reset();
	},
  externalClipboardActive: function() {
    var mainPanel = Ext.getCmp( 'main_panel' );

    return mainPanel.getUseExternalClipboard();
  },
	setIntegrationComponentParameterValue: function( value ) {
		this.integrationComponent.parameterValue = deepObjectCopy( value );

    this.populateCopyMessage(
        this.integrationComponentParameterValueMessageType,
        this.integrationComponent.parameterValue );
	},
	getIntegrationComponentParameterValue: function( func, scope ) {
    this.getObject(
        func,
        scope,
        this.integrationComponentParameterValueMessageType,
        this.integrationComponent.parameterValue );
	},
	setIntegrationComponentFormActions: function( formActions ) {
		this.integrationComponent.formActions = deepObjectCopy( formActions );

    this.populateCopyMessage(
        this.integrationComponentFormActionsMessageType,
        this.integrationComponent.formActions );
	},
	getIntegrationComponentFormActions: function( func, scope ) {
    this.getObject(
        func,
        scope,
        this.integrationComponentFormActionsMessageType,
        this.integrationComponent.formActions );
	},
	setIntegrationComponentValidators: function( validators ) {
		this.integrationComponent.validators = deepObjectCopy( validators );

    this.populateCopyMessage(
        this.integrationComponentValidatorsMessageType,
        this.integrationComponent.validators );
	},
	getIntegrationComponentValidators: function( func, scope ) {
    this.getObject(
        func,
        scope,
        this.integrationComponentValidatorsMessageType,
        this.integrationComponent.validators );
	},
	setIntegrationComponentVariablesSetters: function( variablesSetters ) {
		this.integrationComponent.variablesSetters = deepObjectCopy( variablesSetters );

    this.populateCopyMessage(
        this.integrationComponentVariablesSettersMessageType,
        this.integrationComponent.variablesSetters );
	},
	getIntegrationComponentVariablesSetters: function( func, scope ) {
    this.getObject(
        func,
        scope,
        this.integrationComponentVariablesSettersMessageType,
        this.integrationComponent.variablesSetters );
	},
	setIntegrationComponentApplications: function( applications ) {
		this.integrationComponent.applications = deepObjectCopy( applications );

    this.populateCopyMessage(
        this.integrationComponentApplicationsMessageType,
        this.integrationComponent.applications );
	},
	getIntegrationComponentApplications: function( func, scope ) {
    this.getObject(
        func,
        scope,
        this.integrationComponentApplicationsMessageType,
        this.integrationComponent.applications );
	},
	setIntegrationComponentDataChoosers: function( dataChoosers ) {
		this.integrationComponent.dataChoosers = deepObjectCopy( dataChoosers );

    this.populateCopyMessage(
        this.integrationComponentDataChoosersMessageType,
        this.integrationComponent.dataChoosers );
	},
	getIntegrationComponentDataChoosers: function( func, scope ) {
    this.getObject(
        func,
        scope,
        this.integrationComponentDataChoosersMessageType,
        this.integrationComponent.dataChoosers );
	},
  setIntegrationComponentEventActions: function( eventActions ) {
    this.integrationComponent.eventActions = deepObjectCopy( eventActions );

    this.populateCopyMessage(
        this.integrationComponentEventActionsMessageType,
        this.integrationComponent.eventActions );
  },
  getIntegrationComponentEventActions: function( func, scope ) {
    this.getObject(
        func,
        scope,
        this.integrationComponentEventActionsMessageType,
        this.integrationComponent.eventActions );
  },
  setActivityFormComponents: function( components ) {
    this.activityFormComponents = deepObjectCopy( components );

    this.populateCopyMessage(
        this.activityFormComponentsMessageType,
        this.activityFormComponents );
  },
  getActivityFormComponents: function( func, scope ) {
    this.getObject(
        func,
        scope,
        this.activityFormComponentsMessageType,
        this.activityFormComponents );
  },
  setProcessVariables: function( variables ) {
    this.processVariables = deepObjectCopy( variables );

    this.populateCopyMessage(
        this.processVariablesMessageType,
        this.processVariables );
  },
  getProcessVariables: function( func, scope ) {
    this.getObject(
        func,
        scope,
        this.processVariablesMessageType,
        this.processVariables );
  },
	addActivityFormPreview: function( win ) {
		this.activityFormPreview.add( win );
	},
	getActivityFormPreviews: function() {
		return this.activityFormPreview.get();
	},
	deleteActivityFormPreviews: function() {
		this.activityFormPreview.reset();
	},
	setActivityFormDesigner: function( win ) {
		this.activityFormDesigner.set( win );
	},
	getActivityFormDesigner: function() {
		return this.activityFormDesigner.get();
	},
	deleteActivityFormDesigner: function() {
		this.activityFormDesigner.reset();
	},
  populateCopyMessage: function( type, body ) {
    var message = new Object();
    message = Ext.apply( message, {
      type: type,
      body: body
    } );

    copyTextToClipboard( Ext.util.JSON.encode( message ) );
  },
  getObject: function( func, scope, messageType, object ) {
    if ( !Ext.isFunction( func ) ) {
      return;
    }

    scope = !Ext.isEmpty( scope ) ? scope : window;

    if ( this.externalClipboardActive() ) {
      this.consumeCopyMessage(
          messageType,
          function( body ) {
            scope = !Ext.isEmpty( scope ) ? scope : window;
            var value = deepObjectCopy( body );

            func.apply( scope, [ value ] );
          }, function() {
            var value = deepObjectCopy( object );

            func.apply( scope, [ value ] );
          } );
    } else {
      var value = deepObjectCopy( object );

      func.apply( scope, [ value ] );
    }
  },
  consumeCopyMessage: function( type, successHandler, errorHandler ) {
    if ( Ext.isFunction( successHandler ) && Ext.isFunction( errorHandler ) ) {
      readTextFromClipboard( function( text ) {
        if ( !Ext.isEmpty( text ) ) {
          var fromClipboard = Ext.util.JSON.decode( text );

          if ( fromClipboard.type === type && !Ext.isEmpty( fromClipboard.body ) ) {
            successHandler.apply( this, [ fromClipboard.body ] );
            return;
          }
        }

        errorHandler.apply( this, [] );
      }, this, function() {
        errorHandler.apply( this, [] );
      }, this );
    }
  }
};