/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.tutorial.builder;

import com.suncode.plugin.pwe.util.comparator.TutorialNodeDtoComparator;
import com.suncode.plugin.pwe.web.support.dto.tutorial.TutorialNodeDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class TutorialNodeDtoBuilder {
    public static Logger log = Logger.getLogger(TutorialNodeDtoBuilder.class);
    private static final String PATH_SUBSTRING = "jar!/resources/";

    public List<TutorialNodeDto> build(Resource[] resources) {
        ArrayList<TutorialNodeDto> dtos = new ArrayList<TutorialNodeDto>();
        if (ArrayUtils.isNotEmpty((Object[])resources)) {
            for (Resource resource : resources) {
                if (!resource.exists()) continue;
                dtos.add(this.build(resource));
            }
            Collections.sort(dtos, new TutorialNodeDtoComparator());
        }
        return dtos;
    }

    public TutorialNodeDto build(Resource resource) {
        TutorialNodeDto dto = new TutorialNodeDto();
        dto.setLocation(this.buildLocation(resource));
        dto.setIconCls("x-Module-tutorialTreeNode");
        dto.setText(this.buildText(resource));
        dto.setLeaf(true);
        return dto;
    }

    private String buildText(Resource resource) {
        return StringUtils.replace((String)FilenameUtils.getBaseName((String)resource.getFilename()), (String)"_", (String)" ");
    }

    private String buildLocation(Resource resource) {
        try {
            return StringUtils.substringAfterLast((String)resource.getURL().getPath(), (String)PATH_SUBSTRING);
        }
        catch (IOException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return "";
        }
    }
}

