/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.plugin.builder;

import com.suncode.plugin.pwe.web.support.dto.plugin.PluginVersionDto;
import java.util.Properties;
import org.springframework.stereotype.Component;

@Component
public class PluginVersionDtoBuilder {
    private static final String VERSION_PROPERTY_NAME = "version";
    private static final String REVISION_PROPERTY_NAME = "revision";
    private static final String BUILD_DATE_PROPERTY_NAME = "build.date";

    public PluginVersionDto build(Properties properties) {
        String version = this.getProperty(properties, VERSION_PROPERTY_NAME);
        PluginVersionDto dto = new PluginVersionDto();
        dto.setVersion(version);
        dto.setVersionWithRevision(this.buildVersionWithRevision(properties, version));
        dto.setBuildDate(this.getProperty(properties, BUILD_DATE_PROPERTY_NAME));
        return dto;
    }

    private String buildVersionWithRevision(Properties properties, String version) {
        StringBuilder versionWithRevision = new StringBuilder();
        versionWithRevision.append(version);
        versionWithRevision.append(" #");
        versionWithRevision.append(this.getProperty(properties, REVISION_PROPERTY_NAME));
        return versionWithRevision.toString();
    }

    private String getProperty(Properties properties, String propertyName) {
        return properties.getProperty(propertyName, "");
    }
}

