/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.icon.builder;

import com.suncode.plugin.pwe.web.support.dto.icon.IconDto;
import com.suncode.pwfl.util.style.IconUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class IconDtoBuilder {
    public List<IconDto> build(List<String> icons) {
        ArrayList<IconDto> dtos = new ArrayList<IconDto>();
        if (CollectionUtils.isNotEmpty(icons)) {
            for (String name : icons) {
                dtos.add(this.build(name));
            }
        }
        return dtos;
    }

    public IconDto build(String name) {
        String cls = IconDtoBuilder.buildCls(name);
        IconDto dto = new IconDto();
        dto.setName(name);
        dto.setCls(cls);
        dto.setIcon(IconDtoBuilder.buildIcon(name));
        return dto;
    }

    private static String buildCls(String name) {
        return IconUtils.addClsPrefix((String)name);
    }

    private static String buildIcon(String name) {
        return "DIVANTE_ICON_" + name;
    }
}

