/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.example.builder;

import com.suncode.plugin.pwe.util.comparator.XpdlExampleDtoComparator;
import com.suncode.plugin.pwe.web.support.dto.example.XpdlExampleDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class XpdlExampleDtoBuilder {
    public static Logger log = Logger.getLogger(XpdlExampleDtoBuilder.class);
    private static final String PATH_SUBSTRING = "jar!";

    public List<XpdlExampleDto> build(Resource[] resources) {
        ArrayList<XpdlExampleDto> dtos = new ArrayList<XpdlExampleDto>();
        if (ArrayUtils.isNotEmpty((Object[])resources)) {
            for (Resource resource : resources) {
                if (!resource.exists()) continue;
                dtos.add(this.build(resource));
            }
            Collections.sort(dtos, new XpdlExampleDtoComparator());
        }
        return dtos;
    }

    public XpdlExampleDto build(Resource resource) {
        XpdlExampleDto dto = new XpdlExampleDto();
        dto.setName(this.buildName(resource));
        dto.setPath(this.buildPath(resource));
        return dto;
    }

    private String buildName(Resource resource) {
        return FilenameUtils.getBaseName((String)resource.getFilename());
    }

    private String buildPath(Resource resource) {
        try {
            return StringUtils.substringAfterLast((String)resource.getURL().toString(), (String)PATH_SUBSTRING);
        }
        catch (IOException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return "";
        }
    }
}

