/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.rest.advice;

import com.suncode.plugin.pwe.web.support.dto.exception.ExceptionDto;
import com.suncode.plugin.pwe.web.support.dto.exception.builder.ExceptionDtoBuilder;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ExceptionHandlerAdvice {
    public static Logger log = Logger.getLogger(ExceptionHandlerAdvice.class);
    @Autowired
    private ExceptionDtoBuilder exceptionDtoBuilder;

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ExceptionDto> handleException(Exception exception) {
        log.error((Object)exception.getMessage(), (Throwable)exception);
        ExceptionDto dto = this.buildException(exception);
        return new ResponseEntity((Object)dto, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private ExceptionDto buildException(Exception exception) {
        return this.exceptionDtoBuilder.build(exception);
    }
}

