/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.rest;

import com.suncode.plugin.pwe.service.userconfig.UserConfigService;
import com.suncode.plugin.pwe.web.support.dto.userconfig.UserConfigDto;
import com.suncode.plugin.pwe.web.support.util.RestUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/userconfig"})
public class UserConfigController {
    @Autowired
    private UserConfigService userConfigService;

    @RequestMapping(value={"get"}, method={RequestMethod.GET})
    @ResponseBody
    public UserConfigDto get(HttpServletRequest request, @RequestParam Boolean canUseDefaultUserConfig) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.userConfigService.getForUser(userId, BooleanUtils.isTrue((Boolean)canUseDefaultUserConfig));
    }

    @RequestMapping(value={"set"}, method={RequestMethod.POST})
    @ResponseBody
    public Boolean create(HttpServletRequest request, UserConfigDto dto) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.userConfigService.setForUser(userId, dto);
    }
}

