/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.rest;

import com.suncode.plugin.pwe.service.servererror.ServerErrorService;
import com.suncode.plugin.pwe.web.support.form.SaveServerErrorForm;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/api/servererror"})
public class ServerErrorController {
    private static final String CONTENT_TYPE = "text/plain";
    private static final String FILE_NAME = "server_error.txt";
    @Autowired
    private ServerErrorService serverErrorService;

    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> save(SaveServerErrorForm form) {
        byte[] bytes = this.serverErrorService.generateErrorTextFileContent(form);
        HttpHeaders responseHeaders = this.buildHeaders(bytes, CONTENT_TYPE, FILE_NAME);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private HttpHeaders buildHeaders(byte[] bytes, String contentType, String filename) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)contentType));
        responseHeaders.setContentLength((long)ArrayUtils.getLength((Object)bytes));
        responseHeaders.setContentDispositionFormData("attachment", filename);
        return responseHeaders;
    }
}

