/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.rest;

import com.google.gson.Gson;
import com.plusmpm.util.Authorization;
import com.suncode.plugin.pwe.service.configuration.PweAdministrationConfigurationService;
import com.suncode.plugin.pwe.service.configuration.PweConfigurationService;
import com.suncode.plugin.pwe.service.language.LanguageService;
import com.suncode.plugin.pwe.service.module.ScriptService;
import com.suncode.plugin.pwe.service.module.StyleService;
import com.suncode.plugin.pwe.service.permission.PermissionService;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.service.xpdl.InternalXpdlService;
import com.suncode.plugin.pwe.util.AuditType;
import com.suncode.plugin.pwe.web.support.dto.configuration.PweAdministrationConfigurationDto;
import com.suncode.plugin.pwe.web.support.dto.configuration.PweConfigurationDto;
import com.suncode.plugin.pwe.web.support.dto.module.ScriptDto;
import com.suncode.plugin.pwe.web.support.dto.module.StyleDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.ServerXpdlDto;
import com.suncode.plugin.pwe.web.support.form.PweConfigurationForm;
import com.suncode.plugin.pwe.web.support.util.RestUtils;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.ui.skin.Skin;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.jooq.tools.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/"})
public class PweController {
    private static final String UNAUTHORIZED = "pwe.unauthorized";
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private StyleService styleService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private LanguageService languageService;
    @Autowired
    private InternalXpdlService internalXpdlService;
    @Autowired
    private PweConfigurationService pweConfigurationService;
    @Autowired
    private PweAdministrationConfigurationService pweAdministrationConfigurationService;
    @Autowired
    private TranslatorService translatorService;

    @RequestMapping
    public ModelAndView program(HttpServletRequest request, PweConfigurationForm form) {
        Date started = new Date();
        String userId = RestUtils.getUserIdFromSession(request);
        if (this.shouldRunProgram(form, userId)) {
            ModelAndView modelAndView = new ModelAndView("pwe");
            modelAndView.addObject("styles", this.buildProgramStyles());
            modelAndView.addObject("scripts", this.buildProgramScripts());
            modelAndView.addObject("injectedScript", (Object)this.buildInjectedScript(form));
            modelAndView.addObject("language", (Object)this.buildLanguage());
            modelAndView.addObject("moduleStartTime", (Object)this.buildModuleStartTime());
            modelAndView.addObject("autoSaved", (Object)this.buildAutoSavedAsString(userId));
            modelAndView.addObject("configuration", (Object)this.buildPweConfigurationAsString(userId, form));
            modelAndView.addObject("skinPath", (Object)this.buildSkinPath(userId));
            this.logPluginOpenAudit(userId, started, true);
            return modelAndView;
        }
        this.logPluginOpenAudit(userId, started, false);
        return this.buildUnauthorizedView();
    }

    @RequestMapping(value={"administration"})
    public ModelAndView administration(HttpServletRequest request) {
        String userId = RestUtils.getUserIdFromSession(request);
        if (this.hasAdminRights(userId)) {
            ModelAndView modelAndView = new ModelAndView("pwe-administration");
            modelAndView.addObject("styles", this.buildAdministrationStyles());
            modelAndView.addObject("scripts", this.buildAdministrationScripts());
            modelAndView.addObject("configuration", (Object)this.buildPweAdministrationConfigurationAsString());
            return modelAndView;
        }
        return this.buildUnauthorizedView();
    }

    private boolean shouldRunProgram(PweConfigurationForm form, String userId) {
        return this.shouldSkipAuthorization(form) || this.isUserAuthorized(userId);
    }

    private boolean shouldSkipAuthorization(PweConfigurationForm form) {
        return BooleanUtils.isTrue((Boolean)form.getCurrentActivityMapMode()) || BooleanUtils.isTrue((Boolean)form.getProcessPreviewMode()) || BooleanUtils.isTrue((Boolean)form.getSimulationMode());
    }

    private boolean isUserAuthorized(String userId) {
        return this.permissionService.isAuthorized(userId);
    }

    private boolean hasAdminRights(String userId) {
        try {
            int right = Authorization.checkRight((String)"system.admin", (String)userId, (boolean)false, (boolean)false);
            return right == 0;
        }
        catch (SQLException exception) {
            return false;
        }
    }

    private String buildUnauthorizedMessage() {
        return this.translatorService.translateMessage(UNAUTHORIZED);
    }

    private List<StyleDto> buildProgramStyles() {
        return this.styleService.getAllForProgram();
    }

    private List<ScriptDto> buildProgramScripts() {
        return this.scriptService.getAllForProgram();
    }

    private ScriptDto buildInjectedScript(PweConfigurationForm form) {
        return this.scriptService.getInjectedScript(BooleanUtils.isTrue((Boolean)form.getDevMode()));
    }

    private String buildLanguage() {
        return this.languageService.getLanguage();
    }

    private String buildModuleStartTime() {
        return String.valueOf(System.currentTimeMillis());
    }

    private String buildAutoSavedAsString(String userId) {
        Gson gson = new Gson();
        String json = gson.toJson(this.buildAutoSaved(userId));
        return JSONObject.escape((String)json);
    }

    private List<ServerXpdlDto> buildAutoSaved(String userId) {
        return this.internalXpdlService.getAutoSaved(userId);
    }

    private String buildPweConfigurationAsString(String userId, PweConfigurationForm form) {
        Gson gson = new Gson();
        String json = gson.toJson((Object)this.buildPweConfiguration(userId, form));
        return JSONObject.escape((String)json);
    }

    private PweConfigurationDto buildPweConfiguration(String userId, PweConfigurationForm form) {
        return this.pweConfigurationService.build(userId, form);
    }

    private void logPluginOpenAudit(String userId, Date started, boolean success) {
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_PLUGIN_RUN.getValue()).username(userId).success(success).params(new LinkedHashMap()).started(started).stopped(new Date()).build().log();
    }

    private List<StyleDto> buildAdministrationStyles() {
        return this.styleService.getAllForAdministration();
    }

    private List<ScriptDto> buildAdministrationScripts() {
        return this.scriptService.getAllForAdministration();
    }

    private String buildPweAdministrationConfigurationAsString() {
        Gson gson = new Gson();
        String json = gson.toJson((Object)this.buildPweAdministrationConfiguration());
        return JSONObject.escape((String)json);
    }

    private PweAdministrationConfigurationDto buildPweAdministrationConfiguration() {
        return this.pweAdministrationConfigurationService.build();
    }

    private ModelAndView buildUnauthorizedView() {
        ModelAndView modelAndView = new ModelAndView(UNAUTHORIZED);
        modelAndView.addObject("unauthorizedMessage", (Object)this.buildUnauthorizedMessage());
        return modelAndView;
    }

    @RequestMapping(value={"close"}, method={RequestMethod.GET})
    public ResponseEntity<Void> close(HttpServletRequest request) {
        Date started = new Date();
        String userId = RestUtils.getUserIdFromSession(request);
        this.logPluginCloseAudit(userId, started);
        return new ResponseEntity(HttpStatus.OK);
    }

    private void logPluginCloseAudit(String userId, Date started) {
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_PLUGIN_CLOSE.getValue()).username(userId).success(true).params(new LinkedHashMap()).started(started).stopped(new Date()).build().log();
    }

    private String buildSkinPath(String userId) {
        UserSettingsService userSettingsService = (UserSettingsService)SpringContext.getBean(UserSettingsService.class);
        Skin userSkin = userSettingsService.getSkinForUser(userId);
        switch (userSkin.getKey()) {
            case "pwfl-dark": {
                return "pwfl_dark_pwe.css";
            }
            case "pwfl-dark-compact": {
                return "pwfl_dark_compact_pwe.css";
            }
            case "pwfl-high-contrast": {
                return "pwfl_high_contrast_pwe.css";
            }
            case "pwfl-high-contrast-compact": {
                return "pwfl_high_contrast_compact_pwe.css";
            }
        }
        return "default";
    }
}

