/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.rest;

import com.suncode.plugin.pwe.service.jscode.JsCodeService;
import com.suncode.plugin.pwe.web.support.dto.jscode.JsCodeDto;
import com.suncode.plugin.pwe.web.support.form.JsCodeForm;
import com.suncode.plugin.pwe.web.support.result.DataResult;
import com.suncode.plugin.pwe.web.support.util.RestUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/jscode"})
public class JsCodeController {
    @Autowired
    private JsCodeService jsCodeService;

    @RequestMapping(value={"get"}, method={RequestMethod.POST})
    @ResponseBody
    public DataResult<JsCodeDto> get(HttpServletRequest request, JsCodeForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        JsCodeDto dto = this.jsCodeService.get(userId, form);
        return new DataResult<JsCodeDto>(true, dto);
    }

    @RequestMapping(value={"set"}, method={RequestMethod.POST})
    @ResponseBody
    public Boolean set(HttpServletRequest request, JsCodeDto dto) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.jsCodeService.set(userId, dto);
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean delete(@RequestParam String functionName) {
        return this.jsCodeService.delete(functionName);
    }

    @RequestMapping(value={"getFromTemplate"}, method={RequestMethod.POST}, produces={"text/plain; charset=utf-8"})
    @ResponseBody
    public String getSourceCode(JsCodeForm form) {
        return this.jsCodeService.getSourceCodeFromTemplate(form);
    }

    @RequestMapping(value={"generate"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> generate(HttpServletRequest request, @RequestParam String customJs, @RequestParam String packageId) {
        String userId = RestUtils.getUserIdFromSession(request);
        byte[] bytes = this.jsCodeService.generate(userId, customJs);
        HttpHeaders responseHeaders = this.buildHeaders(bytes, packageId);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private HttpHeaders buildHeaders(byte[] bytes, String packageId) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)"application/js"));
        responseHeaders.setContentLength((long)ArrayUtils.getLength((Object)bytes));
        responseHeaders.setContentDispositionFormData("attachment", this.buildFilename(packageId));
        return responseHeaders;
    }

    private String buildFilename(String packageId) {
        StringBuilder filename = new StringBuilder();
        filename.append("suncodescripts_");
        filename.append(packageId);
        filename.append(".js");
        return filename.toString();
    }
}

