/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.rest;

import com.suncode.plugin.pwe.service.javacode.JavaCodeService;
import com.suncode.plugin.pwe.web.support.dto.javacode.JavaCodeDto;
import com.suncode.plugin.pwe.web.support.dto.javacode.JavaCodeValidationDto;
import com.suncode.plugin.pwe.web.support.form.JavaCodeForm;
import com.suncode.plugin.pwe.web.support.result.DataResult;
import com.suncode.plugin.pwe.web.support.util.RestUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/javacode"})
public class JavaCodeController {
    @Autowired
    private JavaCodeService javaCodeService;

    @RequestMapping(value={"get"}, method={RequestMethod.POST})
    @ResponseBody
    public DataResult<JavaCodeDto> get(HttpServletRequest request, JavaCodeForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        JavaCodeDto dto = this.javaCodeService.get(userId, form);
        return new DataResult<JavaCodeDto>(true, dto);
    }

    @RequestMapping(value={"validate"}, method={RequestMethod.POST})
    @ResponseBody
    public DataResult<JavaCodeValidationDto> validate(JavaCodeDto dto) {
        JavaCodeValidationDto validationDto = this.javaCodeService.validate(dto);
        return new DataResult<JavaCodeValidationDto>(true, validationDto);
    }

    @RequestMapping(value={"set"}, method={RequestMethod.POST})
    @ResponseBody
    public Boolean set(HttpServletRequest request, JavaCodeDto dto) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.javaCodeService.set(userId, dto);
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean delete(@RequestParam String qualifiedName) {
        return this.javaCodeService.delete(qualifiedName);
    }

    @RequestMapping(value={"getFromTemplate"}, method={RequestMethod.POST}, produces={"text/plain; charset=utf-8"})
    @ResponseBody
    public String getSourceCode(HttpServletRequest request, JavaCodeForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.javaCodeService.getSourceCodeFromTemplate(userId, form);
    }

    @RequestMapping(value={"generate"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> generate(HttpServletRequest request, @RequestParam String javaClasses, @RequestParam String fileName) {
        String userId = RestUtils.getUserIdFromSession(request);
        byte[] bytes = this.javaCodeService.generate(userId, javaClasses);
        HttpHeaders responseHeaders = this.buildHeaders(bytes, fileName);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"loadToSystem"}, method={RequestMethod.POST})
    public ResponseEntity<Void> loadToSystem(HttpServletRequest request, @RequestParam String javaClasses) {
        String userId = RestUtils.getUserIdFromSession(request);
        this.javaCodeService.loadToSystem(userId, javaClasses);
        return new ResponseEntity(HttpStatus.OK);
    }

    private HttpHeaders buildHeaders(byte[] bytes, String fileName) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)"application/zip"));
        responseHeaders.setContentLength((long)ArrayUtils.getLength((Object)bytes));
        responseHeaders.setContentDispositionFormData("attachment", this.buildFilename(fileName));
        return responseHeaders;
    }

    private String buildFilename(String fileName) {
        StringBuilder filename = new StringBuilder();
        filename.append(fileName);
        filename.append(" - Java.zip");
        return filename.toString();
    }
}

