/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.rest;

import com.suncode.plugin.pwe.service.documentationconfig.DocumentationConfigService;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.SetDocumentationConfigDto;
import com.suncode.plugin.pwe.web.support.result.DataResult;
import com.suncode.plugin.pwe.web.support.util.RestUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/documentationconfig"})
public class DocumentationConfigController {
    private static final String HTML_CONTENT_TYPE = "text/html";
    @Autowired
    private DocumentationConfigService documentationConfigService;

    @RequestMapping(value={"default"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResult<DocumentationConfigDto> get(HttpServletRequest request) {
        String userId = RestUtils.getUserIdFromSession(request);
        DocumentationConfigDto dto = this.documentationConfigService.getDefaultForUser(userId);
        return new DataResult<DocumentationConfigDto>(true, dto);
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResult<DocumentationConfigDto> get(HttpServletRequest request, @RequestParam String type) {
        String userId = RestUtils.getUserIdFromSession(request);
        DocumentationConfigDto dto = this.documentationConfigService.getForUser(userId, type);
        return new DataResult<DocumentationConfigDto>(true, dto);
    }

    @RequestMapping(value={"set"}, method={RequestMethod.POST})
    public ResponseEntity<SetDocumentationConfigDto> create(HttpServletRequest request, DocumentationConfigDto dto) {
        String userId = RestUtils.getUserIdFromSession(request);
        SetDocumentationConfigDto response = this.documentationConfigService.setForUser(userId, dto);
        return this.buildHtmlResponse(response);
    }

    private <T> ResponseEntity<T> buildHtmlResponse(T dto) {
        HttpHeaders responseHeaders = this.buildHeaders(HTML_CONTENT_TYPE);
        return new ResponseEntity(dto, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private HttpHeaders buildHeaders(String contentType) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)contentType));
        return responseHeaders;
    }
}

