/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.processspecification;

import com.suncode.plugin.pwe.documentation.specification.ActivitiesOrderPositionSpecification;
import com.suncode.plugin.pwe.documentation.specification.ActivitiesOrderSpecification;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.ApplicationSpecification;
import com.suncode.plugin.pwe.documentation.specification.AssumptionsAndScopeSpecification;
import com.suncode.plugin.pwe.documentation.specification.AttachmentSpecification;
import com.suncode.plugin.pwe.documentation.specification.ButtonSpecification;
import com.suncode.plugin.pwe.documentation.specification.ColumnSpecification;
import com.suncode.plugin.pwe.documentation.specification.DatabaseTableSpecification;
import com.suncode.plugin.pwe.documentation.specification.DescriptionSpecification;
import com.suncode.plugin.pwe.documentation.specification.DocumentClassSpecification;
import com.suncode.plugin.pwe.documentation.specification.DocumentLinkSpecification;
import com.suncode.plugin.pwe.documentation.specification.DtButtonSpecification;
import com.suncode.plugin.pwe.documentation.specification.FormVariableSpecification;
import com.suncode.plugin.pwe.documentation.specification.GeneratedDocumentSpecification;
import com.suncode.plugin.pwe.documentation.specification.IntegrationSpecification;
import com.suncode.plugin.pwe.documentation.specification.ParameterSpecification;
import com.suncode.plugin.pwe.documentation.specification.ParticipantSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProgrammingTaskSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProjectExclusionSpecification;
import com.suncode.plugin.pwe.documentation.specification.ScheduledTaskSpecification;
import com.suncode.plugin.pwe.documentation.specification.TableButtonSpecification;
import com.suncode.plugin.pwe.documentation.specification.TableSpecification;
import com.suncode.plugin.pwe.documentation.specification.TeamMemberSpecification;
import com.suncode.plugin.pwe.documentation.specification.TeamSpecification;
import com.suncode.plugin.pwe.documentation.specification.TransitionSpecification;
import com.suncode.plugin.pwe.documentation.specification.UtilizationSpecification;
import com.suncode.plugin.pwe.documentation.specification.VariableSpecification;
import com.suncode.plugin.pwe.documentation.specification.ViewDocumentClassSpecification;
import com.suncode.plugin.pwe.service.xml.XmlService;
import com.suncode.plugin.pwe.util.XmlAttribute;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class ProcessSpecificationMarshaller {
    @Autowired
    private XmlService xmlService;

    public void marshall(OutputStream outputStream, ProcessSpecification processSpecification) throws Exception {
        Document document = this.xmlService.create();
        Element root = ProcessSpecificationMarshaller.marshallRoot(document);
        document.appendChild(root);
        this.xmlService.setElementAttribute(root, new XmlAttribute("id", processSpecification.getId()));
        this.xmlService.setElementAttribute(root, new XmlAttribute("dtButtonsSupplied", processSpecification.getDtButtonsSupplied()));
        this.xmlService.setElementAttribute(root, new XmlAttribute("ProcessMapImage", processSpecification.getProcessMapImage()));
        Element activitySpecificationsElement = this.marshallActivitySpecifications(document, processSpecification.getActivitySpecifications());
        root.appendChild(activitySpecificationsElement);
        Element applicationSpecificationsElement = this.marshallApplicationSpecifications(document, processSpecification.getApplicationSpecifications());
        root.appendChild(applicationSpecificationsElement);
        Element assumptionsAndScopeElement = this.marshallAssumptionsAndScope(document, processSpecification.getAssumptionsAndScope());
        root.appendChild(assumptionsAndScopeElement);
        Element attachmentsElement = this.marshallAttachments(document, processSpecification.getAttachmentSpecifications());
        root.appendChild(attachmentsElement);
        Element activitiesOrderElement = this.marshallActivitiesOrder(document, processSpecification.getActivitiesOrder());
        root.appendChild(activitiesOrderElement);
        Element databaseTablesElement = this.marshallDatabaseTables(document, processSpecification.getDatabaseTableSpecifications());
        root.appendChild(databaseTablesElement);
        Element documentClassesElement = this.marshallDocumentClasses(document, processSpecification.getDocumentClassSpecifications());
        root.appendChild(documentClassesElement);
        Element documentLinksElement = this.marshallDocumentLinks(document, processSpecification.getDocumentLinkSpecifications());
        root.appendChild(documentLinksElement);
        Element integrationsElement = this.marshallIntegrations(document, processSpecification.getIntegrationSpecifications());
        root.appendChild(integrationsElement);
        Element participantSpecificationsElement = this.marshallParticipantSpecifications(document, processSpecification.getParticipantSpecifications());
        root.appendChild(participantSpecificationsElement);
        Element projectExclusionsElement = this.marshallProjectExclusions(document, processSpecification.getProjectExclusionSpecifications());
        root.appendChild(projectExclusionsElement);
        Element programmingTasksElement = this.marshallProgrammingTasks(document, processSpecification.getProgrammingTaskSpecifications());
        root.appendChild(programmingTasksElement);
        Element ScheduledTasksElement = this.marshallScheduledTasks(document, processSpecification.getScheduledTaskSpecifications());
        root.appendChild(ScheduledTasksElement);
        Element tableButtonSpecificationsElement = this.marshallTableButtonSpecifications(document, processSpecification.getTableButtonSpecifications());
        root.appendChild(tableButtonSpecificationsElement);
        Element tableSpecificationsElement = this.marshallTableSpecifications(document, processSpecification.getTableSpecifications());
        root.appendChild(tableSpecificationsElement);
        Element variableSpecificationsElement = this.marshallVariableSpecifications(document, processSpecification.getVariableSpecifications());
        root.appendChild(variableSpecificationsElement);
        this.xmlService.writeToOutputStream(outputStream, document);
    }

    private static Element marshallRoot(Document document) {
        return document.createElement("Process");
    }

    private Element marshallActivitySpecifications(Document document, Map<String, ActivitySpecification> activitySpecifications) {
        Element element = document.createElement("Activities");
        activitySpecifications.entrySet().stream().forEach(entry -> {
            Element activitySpecificationElement = this.marshallActivitySpecification(document, (String)entry.getKey(), (ActivitySpecification)entry.getValue());
            element.appendChild(activitySpecificationElement);
        });
        return element;
    }

    private Element marshallActivitySpecification(Document document, String id, ActivitySpecification activitySpecification) {
        Element element = document.createElement("Activity");
        this.xmlService.setElementAttribute(element, new XmlAttribute("id", id));
        Element specificationElement = document.createElement("Specification");
        this.xmlService.appendTextElement(document, specificationElement, "FormImage", activitySpecification.getFormImage());
        this.xmlService.appendTextElement(document, specificationElement, "EmailNotificationsDescription", activitySpecification.getEmailNotificationsDescription());
        this.xmlService.appendTextElement(document, specificationElement, "GeneralActivityDescription", activitySpecification.getGeneralActivityDescription());
        Element buttonSpecificationsElement = this.marshallButtonSpecifications(document, activitySpecification.getButtonSpecifications());
        specificationElement.appendChild(buttonSpecificationsElement);
        Element dtButtonSpecificationsElement = this.marshallDtButtonSpecifications(document, activitySpecification.getDtButtonSpecifications());
        specificationElement.appendChild(dtButtonSpecificationsElement);
        Element formVariableSpecificationsElement = this.marshallFormVariableSpecifications(document, activitySpecification.getFormVariableSpecifications());
        specificationElement.appendChild(formVariableSpecificationsElement);
        Element generatedDocumentsElement = this.marshallGeneratedDocuments(document, activitySpecification.getGeneratedDocuments());
        specificationElement.appendChild(generatedDocumentsElement);
        Element transitionSpecificationsElement = this.marshallTransitionSpecifications(document, activitySpecification.getTransitionSpecifications());
        specificationElement.appendChild(transitionSpecificationsElement);
        Element viewDocumentClassesElement = this.marshallViewDocumentClasses(document, activitySpecification.getViewDocumentClasses());
        specificationElement.appendChild(viewDocumentClassesElement);
        element.appendChild(specificationElement);
        return element;
    }

    private Element marshallButtonSpecifications(Document document, Map<String, ButtonSpecification> buttonSpecifications) {
        return this.marshallDescriptionSpecifications(document, "Buttons", buttonSpecifications, "Button", "id", "Description");
    }

    private Element marshallDtButtonSpecifications(Document document, Map<String, DtButtonSpecification> dtButtonSpecifications) {
        return this.marshallDescriptionSpecifications(document, "DtButtons", dtButtonSpecifications, "DtButton", "id", "Description");
    }

    private Element marshallFormVariableSpecifications(Document document, Map<String, FormVariableSpecification> formVariableSpecifications) {
        return this.marshallDescriptionSpecifications(document, "FormVariables", formVariableSpecifications, "FormVariable", "id", "Description");
    }

    private Element marshallGeneratedDocuments(Document document, List<GeneratedDocumentSpecification> generatedDocuments) {
        Element element = document.createElement("GeneratedDocuments");
        generatedDocuments.stream().forEach(generatedDocument -> {
            Element generatedDocumentElement = this.marshallGeneratedDocument(document, (GeneratedDocumentSpecification)generatedDocument);
            element.appendChild(generatedDocumentElement);
        });
        return element;
    }

    private Element marshallGeneratedDocument(Document document, GeneratedDocumentSpecification generatedDocument) {
        Element element = document.createElement("GeneratedDocument");
        this.xmlService.appendTextElement(document, element, "Name", generatedDocument.getName());
        return element;
    }

    private Element marshallTransitionSpecifications(Document document, Map<String, TransitionSpecification> transitionSpecifications) {
        return this.marshallDescriptionSpecifications(document, "Transitions", transitionSpecifications, "Transition", "to", "Description");
    }

    private Element marshallViewDocumentClasses(Document document, List<ViewDocumentClassSpecification> viewDocumentClasses) {
        Element element = document.createElement("ViewDocumentClasses");
        viewDocumentClasses.stream().forEach(viewDocumentClass -> {
            Element viewDocumentClassElement = this.marshallViewDocumentClass(document, (ViewDocumentClassSpecification)viewDocumentClass);
            element.appendChild(viewDocumentClassElement);
        });
        return element;
    }

    private Element marshallViewDocumentClass(Document document, ViewDocumentClassSpecification viewDocumentClass) {
        Element element = document.createElement("ViewDocumentClass");
        this.xmlService.appendTextElement(document, element, "Name", viewDocumentClass.getName());
        return element;
    }

    private Element marshallApplicationSpecifications(Document document, Map<String, ApplicationSpecification> applicationSpecifications) {
        return this.marshallDescriptionSpecifications(document, "Applications", applicationSpecifications, "Application", "id", "Description");
    }

    private Element marshallAssumptionsAndScope(Document document, AssumptionsAndScopeSpecification assumptionsAndScope) {
        Element element = document.createElement("AssumptionsAndScope");
        this.xmlService.appendTextElement(document, element, "ClientName", assumptionsAndScope.getClientName());
        this.xmlService.appendTextElement(document, element, "SystemLink", assumptionsAndScope.getSystemLink());
        this.xmlService.appendTextElement(document, element, "GeneralProcessDescription", assumptionsAndScope.getGeneralProcessDescription());
        this.xmlService.appendTextElement(document, element, "ProcessInitiationMethod", assumptionsAndScope.getProcessInitiationMethod());
        this.xmlService.appendTextElement(document, element, "EmailNotificationsDescription", assumptionsAndScope.getEmailNotificationsDescription());
        this.xmlService.appendTextElement(document, element, "ProcessesPerMonth", assumptionsAndScope.getProcessesPerMonth());
        this.xmlService.appendTextElement(document, element, "UsersInProcess", assumptionsAndScope.getUsersInProcess());
        Element analysisTeamElement = this.marshallAnalysisTeam(document, assumptionsAndScope.getAnalysisTeam());
        element.appendChild(analysisTeamElement);
        Element projectTeamElement = this.marshallProjectTeam(document, assumptionsAndScope.getProjectTeam());
        element.appendChild(projectTeamElement);
        return element;
    }

    private Element marshallAnalysisTeam(Document document, TeamSpecification analysisTeam) {
        return this.marshallTeam(document, "AnalysisTeam", analysisTeam);
    }

    private Element marshallProjectTeam(Document document, TeamSpecification projectTeam) {
        return this.marshallTeam(document, "ProjectTeam", projectTeam);
    }

    private Element marshallTeam(Document document, String nodeName, TeamSpecification team) {
        Element element = document.createElement(nodeName);
        Element clientSideMembersElement = this.marshallClientSideMembers(document, team.getClientSideMembers());
        element.appendChild(clientSideMembersElement);
        Element companySideMembersElement = this.marshallCompanySideMembers(document, team.getCompanySideMembers());
        element.appendChild(companySideMembersElement);
        return element;
    }

    private Element marshallClientSideMembers(Document document, List<TeamMemberSpecification> members) {
        return this.marshallMembers(document, "ClientSide", members);
    }

    private Element marshallCompanySideMembers(Document document, List<TeamMemberSpecification> members) {
        return this.marshallMembers(document, "CompanySide", members);
    }

    private Element marshallMembers(Document document, String nodeName, List<TeamMemberSpecification> members) {
        Element element = document.createElement(nodeName);
        members.stream().forEach(member -> {
            Element memberElement = this.marshallMember(document, (TeamMemberSpecification)member);
            element.appendChild(memberElement);
        });
        return element;
    }

    private Element marshallMember(Document document, TeamMemberSpecification member) {
        Element element = document.createElement("Member");
        this.xmlService.appendTextElement(document, element, "Name", member.getName());
        return element;
    }

    private Element marshallAttachments(Document document, List<AttachmentSpecification> attachments) {
        Element element = document.createElement("Attachments");
        attachments.stream().forEach(attachment -> {
            Element attachmentElement = this.marshallAttachment(document, (AttachmentSpecification)attachment);
            element.appendChild(attachmentElement);
        });
        return element;
    }

    private Element marshallAttachment(Document document, AttachmentSpecification attachment) {
        Element element = document.createElement("Attachment");
        this.xmlService.appendTextElement(document, element, "Id", attachment.getId());
        this.xmlService.appendTextElement(document, element, "Name", attachment.getName());
        this.xmlService.appendTextElement(document, element, "FileName", attachment.getFileName());
        this.xmlService.appendTextElement(document, element, "Description", attachment.getDescription());
        return element;
    }

    private Element marshallActivitiesOrder(Document document, ActivitiesOrderSpecification activitiesOrder) {
        Element element = document.createElement("ActivitiesOrder");
        this.xmlService.appendTextElement(document, element, "Type", activitiesOrder.getType());
        Element activitiesOrderSequenceElement = this.marshallActivitiesOrderSequence(document, activitiesOrder.getSequence());
        element.appendChild(activitiesOrderSequenceElement);
        return element;
    }

    private Element marshallActivitiesOrderSequence(Document document, List<ActivitiesOrderPositionSpecification> sequence) {
        Element element = document.createElement("Sequence");
        sequence.stream().forEach(position -> {
            Element positionElement = this.marshallActivitiesOrderPosition(document, (ActivitiesOrderPositionSpecification)position);
            element.appendChild(positionElement);
        });
        return element;
    }

    private Element marshallActivitiesOrderPosition(Document document, ActivitiesOrderPositionSpecification position) {
        Element element = document.createElement("Position");
        this.xmlService.appendTextElement(document, element, "ActivityDefId", position.getActivityDefId());
        return element;
    }

    private Element marshallDatabaseTables(Document document, List<DatabaseTableSpecification> databaseTables) {
        Element element = document.createElement("DatabaseTables");
        databaseTables.stream().forEach(databaseTable -> {
            Element databaseTableElement = this.marshallDatabaseTable(document, (DatabaseTableSpecification)databaseTable);
            element.appendChild(databaseTableElement);
        });
        return element;
    }

    private Element marshallDatabaseTable(Document document, DatabaseTableSpecification databaseTable) {
        Element element = document.createElement("DatabaseTable");
        this.xmlService.appendTextElement(document, element, "AddedFromAdministration", databaseTable.getAddedFromAdministration());
        this.xmlService.appendTextElement(document, element, "DatabaseType", databaseTable.getDatabaseType());
        this.xmlService.appendTextElement(document, element, "Name", databaseTable.getName());
        this.xmlService.appendTextElement(document, element, "Location", databaseTable.getLocation());
        Element columnsElement = this.marshallColumns(document, databaseTable.getColumns());
        element.appendChild(columnsElement);
        Element utilizationInActivitiesElement = this.marshallUtilizationInActivities(document, databaseTable.getUtilizationInActivities());
        element.appendChild(utilizationInActivitiesElement);
        return element;
    }

    private Element marshallColumns(Document document, List<ColumnSpecification> columns) {
        Element element = document.createElement("Columns");
        columns.stream().forEach(column -> {
            Element columnElement = this.marshallColumn(document, (ColumnSpecification)column);
            element.appendChild(columnElement);
        });
        return element;
    }

    private Element marshallColumn(Document document, ColumnSpecification column) {
        Element element = document.createElement("Column");
        this.xmlService.appendTextElement(document, element, "Name", column.getName());
        this.xmlService.appendTextElement(document, element, "Description", column.getDescription());
        this.xmlService.appendTextElement(document, element, "Type", column.getType());
        return element;
    }

    private Element marshallUtilizationInActivities(Document document, List<UtilizationSpecification> utilizations) {
        Element element = document.createElement("UtilizationInActivities");
        utilizations.stream().forEach(utilization -> {
            Element utilizationElement = this.marshallUtilizationInActivity(document, (UtilizationSpecification)utilization);
            element.appendChild(utilizationElement);
        });
        return element;
    }

    private Element marshallUtilizationInActivity(Document document, UtilizationSpecification utilization) {
        Element element = document.createElement("Utilization");
        this.xmlService.appendTextElement(document, element, "ActivityDefId", utilization.getActivityDefId());
        this.xmlService.appendTextElement(document, element, "Description", utilization.getDescription());
        return element;
    }

    private Element marshallDocumentClasses(Document document, List<DocumentClassSpecification> documentClasses) {
        Element element = document.createElement("DocumentClasses");
        documentClasses.stream().forEach(documentClass -> {
            Element documentClassElement = this.marshallDocumentClass(document, (DocumentClassSpecification)documentClass);
            element.appendChild(documentClassElement);
        });
        return element;
    }

    private Element marshallDocumentClass(Document document, DocumentClassSpecification documentClass) {
        Element element = document.createElement("DocumentClass");
        this.xmlService.appendTextElement(document, element, "Name", documentClass.getName());
        this.xmlService.appendTextElement(document, element, "Description", documentClass.getDescription());
        return element;
    }

    private Element marshallDocumentLinks(Document document, List<DocumentLinkSpecification> documentLinks) {
        Element element = document.createElement("DocumentLinks");
        documentLinks.stream().forEach(documentLink -> {
            Element documentLinkElement = this.marshallDocumentLink(document, (DocumentLinkSpecification)documentLink);
            element.appendChild(documentLinkElement);
        });
        return element;
    }

    private Element marshallDocumentLink(Document document, DocumentLinkSpecification documentLink) {
        Element element = document.createElement("DocumentLink");
        this.xmlService.appendTextElement(document, element, "Name", documentLink.getName());
        this.xmlService.appendTextElement(document, element, "Description", documentLink.getDescription());
        return element;
    }

    private Element marshallIntegrations(Document document, List<IntegrationSpecification> integrations) {
        Element element = document.createElement("Integrations");
        integrations.stream().forEach(integration -> {
            Element integrationElement = this.marshallIntegration(document, (IntegrationSpecification)integration);
            element.appendChild(integrationElement);
        });
        return element;
    }

    private Element marshallIntegration(Document document, IntegrationSpecification integration) {
        Element element = document.createElement("Integration");
        this.xmlService.appendTextElement(document, element, "Name", integration.getName());
        this.xmlService.appendTextElement(document, element, "Description", integration.getDescription());
        this.xmlService.appendTextElement(document, element, "SystemName", integration.getSystemName());
        this.xmlService.appendTextElement(document, element, "IntegrationMethod", integration.getIntegrationMethod());
        this.xmlService.appendTextElement(document, element, "Purpose", integration.getPurpose());
        return element;
    }

    private Element marshallParticipantSpecifications(Document document, Map<String, ParticipantSpecification> participantSpecifications) {
        return this.marshallDescriptionSpecifications(document, "Participants", participantSpecifications, "Participant", "id", "Description");
    }

    private Element marshallProjectExclusions(Document document, List<ProjectExclusionSpecification> projectExclusions) {
        Element element = document.createElement("ProjectExclusions");
        projectExclusions.stream().forEach(projectExclusion -> {
            Element projectExclusionElement = this.marshallProjectExclusion(document, (ProjectExclusionSpecification)projectExclusion);
            element.appendChild(projectExclusionElement);
        });
        return element;
    }

    private Element marshallProjectExclusion(Document document, ProjectExclusionSpecification projectExclusion) {
        Element element = document.createElement("ProjectExclusion");
        this.xmlService.appendTextElement(document, element, "Name", projectExclusion.getName());
        this.xmlService.appendTextElement(document, element, "Contents", projectExclusion.getContents());
        return element;
    }

    private Element marshallProgrammingTasks(Document document, List<ProgrammingTaskSpecification> programmingTasks) {
        Element element = document.createElement("ProgrammingTasks");
        programmingTasks.stream().forEach(programmingTask -> {
            Element programmingTaskElement = this.marshallProgrammingTask(document, (ProgrammingTaskSpecification)programmingTask);
            element.appendChild(programmingTaskElement);
        });
        return element;
    }

    private Element marshallProgrammingTask(Document document, ProgrammingTaskSpecification programmingTask) {
        Element element = document.createElement("ProgramingTask");
        this.xmlService.appendTextElement(document, element, "Name", programmingTask.getName());
        this.xmlService.appendTextElement(document, element, "Description", programmingTask.getDescription());
        this.xmlService.appendTextElement(document, element, "Type", programmingTask.getType());
        this.xmlService.appendTextElement(document, element, "ExecutionLocation", programmingTask.getExecutionLocation());
        this.xmlService.appendTextElement(document, element, "AlgorithmDescription", programmingTask.getAlgorithmDescription());
        Element inputParametersElement = this.marshallParameters(document, "InputParameters", programmingTask.getInputParameters());
        element.appendChild(inputParametersElement);
        Element outputParametersElement = this.marshallParameters(document, "OutputParameters", programmingTask.getOutputParameters());
        element.appendChild(outputParametersElement);
        return element;
    }

    private Element marshallParameters(Document document, String nodeName, List<ParameterSpecification> parameters) {
        Element element = document.createElement(nodeName);
        parameters.stream().forEach(parameter -> {
            Element parameterElement = this.marshallParameter(document, (ParameterSpecification)parameter);
            element.appendChild(parameterElement);
        });
        return element;
    }

    private Element marshallParameter(Document document, ParameterSpecification parameter) {
        Element element = document.createElement("parameter-specification");
        this.xmlService.appendTextElement(document, element, "Name", parameter.getName());
        this.xmlService.appendTextElement(document, element, "Description", parameter.getDescription());
        return element;
    }

    private Element marshallScheduledTasks(Document document, List<ScheduledTaskSpecification> scheduledTasks) {
        Element element = document.createElement("ScheduledTasks");
        scheduledTasks.stream().forEach(scheduledTask -> {
            Element scheduledTaskElement = this.marshallScheduledTask(document, (ScheduledTaskSpecification)scheduledTask);
            element.appendChild(scheduledTaskElement);
        });
        return element;
    }

    private Element marshallScheduledTask(Document document, ScheduledTaskSpecification scheduledTask) {
        Element element = document.createElement("ScheduledTask");
        this.xmlService.appendTextElement(document, element, "Name", scheduledTask.getName());
        this.xmlService.appendTextElement(document, element, "Description", scheduledTask.getDescription());
        this.xmlService.appendTextElement(document, element, "ClassName", scheduledTask.getClassName());
        this.xmlService.appendTextElement(document, element, "MethodName", scheduledTask.getMethodName());
        this.xmlService.appendTextElement(document, element, "AlgorithmDescription", scheduledTask.getAlgorithmDescription());
        this.xmlService.appendTextElement(document, element, "ExecutionFrequencyValue", scheduledTask.getExecutionFrequencyValue());
        this.xmlService.appendTextElement(document, element, "ExecutionFrequencyUnit", scheduledTask.getExecutionFrequencyUnit());
        Element inputParametersElement = this.marshallParameters(document, "InputParameters", scheduledTask.getInputParameters());
        element.appendChild(inputParametersElement);
        return element;
    }

    private Element marshallTableButtonSpecifications(Document document, Map<String, TableButtonSpecification> tableButtonSpecifications) {
        return this.marshallDescriptionSpecifications(document, "TableButtons", tableButtonSpecifications, "TableButton", "id", "Description");
    }

    private Element marshallTableSpecifications(Document document, Map<String, TableSpecification> tableSpecifications) {
        return this.marshallDescriptionSpecifications(document, "Tables", tableSpecifications, "Table", "id", "Description");
    }

    private Element marshallVariableSpecifications(Document document, Map<String, VariableSpecification> variableSpecifications) {
        return this.marshallDescriptionSpecifications(document, "Variables", variableSpecifications, "Variable", "id", "Description");
    }

    private Element marshallDescriptionSpecifications(Document document, String listNodeName, Map<String, ? extends DescriptionSpecification> descriptionSpecifications, String itemNodeName, String idAttrName, String descriptionNodeName) {
        Element element = document.createElement(listNodeName);
        descriptionSpecifications.entrySet().stream().forEach(entry -> {
            Element descriptionSpecificationElement = this.marshallDescriptionSpecification(document, itemNodeName, idAttrName, (String)entry.getKey(), descriptionNodeName, (DescriptionSpecification)entry.getValue());
            element.appendChild(descriptionSpecificationElement);
        });
        return element;
    }

    private Element marshallDescriptionSpecification(Document document, String nodeName, String idAttrName, String id, String descriptionNodeName, DescriptionSpecification descriptionSpecification) {
        Element element = document.createElement(nodeName);
        this.xmlService.setElementAttribute(element, new XmlAttribute(idAttrName, id));
        Element specificationElement = document.createElement("Specification");
        this.xmlService.appendTextElement(document, specificationElement, descriptionNodeName, descriptionSpecification.getDescription());
        element.appendChild(specificationElement);
        return element;
    }
}

