/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.documentation;

import com.google.common.collect.Lists;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.framework.PluginStoreResource;
import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.builder.DocumentationBuilder;
import com.suncode.plugin.pwe.documentation.changecard.builder.ChangeCardBuilder;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.json.JsonConverter;
import com.suncode.plugin.pwe.service.documentationconfig.DocumentationConfigService;
import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.service.processfile.ProcessFileService;
import com.suncode.plugin.pwe.service.xml.XmlService;
import com.suncode.plugin.pwe.service.zip.ZipService;
import com.suncode.plugin.pwe.util.Attachment;
import com.suncode.plugin.pwe.util.AuditType;
import com.suncode.plugin.pwe.util.ChangeCardVersionSourceType;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.util.exception.LoadAttachmentException;
import com.suncode.plugin.pwe.web.support.dto.documentation.AddDocumentationAttachmentDto;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import com.suncode.plugin.pwe.web.support.form.AddDocumentationAttachmentForm;
import com.suncode.plugin.pwe.web.support.form.ChangeCardForm;
import com.suncode.plugin.pwe.web.support.form.DocumentationForm;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.util.LzStringUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.w3c.dom.Document;

@Service
public class DocumentationService {
    public static Logger log = Logger.getLogger(DocumentationService.class);
    @Autowired
    private XmlService xmlService;
    @Autowired
    @Qualifier(value="processSpecificationJsonConverter")
    private JsonConverter<ProcessSpecification> processSpecificationJsonConverter;
    @Autowired
    private DocumentationConfigService documentationConfigService;
    @Autowired
    private DocumentationBuilder documentationBuilder;
    @Autowired
    @Qualifier(value="processSpecificationService")
    private ProcessFileService<ProcessSpecification> processSpecificationService;
    @Autowired
    private ChangeCardBuilder changeCardBuilder;
    @Autowired
    private PluginService pluginService;
    @Autowired
    private ZipService zipService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generate(String userId, DocumentationForm form) {
        Date started = new Date();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)bufferedOutputStream, Charset.forName("UTF-8"));
        try {
            this.addDocumentationToZip(zipOutputStream, userId, form);
            this.addAttachmentsToDocumentationZip(zipOutputStream, userId, form.getAttachmentDirectory());
            zipOutputStream.finish();
            zipOutputStream.flush();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            this.logGenerateDocumentationAudit(userId, started, true, form.getPackageId(), form.getProcessDefId());
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logGenerateDocumentationAudit(userId, started, false, form.getPackageId(), form.getProcessDefId());
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zipOutputStream);
        }
    }

    private void addDocumentationToZip(ZipOutputStream zipOutputStream, String userId, DocumentationForm form) throws Exception {
        Document xpdl = this.buildXpdl(form);
        ProcessSpecification processSpecification = this.buildProcessSpecification(form);
        Documentation documentation = this.buildDocumentation(userId, xpdl, processSpecification);
        String fileName = this.buildDocumentationFilename(form);
        this.zipService.addToZip(zipOutputStream, fileName, documentation.getBytes());
    }

    private void logGenerateDocumentationAudit(String userId, Date started, boolean success, String packageId, String processDefId) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.generate.documentation.param.packageid", packageId);
        params.put("pwe.audit.generate.documentation.param.processdefid", processDefId);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_GENERATE_DOCUMENTATION.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    private Document buildXpdl(DocumentationForm form) throws Exception {
        return this.xmlService.write(LzStringUtils.decompressFromBase64((String)form.getXpdl()), "xpdl");
    }

    private ProcessSpecification buildProcessSpecification(DocumentationForm form) throws Exception {
        return this.buildProcessSpecification(LzStringUtils.decompressFromBase64((String)form.getProcessSpecification()));
    }

    private ProcessSpecification buildProcessSpecification(String processSpecification) {
        return this.processSpecificationJsonConverter.convertToObject(processSpecification);
    }

    private Documentation buildDocumentation(String userId, Document xpdl, ProcessSpecification processSpecification) throws TransformerException {
        DocumentationConfigDto documentationConfig = this.documentationConfigService.getDefaultForUser(userId);
        return this.documentationBuilder.build(userId, xpdl, processSpecification, documentationConfig);
    }

    private String buildDocumentationFilename(DocumentationForm form) {
        StringBuilder filename = new StringBuilder();
        filename.append(form.getFileName());
        filename.append(".docx");
        return filename.toString();
    }

    public void addAttachmentsToDocumentationZip(ZipOutputStream zipOutputStream, String userId, String attachmentDirectory) throws IOException {
        this.getWorkdirAttachments(userId, Arrays.asList(attachmentDirectory)).forEach(attachment -> {
            try {
                String path = this.buildAttachmentDocumentationZipPath((Attachment)attachment);
                this.zipService.addToZip(zipOutputStream, path, attachment.getBytes());
            }
            catch (IOException exception) {
                throw new LoadAttachmentException(exception);
            }
        });
    }

    private String buildAttachmentDocumentationZipPath(Attachment attachment) {
        StringBuilder path = new StringBuilder();
        path.append("attachment");
        path.append(File.separator);
        path.append(attachment.getName());
        return path.toString();
    }

    public byte[] generateChangeCard(String userId, ChangeCardForm form) {
        Date started = new Date();
        WorkflowProcess baseProcess = null;
        ProcessSpecification baseProcessSpecification = null;
        WorkflowProcess comparedProcess = null;
        ProcessSpecification comparedProcessSpecification = null;
        String processDefId = form.getProcessDefId();
        String baseVersionValue = null;
        String comparedVersionValue = null;
        try {
            String baseVersionSource = LzStringUtils.decompressFromBase64((String)form.getBaseVersionSource());
            switch (ChangeCardVersionSourceType.getByName(baseVersionSource)) {
                case CURRENTPROCESS: {
                    String xpdl = LzStringUtils.decompressFromBase64((String)form.getXpdl());
                    baseProcess = this.getProcess(xpdl, processDefId);
                    baseVersionValue = LzStringUtils.decompressFromBase64((String)form.getBaseVersionValue());
                    baseProcessSpecification = this.buildProcessSpecification(baseVersionValue);
                    break;
                }
                case PROCESSVERSION: {
                    String baseVersionProcessVersion = LzStringUtils.decompressFromBase64((String)form.getBaseVersionProcessVersion());
                    baseProcess = this.getProcess(form.getPackageId(), baseVersionProcessVersion, processDefId);
                    baseVersionValue = LzStringUtils.decompressFromBase64((String)form.getBaseVersionValue());
                    baseProcessSpecification = this.getProcessSpecification(baseVersionValue);
                    break;
                }
            }
            String comparedVersionSource = LzStringUtils.decompressFromBase64((String)form.getComparedVersionSource());
            switch (ChangeCardVersionSourceType.getByName(comparedVersionSource)) {
                case CURRENTPROCESS: {
                    String xpdl = LzStringUtils.decompressFromBase64((String)form.getXpdl());
                    comparedProcess = this.getProcess(xpdl, processDefId);
                    comparedVersionValue = LzStringUtils.decompressFromBase64((String)form.getComparedVersionValue());
                    comparedProcessSpecification = this.buildProcessSpecification(comparedVersionValue);
                    break;
                }
                case PROCESSVERSION: {
                    String comparedVersionProcessVersion = LzStringUtils.decompressFromBase64((String)form.getComparedVersionProcessVersion());
                    comparedProcess = this.getProcess(form.getPackageId(), comparedVersionProcessVersion, processDefId);
                    comparedVersionValue = LzStringUtils.decompressFromBase64((String)form.getComparedVersionValue());
                    comparedProcessSpecification = this.getProcessSpecification(comparedVersionValue);
                    break;
                }
            }
            Documentation changeCard = this.changeCardBuilder.build(form.getChangeCardSubtitle(), baseProcess, baseProcessSpecification, comparedProcess, comparedProcessSpecification);
            byte[] bytes = changeCard.getBytes();
            this.logGenerateChangeCardAudit(userId, started, true, form.getPackageId(), form.getProcessDefId());
            return bytes;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logGenerateChangeCardAudit(userId, started, true, form.getPackageId(), form.getProcessDefId());
            return new byte[0];
        }
    }

    private void logGenerateChangeCardAudit(String userId, Date started, boolean success, String packageId, String processDefId) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.generate.changecard.param.packageid", packageId);
        params.put("pwe.audit.generate.changecard.param.processdefid", processDefId);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_GENERATE_CHANGE_CARD.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    private ProcessSpecification getProcessSpecification(String path) throws Exception {
        return this.processSpecificationService.get(path);
    }

    private WorkflowProcess getProcess(String xpdl, String processDefId) throws TransformerException {
        Package pack = this.getPackage(xpdl);
        return this.getProcess(pack, processDefId);
    }

    private WorkflowProcess getProcess(Package pack, String processDefId) {
        return pack.getWorkflowProcess(processDefId);
    }

    private Package getPackage(String xpdl) throws TransformerException {
        String xpdlText = this.getAsXmlString(xpdl);
        return PweUtils.getPackage(xpdlText, true);
    }

    private String getAsXmlString(String xpdl) {
        return this.xmlService.getAsString(xpdl, "xpdl", false);
    }

    private WorkflowProcess getProcess(String packageId, String processVersion, String processDefId) {
        Package pack = XpdlPackageManager.getInstance().getPackage(packageId, processVersion);
        return this.getProcess(pack, processDefId);
    }

    public AddDocumentationAttachmentDto addAttachment(String userId, AddDocumentationAttachmentForm form) {
        try {
            CommonsMultipartFile file = form.getFile();
            String fileName = file.getOriginalFilename();
            this.storeAttachmentInWorkdir(userId, form.getAttachmentDirectory(), fileName, file.getInputStream());
            AddDocumentationAttachmentDto dto = new AddDocumentationAttachmentDto();
            dto.setSuccess(true);
            dto.setId(form.getId());
            dto.setName(form.getName());
            dto.setFileName(fileName);
            dto.setDescription(form.getDescription());
            return dto;
        }
        catch (IOException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            AddDocumentationAttachmentDto dto = new AddDocumentationAttachmentDto();
            dto.setSuccess(false);
            return dto;
        }
    }

    private void storeAttachmentInWorkdir(String userId, String attachmentDirectory, String name, InputStream inputStream) throws IOException {
        String attachmentLocation = this.buildWorkdirAttachmentLocation(userId, attachmentDirectory, name);
        this.pluginService.save(attachmentLocation, inputStream);
    }

    private void storeAttachmentInWorkdir(String userId, String attachmentDirectory, String name, byte[] bytes) throws IOException {
        String attachmentLocation = this.buildWorkdirAttachmentLocation(userId, attachmentDirectory, name);
        this.pluginService.save(attachmentLocation, bytes);
    }

    public byte[] downloadAttachment(String userId, String attachmentDirectory, String fileName) throws IOException {
        String attachmentLocation = this.buildWorkdirAttachmentLocation(userId, attachmentDirectory, fileName);
        PluginStoreResource resource = this.pluginService.getSavedResource(attachmentLocation);
        return IOUtils.toByteArray((InputStream)resource.getInputStream());
    }

    public boolean deleteAttachment(String userId, String attachmentDirectory, String fileName) {
        String attachmentLocation = this.buildWorkdirAttachmentLocation(userId, attachmentDirectory, fileName);
        this.pluginService.delete(attachmentLocation);
        return true;
    }

    public void saveAttachments(String userId, List<String> attachmentDirectories, String additionalsFolderLocation) throws IOException {
        this.getWorkdirAttachments(userId, attachmentDirectories).forEach(attachment -> {
            try {
                this.saveAttachment((Attachment)attachment, additionalsFolderLocation);
            }
            catch (IOException exception) {
                throw new LoadAttachmentException(exception);
            }
        });
    }

    public void saveAttachment(Attachment attachment, String additionalsFolderLocation) throws IOException {
        String pathSeparator = this.getPathSeparator(attachment.getPath());
        String[] splittedPathName = StringUtils.split((String)attachment.getPath(), (String)pathSeparator);
        String attachmentDirectory = splittedPathName[splittedPathName.length - 2];
        String attachmentName = splittedPathName[splittedPathName.length - 1];
        String attachmentLocation = this.buildAttachmentLocation(additionalsFolderLocation, attachmentDirectory, attachmentName);
        this.pluginService.save(attachmentLocation, attachment.getBytes());
    }

    public void openAttachmentsFromSaved(String userId, String additionalsLocationPrefix) throws IOException {
        ArrayList attachmentLocationPrefixes = Lists.newArrayList((Object[])new String[]{this.buildAttachmentLocationPrefix(additionalsLocationPrefix)});
        this.getAttachments(attachmentLocationPrefixes).forEach(attachment -> {
            try {
                this.openAttachmentsFromSaved(userId, (Attachment)attachment);
            }
            catch (IOException exception) {
                throw new LoadAttachmentException(exception);
            }
        });
    }

    private void openAttachmentsFromSaved(String userId, Attachment attachment) throws IOException {
        String pathSeparator = this.getPathSeparator(attachment.getPath());
        String[] splittedPathName = StringUtils.split((String)attachment.getPath(), (String)pathSeparator);
        String attachmentDirectory = splittedPathName[splittedPathName.length - 2];
        String attachmentName = splittedPathName[splittedPathName.length - 1];
        this.storeAttachmentInWorkdir(userId, attachmentDirectory, attachmentName, attachment.getBytes());
    }

    private String buildAttachmentLocation(String additionalsFolderLocation, String attachmentDirectory, String attachmentName) {
        StringBuilder location = new StringBuilder();
        location.append(this.buildAttachmentLocationPrefix(additionalsFolderLocation));
        location.append(File.separator);
        location.append(attachmentDirectory);
        location.append(File.separator);
        location.append(attachmentName);
        return location.toString();
    }

    private String buildAttachmentLocationPrefix(String additionalsFolderLocation) {
        StringBuilder prefix = new StringBuilder();
        prefix.append(additionalsFolderLocation);
        prefix.append(File.separator);
        prefix.append("__attachment");
        return prefix.toString();
    }

    public void addAttachmentsToZip(ZipOutputStream zipOutputStream, String userId, List<String> attachmentDirectories) throws IOException {
        this.getWorkdirAttachments(userId, attachmentDirectories).forEach(attachment -> {
            try {
                this.addAttachmentToZip(zipOutputStream, (Attachment)attachment);
            }
            catch (IOException exception) {
                throw new LoadAttachmentException(exception);
            }
        });
    }

    private void addAttachmentToZip(ZipOutputStream zipOutputStream, Attachment attachment) throws IOException {
        String pathSeparator = this.getPathSeparator(attachment.getPath());
        String[] splittedEntryName = StringUtils.split((String)attachment.getPath(), (String)pathSeparator);
        String attachmentDirectory = splittedEntryName[splittedEntryName.length - 2];
        String attachmentName = splittedEntryName[splittedEntryName.length - 1];
        String pathToDir = "__attachment" + File.separator + attachmentDirectory;
        String attachmentLocation = pathToDir + File.separator + attachmentName;
        this.zipService.addToZip(zipOutputStream, attachmentLocation, attachment.getBytes());
    }

    public void loadAttachmentsToSystem(String userId, List<String> attachmentDirectories, String additionalsFolderPath) throws IOException {
        this.getWorkdirAttachments(userId, attachmentDirectories).forEach(attachment -> {
            try {
                this.loadAttachmentToSystem((Attachment)attachment, additionalsFolderPath);
            }
            catch (IOException exception) {
                throw new LoadAttachmentException(exception);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttachmentToSystem(Attachment attachment, String additionalsFolderPath) throws IOException {
        FileOutputStream outputStream = null;
        try {
            String pathSeparator = this.getPathSeparator(attachment.getPath());
            String[] splittedEntryName = StringUtils.split((String)attachment.getPath(), (String)pathSeparator);
            String attachmentDirectory = splittedEntryName[splittedEntryName.length - 2];
            String attachmentName = splittedEntryName[splittedEntryName.length - 1];
            String pathToDir = this.buildAttachmentLocationPrefix(additionalsFolderPath) + File.separator + attachmentDirectory;
            String attachmentLocation = pathToDir + File.separator + attachmentName;
            this.controlFolderExistence(pathToDir);
            outputStream = new FileOutputStream(attachmentLocation);
            ((OutputStream)outputStream).write(attachment.getBytes());
            outputStream.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    private void controlFolderExistence(String pathToDir) throws IOException {
        File objectFolder = new File(pathToDir);
        FileUtils.forceMkdir((File)objectFolder);
    }

    public void openAttachmentsFromSystem(String userId, String additionalsFolderPath) {
        File directory = new File(this.buildAttachmentLocationPrefix(additionalsFolderPath));
        this.openAttachmentsFromDirectory(userId, directory);
    }

    private void openAttachmentsFromDirectory(String userId, File directory) {
        if (this.shouldOpenAttachmentsFromDirectory(directory)) {
            FileUtils.listFiles((File)directory, null, (boolean)true).forEach(file -> {
                try {
                    this.openAttachmentFromFile(userId, (File)file);
                }
                catch (IOException exception) {
                    throw new LoadAttachmentException(exception);
                }
            });
        }
    }

    private boolean shouldOpenAttachmentsFromDirectory(File directory) {
        return directory.isDirectory() && directory.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openAttachmentFromFile(String userId, File file) throws IOException {
        String pathSeparator = this.getPathSeparator(file.getAbsolutePath());
        String[] splittedPathName = StringUtils.split((String)file.getAbsolutePath(), (String)pathSeparator);
        String attachmentDirectory = splittedPathName[splittedPathName.length - 2];
        String attachmentName = splittedPathName[splittedPathName.length - 1];
        FileInputStream inputStream = FileUtils.openInputStream((File)file);
        try {
            this.storeAttachmentInWorkdir(userId, attachmentDirectory, attachmentName, inputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public void openAttachmentFromDisc(String userId, String internalPath, String additionalsFolderLocation, InputStream inputStream) throws IOException {
        String pathSeparator = this.getPathSeparator(internalPath);
        String[] splittedPathName = StringUtils.split((String)internalPath, (String)pathSeparator);
        String attachmentDirectory = splittedPathName[splittedPathName.length - 2];
        String attachmentName = splittedPathName[splittedPathName.length - 1];
        String attachmentLocation = this.buildAttachmentLocation(additionalsFolderLocation, attachmentDirectory, attachmentName);
        this.pluginService.save(attachmentLocation, inputStream);
        this.storeAttachmentInWorkdir(userId, attachmentDirectory, attachmentName, inputStream);
    }

    private List<Attachment> getWorkdirAttachments(String userId, List<String> attachmentDirectories) throws IOException {
        List<String> attachmentLocationPrefixes = Optional.ofNullable(attachmentDirectories).orElse(Collections.emptyList()).stream().map(attachmentDirectory -> this.buildWorkdirAttachmentLocationPrefix(userId, (String)attachmentDirectory)).collect(Collectors.toList());
        return this.getAttachments(attachmentLocationPrefixes);
    }

    private List<Attachment> getAttachments(List<String> attachmentLocationPrefixes) throws IOException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        Map<String, PluginStoreResource> resources = this.pluginService.getSavedResources();
        if (MapUtils.isNotEmpty(resources)) {
            Pattern pattern = this.buildAttachmentLocationPattern(attachmentLocationPrefixes);
            for (String location : resources.keySet()) {
                if (!this.doesAttachmentMatchPattern(pattern, location)) continue;
                PluginStoreResource attachment = resources.get(location);
                byte[] bytes = IOUtils.toByteArray((InputStream)attachment.getInputStream());
                String path = attachment.getPath();
                String name = FilenameUtils.getName((String)path);
                attachments.add(new Attachment(bytes, path, name));
            }
        }
        return attachments;
    }

    private String buildWorkdirAttachmentLocation(String userId, String attachmentDirectory, String fileName) {
        StringBuilder location = new StringBuilder();
        location.append(this.buildWorkdirAttachmentLocationPrefix(userId, attachmentDirectory));
        location.append(File.separator);
        location.append(fileName);
        return location.toString();
    }

    private String buildWorkdirAttachmentLocationPrefix(String userId, String attachmentDirectory) {
        StringBuilder location = new StringBuilder();
        location.append("workdir");
        location.append(File.separator);
        location.append("attachment");
        location.append(File.separator);
        location.append(userId);
        location.append(File.separator);
        location.append(attachmentDirectory);
        return location.toString();
    }

    private Pattern buildAttachmentLocationPattern(List<String> attachmentLocationPrefixes) {
        String regex = attachmentLocationPrefixes.stream().map(attachmentLocationPrefix -> PweUtils.buildSafePatternValue(attachmentLocationPrefix) + "/.*").collect(Collectors.joining("|"));
        return Pattern.compile(regex);
    }

    private boolean doesAttachmentMatchPattern(Pattern pattern, String location) {
        Matcher matcher = pattern.matcher(PweUtils.buildSafePatternValue(location));
        return matcher.matches();
    }

    private String getPathSeparator(String path) {
        return StringUtils.contains((CharSequence)path, (CharSequence)"/") ? "/" : "\\";
    }
}

