/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.object.AttachmentSpecificationsHolder;
import com.suncode.plugin.pwe.documentation.object.TextPart;
import com.suncode.plugin.pwe.documentation.object.UserIdHolder;
import com.suncode.plugin.pwe.documentation.specification.AttachmentSpecification;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.service.documentation.DocumentationService;
import com.suncode.plugin.pwe.util.ExtAttrUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpecificationDescriptionPartBuilder {
    public static Logger log = Logger.getLogger(SpecificationDescriptionPartBuilder.class);
    private static final String REGEX = "[{](variable_|activity_|participant_|attachmentname_|attachmentpreview_)\\w+[}]";
    private static final String VARIABLE_PREFIX = "variable_";
    private static final String ACTIVITY_PREFIX = "activity_";
    private static final String PARTICIPANT_PREFIX = "participant_";
    private static final String ATTACHMENT_NAME_PREFIX = "attachmentname_";
    private static final String ATTACHMENT_PREVIEW_PREFIX = "attachmentpreview_";
    private static final String ATTACHMENT_DIRECTORY_EXT_ATTR_NAME = "ATTACHMENT_DIRECTORY";
    @Autowired
    private DocumentationService documentationService;

    public List<TextPart> build(WorkflowProcess process, String description) {
        ArrayList<TextPart> parts = new ArrayList<TextPart>();
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            Pattern pattern = Pattern.compile(REGEX);
            Matcher matcher = pattern.matcher(description);
            int lastIndex = 0;
            while (matcher.find()) {
                String idPart = matcher.group();
                String firstPart = description.substring(lastIndex, matcher.start());
                lastIndex = matcher.end();
                if (StringUtils.isNotEmpty((CharSequence)firstPart)) {
                    parts.add(this.buildBasic(firstPart));
                }
                parts.add(this.buildFormatted(process, idPart));
            }
            String lastPart = description.substring(lastIndex);
            if (StringUtils.isNotEmpty((CharSequence)lastPart)) {
                parts.add(this.buildBasic(lastPart));
            }
        }
        return parts;
    }

    private TextPart buildBasic(String text) {
        TextPart part = new TextPart();
        part.setText(text);
        return part;
    }

    private TextPart buildFormatted(WorkflowProcess process, String idPart) {
        String id = StringUtils.substringBetween((String)idPart, (String)"_", (String)"}");
        TextPart part = new TextPart();
        if (StringUtils.startsWith((CharSequence)idPart, (CharSequence)"{variable_") && process.getDataFields().containsElement(id)) {
            DataField dataField = process.getDataField(id);
            part.setBookmarked(true);
            part.setBookmarkName(this.buildVariableBookmarkName(dataField));
            part.setText(dataField.getName());
        } else if (StringUtils.startsWith((CharSequence)idPart, (CharSequence)"{activity_") && process.getActivities().containsElement(id)) {
            Activity activity = process.getActivity(id);
            part.setBookmarked(true);
            part.setBookmarkName(this.buildActivityBookmarkName(activity));
            part.setText(activity.getName());
        } else if (StringUtils.startsWith((CharSequence)idPart, (CharSequence)"{participant_")) {
            Package pack = (Package)process.getParent().getParent();
            if (process.getParticipants().containsElement(id)) {
                Participant participant = process.getParticipant(id);
                part.setBookmarked(true);
                part.setBookmarkName(this.buildParticipantBookmarkName(participant));
                part.setText(participant.getName());
            } else if (pack.getParticipants().containsElement(id)) {
                Participant participant = pack.getParticipant(id);
                part.setBookmarked(true);
                part.setBookmarkName(this.buildParticipantBookmarkName(participant));
                part.setText(participant.getName());
            } else {
                part.setText(id);
            }
        } else if (StringUtils.startsWith((CharSequence)idPart, (CharSequence)"{attachmentname_")) {
            Optional<AttachmentSpecification> attachmentSpecificationOpt = this.findAttachmentSpecification(id);
            if (attachmentSpecificationOpt.isPresent()) {
                AttachmentSpecification attachmentSpecification = attachmentSpecificationOpt.get();
                part.setText(attachmentSpecification.getName());
            } else {
                part.setText(id);
            }
            part.setBold(true);
        } else if (StringUtils.startsWith((CharSequence)idPart, (CharSequence)"{attachmentpreview_")) {
            Optional<AttachmentSpecification> attachmentSpecificationOpt = this.findAttachmentSpecification(id);
            if (attachmentSpecificationOpt.isPresent()) {
                AttachmentSpecification attachmentSpecification = attachmentSpecificationOpt.get();
                String attachmentDirectory = ExtAttrUtils.getExtAttrValue(process.getExtendedAttributes(), ATTACHMENT_DIRECTORY_EXT_ATTR_NAME);
                try {
                    part.setImage(true);
                    part.setBytes(this.documentationService.downloadAttachment(UserIdHolder.get(), attachmentDirectory, attachmentSpecification.getFileName()));
                }
                catch (IOException exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                    part.setBold(true);
                }
            } else {
                part.setBold(true);
            }
            part.setText(id);
        } else {
            part.setText(id);
        }
        return part;
    }

    private String buildVariableBookmarkName(DataField dataField) {
        return BookmarkNameUtils.getNameForProcessVariable(dataField.getId());
    }

    private String buildActivityBookmarkName(Activity activity) {
        return BookmarkNameUtils.getNameForActivity(activity.getId());
    }

    private String buildParticipantBookmarkName(Participant participant) {
        return BookmarkNameUtils.getNameForParticipant(participant.getId());
    }

    private Optional<AttachmentSpecification> findAttachmentSpecification(String id) {
        return AttachmentSpecificationsHolder.get().stream().filter(attachmentSpecification -> StringUtils.equals((CharSequence)attachmentSpecification.getId(), (CharSequence)id)).findFirst();
    }

    public String buildAsString(WorkflowProcess process, String description) {
        StringBuilder asString = new StringBuilder();
        List<TextPart> parts = this.build(process, description);
        if (CollectionUtils.isNotEmpty(parts)) {
            for (TextPart part : parts) {
                asString.append(part.getText());
            }
        }
        return asString.toString();
    }
}

