/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.enumeration.DataChooserConfig;
import com.suncode.plugin.pwe.documentation.object.DataChooser;
import com.suncode.plugin.pwe.util.ExtAttrUtils;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.springframework.stereotype.Component;

@Component
public class DataChooserBuilder {
    private static final String DATA_CHOOSER_EXT_ATTR_NAME = "DATA_CHOOSER";
    private static final String DEFAULT_TYPE = "combobox";

    public DataChooser build(DataField dataField) {
        DataChooser dataChooser = new DataChooser();
        dataChooser.setType(DEFAULT_TYPE);
        ExtendedAttributes extAttrs = dataField.getExtendedAttributes();
        String extAttrValue = ExtAttrUtils.getExtAttrValue(extAttrs, DATA_CHOOSER_EXT_ATTR_NAME);
        ArrayList<String> mappings = new ArrayList<String>();
        block5: for (String oneExtAttrValue : extAttrValue.split("\n")) {
            String[] config = oneExtAttrValue.split("=", 2);
            switch (DataChooserConfig.getByName(config[0])) {
                case TYPE: {
                    dataChooser.setType(config[1]);
                    continue block5;
                }
                case COMBOFORCESELECTION: {
                    dataChooser.setForceSelection(this.buildForceSelection(config[1]));
                    continue block5;
                }
                case MAPPING: {
                    String[] mappingSplit = config[1].split(";", -1);
                    if (!StringUtils.isNotBlank((CharSequence)mappingSplit[1])) continue block5;
                    mappings.add(mappingSplit[1]);
                    continue block5;
                }
            }
        }
        dataChooser.setMappings(mappings);
        return dataChooser;
    }

    private boolean buildForceSelection(String value) {
        return Boolean.parseBoolean(value);
    }
}

