/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.comparator.ActivityComparator;
import com.suncode.plugin.pwe.documentation.specification.ActivitiesOrderPositionSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.util.ActivitiesOrderType;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.stereotype.Component;

@Component
public class ActivityListBuilder {
    public List<Activity> build(WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        switch (ActivitiesOrderType.getByName(processSpecification.getActivitiesOrder().getType())) {
            case AZ_ASC: {
                return this.buildAlphabeticalList(process, documentationConfig, true);
            }
            case AZ_DESC: {
                return this.buildAlphabeticalList(process, documentationConfig, false);
            }
            case CUSTOM: {
                return this.buildCustomList(process, processSpecification, documentationConfig);
            }
        }
        return this.buildSimpleList(process, documentationConfig);
    }

    private List<Activity> buildSimpleList(WorkflowProcess process, DocumentationConfigDto documentationConfig) {
        ArrayList<Activity> activitiesList = new ArrayList<Activity>();
        Activities activities = process.getActivities();
        if (!activities.isEmpty()) {
            for (int i = 0; i < activities.size(); ++i) {
                Activity activity = (Activity)activities.get(i);
                if (!this.shouldAddActivity(activity, documentationConfig)) continue;
                activitiesList.add(activity);
            }
        }
        return activitiesList;
    }

    private boolean shouldAddActivity(Activity activity, DocumentationConfigDto documentationConfig) {
        switch (activity.getActivityType()) {
            case 0: {
                return BooleanUtils.isTrue((Boolean)documentationConfig.getShowRoutes());
            }
            case 2: {
                return BooleanUtils.isTrue((Boolean)documentationConfig.getShowSystemTasks());
            }
            case 1: 
            case 3: {
                return BooleanUtils.isTrue((Boolean)documentationConfig.getShowManualTasks());
            }
        }
        return true;
    }

    private List<Activity> buildAlphabeticalList(WorkflowProcess process, DocumentationConfigDto documentationConfig, boolean ascending) {
        List<Activity> activitiesList = this.buildSimpleList(process, documentationConfig);
        Collections.sort(activitiesList, new ActivityComparator(ascending));
        return activitiesList;
    }

    private List<Activity> buildCustomList(WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        ArrayList<Activity> activitiesList = new ArrayList<Activity>();
        Activities activities = process.getActivities();
        if (this.shouldBuildCustomList(activities, processSpecification)) {
            for (ActivitiesOrderPositionSpecification specification : processSpecification.getActivitiesOrder().getSequence()) {
                String activityDefId = specification.getActivityDefId();
                Activity activity = activities.getActivity(activityDefId);
                if (activity == null || !this.shouldAddActivity(activity, documentationConfig)) continue;
                activitiesList.add(activity);
            }
        }
        return activitiesList;
    }

    private boolean shouldBuildCustomList(Activities activities, ProcessSpecification processSpecification) {
        return !activities.isEmpty() && CollectionUtils.isNotEmpty(processSpecification.getActivitiesOrder().getSequence());
    }
}

