/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.comparator.subcomparator;

import com.suncode.plugin.pwe.documentation.comparator.subcomparator.ParameterSpecificationsSubcomparator;
import com.suncode.plugin.pwe.documentation.comparator.subcomparator.ProcessSpecificationSubcomparator;
import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.object.builder.DifferenceBuilder;
import com.suncode.plugin.pwe.documentation.specification.ParameterSpecification;
import com.suncode.plugin.pwe.documentation.specification.ScheduledTaskSpecification;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="scheduledTaskSpecificationsSubcomparator")
public class ScheduledTaskSpecificationsSubcomparatorImpl
implements ProcessSpecificationSubcomparator<List<ScheduledTaskSpecification>> {
    private static final String CLASS_NAME_MODIFIED = "pwe.documentation.changecard.modified.scheduledtaskclassname";
    private static final String METHOD_NAME_MODIFIED = "pwe.documentation.changecard.modified.scheduledtaskmethodname";
    private static final String EXECUTION_FREQUENCY_MODIFIED = "pwe.documentation.changecard.modified.scheduledtaskexecutionfrequency";
    private static final String DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.scheduledtaskdescription";
    private static final String ALGORITHM_DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.scheduledtaskalgorithmdescription";
    private static final String INPUT_PARAMETER_DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.scheduledtaskinputparameterdescription";
    private static final String INPUT_PARAMETER_ADDED = "pwe.documentation.changecard.added.scheduledtaskinputparameter";
    private static final String INPUT_PARAMETER_DELETED = "pwe.documentation.changecard.deleted.scheduledtaskinputparameter";
    private static final String SCHEDULED_TASK_ADDED = "pwe.documentation.changecard.added.scheduledtask";
    private static final String SCHEDULED_TASK_DELETED = "pwe.documentation.changecard.deleted.scheduledtask";
    @Autowired
    private DifferenceBuilder differenceBuilder;
    @Autowired
    private ParameterSpecificationsSubcomparator parameterSpecificationsSubcomparator;
    @Autowired
    private TranslatorService translatorService;

    @Override
    public List<Difference> compare(WorkflowProcess baseProcess, List<ScheduledTaskSpecification> base, WorkflowProcess comparedProcess, List<ScheduledTaskSpecification> compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Map<String, ScheduledTaskSpecification> baseMap = this.convertToMap(base);
        if (CollectionUtils.isNotEmpty(compared)) {
            for (ScheduledTaskSpecification comparedSpecification : compared) {
                if (baseMap.containsKey(comparedSpecification.getName())) {
                    ScheduledTaskSpecification baseSpecification = baseMap.remove(comparedSpecification.getName());
                    differences.addAll(this.compare(comparedSpecification.getName(), baseSpecification, comparedSpecification));
                    continue;
                }
                differences.add(this.differenceBuilder.build(SCHEDULED_TASK_ADDED, comparedSpecification.getName()));
            }
        }
        if (MapUtils.isNotEmpty(baseMap)) {
            for (ScheduledTaskSpecification baseSpecification : baseMap.values()) {
                differences.add(this.differenceBuilder.build(SCHEDULED_TASK_DELETED, baseSpecification.getName()));
            }
        }
        return differences;
    }

    private Map<String, ScheduledTaskSpecification> convertToMap(List<ScheduledTaskSpecification> list) {
        HashMap<String, ScheduledTaskSpecification> map = new HashMap<String, ScheduledTaskSpecification>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (ScheduledTaskSpecification element : list) {
                map.put(element.getName(), element);
            }
        }
        return map;
    }

    private List<Difference> compare(String name, ScheduledTaskSpecification base, ScheduledTaskSpecification compared) {
        String comparedExecutionFrequency;
        String baseExecutionFrequency;
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getClassName(), (CharSequence)compared.getClassName())) {
            differences.add(this.differenceBuilder.build(CLASS_NAME_MODIFIED, name, base.getClassName(), compared.getClassName()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getMethodName(), (CharSequence)compared.getMethodName())) {
            differences.add(this.differenceBuilder.build(METHOD_NAME_MODIFIED, name, base.getMethodName(), compared.getMethodName()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)(baseExecutionFrequency = this.buildExecutionFrequency(base)), (CharSequence)(comparedExecutionFrequency = this.buildExecutionFrequency(compared)))) {
            String translatedBaseExecutionFrequency = this.buildTranstaledExecutionFrequency(base);
            String translatedComparedExecutionFrequency = this.buildTranstaledExecutionFrequency(compared);
            differences.add(this.differenceBuilder.build(EXECUTION_FREQUENCY_MODIFIED, name, translatedBaseExecutionFrequency, translatedComparedExecutionFrequency));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getDescription(), (CharSequence)compared.getDescription())) {
            differences.add(this.differenceBuilder.build(DESCRIPTION_MODIFIED, name, base.getDescription(), compared.getDescription()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getAlgorithmDescription(), (CharSequence)compared.getAlgorithmDescription())) {
            differences.add(this.differenceBuilder.build(ALGORITHM_DESCRIPTION_MODIFIED, name, base.getAlgorithmDescription(), compared.getAlgorithmDescription()));
        }
        differences.addAll(this.compareInputParameters(name, base.getInputParameters(), compared.getInputParameters()));
        return differences;
    }

    private String buildExecutionFrequency(ScheduledTaskSpecification specification) {
        StringBuilder executionFrequency = new StringBuilder();
        executionFrequency.append(specification.getExecutionFrequencyValue());
        executionFrequency.append(specification.getExecutionFrequencyUnit());
        return executionFrequency.toString();
    }

    private String buildTranstaledExecutionFrequency(ScheduledTaskSpecification specification) {
        StringBuilder executionFrequency = new StringBuilder();
        executionFrequency.append(specification.getExecutionFrequencyValue());
        executionFrequency.append(" ");
        executionFrequency.append(this.translatorService.translateDocumentationMessageForText(specification.getExecutionFrequencyUnit()));
        return executionFrequency.toString();
    }

    private List<Difference> compareInputParameters(String containerName, List<ParameterSpecification> base, List<ParameterSpecification> compared) {
        return this.parameterSpecificationsSubcomparator.compare(containerName, INPUT_PARAMETER_DESCRIPTION_MODIFIED, INPUT_PARAMETER_ADDED, INPUT_PARAMETER_DELETED, base, compared);
    }
}

