/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.comparator.subcomparator;

import com.suncode.plugin.pwe.documentation.comparator.subcomparator.ProcessSpecificationSubcomparator;
import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.object.builder.DifferenceBuilder;
import com.suncode.plugin.pwe.documentation.specification.DocumentLinkSpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="documentLinkSpecificationsSubcomparator")
public class DocumentLinkSpecificationsSubcomparatorImpl
implements ProcessSpecificationSubcomparator<List<DocumentLinkSpecification>> {
    private static final String DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.documentlinkdescription";
    private static final String DOCUMENT_LINK_ADDED = "pwe.documentation.changecard.added.documentlink";
    private static final String DOCUMENT_LINK_DELETED = "pwe.documentation.changecard.deleted.documentlink";
    @Autowired
    private DifferenceBuilder differenceBuilder;

    @Override
    public List<Difference> compare(WorkflowProcess baseProcess, List<DocumentLinkSpecification> base, WorkflowProcess comparedProcess, List<DocumentLinkSpecification> compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Map<String, DocumentLinkSpecification> baseMap = this.convertToMap(base);
        if (CollectionUtils.isNotEmpty(compared)) {
            for (DocumentLinkSpecification comparedSpecification : compared) {
                if (baseMap.containsKey(comparedSpecification.getName())) {
                    DocumentLinkSpecification baseSpecification = baseMap.remove(comparedSpecification.getName());
                    differences.addAll(this.compare(comparedSpecification.getName(), baseSpecification, comparedSpecification));
                    continue;
                }
                differences.add(this.differenceBuilder.build(DOCUMENT_LINK_ADDED, comparedSpecification.getName()));
            }
        }
        if (MapUtils.isNotEmpty(baseMap)) {
            for (DocumentLinkSpecification baseSpecification : baseMap.values()) {
                differences.add(this.differenceBuilder.build(DOCUMENT_LINK_DELETED, baseSpecification.getName()));
            }
        }
        return differences;
    }

    private Map<String, DocumentLinkSpecification> convertToMap(List<DocumentLinkSpecification> list) {
        HashMap<String, DocumentLinkSpecification> map = new HashMap<String, DocumentLinkSpecification>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (DocumentLinkSpecification element : list) {
                map.put(element.getName(), element);
            }
        }
        return map;
    }

    private List<Difference> compare(String name, DocumentLinkSpecification base, DocumentLinkSpecification compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getDescription(), (CharSequence)compared.getDescription())) {
            differences.add(this.differenceBuilder.build(DESCRIPTION_MODIFIED, name, base.getDescription(), compared.getDescription()));
        }
        return differences;
    }
}

