/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.comparator.subcomparator;

import com.suncode.plugin.pwe.documentation.comparator.subcomparator.ProcessSpecificationSubcomparator;
import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.object.builder.DifferenceBuilder;
import com.suncode.plugin.pwe.documentation.specification.ColumnSpecification;
import com.suncode.plugin.pwe.documentation.specification.DatabaseTableSpecification;
import com.suncode.plugin.pwe.documentation.specification.UtilizationSpecification;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="databaseTableSpecificationSubcomparator")
public class DatabaseTableSpecificationSubcomparatorImpl
implements ProcessSpecificationSubcomparator<List<DatabaseTableSpecification>> {
    private static final String DATABASE_TYPE_MODIFIED = "pwe.documentation.changecard.modified.databasetabledatabasetype";
    private static final String LOCATION_MODIFIED = "pwe.documentation.changecard.modified.databasetablelocation";
    private static final String YES = "pwe.documentation.text.yes";
    private static final String NO = "pwe.documentation.text.no";
    private static final String ADDED_FROM_ADMINISTRATION_MODIFIED = "pwe.documentation.changecard.modified.databasetableaddedfromadministration";
    private static final String COLUMN_TYPE_MODIFIED = "pwe.documentation.changecard.modified.databasetablecolumntype";
    private static final String COLUMN_DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.databasetablecolumndescription";
    private static final String COLUMN_ADDED = "pwe.documentation.changecard.added.databasetablecolumn";
    private static final String COLUMN_DELETED = "pwe.documentation.changecard.deleted.databasetablecolumn";
    private static final String UTILIZATION_IN_ACTIVITY_DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.databasetableutilizationinactivitydescription";
    private static final String UTILIZATION_IN_ACTIVITY_ADDED = "pwe.documentation.changecard.added.databasetableutilizationinactivity";
    private static final String UTILIZATION_IN_ACTIVITY_DELETED = "pwe.documentation.changecard.deleted.databasetableutilizationinactivity";
    private static final String DATABASE_TABLE_ADDED = "pwe.documentation.changecard.added.databasetable";
    private static final String DATABASE_TABLE_DELETED = "pwe.documentation.changecard.deleted.databasetable";
    @Autowired
    private DifferenceBuilder differenceBuilder;
    @Autowired
    private TranslatorService translatorService;

    @Override
    public List<Difference> compare(WorkflowProcess baseProcess, List<DatabaseTableSpecification> base, WorkflowProcess comparedProcess, List<DatabaseTableSpecification> compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Map<String, DatabaseTableSpecification> baseMap = this.convertToMap(base);
        for (DatabaseTableSpecification comparedSpecification : compared) {
            if (baseMap.containsKey(comparedSpecification.getName())) {
                DatabaseTableSpecification baseSpecification = baseMap.remove(comparedSpecification.getName());
                differences.addAll(this.compare(comparedSpecification.getName(), baseSpecification, comparedSpecification));
                continue;
            }
            differences.add(this.differenceBuilder.build(DATABASE_TABLE_ADDED, comparedSpecification.getName()));
        }
        if (MapUtils.isNotEmpty(baseMap)) {
            for (DatabaseTableSpecification baseSpecification : baseMap.values()) {
                differences.add(this.differenceBuilder.build(DATABASE_TABLE_DELETED, baseSpecification.getName()));
            }
        }
        return differences;
    }

    private Map<String, DatabaseTableSpecification> convertToMap(List<DatabaseTableSpecification> list) {
        HashMap<String, DatabaseTableSpecification> map = new HashMap<String, DatabaseTableSpecification>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (DatabaseTableSpecification element : list) {
                map.put(element.getName(), element);
            }
        }
        return map;
    }

    private List<Difference> compare(String name, DatabaseTableSpecification base, DatabaseTableSpecification compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getDatabaseType(), (CharSequence)compared.getDatabaseType())) {
            differences.add(this.differenceBuilder.build(DATABASE_TYPE_MODIFIED, name, base.getDatabaseType(), compared.getDatabaseType()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getLocation(), (CharSequence)compared.getLocation())) {
            differences.add(this.differenceBuilder.build(LOCATION_MODIFIED, name, base.getLocation(), compared.getLocation()));
        }
        if (!ObjectUtils.equals((Object)base.getAddedFromAdministration(), (Object)compared.getAddedFromAdministration())) {
            String baseText = this.buildAddedFromAdministrationText(base);
            String comparedText = this.buildAddedFromAdministrationText(compared);
            differences.add(this.differenceBuilder.build(ADDED_FROM_ADMINISTRATION_MODIFIED, name, baseText, comparedText));
        }
        differences.addAll(this.compareColumns(name, base.getColumns(), compared.getColumns()));
        differences.addAll(this.compareUtilizationInActivities(name, base.getUtilizationInActivities(), compared.getUtilizationInActivities()));
        return differences;
    }

    private String buildAddedFromAdministrationText(DatabaseTableSpecification databaseTableSpecification) {
        if (BooleanUtils.isTrue((Boolean)databaseTableSpecification.getAddedFromAdministration())) {
            return this.translatorService.translateMessage(YES);
        }
        return this.translatorService.translateMessage(NO);
    }

    private List<Difference> compareColumns(String containerName, List<ColumnSpecification> base, List<ColumnSpecification> compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Map<String, ColumnSpecification> baseMap = this.convertColumnsToMap(base);
        if (CollectionUtils.isNotEmpty(compared)) {
            for (ColumnSpecification comparedSpecification : compared) {
                if (baseMap.containsKey(comparedSpecification.getName())) {
                    ColumnSpecification baseSpecification = baseMap.remove(comparedSpecification.getName());
                    differences.addAll(this.compareColumn(containerName, comparedSpecification.getName(), baseSpecification, comparedSpecification));
                    continue;
                }
                differences.add(this.differenceBuilder.build(COLUMN_ADDED, comparedSpecification.getName(), containerName));
            }
        }
        if (MapUtils.isNotEmpty(baseMap)) {
            for (ColumnSpecification baseSpecification : baseMap.values()) {
                differences.add(this.differenceBuilder.build(COLUMN_DELETED, baseSpecification.getName(), containerName));
            }
        }
        return differences;
    }

    private Map<String, ColumnSpecification> convertColumnsToMap(List<ColumnSpecification> list) {
        HashMap<String, ColumnSpecification> map = new HashMap<String, ColumnSpecification>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (ColumnSpecification element : list) {
                map.put(element.getName(), element);
            }
        }
        return map;
    }

    private List<Difference> compareColumn(String containerName, String name, ColumnSpecification base, ColumnSpecification compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getType(), (CharSequence)compared.getType())) {
            differences.add(this.differenceBuilder.build(COLUMN_TYPE_MODIFIED, name, containerName, base.getType(), compared.getType()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getDescription(), (CharSequence)compared.getDescription())) {
            differences.add(this.differenceBuilder.build(COLUMN_DESCRIPTION_MODIFIED, name, containerName, base.getDescription(), compared.getDescription()));
        }
        return differences;
    }

    private List<Difference> compareUtilizationInActivities(String containerName, List<UtilizationSpecification> base, List<UtilizationSpecification> compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Map<String, UtilizationSpecification> baseMap = this.convertUtilizationInActivitiesToMap(base);
        if (CollectionUtils.isNotEmpty(compared)) {
            for (UtilizationSpecification comparedSpecification : compared) {
                if (baseMap.containsKey(comparedSpecification.getActivityDefId())) {
                    UtilizationSpecification baseSpecification = baseMap.remove(comparedSpecification.getActivityDefId());
                    differences.addAll(this.compareUtilizationInActivity(containerName, comparedSpecification.getActivityDefId(), baseSpecification, comparedSpecification));
                    continue;
                }
                differences.add(this.differenceBuilder.build(UTILIZATION_IN_ACTIVITY_ADDED, comparedSpecification.getActivityDefId(), containerName));
            }
        }
        if (MapUtils.isNotEmpty(baseMap)) {
            for (UtilizationSpecification baseSpecification : baseMap.values()) {
                differences.add(this.differenceBuilder.build(UTILIZATION_IN_ACTIVITY_DELETED, baseSpecification.getActivityDefId(), containerName));
            }
        }
        return differences;
    }

    private Map<String, UtilizationSpecification> convertUtilizationInActivitiesToMap(List<UtilizationSpecification> list) {
        HashMap<String, UtilizationSpecification> map = new HashMap<String, UtilizationSpecification>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (UtilizationSpecification element : list) {
                map.put(element.getActivityDefId(), element);
            }
        }
        return map;
    }

    private List<Difference> compareUtilizationInActivity(String containerName, String name, UtilizationSpecification base, UtilizationSpecification compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getDescription(), (CharSequence)compared.getDescription())) {
            differences.add(this.differenceBuilder.build(UTILIZATION_IN_ACTIVITY_DESCRIPTION_MODIFIED, name, containerName, base.getDescription(), compared.getDescription()));
        }
        return differences;
    }
}

