/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.TableCell;
import com.suncode.plugin.pwe.documentation.TableHeader;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecord;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.paragraph.builder.SpecificationDescriptionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.paragraph.builder.TransitionConditionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.TransitionSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.documentation.util.TableUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.Condition;
import org.enhydra.shark.xpdl.elements.Transition;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activityTransitionsPointBuilder")
public class ActivityTransitionsPointBuilderImpl
implements ActivityPointBuilder {
    private static final String POINT_TITLE = "pwe.documentation.point.title.possibletransitions";
    private static final String TRANSITION_TABLE_TO_COLUMN_ID = "to";
    private static final String ACTIVITY_NAME_TABLE_HEADER = "pwe.documentation.table.header.activityname";
    private static final String TRANSITION_TABLE_CONDITION_COLUMN_ID = "condition";
    private static final String TRANSITION_CONDITION_TABLE_HEADER = "pwe.documentation.table.header.transitioncondition";
    private static final String TRANSITION_TABLE_DESCRIPTION_COLUMN_ID = "description";
    private static final String TRANSITION_DESCRIPTION_TABLE_HEADER = "pwe.documentation.table.header.transitiondescription";
    private static final String PROCESS_END = "pwe.documentation.text.processend";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private TransitionConditionParagraphContentsBuilder transitionConditionParagraphContentsBuilder;
    @Autowired
    private SpecificationDescriptionParagraphContentsBuilder specificationDescriptionParagraphContentsBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        TableRecords records = new TableRecords();
        ArrayList transitions = activity.getOutgoingTransitions();
        ArrayList endingActivities = process.getEndingActivities();
        if (CollectionUtils.isNotEmpty((Collection)transitions)) {
            for (Transition transition : transitions) {
                records.add(this.buildTransitionsTableRecord(process, activitySpecification, transition, activityForm));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)endingActivities)) {
            for (Activity endingActivity : endingActivities) {
                if (!endingActivity.equals((Object)activity)) continue;
                records.add(this.buildTransitionsTableEndingActivityRecord());
            }
        }
        TableHeaders headers = this.buildActivitySubsubchapterTransitionsTableHeaders();
        this.buildPoint(documentation, headers, records);
    }

    private TableRecord buildTransitionsTableRecord(WorkflowProcess process, ActivitySpecification activitySpecification, Transition transition, ActivityForm activityForm) {
        TransitionSpecification transitionSpecification = this.getTransitionSpecification(activitySpecification, transition);
        TableRecord record = new TableRecord();
        record.addCell(TRANSITION_TABLE_TO_COLUMN_ID, this.buildTransitionsTableToCell(transition));
        record.addCell(TRANSITION_TABLE_CONDITION_COLUMN_ID, this.buildTransitionsTableConditionCell(process, transition, activityForm));
        record.addCell(TRANSITION_TABLE_DESCRIPTION_COLUMN_ID, this.buildTransitionsTableDescriptionCell(process, transitionSpecification));
        return record;
    }

    private TransitionSpecification getTransitionSpecification(ActivitySpecification activitySpecification, Transition transition) {
        String transitionId = transition.getId();
        if (MapUtils.isNotEmpty(activitySpecification.getTransitionSpecifications()) && activitySpecification.getTransitionSpecifications().containsKey(transitionId)) {
            return activitySpecification.getTransitionSpecifications().get(transitionId);
        }
        return new TransitionSpecification();
    }

    private TableCell buildTransitionsTableToCell(Transition transition) {
        Activity toActivity = transition.getToActivity();
        String text = toActivity.getName();
        String bookmarkName = this.buildTransitionsTableToCellBookmarkName(toActivity);
        return TableUtils.buildTableCell(text, bookmarkName);
    }

    private String buildTransitionsTableToCellBookmarkName(Activity activity) {
        return BookmarkNameUtils.getNameForActivity(activity.getId());
    }

    private TableCell buildTransitionsTableConditionCell(WorkflowProcess process, Transition transition, ActivityForm activityForm) {
        Condition condition = transition.getCondition();
        if (condition != null && StringUtils.isNotBlank((CharSequence)condition.toValue())) {
            ParagraphContents contents = this.buildTransitionConditionParagraphContents(process, condition.toValue(), activityForm);
            contents.setIndents(ParagraphIndentsUtils.buildLeft(0));
            return TableUtils.buildTableCell(contents);
        }
        return this.buildEmptyTableCell();
    }

    private ParagraphContents buildTransitionConditionParagraphContents(WorkflowProcess process, String condition, ActivityForm activityForm) {
        return this.transitionConditionParagraphContentsBuilder.build(process, condition, activityForm);
    }

    private TableCell buildEmptyTableCell() {
        return TableUtils.buildTableCell("");
    }

    private TableCell buildTransitionsTableDescriptionCell(WorkflowProcess process, TransitionSpecification transitionSpecification) {
        ParagraphContents contents = this.buildSpecificationDescriptionParagraphContents(process, transitionSpecification.getDescription());
        contents.setIndents(ParagraphIndentsUtils.buildLeft(0));
        return TableUtils.buildTableCell(contents);
    }

    private TableRecord buildTransitionsTableEndingActivityRecord() {
        TableRecord record = new TableRecord();
        record.addCell(this.buildTransitionsTableEndingActivityToCell());
        record.setMerged(true);
        return record;
    }

    private TableCell buildTransitionsTableEndingActivityToCell() {
        return TableUtils.buildTableCell(this.translatorService.translateMessage(PROCESS_END));
    }

    private TableHeaders buildActivitySubsubchapterTransitionsTableHeaders() {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildTransitionsTableToHeader());
        headers.add(this.buildTransitionsTableConditionHeader());
        headers.add(this.buildTransitionsTableDescriptionHeader());
        return headers;
    }

    private TableHeader buildTransitionsTableToHeader() {
        return TableUtils.buildTableHeader(TRANSITION_TABLE_TO_COLUMN_ID, this.translatorService.translateMessage(ACTIVITY_NAME_TABLE_HEADER));
    }

    private TableHeader buildTransitionsTableConditionHeader() {
        return TableUtils.buildTableHeader(TRANSITION_TABLE_CONDITION_COLUMN_ID, this.translatorService.translateMessage(TRANSITION_CONDITION_TABLE_HEADER));
    }

    private TableHeader buildTransitionsTableDescriptionHeader() {
        return TableUtils.buildTableHeader(TRANSITION_TABLE_DESCRIPTION_COLUMN_ID, this.translatorService.translateMessage(TRANSITION_DESCRIPTION_TABLE_HEADER));
    }

    private ParagraphContents buildSpecificationDescriptionParagraphContents(WorkflowProcess process, String description) {
        return this.specificationDescriptionParagraphContentsBuilder.build(process, description);
    }

    private void buildPoint(Documentation documentation, TableHeaders headers, TableRecords records) {
        this.subchapterBuilder.build(documentation, POINT_TITLE, headers, records);
    }
}

