/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.IntegrationComponentsPointBuilder;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.object.AddFileButton;
import com.suncode.plugin.pwe.documentation.object.FormAction;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activityAddFileButtonsPointBuilder")
public class ActivityAddFileButtonsPointBuilderImpl
implements ActivityPointBuilder {
    private static final String DOCUMENT_CLASS_FOR_FILE_POINT_TITLE = "pwe.documentation.point.title.documentclassforfile";
    private static final String FORM_ACTIONS_POINT_TITLE = "pwe.documentation.point.title.formactions";
    @Autowired
    private IntegrationComponentsPointBuilder<FormAction> formActionsIntegrationComponentsPointBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        for (AddFileButton addFileButton : activityForm.getAddFileButtons()) {
            this.buildPoints(documentation, process, addFileButton);
        }
    }

    private void buildPoints(Documentation documentation, WorkflowProcess process, AddFileButton addFileButton) {
        this.buildTitlePoint(documentation, addFileButton);
        this.buildDocumentClassForFilePoint(documentation, addFileButton);
        if (CollectionUtils.isNotEmpty(addFileButton.getFormActions())) {
            this.buildFormActionsPoint(documentation, process, addFileButton);
        }
        documentation.addNewLine();
    }

    private void buildTitlePoint(Documentation documentation, AddFileButton addFileButton) {
        this.buildPoint(documentation, addFileButton.getButtonName());
    }

    private void buildDocumentClassForFilePoint(Documentation documentation, AddFileButton addFileButton) {
        ParagraphContents contents = this.buildDocumentClassForFilePointContents(addFileButton);
        contents.setIndents(ParagraphIndentsUtils.buildLeft(3));
        this.buildPoint(documentation, DOCUMENT_CLASS_FOR_FILE_POINT_TITLE, contents);
    }

    private ParagraphContents buildDocumentClassForFilePointContents(AddFileButton addFileButton) {
        String documentClassName = addFileButton.getDocumentClassName();
        String bookmarkName = BookmarkNameUtils.getNameForDocumentClass(documentClassName);
        return this.buildParagraphContents(documentClassName, bookmarkName);
    }

    private ParagraphContents buildParagraphContents(String text, String bookmarkName) {
        return ParagraphContentsUtils.build(text, bookmarkName);
    }

    private void buildFormActionsPoint(Documentation documentation, WorkflowProcess process, AddFileButton addFileButton) {
        this.formActionsIntegrationComponentsPointBuilder.build(documentation, process, addFileButton.getFormActions(), FORM_ACTIONS_POINT_TITLE, 3);
    }

    private void buildPoint(Documentation documentation, String title) {
        this.buildPoint(documentation, title, 2);
    }

    private void buildPoint(Documentation documentation, String title, int leftIndents) {
        this.subchapterBuilder.build(documentation, title, leftIndents);
    }

    private void buildPoint(Documentation documentation, String titleKey, ParagraphContents contents) {
        this.subchapterBuilder.build(documentation, titleKey, 3, contents);
    }
}

