/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProjectExclusionSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="projectExclusionsChapterBuilder")
public class ProjectExclusionsChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.projectexclusions";
    private static final String CONTENTS_POINT_TITLE = "pwe.documentation.point.title.contents";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, processSpecification);
    }

    private void buildSubchapters(Documentation documentation, ProcessSpecification processSpecification) {
        List<ProjectExclusionSpecification> projectExclusionSpecifications = processSpecification.getProjectExclusionSpecifications();
        if (CollectionUtils.isNotEmpty(projectExclusionSpecifications)) {
            Counter subchapterNo = new Counter(1);
            for (ProjectExclusionSpecification projectExclusionSpecification : projectExclusionSpecifications) {
                this.buildSubchapter(documentation, projectExclusionSpecification, subchapterNo.getCountAndIncrement());
            }
        }
    }

    private void buildSubchapter(Documentation documentation, ProjectExclusionSpecification projectExclusionSpecification, int subchapterNo) {
        String title = this.buildSubchapterTitle(projectExclusionSpecification, subchapterNo);
        documentation.addSubchapter(title);
        this.buildContentsPoint(documentation, projectExclusionSpecification);
        documentation.addNewLine();
    }

    private String buildSubchapterTitle(ProjectExclusionSpecification projectExclusionSpecification, int subchapterNo) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(projectExclusionSpecification.getName());
        return title.toString();
    }

    private void buildContentsPoint(Documentation documentation, ProjectExclusionSpecification projectExclusionSpecification) {
        this.buildPoint(documentation, CONTENTS_POINT_TITLE, projectExclusionSpecification.getContents());
    }

    private void buildPoint(Documentation documentation, String titleKey, String text) {
        this.subchapterBuilder.build(documentation, titleKey, text);
    }
}

