/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.ActivityListBuilder;
import com.suncode.plugin.pwe.documentation.paragraph.builder.SpecificationDescriptionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.specification.AssumptionsAndScopeSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.documentation.util.ImageUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="processMapAndActivitiesListChapterBuilder")
public class ProcessMapAndActivitiesListChapterBuilderImpl
implements ChapterBuilder {
    public static Logger log = Logger.getLogger(ProcessMapAndActivitiesListChapterBuilderImpl.class);
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.processmapandactivitieslist";
    private static final String PROCESS_MAP = "pwe.documentation.text.processmap";
    private static final String GENERAL_PROCESS_DESCRIPTION_SUBCHAPTER_TITLE = "pwe.documentation.subchapter.title.generalprocessdescription";
    private static final String ACTIVITIES_LIST_SUBCHAPTER_TITLE = "pwe.documentation.subchapter.title.activitieslist";
    private static final String PROCESS_INITIATION_METHOD_SUBCHAPTER_TITLE = "pwe.documentation.subchapter.title.processinitiationmethod";
    private static final String EMAIL_NOTIFICATIONS_DESCRIPTION_SUBCHAPTER_TITLE = "pwe.documentation.subchapter.title.emailnotificationsdescription";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private ActivityListBuilder activityListBuilder;
    @Autowired
    private SpecificationDescriptionParagraphContentsBuilder specificationDescriptionParagraphContentsBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, process, processSpecification, documentationConfig);
    }

    private void buildSubchapters(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        AssumptionsAndScopeSpecification assumptionsAndScope = processSpecification.getAssumptionsAndScope();
        Counter subchapterNo = new Counter(1);
        this.buildProcessMap(documentation, processSpecification);
        this.buildGeneralProcessDescriptionSubchapter(documentation, process, assumptionsAndScope, subchapterNo.getCountAndIncrement());
        this.buildActivitiesList(documentation, process, processSpecification, documentationConfig, subchapterNo.getCountAndIncrement());
        this.buildProcessInitiationMethodSubchapter(documentation, assumptionsAndScope, subchapterNo.getCountAndIncrement());
        this.buildEmailNotificationsDescriptionSubchapter(documentation, process, assumptionsAndScope, subchapterNo.getCountAndIncrement());
    }

    private void buildProcessMap(Documentation documentation, ProcessSpecification processSpecification) {
        if (StringUtils.isNotBlank((CharSequence)processSpecification.getProcessMapImage())) {
            this.addImage(documentation, processSpecification.getProcessMapImage());
            documentation.addNewLine();
        }
    }

    private void addImage(Documentation documentation, String processMapImage) {
        try {
            byte[] bytes = ImageUtils.getBase64EncodedBytes(processMapImage);
            String fileNameHint = this.translatorService.translateMessage(PROCESS_MAP);
            documentation.addImage(bytes, fileNameHint);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void buildGeneralProcessDescriptionSubchapter(Documentation documentation, WorkflowProcess process, AssumptionsAndScopeSpecification assumptionsAndScope, int subchapterNo) {
        ParagraphContents paragraphContents = this.specificationDescriptionParagraphContentsBuilder.build(process, assumptionsAndScope.getGeneralProcessDescription());
        this.buildSubchapter(documentation, GENERAL_PROCESS_DESCRIPTION_SUBCHAPTER_TITLE, paragraphContents, subchapterNo);
    }

    private void buildActivitiesList(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig, int subchapterNo) {
        List<Activity> activitiesList = this.buildActivitiesList(process, processSpecification, documentationConfig);
        List<ParagraphContents> numberedList = this.buildNumberedList(activitiesList);
        this.buildSubchapter(documentation, ACTIVITIES_LIST_SUBCHAPTER_TITLE, numberedList, subchapterNo);
    }

    private List<Activity> buildActivitiesList(WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        return this.activityListBuilder.build(process, processSpecification, documentationConfig);
    }

    private List<ParagraphContents> buildNumberedList(List<Activity> activitiesList) {
        ArrayList<ParagraphContents> numberedList = new ArrayList<ParagraphContents>();
        for (Activity activity : activitiesList) {
            numberedList.add(this.buildContents(activity));
        }
        return numberedList;
    }

    private ParagraphContents buildContents(Activity activity) {
        String text = activity.getName();
        String bookmarkName = this.buildBookmarkName(activity);
        return ParagraphContentsUtils.build(text, bookmarkName);
    }

    private String buildBookmarkName(Activity activity) {
        return BookmarkNameUtils.getNameForActivity(activity.getId());
    }

    private void buildProcessInitiationMethodSubchapter(Documentation documentation, AssumptionsAndScopeSpecification assumptionsAndScope, int subchapterNo) {
        this.buildSubchapter(documentation, PROCESS_INITIATION_METHOD_SUBCHAPTER_TITLE, assumptionsAndScope.getProcessInitiationMethod(), subchapterNo);
    }

    private void buildEmailNotificationsDescriptionSubchapter(Documentation documentation, WorkflowProcess process, AssumptionsAndScopeSpecification assumptionsAndScope, int subchapterNo) {
        ParagraphContents paragraphContents = this.specificationDescriptionParagraphContentsBuilder.build(process, assumptionsAndScope.getEmailNotificationsDescription());
        this.buildSubchapter(documentation, EMAIL_NOTIFICATIONS_DESCRIPTION_SUBCHAPTER_TITLE, paragraphContents, subchapterNo);
    }

    private void buildSubchapter(Documentation documentation, String titleKey, List<ParagraphContents> numberedList, int subchapterNo) {
        this.subchapterBuilder.build(documentation, titleKey, numberedList, subchapterNo);
    }

    private void buildSubchapter(Documentation documentation, String titleKey, String text, int subchapterNo) {
        this.subchapterBuilder.build(documentation, titleKey, text, subchapterNo);
    }

    private void buildSubchapter(Documentation documentation, String titleKey, ParagraphContents paragraphContents, int subchapterNo) {
        this.subchapterBuilder.build(documentation, titleKey, paragraphContents, subchapterNo);
    }
}

