/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.specification.IntegrationSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="integrationsChapterBuilder")
public class IntegrationsChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.integrations";
    private static final String SYSTEM_NAME_POINT_TITLE = "pwe.documentation.point.title.systemname";
    private static final String PURPOSE_POINT_TITLE = "pwe.documentation.point.title.dataexchangepurpose";
    private static final String INTEGRATION_METHOD_POINT_TITLE = "pwe.documentation.point.title.integrationmethod";
    private static final String INTEGRATION_DESCRIPTION_POINT_TITLE = "pwe.documentation.point.title.integrationdescription";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, processSpecification);
    }

    private void buildSubchapters(Documentation documentation, ProcessSpecification processSpecification) {
        List<IntegrationSpecification> integrationSpecifications = processSpecification.getIntegrationSpecifications();
        if (CollectionUtils.isNotEmpty(integrationSpecifications)) {
            Counter subchapterNo = new Counter(1);
            for (IntegrationSpecification integrationSpecification : integrationSpecifications) {
                this.buildSubchapter(documentation, integrationSpecification, subchapterNo.getCountAndIncrement());
            }
        }
    }

    private void buildSubchapter(Documentation documentation, IntegrationSpecification integrationSpecification, int subchapterNo) {
        String title = this.buildSubchapterTitle(integrationSpecification, subchapterNo);
        documentation.addSubchapter(title);
        this.buildSystemNamePoint(documentation, integrationSpecification);
        this.buildPurposePoint(documentation, integrationSpecification);
        this.buildIntegrationMethodPoint(documentation, integrationSpecification);
        this.buildIntegrationDescriptionPoint(documentation, integrationSpecification);
        documentation.addNewLine();
    }

    private String buildSubchapterTitle(IntegrationSpecification integrationSpecification, int subchapterNo) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(integrationSpecification.getName());
        return title.toString();
    }

    private void buildSystemNamePoint(Documentation documentation, IntegrationSpecification integrationSpecification) {
        this.buildPoint(documentation, SYSTEM_NAME_POINT_TITLE, integrationSpecification.getSystemName());
    }

    private void buildPurposePoint(Documentation documentation, IntegrationSpecification integrationSpecification) {
        this.buildPoint(documentation, PURPOSE_POINT_TITLE, integrationSpecification.getPurpose());
    }

    private void buildIntegrationMethodPoint(Documentation documentation, IntegrationSpecification integrationSpecification) {
        this.buildPoint(documentation, INTEGRATION_METHOD_POINT_TITLE, integrationSpecification.getIntegrationMethod());
    }

    private void buildIntegrationDescriptionPoint(Documentation documentation, IntegrationSpecification integrationSpecification) {
        this.buildPoint(documentation, INTEGRATION_DESCRIPTION_POINT_TITLE, integrationSpecification.getDescription());
    }

    private void buildPoint(Documentation documentation, String titleKey, String text) {
        this.subchapterBuilder.build(documentation, titleKey, text);
    }
}

