/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContent;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.specification.AttachmentSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.documentation.util.TextValueUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="attachmentsChapterBuilder")
public class AttachmentsChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.attachments";
    @Autowired
    private TranslatorService translatorService;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, processSpecification);
    }

    private void buildSubchapters(Documentation documentation, ProcessSpecification processSpecification) {
        List<AttachmentSpecification> attachmentSpecifications = processSpecification.getAttachmentSpecifications();
        if (CollectionUtils.isNotEmpty(attachmentSpecifications)) {
            Counter subchapterNo = new Counter(1);
            for (AttachmentSpecification attachmentSpecification : attachmentSpecifications) {
                this.buildSubchapter(documentation, attachmentSpecification, subchapterNo.getCountAndIncrement());
            }
        }
    }

    private void buildSubchapter(Documentation documentation, AttachmentSpecification attachmentSpecification, int subchapterNo) {
        String title = this.buildSubchapterTitle(attachmentSpecification, subchapterNo);
        documentation.addSubchapter(title);
        if (StringUtils.isNotBlank((CharSequence)attachmentSpecification.getDescription())) {
            this.buildDescription(documentation, attachmentSpecification);
        }
    }

    private String buildSubchapterTitle(AttachmentSpecification attachmentSpecification, int subchapterNo) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(attachmentSpecification.getName());
        return title.toString();
    }

    private void buildDescription(Documentation documentation, AttachmentSpecification attachmentSpecification) {
        documentation.addParagraph(this.buildDescriptionContents(attachmentSpecification));
        documentation.addNewLine();
    }

    private ParagraphContents buildDescriptionContents(AttachmentSpecification attachmentSpecification) {
        ParagraphContents contents = new ParagraphContents();
        contents.addContent(this.buildDescriptionContent(attachmentSpecification));
        return contents;
    }

    private ParagraphContent buildDescriptionContent(AttachmentSpecification attachmentSpecification) {
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(TextValueUtils.build(attachmentSpecification.getDescription()));
        return content;
    }
}

