/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	var SelectProcess = __webpack_require__(1),
	  TaskToReopen = __webpack_require__(3),
	  Summary = __webpack_require__(12);
	
	Wizards.create({
	  title: 'OPEN PROCESS WIZARD',
	  steps: [SelectProcess, TaskToReopen, Summary],
	  wizardData: {},
	});


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.components.selectprocess.SelectProcessStep', {
	  extend: 'Wizards.wizard.Step',
	  name: Wizards.t('selectprocess.step.name'),
	
	  initComponent: function () {
	    var selectProcessGrid = [
	      {
	        itemId: 'select-process-grid',
	        xtype: 'wizard-selectprocessgrid',
	        wizardProperty: 'units',
	        wizardTempProperty: 'selectedItems',
	      },
	    ];
	
	    this.items = [
	      {
	        xtype: 'wizard-step-item',
	        itemId: 'select-process-item',
	        fieldLabel: Wizards.t('selectprocess.step.grid.label'),
	        description: Wizards.t('selectprocess.step.grid.description'),
	        flex: 1,
	        items: selectProcessGrid,
	        errorMsg: Wizards.t('selectprocess.step.grid.errormsg'),
	        msgTarget: 'under',
	        margin: '0 0 10 0',
	      },
	    ];
	
	    this.callParent(arguments);
	  },
	
	  validate: function () {
	    var item = this.down('#select-process-item');
	    var grid = this.down('#select-process-grid');
	    var isValid = grid.validate();
	    if (!isValid) {
	      this.setInvalid(item);
	    } else {
	      this.unsetInvalid(item);
	    }
	    return isValid;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 2 */
/***/ (function(module, exports) {

	module.exports = Ext4;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(4);
	__webpack_require__(9);
	
	module.exports = Ext.define('Wizards.openprocess.tasktreopen.TaskToReopenStep', {
	  extend: 'Wizards.wizard.Step',
	  alias: 'widget.task-to-reopen-step',
	  name: Wizards.t('tasktoreopen.step.name'),
	
	  initComponent: function () {
	    this.items = [
	      {
	        xtype: 'radio',
	        itemId: 'processdef-radio',
	        boxLabel: Wizards.t('tasktoreopen.step.procdef.label'),
	        name: 'type',
	        margin: '10 0 0 0',
	        cmpBind: 'selectTypes',
	        checked: true,
	      },
	      {
	        xtype: 'wizard-step-item',
	        itemId: 'selectTypes',
	        description: Wizards.t('tasktoreopen.step.procdef.description'),
	        padding: '0 0 0 30',
	        maxHeight: 200,
	        errorMsg: Wizards.t('tasktoreopen.step.procdef.errormsg'),
	        msgTarget: 'under',
	        items: [
	          {
	            id: 'wizard-processdefgrid',
	            xtype: 'wizard-processdefgrid',
	            wizardProperty: 'processesDefToOpen',
	            getConfigCondition: function () {
	              var radio = Ext.ComponentQuery.query('#processdef-radio')[0];
	              return radio.getValue();
	            },
	          },
	        ],
	      },
	      {
	        xtype: 'radio',
	        itemId: 'process-radio',
	        boxLabel: Wizards.t('tasktoreopen.step.proc.label'),
	        name: 'type',
	        margin: '10 0 0 0',
	        cmpBind: 'selectProcesses',
	      },
	      {
	        xtype: 'wizard-step-item',
	        itemId: 'selectProcesses',
	        padding: '0 0 0 30',
	        description: Wizards.t('tasktoreopen.step.proc.description'),
	        flex: 1,
	        minHeight: 300,
	        errorMsg: Wizards.t('tasktoreopen.step.proc.errormsg'),
	        msgTarget: 'under',
	        items: [
	          {
	            id: 'wizard-processgrid',
	            xtype: 'wizard-processgrid',
	            wizardProperty: 'processesToOpen',
	            getConfigCondition: function () {
	              var radio = Ext.ComponentQuery.query('#process-radio')[0];
	              return radio.getValue();
	            },
	          },
	        ],
	      },
	      {
	        xtype: 'wizard-step-item',
	        itemId: 'comment',
	        description: Wizards.t('tasktoreopen.step.comment.description'),
	        padding: '0 0 0 30',
	        maxHeight: 200,
	        items: [
	          {
	            xtype: 'wizard-comment-field',
	            value: Wizards.t('tasktoreopen.step.comment.defaultvalue'),
	          },
	        ],
	      },
	    ];
	    this.callParent();
	    this.addMaskToRadios();
	  },
	
	  addMaskToRadios: function () {
	    Ext.each(
	      this.query('radio'),
	      function (radio) {
	        var targetCmp = this.down('#' + radio.cmpBind);
	        radio.mask = new Ext.LoadMask({
	          target: targetCmp,
	          useMsg: false,
	        });
	      },
	      this
	    );
	  },
	
	  activated: function () {
	    var processDefGrid = this.down('#wizard-processdefgrid');
	    var processGrid = this.down('#wizard-processgrid');
	    var selectedProcesses = this.getData('selectedItems', true);
	
	    this.showWarnings();
	    this.clearInvalid();
	
	    processDefGrid.prepare({
	      data: selectedProcesses,
	    });
	
	    processGrid.prepare({
	      data: selectedProcesses,
	      columnsConfig: this.getData('columnsConfig', true),
	    });
	
	    var radios = this.query('radio');
	    Ext.each(
	      radios,
	      function (radio) {
	        this.maskRadio(radio);
	        radio.on(
	          'change',
	          function (radio) {
	            this.maskRadio(radio);
	          },
	          this
	        );
	      },
	      this
	    );
	
	    this.callParent(arguments);
	  },
	
	  showWarnings: function () {
	    var loadedRecords = this.getData('loadedRecords', true);
	    var visited = this.getData('visited', true) || false;
	    var messages = [];
	
	    this.clearMessages();
	    messages.push({
	      text: Wizards.t('tasktoreopen.step.message.info'),
	      type: 'warning',
	    });
	    if (!visited && loadedRecords.length == 1) {
	      this.saveData(
	        {
	          visited: true,
	        },
	        true
	      );
	      messages.push({
	        text: Wizards.t('tasktoreopen.step.message.skippreviousstep'),
	        type: 'warning',
	      });
	    }
	    this.showMessages(messages);
	  },
	
	  clearInvalid: function () {
	    var radios = this.query('radio');
	    Ext.each(
	      radios,
	      function (radio) {
	        var item = this.down('#' + radio.cmpBind);
	        this.unsetInvalid(item);
	      },
	      this
	    );
	  },
	
	  maskRadio: function (radio) {
	    if (radio.getValue()) {
	      radio.nextSibling().unmask();
	    } else {
	      radio.nextSibling().mask();
	    }
	  },
	
	  validate: function () {
	    var result = true;
	    var radios = this.query('radio');
	    Ext.each(
	      radios,
	      function (radio) {
	        if (radio.getValue()) {
	          var item = this.down('#' + radio.cmpBind);
	          var isValid = item.down().validate();
	          if (!isValid) {
	            this.setInvalid(item);
	          } else {
	            this.unsetInvalid(item);
	          }
	          result = result && isValid;
	        } else {
	          var item = this.down('#' + radio.cmpBind);
	          this.unsetInvalid(item);
	        }
	      },
	      this
	    );
	    return result;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(5);
	var ColumnRenderer = __webpack_require__(6);
	var processDefStore = __webpack_require__(7);
	var activityStore = Ext.create('Ext.data.Store', {
	  model: 'Wizards.openprocess.tasktreopen.model.Activity',
	  autoLoad: false,
	});
	
	//FIXME zapomina wybrane zadania po cofnięciu kroku
	module.exports = Ext.define('Wizards.openprocess.tasktreopen.ActivityForProcessDefGrid', {
	  extend: 'Ext.grid.Panel',
	  xtype: 'wizard-processdefgrid',
	  store: processDefStore,
	  selType: 'cellmodel',
	  plugins: [
	    {
	      ptype: 'cellediting',
	      pluginId: 'cellediting',
	      clicksToEdit: 1,
	    },
	  ],
	  mixins: {
	    columnRenderer: ColumnRenderer,
	  },
	
	  constructor: function () {
	    this.mixins.columnRenderer.constructor.call(this, activityStore, null, 'processDefId');
	    this.callParent(arguments);
	  },
	
	  initComponent: function () {
	    this.columns = [
	      {
	        header: Wizards.t('processdefgrid.column.task.header'),
	        dataIndex: 'task',
	        flex: 1,
	        editor: {
	          xtype: 'combobox',
	          store: activityStore,
	          editable: true,
	          queryMode: 'local',
	          valueField: 'activityId',
	          displayField: 'activityName',
	          forceSelection: true,
	          anyMatch: true
	        },
	        scope: this,
	        renderer: this.taskColumnRenderer,
	      },
	      {
	        header: Wizards.t('processdefgrid.column.processdef.header'),
	        dataIndex: 'processDefName',
	        flex: 2,
	      },
	    ];
	    this.callParent();
	  },
	  prepare: function (params) {
	    var processDefs = [];
	    var tmp = {};
	    // unikalne typu procesu
	    Ext.each(params.data, function (item) {
	      tmp[item.raw.processDefinitionId] = item.data.processType;
	    });
	
	    var processesDefId = [];
	    for (var key in tmp) {
	      processesDefId.push(key);
	      processDefs.push({
	        processDefId: key,
	        processDefName: tmp[key],
	      });
	    }
	
	    this.store.loadData(processDefs);
	
	    Ext.Ajax.request({
	      url: Wizards.contextPath + '/plugin/com.suncode.plugin-wizards-open-process/openprocess/processDef/activities',
	      method: 'GET',
	      params: {
	        processesDefId: processesDefId,
	      },
	      callback: function (options, success, response) {
	        var responseBody = Ext.JSON.decode(response.responseText),
	          result = responseBody.result,
	          data = responseBody.data;
	
	        if (result.status == 'SUCCESS') {
	          activityStore.loadData(data);
	          this.on('beforeedit', function (editor, e) {
	            var filterValue = e.record.get('processDefId');
	            activityStore.removeFilter('processIdFilter');
	            activityStore.filter(
	                Ext.create('Ext.util.Filter', {
	                  id: 'processIdFilter',
	                  property: 'processId',
	                  value: filterValue,
	                  root: 'data',
	                  exactMatch: true,
	                })
	            );
	          });
	        } else {
	          var step = this.up('task-to-reopen-step'),
	            item = this.up('wizard-step-item');
	
	          step.setInvalid(item, result.message);
	        }
	      },
	      scope: this,
	    });
	  },
	  readData: function () {
	    var result = [];
	    this.store.each(function (record) {
	      if (record.data.task) {
	        result.push({
	          processDefId: record.data.processDefId,
	          activityId: record.data.task,
	        });
	      }
	    });
	    return result;
	  },
	  validate: function () {
	    var records = this.getStore().getRange();
	    for (var i = 0; i < records.length; i++) {
	      if (records[i].data.task == undefined) {
	        return false;
	      }
	    }
	    return true;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.openprocess.tasktreopen.model.Activity', {
	  extend: 'Ext.data.Model',
	  alias: 'Activity',
	
	  fields: [
	    { name: 'processId', type: 'string' },
	    { name: 'activityId', type: 'string' },
	    { name: 'activityName', type: 'string' },
	    {
	      name: 'startedDate',
	      convert: function (v, rec) {
	        return v == null ? null : new Date(v)
	      }
	    },
	    {
	      name: 'displayText',
	      convert: function (v, rec) {
	        const startedDate = rec.get('startedDate')
	        if (!startedDate) {
	          return rec.get('activityName')
	        }
	
	        return rec.get('activityName') + ' - ' + Ext.Date.format(startedDate, "Y-m-d H:i:s");
	      }
	    }
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {/**
	 * Functions rendering columns in TaskToReopen
	 *
	 * @class Wizards.openprocess.tasktoreopen.ColumnRenderer
	 */
	module.exports = Ext.define('Wizards.openprocess.tasktoreopen.ColumnRenderer', {
	  /**
	   * Stores used in editor
	   */
	  editorStore: {},
	  sourceUsersStore: {},
	
	  /**
	   * Name of id property
	   */
	  idName: '',
	
	  constructor: function (store, sourceUsersStore, idName) {
	    this.editorStore = store;
	    this.sourceUsersStore = sourceUsersStore;
	    this.idName = idName;
	  },
	
	  taskColumnRenderer: function (value, meta, record) {
	    var result = '';
	    if (value) {
	      var foundRecord = this.editorStore.queryBy(function (storeRecord) {
	        if (storeRecord.get('processId') == record.get(this.idName) && storeRecord.get('activityId') == value) {
	          return true;
	        }
	        return false;
	      }, this);
	
	      result = this.getColumnIconElement('dvnt-icon-check-symbol') + foundRecord.get(0).get('activityName');
	    } else {
	      meta.style = 'color: #F1472F';
	      result = Wizards.t('columnrenderer.column.emptyname');
	    }
	    return result;
	  },
	
	  assignmentUsersColumnRenderer: function (value, meta, record) {
	    var result = '';
	    if (value) {
	      var foundRecord = this.sourceUsersStore.queryBy(function (storeRecord) {
	        if (storeRecord.get('userId') == value) {
	          return true;
	        }
	        return false;
	      }, this);
	
	      result = this.getColumnIconElement('dvnt-icon-check-symbol') + foundRecord.get(0).get('userName');
	    } else {
	      meta.style = 'color: #F1472F';
	      result = Wizards.t('columnrenderer.column.user.emptyname');
	    }
	    return result;
	  },
	
	  getColumnIconElement: function (cls) {
	    return '<span class="' + cls + '" style="float: right; height: 16px; width: 16px; display: block;"></span>';
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var ProcessDef = __webpack_require__(8);
	
	module.exports = Ext.create('Ext.data.ArrayStore', {
	  model: ProcessDef,
	  autoLoad: false,
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.openprocess.tasktreopen.model.ProcessDef', {
	  extend: 'Ext.data.Model',
	
	  fields: [
	    { name: 'processDefId', type: 'string' },
	    { name: 'processDefName', type: 'string' },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(5);
	__webpack_require__(10);
	var ColumnRenderer = __webpack_require__(6);
	var store = __webpack_require__(11);
	var activityStore = Ext.create('Ext.data.Store', {
	  model: 'Wizards.openprocess.tasktreopen.model.Activity',
	  autoLoad: false,
	});
	var userFromAssignmentsStore = Ext.create('Ext.data.Store', {
	  model: 'Wizards.openprocess.tasktoreopen.model.User',
	  autoLoad: false,
	});
	
	module.exports = Ext.define('Wizards.openprocess.tasktreopen.ActivityForProcessGrid', {
	  extend: 'Ext.grid.Panel',
	  xtype: 'wizard-processgrid',
	  store: store,
	  userFromAssignmentsStore: userFromAssignmentsStore,
	  columns: [],
	  selType: 'cellmodel',
	  plugins: [
	    {
	      ptype: 'cellediting',
	      pluginId: 'cellediting',
	      clicksToEdit: 1,
	    },
	  ],
	  mixins: {
	    columnRenderer: ColumnRenderer,
	  },
	
	  constructor: function () {
	    this.mixins.columnRenderer.constructor.call(this, activityStore, userFromAssignmentsStore, 'id');
	    this.callParent(arguments);
	  },
	
	  prepare: function (params) {
	    this.store.loadRecords(params.data);
	    this.reconfigure(this.store, this.withEditableCell(params.columnsConfig.columns));
	
	    this.initActivityStore(params);
	
	    this.on(
	      'beforeedit',
	      function (editor, context) {
	        if (context.field == 'user') {
	          this.onUserColumnBeforeEdit(context);
	        } else if (context.field == 'task') {
	          this.onTaskColumnBeforeEdit(context);
	        }
	      },
	      this
	    );
	  },
	  withEditableCell: function (columns) {
	    var result = Ext.Array.clone(columns),
	      editableColumn = {
	        header: Wizards.t('processgrid.column.task.header'),
	        dataIndex: 'task',
	        locked: true,
	        flex: 1,
	        editor: {
	          xtype: 'combobox',
	          store: activityStore,
	          editable: true,
	          queryMode: 'local',
	          valueField: 'activityId',
	          displayField: 'displayText',
	          forceSelection: true,
	          matchFieldWidth: false,
	          listConfig: {
	            width: 'auto',
	            style: {
	              minWidth: '100px',
	              maxWidth: '600px',
	            },
	          },
	          anyMatch: true
	        },
	        scope: this,
	        renderer: this.taskColumnRenderer,
	      },
	      assignmentUsers = {
	        header: Wizards.t('processgrid.column.user.header'),
	        dataIndex: 'user',
	        locked: true,
	        flex: 1,
	        editor: {
	          id: 'userFromAssignmentsCombo',
	          xtype: 'combobox',
	          store: userFromAssignmentsStore,
	          editable: false,
	          queryMode: 'local',
	          valueField: 'userId',
	          displayField: 'userName',
	          forceSelection: true,
	          matchFieldWidth: false,
	          listConfig: {
	            width: 'auto',
	            style: {
	              minWidth: '100px',
	              maxWidth: '600px',
	            },
	          },
	        },
	        scope: this,
	        renderer: this.assignmentUsersColumnRenderer,
	      };
	    result.unshift(assignmentUsers);
	    result.unshift(editableColumn);
	    return result;
	  },
	  initActivityStore: function (params) {
	    var processesId = [];
	    Ext.each(params.data, function (item) {
	      processesId.push(item.data.id);
	    });
	
	    activityStore.setProxy({
	      type: 'ajax',
	      // FIXME przekazanie sciezki do pluginu
	      url: Wizards.contextPath + '/plugin/com.suncode.plugin-wizards-open-process/openprocess/process/activities',
	      extraParams: {
	        processesId: processesId,
	      },
	      actionMethods: {
	        read: 'POST'
	      },
	      reader: {
	        type: 'json',
	        root: 'data',
	      },
	    });
	    activityStore.load();
	  },
	  onUserColumnBeforeEdit: function (context) {
	    if (!context.record.get('task')) {
	      if (window.PW) {
	        PW.ui.Message.error(Wizards.t('processgrid.column.task.error'));
	      } else {
	        Ext.Msg.alert(Wizards.baseT('base.error'), Wizards.t('processgrid.column.task.error'));
	      }
	      return false;
	    }
	
	    this.userFromAssignmentsStore.setProxy({
	      type: 'ajax',
	      url: Wizards.contextPath + '/plugin/com.suncode.plugin-wizards-open-process/openprocess/process/activity/usersFromAssignment',
	      extraParams: {
	        processId: context.record.get('id'),
	        activityId: context.record.get('task'),
	      },
	      reader: {
	        type: 'json',
	        root: 'data',
	      },
	    });
	    this.userFromAssignmentsStore.load();
	  },
	  onTaskColumnBeforeEdit: function (context) {
	    var filterValue = context.record.get('id');
	    activityStore.removeFilter('processIdFilter');
	    activityStore.filter(
	        Ext.create('Ext.util.Filter', {
	          id: 'processIdFilter',
	          property: 'processId',
	          value: filterValue,
	          root: 'data',
	          exactMatch: true,
	        })
	    );
	  },
	  readData: function () {
	    var result = [];
	    this.store.each(function (record) {
	      if (record.data.task) {
	        result.push({
	          processId: record.get('id'),
	          activityId: record.get('task'),
	          userId: record.get('user'),
	        });
	      }
	    });
	    return result;
	  },
	  validate: function () {
	    var records = this.getStore().getRange();
	    for (var i = 0; i < records.length; i++) {
	      if (!records[i].get('task')) {
	        return false;
	      }
	    }
	    return true;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.openprocess.tasktoreopen.model.User', {
	  extend: 'Ext.data.Model',
	  alias: 'User',
	
	  fields: [
	    { name: 'userId', type: 'string' },
	    { name: 'userName', type: 'string' },
	    { name: 'forceSelected', type: 'bool' },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.create('Ext.data.ArrayStore', {
	  storeId: 'processstore',
	  autoLoad: false,
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('OpenProcess.SummaryStep', {
	  extend: 'Wizards.components.summary.SummaryStep',
	
	  name: Wizards.t('summary.step.name'),
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ })
/******/ ]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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