/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.openprocess;

import com.plusmpm.struts.action.ShowProcessHistoryAction;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.support.Condition;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.web.support.SectionCondition;
import com.suncode.plugin.wizards.Wizard;
import com.suncode.plugin.wizards.WizardImplementation;
import com.suncode.plugin.wizards.execution.config.WizardMenu;
import com.suncode.plugin.wizards.openprocess.OpenProcessConfig;
import com.suncode.plugin.wizards.openprocess.OpenProcessTask;
import com.suncode.plugin.wizards.openprocess.ProcessToOpen;
import com.suncode.plugin.wizards.support.HasAdminRightCondition;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessState;
import com.suncode.pwfl.workflow.search.SearchResultActionSection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenProcessWizzard
implements WizardImplementation<OpenProcessConfig, OpenProcessTask> {
    @Autowired
    Plugin plugin;
    private static final Condition searchTypeCondition = new SectionCondition<SearchResultActionSection>(){

        public boolean isFulfilled(SearchResultActionSection section) {
            return section.getSearchType() == SearchResultActionSection.SearchType.PROCESS;
        }
    };
    private static final Condition resultsCondition = new SectionCondition<SearchResultActionSection>(){

        public boolean isFulfilled(SearchResultActionSection section) {
            return section.count() > 0;
        }
    };
    private static final Condition closedCondition = new SectionCondition<ShowProcessHistoryAction.ProcessHistoryActionSection>(){

        public boolean isFulfilled(ShowProcessHistoryAction.ProcessHistoryActionSection section) {
            return !ProcessState.isOpen((ProcessState)section.getProcessState());
        }
    };
    private static final Condition hasAdminRight = new HasAdminRightCondition();

    public Class<OpenProcessConfig> configClass() {
        return OpenProcessConfig.class;
    }

    public void createMenus(Wizard<OpenProcessConfig, OpenProcessTask> wizard, WizardMenu builder) {
        builder.section("system.search.result.menu").add("open-processes", new LocalizedMessage(this.plugin, "openprocess.menu.search.name", new Object[0]), new Condition[]{searchTypeCondition, resultsCondition, hasAdminRight}).section("system.process.history.menu").add("open-process", new LocalizedMessage(this.plugin, "openprocess.menu.history.name", new Object[0]), new Condition[]{closedCondition, hasAdminRight});
    }

    public List<OpenProcessTask> createTasks(OpenProcessConfig config) {
        ArrayList<OpenProcessTask> result = new ArrayList<OpenProcessTask>();
        if (config.getProcessesToOpen().isEmpty() && config.getProcessesDefToOpen().isEmpty()) {
            return result;
        }
        if (!config.getProcessesToOpen().isEmpty()) {
            for (ProcessToOpen item : config.getProcessesToOpen()) {
                result.add(new OpenProcessTask(this.plugin, item.getProcessId(), item.getActivityId(), item.getUserId(), config.getComment()));
            }
        } else if (!config.getProcessesDefToOpen().isEmpty()) {
            result.addAll(this.mapProcessDefOnSelectedProcesses(config.getUnitIds(), config.getProcessesDefToOpenAsMap(), config.getComment()));
        }
        return result;
    }

    private List<OpenProcessTask> mapProcessDefOnSelectedProcesses(List<String> selectedProcesses, Map<String, String> processesDefToOpen, String comment) {
        ArrayList<OpenProcessTask> result = new ArrayList<OpenProcessTask>();
        ProcessService processService = ServiceFactory.getProcessService();
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        for (String selectedProcessId : selectedProcesses) {
            Process process = processService.getProcess(selectedProcessId, new String[]{"processDefinition"});
            if (!processesDefToOpen.containsKey(process.getProcessDefinition().getProcessDefinitionId())) continue;
            OpenProcessTask task = new OpenProcessTask(this.plugin, selectedProcessId);
            String activityDefId = processesDefToOpen.get(process.getProcessDefinition().getProcessDefinitionId());
            List activities = activityFinder.findByProcessId(selectedProcessId, new String[0]);
            for (Activity activity : activities) {
                if (!activity.getActivityDefinitionId().equals(activityDefId)) continue;
                task.setActivityId(activity.getActivityId());
                task.setComment(comment);
                break;
            }
            result.add(task);
        }
        return result;
    }
}

