/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.openprocess;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.DBManagement;
import com.plusmpm.util.SharkFunctions;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.wizards.execution.state.SimpleTaskExecutionState;
import com.suncode.plugin.wizards.execution.state.TaskExecutionState;
import com.suncode.plugin.wizards.execution.task.TaskContext;
import com.suncode.plugin.wizards.execution.task.WizardTask;
import com.suncode.plugin.wizards.openprocess.OpenTaskException;
import com.suncode.plugin.wizards.support.AdminRightCache;
import com.suncode.plugin.wizards.util.ActivityContextDto;
import com.suncode.plugin.wizards.util.ActivityContextUtil;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessState;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class OpenProcessTask
implements WizardTask {
    private static final Logger logger = LoggerFactory.getLogger(OpenProcessTask.class);
    private Plugin plugin;
    private String processId;
    private String activityId;
    private String username;
    private String comment;

    public OpenProcessTask(Plugin plugin, String processId, String activityId, Long userId, String comment) {
        Assert.notNull((Object)plugin, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)processId, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.plugin = plugin;
        this.processId = processId;
        this.activityId = activityId;
        if (userId != null) {
            this.username = ServiceFactory.getUserService().getUser(userId, new String[0]).getUserName();
        }
        this.comment = comment;
    }

    public OpenProcessTask(Plugin plugin, String processId) {
        this(plugin, processId, null, null, "");
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public TaskExecutionState.TaskExecutionStatus execute(SimpleTaskExecutionState state, TaskContext taskContext) {
        ProcessService processService = ServiceFactory.getProcessService();
        ActivityService activityService = ServiceFactory.getActivityService();
        Process process = processService.getProcess(this.processId, new String[0]);
        Locale locale = taskContext.getLocale();
        if (!AdminRightCache.hasAdminRight((String)taskContext.getLoggedUsername())) {
            state.setMessage(this.plugin.getMessage("openprocess.error.norights", locale, new Object[0]));
            return TaskExecutionState.TaskExecutionStatus.SKIPPED;
        }
        if (process == null) {
            state.setMessage(this.plugin.getMessage("openprocess.error.processnotfound", locale, new Object[]{this.processId}));
            return TaskExecutionState.TaskExecutionStatus.FAILED;
        }
        ProcessState processState = process.getState();
        if (ProcessState.isOpen((ProcessState)processState)) {
            state.setMessage(this.plugin.getMessage("openprocess.error.processisopen", locale, new Object[]{this.processId}));
            return TaskExecutionState.TaskExecutionStatus.SKIPPED;
        }
        if (this.activityId == null) {
            state.setMessage(this.plugin.getMessage("openprocess.error.noactivityinprocess", locale, new Object[0]));
            return TaskExecutionState.TaskExecutionStatus.SKIPPED;
        }
        Activity activity = activityService.getActivity(this.processId, this.activityId, new String[0]);
        if (activity == null) {
            state.setMessage(this.plugin.getMessage("openprocess.error.activitynotfound", locale, new Object[]{this.activityId}));
            return TaskExecutionState.TaskExecutionStatus.FAILED;
        }
        if (activity.isOpen()) {
            state.setMessage(this.plugin.getMessage("openprocess.error.activityisopen", locale, new Object[]{this.activityId}));
            return TaskExecutionState.TaskExecutionStatus.SKIPPED;
        }
        Map activityContext = activityService.getActivityContext(this.processId, this.activityId);
        String activityDefId = activity.getActivityDefinitionId();
        try {
            String newActivityId = this.openProcessOnActivity(activityDefId, activityContext);
            String userId = taskContext.getLoggedUsername();
            this.addComment(newActivityId, userId);
        }
        catch (OpenTaskException e) {
            state.setMessage(this.plugin.getMessage("openprocess.error.activityexecution", locale, new Object[]{this.activityId}));
            return TaskExecutionState.TaskExecutionStatus.FAILED;
        }
        return TaskExecutionState.TaskExecutionStatus.EXECUTED;
    }

    private void addComment(String newActivityId, String username) {
        if (StringUtils.isEmpty((String)this.comment)) {
            return;
        }
        Comment newComment = new Comment();
        newComment.setProcessId(this.processId);
        newComment.setActivityId(newActivityId);
        newComment.setUserId(username);
        newComment.setComment(this.prepareComment());
        newComment.setTimestamp(Long.valueOf(new Date().getTime()));
        ServiceFactory.getCommentService().createComment(newComment, false);
    }

    private String openProcessOnActivity(final String activityDefId, final Map<String, Object> activityContext) {
        final ActivityService activityService = ServiceFactory.getActivityService();
        final ProcessService processService = ServiceFactory.getProcessService();
        final SharkTransactionManager mgr = TransactionManagerFactory.getSharkTransactionManager();
        TransactionTemplate tt = new TransactionTemplate((PlatformTransactionManager)mgr);
        return (String)tt.execute((TransactionCallback)new TransactionCallback<String>(){

            public String doInTransaction(TransactionStatus status) {
                try {
                    SharkTransaction st = mgr.getSharkTransaction();
                    ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
                    String admin = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
                    String password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
                    ea.connect(st, admin, password, "KlientTestowy", null);
                    WfProcess wfProcess = SharkFunctions.GetWfProcess((ExecutionAdministration)ea, (String)OpenProcessTask.this.processId);
                    DBManagement dbManagement = new DBManagement();
                    ArrayList alNotificationsTable = dbManagement.getNotificationsByProcessId(OpenProcessTask.this.processId);
                    alNotificationsTable.forEach(notification -> dbManagement.deleteNotificationsById(notification.getId().toString()));
                    wfProcess.reopen(st);
                    WfActivity previousActivity = ea.getActivity(st, OpenProcessTask.this.processId, OpenProcessTask.this.activityId);
                    String startedActivityId = ea.startActivityFrom(st, OpenProcessTask.this.processId, null, activityDefId, OpenProcessTask.this.username, new WfActivity[]{previousActivity});
                    ActivityContextDto preparedActivityContext = ActivityContextUtil.prepareActivityContext((SharkTransaction)st, (String)OpenProcessTask.this.processId, (String)OpenProcessTask.this.activityId, (Map)activityContext);
                    activityService.setActivityContext(OpenProcessTask.this.processId, startedActivityId, preparedActivityContext.getActivityContext());
                    processService.setProcessContext(OpenProcessTask.this.processId, preparedActivityContext.getProcessContext());
                    return startedActivityId;
                }
                catch (Exception e) {
                    logger.error("Error occurred while opening activity {} in process {}", new Object[]{activityDefId, OpenProcessTask.this.processId, e});
                    throw new OpenTaskException(e);
                }
            }
        });
    }

    public String getTaskId() {
        return this.processId;
    }

    private String prepareComment() {
        ActivityService activityService = ServiceFactory.getActivityService();
        Activity activity = activityService.getActivity(this.processId, this.activityId, new String[]{"process"});
        String processName = activity.getProcess().getName();
        String activityName = activity.getName();
        return this.comment.replaceAll("\\{processName\\}", processName).replaceAll("\\{activityName\\}", activityName);
    }

    public Map<String, Object> getAuditTaskParams() {
        return ImmutableMap.of((Object)"openprocess_processId", (Object)this.processId, (Object)"openprocess_activityId", (Object)this.activityId, (Object)"openprocess_username", (Object)Optional.ofNullable(this.username).orElse("-"));
    }
}

