/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.openprocess;

import com.plusmpm.enhydra.assignment.PlusWorkflowAssignmentManager;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.wizards.openprocess.ActivitiesData;
import com.suncode.plugin.wizards.openprocess.ActivityData;
import com.suncode.plugin.wizards.openprocess.Result;
import com.suncode.plugin.wizards.openprocess.support.UserData;
import com.suncode.plugin.wizards.openprocess.support.UsersData;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/openprocess"})
public class OpenProcessController {
    private static final Logger log = LoggerFactory.getLogger(OpenProcessController.class);
    @Autowired
    private Plugin plugin;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private UserService userService;
    private XpdlPackageManager xpdlPackageManager = XpdlPackageManager.getInstance();

    @ResponseBody
    @RequestMapping(value={"process/activities"}, method={RequestMethod.POST})
    public ActivitiesData getActivitiesForProcesses(@RequestParam List<String> processesId) {
        List<ActivityData> activityDataList = processesId.stream().flatMap(processId -> {
            Package pack = this.xpdlPackageManager.getPackageByProcessId(processId);
            return this.activityFinder.findByProcessId(processId, new String[]{"process"}).stream().filter(activity -> {
                String processDefId = activity.getProcess().getProcessDefinition().getProcessDefinitionId();
                WorkflowProcess workflowProcess = pack.getWorkflowProcess(processDefId);
                return this.isNotRoute(workflowProcess.getActivity(activity.getActivityDefinitionId()));
            }).map(activity -> ActivityData.builder().processId((String)processId).activityId(activity.getActivityId()).activityName(activity.getName()).startedDate(activity.getCreatedTime()).endedDate(activity.getLastStateTime()).build());
        }).sorted(Comparator.comparing(ActivityData::getStartedDate).thenComparing(ActivityData::getEndedDate)).collect(Collectors.toList());
        return ActivitiesData.builder().data(activityDataList).build();
    }

    @ResponseBody
    @RequestMapping(value={"processDef/activities"}, method={RequestMethod.GET})
    public ActivitiesData getActivitiesForProcessDefinitions(@RequestParam List<String> processesDefId) {
        ArrayList<ActivityData> activityDataList = new ArrayList<ActivityData>();
        for (String processDefId : processesDefId) {
            String packageId = this.xpdlPackageManager.getPackageIdByProcessDefinitionId(processDefId);
            Package pack = this.xpdlPackageManager.getPackage(packageId);
            WorkflowProcess process = pack.getWorkflowProcess(processDefId);
            if (process == null) {
                log.error("No process [{}] in current version of package [{}]", (Object)processDefId, (Object)packageId);
                return ActivitiesData.builder().result(new Result(Result.ResultStatus.FAILURE, this.plugin.getMessage("openprocess.error.noprocessesinpackage", new Object[]{processDefId, packageId}))).build();
            }
            ArrayList activitiesList = process.getActivities().toElements();
            activitiesList.stream().filter(this::isNotRoute).map(activity -> ActivityData.builder().processId(processDefId).activityId(activity.getId()).activityName(activity.getName()).build()).forEach(activityDataList::add);
        }
        return ActivitiesData.builder().data(activityDataList).result(new Result(Result.ResultStatus.SUCCESS)).build();
    }

    @ResponseBody
    @RequestMapping(value={"process/activity/usersFromAssignment"}, method={RequestMethod.GET})
    public UsersData getAssignmentUserToActivity(@RequestParam String processId, @RequestParam String activityId) {
        List<String> assignments = this.getAssignments(processId, activityId);
        List<UserData> userDataList = assignments.stream().map(assignment -> {
            UserData userData = new UserData();
            User user = this.userService.getUser(assignment, new String[0]);
            userData.setForceSelected(true);
            userData.setUserId(user.getObjectId());
            userData.setUserName(user.getUserName());
            return userData;
        }).collect(Collectors.toList());
        return new UsersData(userDataList);
    }

    private List<String> getAssignments(@RequestParam String processId, @RequestParam String activityId) {
        SharkTransactionManager mgr = TransactionManagerFactory.getSharkTransactionManager();
        return (List)new TransactionTemplate((PlatformTransactionManager)mgr).execute(status -> {
            SharkTransaction sharkTransaction = mgr.getSharkTransaction();
            PlusWorkflowAssignmentManager am = (PlusWorkflowAssignmentManager)SharkEngineManager.getInstance().getAssignmentManager();
            try {
                Package pack = this.xpdlPackageManager.getPackageByProcessId(processId);
                String processDefId = SharkFunctions.getProcessDefId((SharkTransaction)sharkTransaction, (String)processId);
                String activityDefId = SharkFunctions.getActivityDefId((SharkTransaction)sharkTransaction, (String)processId, (String)activityId);
                WorkflowProcess process = pack.getWorkflowProcess(processDefId);
                String performer = process.getActivity(activityDefId).getPerformer();
                com.suncode.pwfl.workflow.activity.Activity notRoutePreviousActivity = this.activityFinder.findPreviousActivity(processId, activityId);
                while (notRoutePreviousActivity != null && this.isRoute(notRoutePreviousActivity, process)) {
                    notRoutePreviousActivity = this.activityFinder.findPreviousActivity(processId, notRoutePreviousActivity.getActivityId());
                }
                if (notRoutePreviousActivity != null) {
                    Map prevActivityContext = this.activityService.getActivityContext(processId, notRoutePreviousActivity.getActivityId());
                    return am.getAssignments(sharkTransaction, pack.getId(), processId, activityId, performer, prevActivityContext);
                }
                return am.getAssignments(sharkTransaction, pack.getId(), processId, activityId, performer, this.activityService.getActivityContext(processId, activityId));
            }
            catch (RootException e1) {
                log.error("Error while getting assignments for activity [{}] in process [{}]", new Object[]{activityId, processId, e1});
                return null;
            }
        });
    }

    private boolean isRoute(com.suncode.pwfl.workflow.activity.Activity previousActivity, WorkflowProcess process) {
        Activity previousActivityEl = process.getActivity(previousActivity.getActivityDefinitionId());
        return this.isNotRoute(previousActivityEl) == false;
    }

    private Boolean isNotRoute(Activity activity) {
        return activity.getActivityType() != 0;
    }
}

