/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changeuser.administration.permission;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.wizards.changeuser.administration.AuthorizationService;
import com.suncode.plugin.wizards.changeuser.administration.Permission;
import com.suncode.plugin.wizards.changeuser.administration.Response;
import com.suncode.plugin.wizards.changeuser.administration.permission.NewPermissionDto;
import com.suncode.plugin.wizards.changeuser.administration.permission.PermissionDto;
import com.suncode.plugin.wizards.changeuser.administration.permission.PermissionService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"permissions"})
public class PermissionsController {
    private static final Logger logger = LoggerFactory.getLogger(PermissionsController.class);
    @Autowired
    private Plugin plugin;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private AuthorizationService authorizationService;

    @ResponseBody
    @RequestMapping(value={"all"})
    public CountedResult<PermissionDto> getAll() {
        this.authorizationService.assertFullAdministrationRights();
        List<PermissionDto> permissionDtoList = PermissionDto.from(this.permissionService.getAll());
        return new CountedResult((long)permissionDtoList.size(), permissionDtoList);
    }

    @ResponseBody
    @RequestMapping(value={"delete/{id}"})
    public Response deletePermission(@PathVariable Long id) {
        this.authorizationService.assertFullAdministrationRights();
        try {
            Permission permission = this.permissionService.get(id);
            this.permissionService.delete(permission);
            return new Response(true);
        }
        catch (Exception e) {
            Translator t = Translators.get((String)this.plugin.getKey());
            logger.error("Error writing deliting.", (Throwable)e);
            return new Response(false, t.getMessage("changeuser.permission.delete.error"));
        }
    }

    @ResponseBody
    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    public Response save(@RequestBody NewPermissionDto permissionDto) {
        this.authorizationService.assertFullAdministrationRights();
        try {
            this.permissionService.changePermissions(permissionDto);
            return new Response(true);
        }
        catch (Exception e) {
            Translator t = Translators.get((String)this.plugin.getKey());
            logger.error("Error writing permission.", (Throwable)e);
            return new Response(false, t.getMessage("changeuser.permission.save.error"));
        }
    }
}

