/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changeuser;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.support.Condition;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.web.support.SectionCondition;
import com.suncode.plugin.wizards.Wizard;
import com.suncode.plugin.wizards.WizardImplementation;
import com.suncode.plugin.wizards.changeuser.ActivityDefToChange;
import com.suncode.plugin.wizards.changeuser.ActivityToChange;
import com.suncode.plugin.wizards.changeuser.ChangeUserConfig;
import com.suncode.plugin.wizards.changeuser.ChangeUserTask;
import com.suncode.plugin.wizards.changeuser.administration.permission.PermissionService;
import com.suncode.plugin.wizards.execution.config.WizardMenu;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.search.ActivitySearchQuery;
import com.suncode.pwfl.workflow.search.SearchResultActionSection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class ChangeUserWizard
implements WizardImplementation<ChangeUserConfig, ChangeUserTask> {
    @Autowired
    private Plugin plugin;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private PermissionService permissionService;
    private static final Condition searchTypeCondition = new SectionCondition<SearchResultActionSection>(){

        public boolean isFulfilled(SearchResultActionSection section) {
            return section.getSearchType() == SearchResultActionSection.SearchType.ACTIVITY;
        }
    };
    private static final Condition resultsCondition = new SectionCondition<SearchResultActionSection>(){

        public boolean isFulfilled(SearchResultActionSection section) {
            return section.count() > 0;
        }
    };
    private final Condition hasRights = new SectionCondition<SearchResultActionSection>(){

        public boolean isFulfilled(SearchResultActionSection section) {
            return ChangeUserWizard.this.permissionService.hasUserPermission(ChangeUserWizard.this.getLoggedUserName(), section);
        }
    };
    private final Condition allOrOpen = new SectionCondition<SearchResultActionSection>(){

        public boolean isFulfilled(SearchResultActionSection section) {
            ActivitySearchQuery search = section.getActivitySearchQuery();
            return search.hasCondition(ActivitySearchQuery.ActivityField.STATE, "") || search.hasCondition(ActivitySearchQuery.ActivityField.STATE, "open%") || search.hasCondition(ActivitySearchQuery.ActivityField.STATE, "open.running") || search.hasCondition(ActivitySearchQuery.ActivityField.STATE, "open.not_running.not_started") || search.hasCondition(ActivitySearchQuery.ActivityField.STATE, "open.not_running.suspended");
        }
    };

    public Class<ChangeUserConfig> configClass() {
        return ChangeUserConfig.class;
    }

    public List<ChangeUserTask> createTasks(ChangeUserConfig config) {
        ArrayList<ChangeUserTask> result = new ArrayList<ChangeUserTask>();
        List<ActivityToChange> activitiesToChange = config.getActivitiesToChange();
        List<ActivityDefToChange> activitiesDefToChange = config.getActivitiesDefToChange();
        if (activitiesToChange.isEmpty() && activitiesDefToChange.isEmpty()) {
            return result;
        }
        if (!activitiesToChange.isEmpty()) {
            for (ActivityToChange activityToChange : activitiesToChange) {
                String activityId = activityToChange.getActivityId();
                Activity activity = (Activity)this.activityFinder.findOneByProperty("activityId", (Object)activityId, new String[]{"process"});
                result.add(new ChangeUserTask(activity.getProcessId(), activityId, activityToChange.getSourceUserId(), activityToChange.getUserId(), config.getComment()));
            }
        } else if (!activitiesDefToChange.isEmpty()) {
            result.addAll(this.mapOnTasks(config.getActivitiesDefToChangeMap(), config.getUnitIds(), config.getComment()));
        }
        return result;
    }

    private List<ChangeUserTask> mapOnTasks(Map<String, String> activitiesDefToChange, List<String> selectedActivities, String comment) {
        ArrayList<ChangeUserTask> result = new ArrayList<ChangeUserTask>();
        for (String activityId : selectedActivities) {
            Activity activity = (Activity)this.activityFinder.findOneByProperty("activityId", (Object)activityId, new String[]{"process"});
            if (!activitiesDefToChange.containsKey(activity.getActivityDefinitionId())) continue;
            String userId = activitiesDefToChange.get(activity.getActivityDefinitionId());
            result.add(new ChangeUserTask(activity.getProcessId(), activityId, activity.getResourceId(), userId, comment));
        }
        return result;
    }

    public void createMenus(Wizard<ChangeUserConfig, ChangeUserTask> wizard, WizardMenu builder) {
        builder.section("system.search.result.menu").add("change-user", new LocalizedMessage(this.plugin, "changeuser.menu.search.name", new Object[0]), new Condition[]{searchTypeCondition, resultsCondition, this.allOrOpen, this.hasRights});
    }

    private RequestAttributes getCurrentRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            throw new IllegalStateException("Current thread is not bound to HttpRequest");
        }
        return attributes;
    }

    private Object getSessionAttribute(String name) {
        return this.getCurrentRequestAttributes().getAttribute(name, 1);
    }

    private String getLoggedUserName() {
        return (String)this.getSessionAttribute("username");
    }
}

