/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changeuser;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.plusmpm.util.SharkFunctions;
import com.suncode.plugin.wizards.execution.state.SimpleTaskExecutionState;
import com.suncode.plugin.wizards.execution.state.TaskExecutionState;
import com.suncode.plugin.wizards.execution.task.TaskContext;
import com.suncode.plugin.wizards.execution.task.WizardTask;
import com.suncode.plugin.wizards.util.ActivityContextDto;
import com.suncode.plugin.wizards.util.ActivityContextUtil;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SharkUtils;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.transfer.TransferActivityService;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeUserTask
implements WizardTask {
    private static final Logger log = LoggerFactory.getLogger(ChangeUserTask.class);
    private String processId;
    private String activityId;
    private String oldUserLogin;
    private String newUserLogin;
    private String comment;
    private List<String> currentAssignmentsLogins = new ArrayList<String>();
    private String currentActivityState;

    public ChangeUserTask(String processId, String activityId, String oldUserLogin, String newUserLogin, String comment) {
        this.processId = processId;
        this.activityId = activityId;
        this.oldUserLogin = oldUserLogin;
        this.newUserLogin = newUserLogin;
        this.comment = comment;
        TransactionWrapper.get().doInSharkTransaction(sharkTransaction -> {
            this.currentAssignmentsLogins = ServiceFactory.getActivityService().getAssignments(processId, activityId);
            WfActivity currentActivity = SharkFunctions.GetWfActivity((SharkTransaction)sharkTransaction, (ExecutionAdministration)SharkUtils.getExecutionAdministration(), (String)processId, (String)activityId);
            try {
                this.currentActivityState = currentActivity.state(sharkTransaction);
            }
            catch (BaseException e) {
                log.error("B\u0142\u0105d podczas pobierania statusu zadania", (Object)e.getLocalizedMessage());
            }
        });
    }

    public String getTaskId() {
        return this.activityId;
    }

    public TaskExecutionState.TaskExecutionStatus execute(SimpleTaskExecutionState status, TaskContext taskContext) throws Exception {
        return (TaskExecutionState.TaskExecutionStatus)TransactionWrapper.get().doInSharkTransaction(st -> (TaskExecutionState.TaskExecutionStatus)TransactionWrapper.get().doInHibernateTransaction(session -> {
            ActivityService activityService = ServiceFactory.getActivityService();
            ProcessService processService = ServiceFactory.getProcessService();
            Map activityContext = activityService.getActivityContext(this.processId, this.activityId);
            ActivityContextDto preparedActivityContext = ActivityContextUtil.prepareActivityContext((SharkTransaction)st, (String)this.processId, (String)this.activityId, (Map)activityContext);
            activityService.setActivityContext(this.processId, this.activityId, preparedActivityContext.getActivityContext());
            processService.setProcessContext(this.processId, preparedActivityContext.getProcessContext());
            TransferActivityService transferActivityService = ServiceFactory.getTransferActivityService();
            if (StringUtils.isBlank((String)this.oldUserLogin)) {
                transferActivityService.transfer(this.processId, this.activityId, (Set)Sets.newHashSet((Object[])new String[]{this.newUserLogin}), true);
            } else {
                transferActivityService.transfer(this.processId, this.activityId, this.oldUserLogin, (Set)Sets.newHashSet((Object[])new String[]{this.newUserLogin}), true);
            }
            this.addComment(taskContext.getLoggedUsername());
            return TaskExecutionState.TaskExecutionStatus.EXECUTED;
        }));
    }

    private void addComment(String currentUsername) {
        if (StringUtils.isEmpty((String)this.comment)) {
            return;
        }
        Comment newComment = new Comment();
        newComment.setProcessId(this.processId);
        newComment.setActivityId(this.activityId);
        newComment.setUserId(currentUsername);
        newComment.setComment(this.prepareComment());
        newComment.setTimestamp(Long.valueOf(new Date().getTime()));
        ServiceFactory.getCommentService().createComment(newComment, false);
    }

    private String prepareComment() {
        UserService userService = ServiceFactory.getUserService();
        ActivityService activityService = ServiceFactory.getActivityService();
        User oldUser = userService.getUser(this.oldUserLogin, new String[0]);
        User newUser = userService.getUser(this.newUserLogin, new String[0]);
        String activityName = activityService.getActivity(this.processId, this.activityId, new String[0]).getName();
        return this.comment.replaceAll("\\{activityName\\}", activityName).replaceAll("\\{oldUser\\}", oldUser != null ? this.getUserName(oldUser) : this.getPreviousUserName()).replaceAll("\\{newUser\\}", this.getUserName(newUser));
    }

    private String getUserName(User user) {
        if (user != null) {
            String userName = user.getUserName();
            String fullName = user.getFullName();
            if (StringUtils.isEmpty((String)fullName)) {
                return "(" + userName + ")";
            }
            return fullName + " (" + userName + ")";
        }
        return "-";
    }

    private String getPreviousUserName() {
        if (this.currentActivityState != null && this.currentAssignmentsLogins.size() > 0) {
            UserService userService = ServiceFactory.getUserService();
            if (this.currentAssignmentsLogins.size() <= 5) {
                return this.currentAssignmentsLogins.stream().map(login -> this.getUserName(userService.getUser(login, new String[0]))).collect(Collectors.joining(","));
            }
            return this.currentAssignmentsLogins.stream().limit(5L).map(login -> this.getUserName(userService.getUser(login, new String[0]))).collect(Collectors.joining(", ")) + "...";
        }
        return "-";
    }

    public Map<String, Object> getAuditTaskParams() {
        Object oldUser = "-";
        if (StringUtils.isNotBlank((String)this.oldUserLogin)) {
            oldUser = this.oldUserLogin;
        } else if (this.currentActivityState != null && !this.currentAssignmentsLogins.isEmpty()) {
            oldUser = this.currentAssignmentsLogins;
        }
        return ImmutableMap.of((Object)"changeuser_processId", (Object)this.processId, (Object)"changeuser_activityId", (Object)this.activityId, (Object)"changeuser_olduser", (Object)oldUser, (Object)"changeuser_newuser", (Object)this.newUserLogin);
    }
}

