/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changeuser;

import com.suncode.plugin.wizards.changeuser.support.UserData;
import com.suncode.plugin.wizards.changeuser.support.UsersData;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/changeuser"})
public class ChangeUserController {
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ActivityService activityService;

    @ResponseBody
    @RequestMapping(value={"activity/usersFromAssignment"}, method={RequestMethod.POST})
    public UsersData getUsersFromAssignments(@RequestParam(required=false) String query, @RequestParam List<String> activitiesId) {
        UsersData data = new UsersData();
        ArrayList<UserData> userDataList = new ArrayList<UserData>();
        activitiesId = activitiesId == null ? new ArrayList() : activitiesId;
        for (String activityId : activitiesId) {
            Activity activity = (Activity)this.activityFinder.findOneByProperty("activityId", (Object)activityId, new String[]{"process"});
            List assignments = this.activityService.getAssignments(activity.getProcessId(), activityId);
            for (String assignment : assignments) {
                UserData userData = new UserData();
                User user = (User)this.userFinder.findOneByProperty("userName", (Object)assignment, new String[0]);
                if (!StringUtils.isEmpty((CharSequence)query) && (StringUtils.isEmpty((CharSequence)query) || !user.getFirstName().contains(query) && !user.getLastName().contains(query) && !user.getUserName().contains(query))) continue;
                userData.setUserId(user.getUserName());
                userData.setUserName(this.prepareUserName(user));
                userData.setActivityId(activityId);
                if (assignments.size() == 1) {
                    userData.setForceSelected(true);
                }
                userDataList.add(userData);
            }
        }
        data.setData(userDataList);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"activity/users"}, method={RequestMethod.GET})
    public UsersData getUsersForActivity(@RequestParam(required=false) String query) {
        UsersData data = new UsersData();
        ArrayList<UserData> userDataList = new ArrayList<UserData>();
        DetachedCriteria dc = DetachedCriteria.forClass(User.class);
        if (!StringUtils.isEmpty((CharSequence)query)) {
            String wrappedQuery = "%" + query + "%";
            dc.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.ilike((String)"userName", (Object)wrappedQuery), Restrictions.ilike((String)"firstName", (Object)wrappedQuery), Restrictions.ilike((String)"lastName", (Object)wrappedQuery)}));
        }
        List users = this.userFinder.findByCriteria(dc);
        for (User user : users) {
            UserData userData = new UserData();
            userData.setUserId(user.getUserName());
            userData.setUserName(this.prepareUserName(user));
            userDataList.add(userData);
        }
        data.setData(userDataList);
        return data;
    }

    private String prepareUserName(User user) {
        String userName = user.getUserName();
        String fullName = user.getFullName();
        if (StringUtils.isEmpty((CharSequence)fullName)) {
            return "(" + userName + ")";
        }
        return fullName + " (" + userName + ")";
    }
}

